// Package globalstate holds the types for the ui state
package globalstate

import (
	"bytes"
	"time"

	"gioui.org/app"
	"gioui.org/widget/material"
	"gioui.org/x/explorer"
	"gioui.org/x/markdown"
	"git.sr.ht/~mil/mobroute"
)

type AppQueueload struct {
	RuntimeInitialize    bool
	FeedIDLoadAndCompute *int
	FeedLoadCustomPicker bool
	FeedIDUpdate         *int
	ReturnToTab          string
}

type PendingLoadInfo struct {
	TimerStart *time.Time
	Message    string
	SubMessage string
	IsError    bool
}

type GlobalState struct {
	Window           *app.Window
	Explorer         *explorer.Explorer
	Theme            *material.Theme
	MarkdownRenderer *markdown.Renderer
	MobrouteRuntime  *mobroute.MobrouteRuntime
	MobrouteLog      *bytes.Buffer

	PendingLoadInfo PendingLoadInfo
	AppQueueload    *AppQueueload

	// Unsaved global state
	TabSelected        string
	LocationFromCoords []float64
	LocationFromLabel  string
	LocationToLabel    string
	LocationToCoords   []float64

	// Saved global state (will be written to file & restored on quit/boot)
	Save GlobalStateSave
}
