package globalintegrations

import (
	"fmt"
	"strconv"
	"strings"

	"git.sr.ht/~mil/mobroute"
	"git.sr.ht/~mil/transito/src/util/utilfuncs"
)

func MRIntegrationGetBboxForFeedIDs(
	mobrouteRuntime *mobroute.MobrouteRuntime,
	feedIDs []int,
) (*[4]float64, error) {
	if len(feedIDs) == 0 {
		// Note by default empty filter in mobsql sourceset filter passes
		// through entire / all sources - this is not really desirable on UI side
		return nil, nil
	} else if statuses, err := mobroute.RTDatabaseq(
		mobrouteRuntime,
		&mobroute.DatabaseqParams{FeedIDs: feedIDs},
	); err != nil {
		return nil, err
	} else {
		var returnBbox *[4]float64 = nil
		for _, s := range *statuses {
			if s.LocationBbox == nil {
				continue
			} else {
				var (
					// TODO: this is a bit hacky.. really mobsql should provide bbox
					// either as straight CSV or as seperate fields, currently
					// format is [a,b,c,d] so we strip out [] since rest can be simply parsed
					bboxMobsqlString = strings.Replace(
						strings.Replace(*s.LocationBbox, "[", "", -1),
						"]", "", -1,
					)
					components = strings.Split(bboxMobsqlString, ",")
				)
				if len(components) < 4 {
					return nil, fmt.Errorf("Bbox format invalid?: %s", bboxMobsqlString)
				} else if a, err := strconv.ParseFloat(components[0], 64); err != nil {
					return nil, err
				} else if b, err := strconv.ParseFloat(components[1], 64); err != nil {
					return nil, err
				} else if c, err := strconv.ParseFloat(components[2], 64); err != nil {
					return nil, err
				} else if d, err := strconv.ParseFloat(components[3], 64); err != nil {
					return nil, err
				} else if returnBbox == nil {
					returnBbox = &[4]float64{a, b, c, d}
				} else {
					// E.g. expand bbox dimensions
					returnBbox[0] = utilfuncs.MinFloat64(returnBbox[0], a)
					returnBbox[1] = utilfuncs.MinFloat64(returnBbox[1], b)
					returnBbox[2] = utilfuncs.MaxFloat64(returnBbox[2], c)
					returnBbox[3] = utilfuncs.MaxFloat64(returnBbox[3], d)
				}
			}
		}
		return returnBbox, nil
	}
}
