package headerbar

import (
	"image"
	"image/color"

	"gioui.org/font"
	"gioui.org/layout"
	"gioui.org/op/clip"
	"gioui.org/op/paint"
	"gioui.org/text"
	"gioui.org/unit"
	"gioui.org/widget/material"
)

func Headerbar(gtx layout.Context, th *material.Theme, spinnerPercent float32, textLeft, textRight string) layout.Dimensions {
	header := layout.Rigid(func(gtx layout.Context) layout.Dimensions {
		gtx.Constraints.Min.Y = gtx.Dp(unit.Dp(50))
		gtx.Constraints.Max.Y = gtx.Dp(unit.Dp(50))

		left := material.H5(th, textLeft)
		left.Font.Weight = font.Bold
		left.Alignment = text.Start
		left.MaxLines = 1

		right := material.H6(th, textRight)
		right.Font.Style = font.Italic
		right.Alignment = text.End
		right.MaxLines = 1

		createColorbox := func(gtx layout.Context, size image.Point, color color.NRGBA) layout.Dimensions {
			defer clip.Rect{Max: size}.Push(gtx.Ops).Pop()
			paint.ColorOp{Color: color}.Add(gtx.Ops)
			paint.PaintOp{}.Add(gtx.Ops)
			return layout.Dimensions{Size: size}
		}
		colorbox := func(gtx layout.Context) layout.Dimensions {
			c := color.NRGBA{R: 0xe6, G: 0xf4, B: 0xff, A: 0xFF}
			return createColorbox(gtx, gtx.Constraints.Max, c)
		}

		circle := func(gtx layout.Context) layout.Dimensions {
			size := 25
			gtx.Constraints.Min.Y = gtx.Dp(unit.Dp(size))
			gtx.Constraints.Max.Y = gtx.Constraints.Min.Y
			gtx.Constraints.Min.X = gtx.Dp(unit.Dp(size))
			gtx.Constraints.Max.X = gtx.Constraints.Min.X
			return material.ProgressCircle(th, spinnerPercent).Layout(gtx)
		}

		inset := layout.UniformInset(unit.Dp(10))
		return layout.Stack{}.Layout(gtx,
			layout.Stacked(colorbox),
			layout.Stacked(
				func(gtx layout.Context) layout.Dimensions {
					return inset.Layout(gtx, func(gtx layout.Context) layout.Dimensions {
						return layout.Flex{Axis: layout.Horizontal}.Layout(gtx,
							layout.Rigid(left.Layout),
							layout.Flexed(1,
								func(gtx layout.Context) layout.Dimensions {
									if spinnerPercent > 0 {
										return layout.Stack{Alignment: layout.E}.Layout(gtx,
											layout.Stacked(circle),
										)
									} else {
										return right.Layout(gtx)
									}
								},
							),
						)
					})
				},
			),
		)
	})
	return layout.Flex{Axis: layout.Vertical}.Layout(gtx, header)
}
