package buttonrow

import (
	"gioui.org/layout"
	"gioui.org/unit"
	"gioui.org/widget/material"
	"git.sr.ht/~mil/transito/src/util/utilfuncs"
	"git.sr.ht/~mil/transito/src/util/utiltheme"
)

func (buttonrow *ButtonRow) Layout(gtx layout.Context) layout.Dimensions {
	gtx.Constraints.Min.Y = gtx.Dp(unit.Dp(35))
	gtx.Constraints.Max.Y = gtx.Constraints.Min.Y

	var (
		leftButtons  = []material.ButtonStyle{}
		rightButtons = []material.ButtonStyle{}
	)
	for i, _ := range buttonrow.Buttons {
		btn := &buttonrow.Buttons[i]
		if btn.Hide {
			continue
		}
		materialBtn := material.Button(
			utiltheme.MaterialTheme(
				*buttonrow.Theme,
				utilfuncs.Fif(btn.Label == buttonrow.ActiveButtonLabel, buttonrow.ActiveButtonThemecolor, btn.Themecolor),
				14,
			),
			&btn.clickable,
			btn.Label,
		)
		if btn.Align == Align(AlignLeft) {
			leftButtons = append(leftButtons, materialBtn)
		} else {
			rightButtons = append(rightButtons, materialBtn)
		}
		if btn.clickable.Clicked(gtx) {
			if btn.CanActivate {
				buttonrow.ActiveButtonLabel = btn.Label
			}
			if btn.Callback != nil {
				btn.Callback(gtx)
			}
		}
	}

	flexes := []layout.FlexChild{}
	for _, b := range leftButtons {
		flexes = append(
			flexes,
			layout.Flexed(0.3, b.Layout),
			layout.Flexed(0.01, layout.Spacer{Width: unit.Dp(2)}.Layout),
		)
	}
	flexes = append(flexes, layout.Flexed(0.5, layout.Spacer{Width: unit.Dp(2)}.Layout))
	for _, b := range rightButtons {
		flexes = append(
			flexes,
			layout.Flexed(0.01, layout.Spacer{Width: unit.Dp(2)}.Layout),
			layout.Flexed(0.3, b.Layout),
		)
	}

	btns := layout.Flex{}.Layout(gtx, layout.Rigid(dimensionsToWidget(layout.Flex{}.Layout(
		gtx,
		flexes...,
	))))

	return layout.Stack{}.Layout(gtx,
		layout.Stacked(func(gtx layout.Context) layout.Dimensions {
			gtx.Constraints.Min.Y = gtx.Dp(unit.Dp(35))
			gtx.Constraints.Max.Y = gtx.Dp(unit.Dp(20))
			return btns
		}),
	)
}
