# **Transito**:  Userguide

[Transito](http://git.sr.ht/~mil/transito) is FOSS
data-provider-agnostic public transportation app that let's you route
between locations using openly available public GTFS feeds. For
an overview of Transito's functionality see [Transito's project
page](http://git.sr.ht/~mil/transito). This document is a guide on how
to get Transito setup on your local device.

## Install

- **Android**
    - The recommended way to install is [via F-Droid](https://f-droid.org/packages/ht.sr.git.mil.transito)
        - [<img src="https://fdroid.gitlab.io/artwork/badge/get-it-on.png" alt="Get it on F-Droid" height="80">](https://f-droid.org/packages/ht.sr.git.mil.transito)
      - Development builds can be used for testing from [the CI server](https://ci.lrdu.org/android/)
          - Builds tagged as `master`: Latest builds / features development, may be less stable
          - Builds tagged as `0.x.x`: Tagged builds for specific releases, see [Release Notes](https://git.sr.ht/~mil/transito/refs) for details on changes
- **Linux & Desktop**
    - Distro packages install:
        - Alpine Linux testing: `apk add transito`
    - Build from source:
        - Building from source is possible & [covered by the development guide](doc_transito_development.md)

## Usage

This section will guide you through a basic routing request using an
example of using the Agglobus provider in Bourges, France (GTFS feed ID:
1898). You may wish to change your GTFS datafeed and search terms,
however if you're unclear about how to use the app, this is a good guide
to follow along with:


<table>
  <tr>
    <td><strong>Screenshot</strong></td>
    <td><strong>Description</strong></td>
  </tr>
  <tr>
    <td>
      <a href="http://mr.lrdu.org/transito/doc/doc_transito_screenshots/"><img src='https://media.lrdu.org/images/transito/transito_screenshot_config.png' /></a>
    </td>
    <td>
      <strong>Config:</strong>
      <ul>
        <li>After launching the app, by default you will be on the <strong>Config</strong> tab.</li>
        <li>This tab lets you download GTFS feeds and configure various advanced parameters.</li>
        <li>For our basic example walkthrough, type <strong>'Bourges'</strong> in the GTFS feed search and select the 1898 feed ID correlated to the Agglobus provides in Bourges, France</li>
        <li>Different providers of GTFS datafeeds each have their own specific feed ID, you can learn more about this at the <a href="https://mr.lrdu.org/mobroute/doc/doc_gtfsfeeds/">available GTFS Feeds guide</a>.</li>
        <li>You can also interactively search for an appropriate GTFS provider datafeed ID at the <a href="https://mdb.lrdu.org/">Mobility Database UI</a>.</li>
        <li>Clicking add will start the GTFS load process, this is a long-running process which downloads the GTFS data from the origin provider and prepare it in a format usable for routing.</li>
        <li>Depending on the size of the feed this may take several minutes or longer (even possibly up to an hour for large feeds); please be patient GTFS dataload is a onetime process and then subsequent app functionality works offline.</li>
        <li>Once you have your GTFS feed set; 3 new tabs are present (Route, Stops, and POI), for our example switch to the <strong>Stops</strong> tab.</li>
        <li><em>Important sidenote for Config tab: The <a href="#advanced-config">advanced config</a> parameters effect GTFS loads. In particular, <strong>Use Agency GTFS URLs</strong> effects whether to use agency or CI/mirrored GTFS URLs (which are enabled by default and may be slightly out of date), see documentation below.</em></li>
      </ul>
    </td>
  </tr>
  <tr>
    <td>
      <a href="http://mr.lrdu.org/transito/doc/doc_transito_screenshots/"><img src='https://media.lrdu.org/images/transito/transito_screenshot_stops.png' /></a>
    </td>
    <td>
      <strong>Stops:</strong>
      <ul>
        <li>On the <strong>Stops</strong> tab, you can select stops as an origin or destination point for routing.</li>
        <li>Stop selection lookup takes place offline and is a simple way to quickly find origin/destination points without typing a specific POI or address.</li>
        <li>For our routing example, type 'Robespierre' in the filter and select that associated stop for 'Set as From'.</li>
        <li>You will be taken back to the <strong>Route</strong> tab and see that the From location is set.</li>
        <li>Now, let's set the destination, instead of using a stop, let's use a point of interest (POI) this time; select the <strong>POI</strong> tab.</li>
      </ul>
    </td>
  </tr>
  <tr>
    <td>
      <a href="http://mr.lrdu.org/transito/doc/doc_transito_screenshots/"><img src='https://media.lrdu.org/images/transito/transito_screenshot_poi.png' /></a>
    </td>
    <td>
      <strong>POI:</strong>
      <ul>
        <li>On the <strong>POI</strong> tab, you can search for either points of interest (POIs) or direct addresses by using <a href="https://nominatim.org/">Nominatim</a>.</li>
        <li>For our example, we will route to "Velodrome" so simply enter that into the search field and press the "Search" button.</li>
        <li>In the select list below you will see results; you can pick among multiple results if there is more then 1 match.</li>
        <li>Once you've determined the correct location, press "Set as To".</li>
        <li>You will be taken back to the <strong>Route</strong> tab and see that now that both the From & To locations are set.</li>
      </ul>
    </td>
  </tr>
  <tr>
    <td>
      <a href="http://mr.lrdu.org/transito/doc/doc_transito_screenshots/"><img src='https://media.lrdu.org/images/transito/transito_screenshot_routesteps.png' /></a>
    </td>
    <td>
      <strong>Route:</strong>
      <ul>
        <li>Now the From and To locations are set, and you're on the <strong>Route</strong> tab.</li>
        <li>From here, to submit a routing request, simply press the "Route" button.</li>
        <li>Be patient as the route is calculated on your device, depending on the GTFS feed size and your request the time for the routing algorithm to complete varies.</li>
        <li>
          Once the route has been calculated:
          <ul>
            <li>Clicking "Overview" shows the steps for the route.</li>
            <li>Clicking the "Map" button opens a URL to show the route on a map (see next section).</li>
            <li>Clicking "Debug" shows raw diagnostics response information about the including route & performance details (and copies this raw data to the clipboard).</li>
            <li>Clicking "Clear" clears the route result.</li>
          </ul>
        </li>
      </ul>
    </td>
  </tr>
  <tr>
    <td>
      <a href="http://mr.lrdu.org/transito/doc/doc_transito_screenshots/"><img src='https://media.lrdu.org/images/transito/transito_screenshot_routemap.png' /></a>
    </td>
    <td>
      <strong>Map:</strong>
      <ul>
        <li>Clicking the "Map" button opens a URL to show the route on a map.</li>
        <li>Note: the map view requires being online.</li>
        <li>This map is simply the route rendered to GeoJSON and passed in the URL hash to a <a href="https://geojson.lrdu.org/">GeoJSON WebUI Rendering JS UI</a>.</li>
        <li>You can click on locations on the map for details on each leg's steps and such.</li>
        <li>In the bottom right of the map there is a link that says "m" which you may click to see the original route request parameters.</li>
      </ul>
    </td>
  </tr>
  <tr>
    <td>
      <a href="http://mr.lrdu.org/transito/doc/doc_transito_screenshots/"><img src='https://media.lrdu.org/images/transito/transito_screenshot_fave.png' /></a>
    </td>
    <td>
      <strong>Fave:</strong>
      <ul>
        <li>On both the Stops and POI tab there is a button "Favorite", clicking this adds the location to your favorites.</li>
        <li>This tab, <strong>Fave</strong>, can be used to store commonly used locations such as your work, home, or common stops.</li>
        <li>Favorites function offline & this tab will only be present if there is >1 favorite.</li>
      </ul>
    </td>
  </tr>
</table>

## Routing Params
On the route page there is a button entitled Params which lets you toggle hiding
and showing the parameters for routing requests. On each boot these params are
reset to pragmatic defaults. Each param correlates to to a tunable in the underlying
Mobroute library routing function call. See the [documentation page for routing 
tunables](https://mr.lrdu.org/mobroute/doc/routing_tunables/) for extended information on each param. 
For a high level overview of each param, please reference the below table:

|**Parameter** | **Default Value** | **Explanation** |
|---|----|---|
| Max Wᵐ | 20 | Maximum number of minutes to consider valid walking to the origin stop for the first trip or walking from the destination stop for the last trip. |
| Max Tᵐ | 240 | Maximum number of minutes for the total route / trip duration. By default 240 minutes (4 hours). |
| Min Cᵐ | 3 |  Minimum number of minutes to consider a transfer (c)hange valid. |
| Max Cᵐ | 40 | Maximum number of minutes to consider a transfer (c)change valid. Set to a lower number to prevent excessively long transfers as desired. |
| Wᵏᵐʰʳ | 4 | Speed of walking (for both transfers & from/to origin/destination) in km/hr ratio. Adjust up or down depending on your speed. |
| Feed Transfers | Enabled | Enables origin GTFS `tables.txt` based transfers. |
| Implicit Transfers | Enabled | Enables implicit transfers from one stop to another stop (with the same parent stop). |
| Generated Transfers | Disabled | Enables 'generated' both same feed and intrafeed transfers. Heavier performance cost, but necessary for transferring between multiple feeds or in the case where feed & implicit transfers don't suffice for a single feed. |


## Updating Feeds

Periodically *after* a given GTFS feed is loaded you may wish to update
the feed.  GTFS feeds are all correlated with a specific daterange (this
is indicated on loaded feeds on the Config page). Note this daterange
is calculated from the origin `calendar` and `calendar_dates` GTFS tables.

There are few important points to note with respect to updates:

- [Mobility Database](https://github.com/MobilityData/mobility-database-catalogs)
  handles all feed specific updates (GTFS URL changes, new feeds,
  removed feeds, metadata updates etc.).
- On each new release & build, Transito embeds a copy of the
  [Mobility Database's master
  CSV](https://github.com/MobilityData/mobility-database-catalogs?tab=readme-ov-file#browsing-and-consuming-the-spreadsheet)
  which is [snapshotted](https://git.sr.ht/~mil/transito/tree/master/item/src/assets) & embedded in the release binary.
- The **update** link alongside each feed after load let's you update
  feeds from the provided source URL (either Mobility Database's CI
  mirror URL or the direct agency URL - see next point)
- The advanced config parameter **Use Agency GTFS URLs** is very relevant
  to updates. This parameter if checked will use "direct" agency URLs; while
  by default Mobility Database's cloud mirrored bucket CI URLs are used.

A good way to assess whether to update a given GTFS feed is to reference
the daterange alongside the loaded feed (and note this daterange may
change after an update after not using the app for sometime).

## User-Provided GTFS Data & Custom POI Endpoint Search Usage

By default the app is configured to utilize
[GTFS](https://en.wikipedia.org/wiki/GTFS) sources from the [Mobility
Database](https://mobilitydatabase.org/) for stops/routing functionality
and additionally POI searches operate based on the [public Nominatim
instance](https://nominatim.org/). However, for advanced users who
wish to provide their own custom GTFS ZIP data (not listed in the
Mobility Database) the app supports loading custom user-provided GTFS
ZIP files. Also, for users who don't want to use the public Nominatim
instance for POI searches this endpoint is also customizable.

1. To utilize **User-Provided / Custom GTFS Data for Routing**:
  - The **Custom GTFS Zip** button in the Advanced config section can be used to load a custom [GTFS Zip archive](https://en.wikipedia.org/wiki/GTFS)
  - GTFS data must be specifiation conforming, have the `.zip` file extension, and can be sourced from the user's desired transit agency.
  - Custom GTFS data is loaded exactly the same as Mobility Database GTFS feeds; note the custom feed ID `-99` is used for loaded data.
  - The user is responsible for updating data periodically in this scenario by reloading new archives.
2. To utilize a **Custom Nominatim Server for POI Searches**:
  - The field **Nominatim URL Endpoint** can be used in the Advanced config section.
  - This can be an endpoint the user controlls, see [Nominatim hosting information](https://nominatim.org/) for further details.
  - You may use the 'Reset Defaults' button to restore the original / public Nominatim instance endpoint.

## Advanced Config

On the config page there are a number 'Advanced Configuration' option checkboxes.
By default all these are disabled & for pragmatic defaults you shouldn't need to
change anything. If you're interested in fine-tuning however these parameters
can be very helpful.

|**Parameter** | **Disabled Functionality** (Default) | **Enabled Functionality** |
|---|----|---|
| Offline Mode | Online functionality is enabled. This includes the POI tab & GTFS add/updates. | Disables all 'online' functionality (POI tab & GTFS add/updates). |
| Disable Schedules | Upcoming departures are shown on the Stops tab. | Upcoming departures are not shown on the Stops tab (can be helpful for performance issues). |
| Crossfeed Transfers | Computed transfers between separate feeds are not calculated in adding/updating feeds. | Computed transfers are dynamically calculated between feeds when adding/updating feeds |
| Use Agency GTFS URLs | Use **cloud / bucket** CI-generated GTFS URLs when loading or updating feeds. May be occasionally out-of-date as Mobility Database source CSV GTFS bucket URLS are updated *periodically*. However, generally bucket CI mirrored URLs are vastly more *reliable* than any 1 given agency. | Use **direct** agency GTFS URL - always more up-to-date but certain agencies have usage or rate-limiting policies. Upstream GTFS URLs agency URLs reliability guarantees vary in quality among the ~1500 agency providers. |
