# **Transito**: Development Guide
This development guide provides various pointers on local development. If
something from this guide is missing feel free to add it. If you have
a question regarding something on this guide, please open a ticket on
the ticket tracker or send a note to the mailing list.


## Build for Linux (X11/Wayland)
- On Linux, there are a few dependencies to first install
    - See [Gio's Linux Guide](https://gioui.org/doc/install/linux)
    - Dependencies on Alpine Linux: `apk add sqlite-dev libxcursor-dev libxkbcommon-dev libxkbcommon-x11 mesa-egl vulkan-headers wayland-dev mesa-dev xdg-utils xdg-desktop-portal-gtk tzdata`
- Once dependencies are setup, run:
    - `./build.sh blinux`
- Run via `./transito`
- Install via: `./build.sh install`

## Build for Android
- On Android you'll need to have the Android SDK setup
    - See [Gio's Android Guide](https://gioui.org/doc/install/android)
- Note: Android 11 / R / API Version 30 & SQLite version >= 3.28.0 is
  required.
- Once dependencies setup, run:
    - `./build.sh bandroid`
- Once build is complete, you have a new `.apk`:
    - Run `adb install transito.apk` to copy to device
    - Or copy the apk to your device some other way

## Build for Android (via Docker)
- If you don't have Android SDK or don't want to deal with Go/Gio deps,
  you can bake an apk just using docker.
- Run to produce `transito.apk`:
    - `./build.sh bandroid_docker`

## Debugging on Android

- Install ADB Debugging Deps:
    - Alpine Linux ADB Debugging Deps: `apk add android-tools android-udev-rules`
- View Logs:
    - `adb logcat | grep transito`

## Cache Directories

There are a few cache & config directories to be aware of:

- `~/.cache/mobroute`
  - Mobroute's cache: stores cached downloaded GTFS data & master SQLite DB
- `~/.config/transito`
  - Transito config: stores config for transito (e.g. enabled feed IDs, params, etc.)

## Gio Tips

- There are certain situations where the UI state may go out of sync with
  the underlying data and need to be manually rerendered. The Invalidate()
  function on Gio's `Window` can be used for this. Look in the source for
  examples of this such as `page.GlobalState.Window.Invalidate()`
