#!/usr/bin/env sh
set -e

fmt() {
  ag -g '.go$' | xargs -IC go fmt C
}

vercodeandroid() {
  # Android specificies a 'versionCode' which is a numerical
  # increased by 1 for every release / only used for android releases
  # and generally anytime versemver is changed, vercodeandroid should
  # be incremented
  echo "9"
}

# Use 0.x.x when building tags, or 0.x.x-2-g57ad913 otherwise.
ver() {
  # When exporting tarballs, git-archive shall replace this string with the output of git-describe:
  local VERSION='$Format:%(describe)$'
  case "$VERSION" in
    *Format*) git describe --tag | sed 's/^v//' ;;
    *) echo "$VERSION" ;;
  esac
}

versemver() {
  git describe --tag | grep -oE 'v[0-9]+[.][0-9]+[.][0-9]+' | tr -d v
}

bandroid() {
  # E.g. copy sqlite headers to android root as these are required for
  # building custom SQLite shared module; they are automatically picked
  # up in ordinary builds for mobroute/mobsql etc.; however for android
  # gogio build the NDK headers so we just copy into needed NDK dir so
  # build succeeds
  if [ -n "$ANDROID_NDK_ROOT" ]; then
    cp /usr/include/sqlite3* $ANDROID_NDK_ROOT/toolchains/llvm/prebuilt/*/sysroot/usr/include/
  elif [ -n "$ANDROID_SDK_ROOT" ]; then
    cp /usr/include/sqlite3* $ANDROID_SDK_ROOT/ndk-bundle/toolchains/llvm/prebuilt/*/sysroot/usr/include/
  else
    echo "Neither ANDROID_SDK_ROOT nor ANDROID_NDK_ROOT set; failed to copy sqlite-dev headers for build"
  fi

  GOFLAGS="-buildvcs=false -trimpath" gogio \
    -icon assets/transito.png \
    -tags=sqlite_math_functions,android \
    -target android \
    -appid ht.sr.git.mil.transito \
    -version "$(versemver)"."$(vercodeandroid)" \
    -minsdk 30 \
    -ldflags="-buildid= -X git.sr.ht/~mil/transito/src/uipages/pageconfig.Commit=$(ver).$(vercodeandroid)" \
    "$@" .
}

bandroid_dockerdev() {
  docker build --progress=plain -t transito .
  docker run -it -v $(pwd):/transito transito bash
}

bandroid_docker() {
  docker build --progress=plain -t transito .
  docker run -it -v $(pwd):/transito transito ./build.sh bandroid
}

blinux() {
  go build -v -tags=sqlite_math_functions -ldflags="-X git.sr.ht/~mil/transito/src/uipages/pageconfig.Commit=$(ver)"
}

install() {
  mkdir -p /usr/bin /usr/share/applications /usr/share/pixmaps/
  mkdir -p /usr/share/icons/hicolor/16x16/apps
  mkdir -p /usr/share/icons/hicolor/32x32/apps
  mkdir -p /usr/share/icons/hicolor/48x48/apps
  mkdir -p /usr/share/icons/hicolor/128x128/apps
  mkdir -p /usr/share/icons/hicolor/512x512/apps

  cp transito /usr/bin/transito
  cp assets/transito.desktop /usr/share/applications/
  cp assets/transito.png /usr/share/pixmaps/transito.png
  cp assets/transito_16x16.png /usr/share/icons/hicolor/16x16/apps/transito.png
  cp assets/transito_32x32.png /usr/share/icons/hicolor/32x32/apps/transito.png
  cp assets/transito_48x48.png /usr/share/icons/hicolor/48x48/apps/transito.png
  cp assets/transito_128x128.png /usr/share/icons/hicolor/128x128/apps/transito.png
  cp assets/transito_512x512.png /usr/share/icons/hicolor/512x512/apps/transito.png
}

adbinstall() {
  adb uninstall ht.sr.git.transito || echo "uninstall fail"
  adb install transito.apk
}

adbflush() {
  adb kill-server
  adb start-server
}

updatemr() {
  GOPROXY=direct go get -v -u git.sr.ht/~mil/mobroute@master
}

um() {
  updatemr
}

run() {
  blinux
  ./transito
}

"$@"
