package pagestops

import (
	"fmt"
	"image/color"
	"log"

	"gioui.org/layout"
	"gioui.org/op/clip"
	"gioui.org/op/paint"
	"gioui.org/unit"
	"gioui.org/widget/material"
	"git.sr.ht/~mil/transito/src/uipages/pagestops/integrations"
)

func (widget *PageStops) renderSearchWidgetsStops(gtx layout.Context) []layout.Widget {
	if len(widget.GlobalState.Save.FeedIDsEnabled) == 0 {
		return []layout.Widget{
			material.Body1(widget.GlobalState.Theme, "Must enable atleast 1 GTFS source to search stops").Layout,
		}
	}

	widgetSearch := func(gtx layout.Context) layout.Dimensions {
		if tableData, err := integrations.MobrouteStopsTableData(
			widget.GlobalState.MobrouteRuntime,
			widget.GlobalState.Save.FeedIDsEnabled,
			widget.stopsSearchTextfield.Text(),
		); err != nil {
			log.Println("Error with MR integration for stops page", err)
			widget.stopsSelectListItems = []string{
				fmt.Sprintf("Error: %v", err),
			}
		} else {
			widget.stopsSelectListItems = *tableData
		}

		l := layout.List{Axis: layout.Vertical}
		return l.Layout(gtx, 3, func(gtx layout.Context, i int) layout.Dimensions {
			if i == 0 {
				gtx.Constraints.Min.Y = gtx.Dp(unit.Dp(50))
				gtx.Constraints.Max.Y = gtx.Constraints.Min.Y

				flexItems := []layout.FlexChild{
					layout.Flexed(0.5, func(gtx layout.Context) layout.Dimensions {
						gtx.Constraints.Min.Y = gtx.Dp(unit.Dp(1))
						widget.stopsSearchTextfield.SingleLine = true
						return widget.stopsSearchTextfield.Layout(gtx, widget.GlobalState.Theme, "Filter Stops")
					}),
				}
				return layout.Flex{}.Layout(gtx, layout.Rigid(dimensionsToWidget(layout.Flex{}.Layout(gtx, flexItems...))))
			} else if i == 1 {
				return layout.Spacer{Height: unit.Dp(20)}.Layout(gtx)
			} else {
				if len(widget.stopsSelectListItems) > 0 {
					gtx.Constraints.Min.Y = gtx.Dp(unit.Dp(20))
					gtx.Constraints.Max.Y = gtx.Dp(unit.Dp(150))
					return widget.stopsSelectList.Layout(
						gtx,
						len(widget.stopsSelectListItems),
						func(gtx layout.Context, index int) layout.Dimensions {
							defer clip.Rect{Max: gtx.Constraints.Max}.Push(gtx.Ops).Pop()
							switch {
							case widget.stopsSelectList.Selected == index:
								paint.Fill(gtx.Ops, color.NRGBA{R: 0xFF, G: 0xF0, B: 0xF0, A: 0xFF})
							case widget.stopsSelectList.Hovered == index:
								paint.Fill(gtx.Ops, color.NRGBA{R: 0xF0, G: 0xFF, B: 0xF0, A: 0xFF})
							}
							inset := layout.Inset{Top: 1, Right: 4, Bottom: 1, Left: 4}
							return inset.Layout(gtx, material.Body1(widget.GlobalState.Theme, widget.stopsSelectListItems[index]).Layout)
						},
					)
				} else {
					return layout.Spacer{Height: unit.Dp(0)}.Layout(gtx)
				}
			}
		})
	}

	widgets := []layout.Widget{
		widgetSearch,
	}
	return widgets
}
