package pageroute

import (
	"gioui.org/layout"
	"gioui.org/unit"
	"gioui.org/widget/material"
	"git.sr.ht/~mil/transito/src/components/divider"
)

func (page *PageRoute) widgetRowParams(gtx layout.Context) []layout.Widget {
	widgetCheckboxesTransfers := func(gtx layout.Context) layout.Dimensions {
		gtx.Constraints.Min.Y = gtx.Dp(unit.Dp(40))
		gtx.Constraints.Max.Y = gtx.Constraints.Min.Y
		return layout.Flex{}.Layout(gtx, layout.Rigid(dimensionsToWidget(layout.Flex{}.Layout(
			gtx,
			layout.Flexed(0.2, material.CheckBox(page.GlobalState.Theme, &page.checkboxTransfersFeed, "Feed\nTransfers").Layout),
			layout.Flexed(0.01, layout.Spacer{Width: unit.Dp(2)}.Layout),
			layout.Flexed(0.2, material.CheckBox(page.GlobalState.Theme, &page.checkboxTransfersImplicit, "Implicit\nTransfers").Layout),
			layout.Flexed(0.01, layout.Spacer{Width: unit.Dp(2)}.Layout),
			layout.Flexed(0.2, material.CheckBox(page.GlobalState.Theme, &page.checkboxTransfersGenerated, "Generated\nTransfers").Layout),
		))))
	}

	// Route params
	widgetTextfieldMaxWalkMinutes := func(gtx layout.Context) layout.Dimensions {
		gtx.Constraints.Min.Y = gtx.Dp(unit.Dp(15))
		page.textfieldMaxWalkMinutes.SingleLine = true
		return page.textfieldMaxWalkMinutes.Layout(gtx, page.GlobalState.Theme, "Max Wᵐ")
	}
	widgetTextfieldMaxTripMinutes := func(gtx layout.Context) layout.Dimensions {
		gtx.Constraints.Min.Y = gtx.Dp(unit.Dp(15))
		page.textfieldMaxTripMinutes.SingleLine = true
		return page.textfieldMaxTripMinutes.Layout(gtx, page.GlobalState.Theme, "Max Tᵐ")
	}
	widgetTextfieldMinTransferMinutes := func(gtx layout.Context) layout.Dimensions {
		gtx.Constraints.Min.Y = gtx.Dp(unit.Dp(15))
		page.textfieldMinTransferMinutes.SingleLine = true
		return page.textfieldMinTransferMinutes.Layout(gtx, page.GlobalState.Theme, "Min Cᵐ")
	}
	widgetTextfieldMaxTransferMinutes := func(gtx layout.Context) layout.Dimensions {
		gtx.Constraints.Min.Y = gtx.Dp(unit.Dp(15))
		page.textfieldMaxTransferMinutes.SingleLine = true
		return page.textfieldMaxTransferMinutes.Layout(gtx, page.GlobalState.Theme, "Max Cᵐ")
	}
	widgetTextfieldWalkspeedKmHr := func(gtx layout.Context) layout.Dimensions {
		gtx.Constraints.Min.Y = gtx.Dp(unit.Dp(15))
		page.textfieldWalkspeedKmHr.SingleLine = true
		return page.textfieldWalkspeedKmHr.Layout(gtx, page.GlobalState.Theme, "Wᵏᵐʰʳ")
	}

	widgetRouteNumbersRow := func(gtx layout.Context) layout.Dimensions {
		gtx.Constraints.Min.Y = gtx.Dp(unit.Dp(40))
		gtx.Constraints.Max.Y = gtx.Constraints.Min.Y
		return layout.Flex{}.Layout(gtx, layout.Rigid(dimensionsToWidget(layout.Flex{}.Layout(
			gtx,
			layout.Flexed(0.2, widgetTextfieldMaxWalkMinutes),
			layout.Flexed(0.2, widgetTextfieldMaxTripMinutes),
			layout.Flexed(0.2, widgetTextfieldMinTransferMinutes),
			layout.Flexed(0.2, widgetTextfieldMaxTransferMinutes),
			layout.Flexed(0.2, widgetTextfieldWalkspeedKmHr),
		))))
	}

	return []layout.Widget{
		divider.Divider(page.GlobalState.Theme).Layout,
		material.Body1(page.GlobalState.Theme, "Parameters").Layout,
		widgetRouteNumbersRow,
		widgetCheckboxesTransfers,
	}
}
