package pagepois

import (
	"time"

	"gioui.org/font/gofont"
	"gioui.org/layout"
	"gioui.org/text"
	"gioui.org/unit"
	"gioui.org/widget"
	"gioui.org/widget/material"
	"gioui.org/x/component"
	"gioui.org/x/richtext"
	"git.sr.ht/~mil/transito/src/components/buttonrow"
	"git.sr.ht/~mil/transito/src/components/selectlist"
	"git.sr.ht/~mil/transito/src/globalstate"
)

type PagePOI struct {
	GlobalState *globalstate.GlobalState
	list        widget.List
	buttonRow   buttonrow.ButtonRow

	// POI section related
	clickableSearch     widget.Clickable
	poisSelectList      selectlist.SelectList
	poisSelectListItems []string
	TimerStartNominatim *time.Time
	textfieldPOI        component.TextField

	// Selected
	richtextSelected richtext.InteractiveText
	clickableSetFrom widget.Clickable
	clickableSetTo   widget.Clickable
	clickableSetFav  widget.Clickable
}

func Initialize(u *globalstate.GlobalState) *PagePOI {
	page := PagePOI{
		GlobalState: u,
		list:        widget.List{List: layout.List{Axis: layout.Vertical}},

		poisSelectList: selectlist.SelectList{
			List:       widget.List{List: layout.List{Axis: layout.Vertical}},
			ItemHeight: unit.Dp(24),
			Theme:      u.Theme,
		},
		poisSelectListItems: []string{},

		TimerStartNominatim: nil,
		textfieldPOI:        component.TextField{Editor: widget.Editor{ReadOnly: false}},
	}
	page.GlobalState.Theme.Shaper = text.NewShaper(text.WithCollection(gofont.Collection()))
	return &page
}

func (page *PagePOI) Render(gtx layout.Context) layout.Dimensions {

	var widgetsScroll = []layout.Widget{}
	if len(page.GlobalState.Save.FeedIDsEnabled) == 0 {
		widgetsScroll = append(
			widgetsScroll,
			material.Body1(page.GlobalState.Theme, "Must enable atleast 1 GTFS source to search").Layout,
		)
	} else {
		widgetsScroll = append(widgetsScroll, page.renderSearchWidgetsPOIs(gtx)...)
		widgetsScroll = append(widgetsScroll, page.renderSearchWidgetsSelected(gtx)...)
	}

	return material.List(page.GlobalState.Theme, &page.list).Layout(
		gtx,
		len(widgetsScroll),
		func(gtx layout.Context, i int) layout.Dimensions {
			return layout.UniformInset(unit.Dp(16)).Layout(gtx, widgetsScroll[i])
		},
	)
}
