package pagepois

import (
	"errors"
	"gioui.org/layout"
	"strconv"
	"strings"
)

func wgToWidget(widget *PagePOI, wg func(widget *PagePOI, gtx layout.Context) layout.Dimensions) func(layout.Context) layout.Dimensions {
	return func(gtx layout.Context) layout.Dimensions {
		return wg(widget, gtx)
	}
}

func dimensionsToWidget(d layout.Dimensions) func(gtx layout.Context) layout.Dimensions {
	return func(gtx layout.Context) layout.Dimensions {
		return d
	}
}

func setFromTo(page *PagePOI, fromOrTo, inputTextLabel string) {
	if label, coords, err := parseLatLon(inputTextLabel); err == nil {
		if fromOrTo == "from" {
			page.GlobalState.LocationFromCoords = coords
			page.GlobalState.LocationFromLabel = label
		} else {
			page.GlobalState.LocationToCoords = coords
			page.GlobalState.LocationToLabel = label
		}
		page.GlobalState.TabSelected = "Route"
		page.GlobalState.Window.Invalidate()
	}
}

func parseLatLon(str string) (string, []float64, error) {
	splt := strings.Split(str, " Latlon: ")
	if len(splt) < 2 {
		return "", nil, errors.New("Couldn't find 'Latlon:' text")
	}
	coords := strings.Split(splt[1], " ")
	if lat, err := strconv.ParseFloat(strings.TrimSpace(coords[0]), 64); err != nil {
		return "", nil, err
	} else if lon, err := strconv.ParseFloat(strings.TrimSpace(coords[1]), 64); err != nil {
		return "", nil, err
	} else {
		return splt[0], []float64{lat, lon}, nil
	}
}

func removeAtIndex[T any](slice []T, idx int) []T {
	return append(slice[:idx], slice[idx+1:]...)
}
