package pageconfig

import (
	"fmt"
	"strconv"
	"strings"

	"gioui.org/layout"
	"gioui.org/widget/material"
	"gioui.org/x/richtext"
	"git.sr.ht/~mil/transito/src/globalstate"
	"git.sr.ht/~mil/transito/src/uipages/pageconfig/integrations"
	"git.sr.ht/~mil/transito/src/util/utilfuncs"
	"git.sr.ht/~mil/transito/src/util/utillinkhandler"
)

func (page *PageConfig) renderConfigWidgetsFeedsManage(gtx layout.Context) []layout.Widget {
	if sourcesClick := utillinkhandler.HandleLinkEvents(page.GlobalState.Window, &page.richtextFeeds, gtx); sourcesClick != "" {
		splt := strings.Split(sourcesClick, ":")
		if len(splt) >= 2 {
			if splt[0] == "feedid_remove" {
				m, _ := strconv.Atoi(splt[1])
				page.GlobalState.Save.FeedIDsEnabled = utilfuncs.RemoveItem(
					page.GlobalState.Save.FeedIDsEnabled, m,
				)
				page.GlobalState.Window.Invalidate()
			}
			if splt[0] == "feedid_update" {
				feedID, _ := strconv.Atoi(splt[1])
				page.GlobalState.AppQueueload = &globalstate.AppQueueload{FeedIDUpdate: &feedID, ReturnToTab: "Config"}
			}
		}
	}
	feedsText := func() func(gtx layout.Context) layout.Dimensions {
		spans := []richtext.SpanStyle{}
		var renderMarkdownLines = []string{}
		if len(page.GlobalState.Save.FeedIDsEnabled) == 0 {
			renderMarkdownLines = append(renderMarkdownLines,
				"You have not configured any GTFS feeds! Please add a GTFS feed below.",
			)
		} else {
			renderMarkdownLines = append(renderMarkdownLines,
				fmt.Sprintf("The enabled (**%d**) GTFS feeds data will be used for routing requests:", len(page.GlobalState.Save.FeedIDsEnabled)),
			)
			if datalines, err := integrations.MobrouteIntegrationGetTableDataForFeedIDs(
				page.GlobalState.MobrouteRuntime,
				nil,
				ptr(page.GlobalState.Save.FeedIDsEnabled),
				true,
				page.GlobalState.Save.CfgOfflineMode,
			); err != nil {
				renderMarkdownLines = append(renderMarkdownLines, fmt.Sprintf("Error: %v", err))
			} else {
				for _, l := range *datalines {
					renderMarkdownLines = append(renderMarkdownLines, fmt.Sprintf("- %s", l))
				}
			}
		}

		if rendered, err := page.GlobalState.MarkdownRenderer.Render([]byte(fmt.Sprintf(strings.Join(renderMarkdownLines, "\n")))); err == nil {
			spans = rendered
		}
		return richtext.Text(&page.richtextFeeds, page.GlobalState.Theme.Shaper, spans...).Layout
	}()

	widgets := []layout.Widget{
		material.H6(page.GlobalState.Theme, "Manage GTFS Feeds").Layout,
		feedsText,
	}
	return widgets
}
