package pageconfig

import (
	"fmt"
	"image/color"
	"log"
	"strconv"
	"strings"

	"gioui.org/layout"
	"gioui.org/op/clip"
	"gioui.org/op/paint"
	"gioui.org/unit"
	"gioui.org/widget/material"
	"git.sr.ht/~mil/transito/src/globalstate"
	"git.sr.ht/~mil/transito/src/uipages/pageconfig/integrations"
	"git.sr.ht/~mil/transito/src/util/utilfuncs"
)

func (page *PageConfig) renderConfigWidgetsFeedsAdd(gtx layout.Context) []layout.Widget {

	if page.searchClickable.Clicked(gtx) {
		if page.searchSelectList.Selected <= len(page.searchSelectListItems)-1 {
			if splt := strings.Split(page.searchSelectListItems[page.searchSelectList.Selected], ":"); len(splt) > 1 {
				if feedID, err := strconv.Atoi(splt[0]); err == nil {
					if !utilfuncs.Contains(page.GlobalState.Save.FeedIDsEnabled, feedID) {
						page.GlobalState.AppQueueload = &globalstate.AppQueueload{FeedIDLoadAndCompute: &feedID, ReturnToTab: "Config"}
					}
				}
			}
		}
		page.searchTextfield.Clear()
		page.searchSelectListItems = []string{}
	}

	if tableData, err := integrations.MobrouteIntegrationGetTableDataForFeedIDs(
		page.GlobalState.MobrouteRuntime,
		ptr(page.searchTextfield.Text()),
		nil,
		false,
		false,
	); err != nil {
		log.Println("Error with MR integration for config page", err)
	} else {
		page.searchSelectListItems = *tableData
	}

	widgetSelectList := func(gtx layout.Context) layout.Dimensions {
		gtx.Constraints.Min.Y = gtx.Dp(unit.Dp(20))
		gtx.Constraints.Max.Y = gtx.Dp(unit.Dp(150))

		return page.searchSelectList.Layout(
			gtx,
			len(page.searchSelectListItems),
			func(gtx layout.Context, index int) layout.Dimensions {
				defer clip.Rect{Max: gtx.Constraints.Max}.Push(gtx.Ops).Pop()
				switch {
				case page.searchSelectList.Selected == index:
					paint.Fill(gtx.Ops, color.NRGBA{R: 0xFF, G: 0xF0, B: 0xF0, A: 0xFF})
				case page.searchSelectList.Hovered == index:
					paint.Fill(gtx.Ops, color.NRGBA{R: 0xF0, G: 0xFF, B: 0xF0, A: 0xFF})
				}
				inset := layout.Inset{Top: 1, Right: 4, Bottom: 1, Left: 4}
				return inset.Layout(gtx, material.Body1(page.GlobalState.Theme, page.searchSelectListItems[index]).Layout)
			},
		)
	}

	widgetSearch := func(gtx layout.Context) layout.Dimensions {
		l := layout.List{Axis: layout.Vertical}
		return l.Layout(gtx, 3, func(gtx layout.Context, i int) layout.Dimensions {
			if i == 0 {
				gtx.Constraints.Min.Y = gtx.Dp(unit.Dp(50))
				gtx.Constraints.Max.Y = gtx.Constraints.Min.Y

				flexItems := []layout.FlexChild{
					layout.Flexed(0.5, func(gtx layout.Context) layout.Dimensions {
						gtx.Constraints.Min.Y = gtx.Dp(unit.Dp(20))
						page.searchTextfield.SingleLine = true
						return page.searchTextfield.Layout(gtx, page.GlobalState.Theme, "Search GTFS Sources")
					}),
				}
				if page.searchSelectList.Selected <= len(page.searchSelectListItems)-1 {
					var btnText string = "?"
					splt := strings.Split(page.searchSelectListItems[page.searchSelectList.Selected], ":")
					if len(splt) < 1 {
						btnText = "ERR"
					} else {
						btnText = fmt.Sprintf("Add %s", splt[0])
					}
					flexItems = append(flexItems, []layout.FlexChild{
						layout.Flexed(0.01, layout.Spacer{Width: unit.Dp(2)}.Layout),
						layout.Flexed(0.2, material.Button(page.GlobalState.Theme, &page.searchClickable, btnText).Layout),
					}...)
				}
				return layout.Flex{}.Layout(gtx, layout.Rigid(dimensionsToWidget(layout.Flex{}.Layout(gtx, flexItems...))))
			} else if i == 1 {
				return layout.Spacer{Height: unit.Dp(20)}.Layout(gtx)
			} else {
				if len(page.searchSelectListItems) > 0 {
					return widgetSelectList(gtx)
				} else {
					return layout.Spacer{Height: unit.Dp(0)}.Layout(gtx)
				}
			}
		})
	}

	widgets := []layout.Widget{
		//material.H6(page.GlobalState.Theme, "Add a GTFS Feed").Layout,
		//material.Body1(page.GlobalState.Theme, "Add a GTFS Feed:").Layout,
		widgetSearch,
	}
	return widgets
}
