# Transito

[![builds.sr.ht status](https://builds.sr.ht/~mil/transito/commits/master.svg)](https://builds.sr.ht/~mil/transito?)

<a href="https://mr.lrdu.org/transito/doc/doc_transito_screenshots"><img width="300px" src='https://git.sr.ht/~mil/transito/blob/master/doc/transito_screenshot_routesteps.png' /></a>  <a href="https://mr.lrdu.org/transito/doc/doc_transito_screenshots/"><img width="300px" src='https://git.sr.ht/~mil/transito/blob/master/doc/transito_screenshot_routemap.png' /></a>

**Transito** is a **FOSS data-provider-agnostic public
transportation app** that let's you route between locations using
openly available public GTFS feeds. Utilizing the [Mobroute Go
Library](http://sr.ht/~mil/mobroute), the Transito app lets you performs
routing calculations offline / right on your phone (e.g. no network
calls once data is initially fetched). Overall, Transito aims to be an
opensource alternative to proprietary routing apps (such as Google Maps,
etc.) to get users from point-a to point-b via public transit without
comprising privacy or user freedoms. It works in many well-connected
metros which have publicly available GTFS data, to name a few: Lisbon,
NYC, Brussels, Krakow, and Bourges ([check for compatability with your
metro here](http://mdb.lrdu.org)).

The app is currently in active development but generally usable on
Android & Linux and looking for more users & testers.

## **App Documentation**

- **Documentation Website:** [Documentation Website for Transito](https://mr.lrdu.org/transito)
- **Transito Doc:** [Mobile Userguide](doc/doc_transito_userguide.md), [Mobile Screenshots](doc/doc_transito_screenshots.md), [Development Guide](doc/doc_transito_development.md)
- **Project Management:** [Bugtracker](https://todo.sr.ht/~mil/mobroute-tickets), [Mailing List](https://lists.sr.ht/~mil/mobroute-devel), [Contribute](https://git.sr.ht/~mil/mobroute/tree/HEAD/doc/doc_contribute.md)
- **CI:** [Test Results](http://ci.lrdu.org/tests_results/), [Generated APKs](http://ci.lrdu.org/android/), [Builds](https://builds.sr.ht/~mil/transito?search=tags%3Amaster)
- **Related:** [Mobroute](https://mr.lrdu.org/mobroute/) (GTFS Routing Library), [Mobsql](https://mr.lrdu.org/mobsql/) (GTFS-to-SQLite ETL library)

## **App Overview / Featureset**

- Simple Mobile App to **perform GTFS routing calculations on-device & offline**
    - Uses [Mobroute](http://git.sr.ht/~mil/mobroute)'s ETL & routing calculation engine to pull GTFS data
      from upstream servers directly and uses CSA algorithm to perform routing
      calculations right on-device
    - Routing algorithm itself functions entirely offline once data is pulled
- Provides **routing results in both steps & map view formats**
    - Routing results from Mobroute's routing library are parsed into a simple
      step-by-step instruction format for the user to follow
    - A map view URL link is provided to see the results of the route on a OSM
      map view as provided by Mobroute's library
- Allows **selecting stops from GTFS data & searching for POIs via Nominatim**
    - Select stops from the GTFS data to route from/to
    - See departure times for each stop
    - Alternatively, search for POIs in the feed's specified bounding box via [Nominatim](https://nominatim.org/)
    - Also you can specify destination by address etc.
- Simple **configuration system & algorithm tunables**
    - **No manual import of GTFS files**; simply specify [GTFS Feed ID](https://mr.lrdu.org/mobroute/doc/doc_gtfsfeeds/) to determine
      which upstream GTFS datafeed(s) to use and Mobroute underlying library
      takes care of the rest
    - User can adjust algorithm tunables such as maximum walk distance, maximum
      transfer seconds, walk speed, and similar
- Offers a **reference implementation for using [Mobroute's Go Routing Library](http://sr.ht/~mil/mobroute)**
    - Mobroute's library lets other developer integrate Mobroute's public transit
      GTFS ETL & routing calculation engine in their own navigation apps
    - Transito offers a simple reference implementation & exmaple of using
      Mobroute's Go library
    - Implemented in Go via [Gio](https://gioui.org/) thus allowing simple
      portability to many platforms; Android & Linux tested in development,
      ostensibly supports other Gio other platforms: MacOS, Windows, iOS, etc.


## **Packaging Links**

[![Packaging status](https://repology.org/badge/vertical-allrepos/transito.svg)](https://repology.org/project/transito/versions)  [<img src="https://fdroid.gitlab.io/artwork/badge/get-it-on.png" alt="Get it on F-Droid" height="80">](https://f-droid.org/packages/ht.sr.git.mil.transito)
