package pageroute

import (
	"gioui.org/font"
	"gioui.org/layout"
	"gioui.org/widget/material"
	"git.sr.ht/~mil/transito/src/components/styledbutton"
)

func (page *PageRoute) widgetRowLogToggle(gtx layout.Context) []layout.Widget {
	// Initial load (e.g. empty)
	if page.ResultMRRouteError == nil && page.ResultMRRoute == nil {
		return []layout.Widget{}
	}

	// Disabled dbglog
	if !page.ResultMRRouteErrorDbglog {
		return []layout.Widget{}
	}

	// Has result, so only show at end of debug tab
	if page.ResultMRRoute != nil && page.buttonRow.ActiveButtonLabel != "Debug" {
		return []layout.Widget{}
	}

	// Handle to toggle show/hide log
	if page.clickableShowHideLog.Clicked(gtx) {
		page.showLog = !page.showLog
	}

	returnWidgets := []layout.Widget{}
	returnWidgets = append(
		returnWidgets,
		styledbutton.StyledButtonSmall(
			gtx, *page.GlobalState.Theme, &page.clickableShowHideLog,
			fif(page.showLog, "Hide Log", "Show Log"),
		),
	)
	if page.showLog {
		logText := material.Body2(page.GlobalState.Theme, page.GlobalState.MobrouteLog.String())
		logText.Font.Style = font.Italic
		returnWidgets = append(returnWidgets, logText.Layout)
	}

	return returnWidgets
}
