package pagepois

import (
	"fmt"
	"image/color"
	"time"

	"gioui.org/layout"
	"gioui.org/op/clip"
	"gioui.org/op/paint"
	"gioui.org/unit"
	"gioui.org/widget/material"
	"git.sr.ht/~mil/transito/src/uipages/pagepois/integrations"
)

func (widget *PagePOI) renderSearchWidgetsPOIs(gtx layout.Context) []layout.Widget {
	widget.eventhandlersSearchWidgetsPOIs(gtx)
	// Searchbox
	widgetSearchbox := func(gtx layout.Context) layout.Dimensions {
		gtx.Constraints.Min.Y = gtx.Dp(unit.Dp(50))
		gtx.Constraints.Max.Y = gtx.Constraints.Min.Y

		return layout.Flex{}.Layout(gtx, layout.Rigid(dimensionsToWidget(layout.Flex{}.Layout(
			gtx,
			layout.Flexed(0.5, func(gtx layout.Context) layout.Dimensions {
				gtx.Constraints.Min.Y = gtx.Dp(unit.Dp(1))
				widget.textfieldPOI.SingleLine = true
				return widget.textfieldPOI.Layout(gtx, widget.GlobalState.Theme, "Nominatim Search")
			}),
			layout.Flexed(0.01, layout.Spacer{Width: unit.Dp(2)}.Layout),
			layout.Flexed(0.2, material.Button(widget.GlobalState.Theme, &widget.clickableSearch, "Search").Layout),
		))))
	}

	// Select list
	widgetSelectList := func(gtx layout.Context) layout.Dimensions {
		gtx.Constraints.Min.Y = gtx.Dp(unit.Dp(20))
		gtx.Constraints.Max.Y = gtx.Dp(unit.Dp(150))

		if len(widget.poisSelectListItems) < 1 {
			return layout.Spacer{Height: unit.Dp(0)}.Layout(gtx)
		}
		return widget.poisSelectList.Layout(
			gtx,
			len(widget.poisSelectListItems),
			func(gtx layout.Context, index int) layout.Dimensions {
				defer clip.Rect{Max: gtx.Constraints.Max}.Push(gtx.Ops).Pop()
				switch {
				case widget.poisSelectList.Selected == index:
					paint.Fill(gtx.Ops, color.NRGBA{R: 0xFF, G: 0xF0, B: 0xF0, A: 0xFF})
				case widget.poisSelectList.Hovered == index:
					paint.Fill(gtx.Ops, color.NRGBA{R: 0xF0, G: 0xFF, B: 0xF0, A: 0xFF})
				}
				inset := layout.Inset{Top: 1, Right: 4, Bottom: 1, Left: 4}
				return inset.Layout(gtx, material.Body1(widget.GlobalState.Theme, widget.poisSelectListItems[index]).Layout)
			},
		)
	}

	widgets := []layout.Widget{widgetSearchbox}
	if len(widget.poisSelectListItems) > 0 {
		widgets = append(widgets, widgetSelectList)
	}
	return widgets
}

func (widget *PagePOI) eventhandlersSearchWidgetsPOIs(gtx layout.Context) {
	if widget.clickableSearch.Clicked(gtx) {
		go func() {
			now := time.Now()
			widget.TimerStartNominatim = &now
			defer func() {
				widget.TimerStartNominatim = nil
				widget.GlobalState.Window.Invalidate()
			}()

			if bbox, err := integrations.MRIntegrationGetBboxForFeedIDs(
				widget.GlobalState.MobrouteRuntime,
				widget.GlobalState.Save.FeedIDsEnabled,
			); err != nil {
				widget.poisSelectListItems = []string{fmt.Sprintf("Mobroute BBox Determination error: %v", err)}
			} else if result, err := integrations.FetchNominatimWithBbox(widget.textfieldPOI.Text(), bbox); err != nil {
				widget.poisSelectListItems = []string{fmt.Sprintf("Nominatim Fetch error: %v", err)}
			} else {
				widget.poisSelectListItems = []string{}
				for _, item := range *result {
					widget.poisSelectListItems = append(widget.poisSelectListItems, fmt.Sprintf(
						"%s - Latlon: %s %s",
						item.DisplayName, item.Lat, item.Lon,
					))
				}
			}
		}()
	}
	if widget.TimerStartNominatim != nil {
		widget.poisSelectListItems = []string{
			fmt.Sprintf("%.1fs", time.Now().Sub(*widget.TimerStartNominatim).Seconds()),
		}
		widget.GlobalState.Window.Invalidate()
	}
}
