package pageconfig

import (
	"gioui.org/layout"
	"gioui.org/unit"
	"gioui.org/widget/material"
	"git.sr.ht/~mil/transito/src/components/divider"
)

func (page *PageConfig) renderConfigWidgetsAdvanced(gtx layout.Context) []layout.Widget {
	widgetCheckboxesRowA := func(gtx layout.Context) layout.Dimensions {
		gtx.Constraints.Min.Y = gtx.Dp(unit.Dp(40))
		gtx.Constraints.Max.Y = gtx.Constraints.Min.Y
		return layout.Flex{}.Layout(gtx, layout.Rigid(dimensionsToWidget(layout.Flex{}.Layout(
			gtx,
			layout.Flexed(0.2, material.CheckBox(page.GlobalState.Theme, &page.checkboxCfgOfflineMode, "Offline\nMode").Layout),
			layout.Flexed(0.01, layout.Spacer{Width: unit.Dp(2)}.Layout),
			layout.Flexed(0.2, material.CheckBox(page.GlobalState.Theme, &page.checkboxCfgSchedule, "Disable\nSchedules").Layout),
			layout.Flexed(0.01, layout.Spacer{Width: unit.Dp(2)}.Layout),
			layout.Flexed(0.2, material.CheckBox(page.GlobalState.Theme, &page.checkboxCfgCrossfeedCompute, "Crossfeed\nTransfers").Layout),
		))))
	}
	return []layout.Widget{
		divider.Divider(page.GlobalState.Theme).Layout,
		material.H6(page.GlobalState.Theme, "Advanced Configuration").Layout,
		widgetCheckboxesRowA,
	}
}
