package pageconfig

import (
	"gioui.org/layout"
	"gioui.org/unit"
	"gioui.org/widget"
	"gioui.org/widget/material"
	"gioui.org/x/component"
	"gioui.org/x/richtext"
	"git.sr.ht/~mil/transito/src/components/selectlist"
	"git.sr.ht/~mil/transito/src/globalstate"
)

type PageConfig struct {
	GlobalState                 *globalstate.GlobalState
	richtextFeeds               richtext.InteractiveText
	richtextHelp                richtext.InteractiveText
	searchTextfield             component.TextField
	searchSelectList            selectlist.SelectList
	searchSelectListItems       []string
	searchClickable             widget.Clickable
	checkboxCfgSchedule         widget.Bool
	checkboxCfgOfflineMode      widget.Bool
	checkboxCfgCrossfeedCompute widget.Bool
	list                        widget.List
}

func Initialize(u *globalstate.GlobalState) *PageConfig {
	page := PageConfig{
		GlobalState: u,
		list:        widget.List{List: layout.List{Axis: layout.Vertical}},
		searchSelectList: selectlist.SelectList{
			List:       widget.List{List: layout.List{Axis: layout.Vertical}},
			ItemHeight: unit.Dp(24),
			Theme:      u.Theme,
		},
		searchSelectListItems: []string{},
		searchTextfield:       component.TextField{Editor: widget.Editor{}},
	}
	page.checkboxCfgOfflineMode.Value = page.GlobalState.Save.CfgOfflineMode
	page.checkboxCfgSchedule.Value = page.GlobalState.Save.CfgDisableSchedules
	page.checkboxCfgCrossfeedCompute.Value = page.GlobalState.Save.CfgCrossfeedCompute
	page.SyncStateToGlobalState()
	return &page
}

func (page *PageConfig) SyncStateToGlobalState() {
	stateChanged := page.GlobalState.Save.CfgOfflineMode != page.checkboxCfgOfflineMode.Value
	page.GlobalState.Save.CfgOfflineMode = page.checkboxCfgOfflineMode.Value
	page.GlobalState.Save.CfgDisableSchedules = page.checkboxCfgSchedule.Value
	page.GlobalState.Save.CfgCrossfeedCompute = page.checkboxCfgCrossfeedCompute.Value
	if stateChanged {
		// Forces rerender so POI tab hides/shows without extra userinput
		page.GlobalState.Window.Invalidate()
	}
}

func (page *PageConfig) Render(gtx layout.Context) layout.Dimensions {
	page.checkboxCfgOfflineMode.Update(gtx)
	page.checkboxCfgSchedule.Update(gtx)
	page.checkboxCfgCrossfeedCompute.Update(gtx)
	page.SyncStateToGlobalState()

	widgetsScroll := []layout.Widget{}
	widgetsScroll = append(widgetsScroll, page.renderConfigWidgetsFeedsManage(gtx)...)
	if !page.GlobalState.Save.CfgOfflineMode {
		widgetsScroll = append(widgetsScroll, page.renderConfigWidgetsFeedsAdd(gtx)...)
	}
	widgetsScroll = append(widgetsScroll, page.renderConfigWidgetsAdvanced(gtx)...)
	widgetsScroll = append(widgetsScroll, page.renderConfigWidgetsHelp(gtx)...)

	return material.List(page.GlobalState.Theme, &page.list).Layout(gtx, len(widgetsScroll), func(gtx layout.Context, i int) layout.Dimensions {
		return layout.UniformInset(unit.Dp(16)).Layout(gtx, widgetsScroll[i])
	})
}
