package styledbutton

import (
	"image/color"

	"gioui.org/layout"
	"gioui.org/unit"
	"gioui.org/widget"
	"gioui.org/widget/material"
)

func StyledButtonSmall(
	gtx layout.Context, baseTheme material.Theme, clickable *widget.Clickable, label string,
) func(gtx layout.Context) layout.Dimensions {
	returnTheme := baseTheme
	returnTheme.TextSize = 10
	returnTheme.Palette = material.Palette{
		Bg:         rgb(0x000000),
		Fg:         rgb(0x000000),
		ContrastBg: rgb(0xe8e8e8),
		ContrastFg: rgb(0x888888),
	}
	b := material.Button(
		&returnTheme,
		clickable,
		label,
	)
	pad := unit.Dp(10)
	b.Inset = layout.Inset{Top: pad, Left: pad, Right: pad, Bottom: pad}
	return func(gtx layout.Context) layout.Dimensions {
		gtx.Constraints.Min.X = gtx.Dp(unit.Dp(50))
		gtx.Constraints.Max.X = gtx.Dp(unit.Dp(300))
		return b.Layout(gtx)
	}
}

func rgb(cbase uint32) color.NRGBA {
	c := 0xff000000 | cbase
	return color.NRGBA{A: uint8(c >> 24), R: uint8(c >> 16), G: uint8(c >> 8), B: uint8(c)}
}
