package buttonrow

import (
	"gioui.org/layout"
	"gioui.org/widget"
	"gioui.org/widget/material"
	"git.sr.ht/~mil/transito/src/util/utiltheme"
)

const (
	AlignLeft int = iota
	AlignRight
)

type Align int

type Button struct {
	Align       Align
	Label       string
	Themecolor  utiltheme.Themecolor
	CanActivate bool
	Callback    func(layout.Context)
	Hide        bool

	clickable widget.Clickable
}

type ButtonRow struct {
	Theme                  *material.Theme
	Buttons                []Button
	ActiveButtonLabel      string
	ActiveButtonThemecolor utiltheme.Themecolor
}
