# **Transito**:  Userguide

[Transito](http://git.sr.ht/~mil/transito) is FOSS
data-provider-agnostic public transportation app that let's you route
between locations using openly available public GTFS feeds. For
an overview of Transito's functionality see [Transito's project
page](http://git.sr.ht/~mil/transito). This document is a guide on how
to get Transito setup on your local device.

- *1:* [Install](#stronginstallstrong)
- *2:* [Primer Documentation](#strongprimer-documentationstrong)
- *3:* [Usage](#strongusagestrong)

## **Install**

- **Android**
  - The recommended way to install is [via F-Droid](https://f-droid.org/packages/ht.sr.git.mil.transito)
    - [<img src="https://fdroid.gitlab.io/artwork/badge/get-it-on.png" alt="Get it on F-Droid" height="80">](https://f-droid.org/packages/ht.sr.git.mil.transito)
  - Development builds can be used for testing from [the CI server](https://ci.lrdu.org/android/)
    - Builds tagged as `master`: Latest builds / features development, may be less stable
    - Builds tagged as `0.x.0`: Tagged builds for specific releases, see [Release Notes](https://git.sr.ht/~mil/transito/src/refs) for details on changes
- **Linux & Desktop**
  - Distro packages install:
    - Alpine Linux testing: `apk add transito`
  - Build from source:
    - Building from source is possible & [covered in a separate guide for advanced usage / builds](https://git.sr.ht/~mil/transito/src/tree/master/item/doc/doc_transito_build_from_source.md)

## **Primer Documentation**

- Before using Transito, please read the following documentation:
  - [Transito: Project Overview & Featureset](https://git.sr.ht/~mil/transito)
  - [Mobroute: Available GTFS Feeds](https://git.sr.ht/~mil/mobroute/tree/master/doc/doc_gtfsfeeds.md)
  - [Mobroute: Algorithm Tunable Parameters](https://git.sr.ht/~mil/mobroute/tree/master/doc/doc_tunables.md)

## **Usage**

This section will guide you through a basic routing request using an
example of using the Agglobus provider in Bourges, France (GTFS feed ID:
1898). You may wish to change your GTFS datafeed and search terms,
however if you're unclear about how to use the app, this is a good guide
to follow along with:


<table>
  <tr>
    <td><strong>Screenshot</strong></td>
    <td><strong>Description</strong></td>
  </tr>
  <tr>
    <td>
      <a href="doc_transito_screenshots.md"><img src='/~mil/transito/blob/master/doc/transito_screenshot_config.png' /></a>
    </td>
    <td>
      <strong>Config:</strong>
      <ul>
        <li>After launching the app, by default you will be on the <strong>Config</strong> tab.</li>
        <li>This tab lets you download GTFS feeds and configure various advanced parameters.</li>
        <li>For our basic example walkthrough, type <strong>'Bourges'</strong> in the GTFS feed search and select the 1898 feed ID correlated to the Agglobus provides in Bourges, France</li>
        <li>Different providers of GTFS datafeeds each have their own specific feed ID, you can learn more about this at the <a href="https://git.sr.ht/~mil/mobroute/tree/master/doc/doc_gtfsfeeds.md">available GTFS Feeds guide</a>.</li>
        <li>You can also interactively search for an appropriate GTFS provider datafeed ID at the <a href="https://mdb.lrdu.org/">Mobility Database UI</a>.</li>
        <li>Clicking add will start the GTFS load process, this is a long-running process which downloads the GTFS data from the origin provider and prepare it in a format usable for routing.</li>
        <li>Depending on the size of the feed this may take several minutes or longer (even possibly up to an hour for large feeds); please be patient GTFS dataload is a onetime process and then subsequent app functionality works offline.</li>
        <li>Once you have your GTFS feed set; 3 new tabs are present (Route, Stops, and POI), for our example switch to the <strong>Stops</strong> tab.</li>
      </ul>
    </td>
  </tr>
  <tr>
    <td>
      <a href="doc_transito_screenshots.md"><img src='/~mil/transito/blob/master/doc/transito_screenshot_stops.png' /></a>
    </td>
    <td>
      <strong>Stops:</strong>
      <ul>
        <li>On the <strong>Stops</strong> tab, you can select stops as an origin or destination point for routing.</li>
        <li>Stop selection lookup takes place offline and is a simple way to quickly find origin/destination points without typing a specific POI or address.</li>
        <li>For our routing example, type 'Robespierre' in the filter and select that associated stop for 'Set as From'.</li>
        <li>You will be taken back to the <strong>Route</strong> tab and see that the From location is set.</li>
        <li>Now, let's set the destination, instead of using a stop, let's use a point of intrest (POI) this time; select the <strong>POI</strong> tab.</li>
      </ul>
    </td>
  </tr>
  <tr>
    <td>
      <a href="doc_transito_screenshots.md"><img src='/~mil/transito/blob/master/doc/transito_screenshot_poi.png' /></a>
    </td>
    <td>
      <strong>POI:</strong>
      <ul>
        <li>On the <strong>POI</strong> tab, you can search for either points of intrest (POIs) or direct addresses by using <a href="https://nominatim.org/">Nominatim</a>.</li>
        <li>For our example, we will route to "Velodrome" so simply enter that into the search field and press the "Search" button.</li>
        <li>In the select list below you will see results; you can pick among multiple results if there is more then 1 match.</li>
        <li>Once you've determined the correct location, press "Set as To".</li>
        <li>You will be taken back to the <strong>Route</strong> tab and see that now that both the From & To locations are set.</li>
      </ul>
    </td>
  </tr>
  <tr>
    <td>
      <a href="doc_transito_screenshots.md"><img src='/~mil/transito/blob/master/doc/transito_screenshot_routesteps.png' /></a>
    </td>
    <td>
      <strong>Route:</strong>
      <ul>
        <li>Now the From and To locations are set, and you're on the <strong>Route</strong> tab.</li>
        <li>From here, to submit a routing request, simply press the "Route" button.</li>
        <li>Be patient as the route is calculated on your device, depending on the GTFS feed size and your request the time for the routing algorithm to complete varies.</li>
        <li>
          Once the route has been calculated:
          <ul>
            <li>Clicking "Overview" shows the steps for the route.</li>
            <li>Clicking the "Map" button opens a URL to show the route on a map (see next section).</li>
            <li>Clicking "Debug" shows raw diagnostics response information about the including route & performance details (and copies this raw data to the clipboard).</li>
            <li>Clicking "Clear" clears the route result.</li>
          </ul>
        </li>
      </ul>
    </td>
  </tr>
  <tr>
    <td>
      <a href="doc_transito_screenshots.md"><img src='/~mil/transito/blob/master/doc/transito_screenshot_routemap.png' /></a>
    </td>
    <td>
      <strong>Map:</strong>
      <ul>
        <li>Clicking the "Map" button opens a URL to show the route on a map.</li>
        <li>Note: the map view requires being online.</li>
        <li>This map is simply the route rendered to GeoJSON and passed in the URL hash to a <a href="https://geojson.lrdu.org/">GeoJSON WebUI Rendering JS UI</a>.</li>
        <li>You can click on locations on the map for details on each leg's steps and such.</li>
        <li>In the bottom right of the map there is a link that says "m" which you may click to see the original route reqest parameters.</li>
      </ul>
    </td>
  </tr>
  <tr>
    <td>
      <a href="doc_transito_screenshots.md"><img src='/~mil/transito/blob/master/doc/transito_screenshot_fave.png' /></a>
    </td>
    <td>
      <strong>Fave:</strong>
      <ul>
        <li>On both the Stops and POI tab there is a button "Favorite", clicking this adds the location to your favorites.</li>
        <li>This tab, <strong>Fave</strong>, can be used to store commonly used locations such as your work, home, or common stops.</li>
        <li>Favorites function offline & this tab will only be present if there is >1 favorite.</li>
      </ul>
    </td>
  </tr>
</table>

---

> [All Transito Docs](http://git.sr.ht/~mil/transito)
