# **Transito**: Build from Source
Transito is a cross-platform mobile app built in Go &
[Gio](https://gioui.org/) for using Mobroute's routing algorithm
on-the-go. It has been tested on Android and Linux although potentially
more platforms work. Currently automated builds of the app exist for
[Android as an APK created through CI](http://ci.lrdu.org/android).
If you wish to run on Linux and a package is not available for your
distro or wish to run on another platform that doesn't have automated
builds you should build from source.

- *1:* [Build for Linux (X11/Wayland)](#strongbuild-for-linux-x11waylandstrong)
- *2:* [Build for Android](#strongbuild-for-androidstrong)

## **Build for Linux (X11/Wayland)**
- On Linux, there are a few dependencies to first install
  - See [Gio's Linux Guide](https://gioui.org/doc/install/linux)
  - Dependencies on Alpine Linux: `apk add sqlite-dev libxcursor-dev libxkbcommon-dev libxkbcommon-x11 mesa-egl vulkan-headers wayland-dev mesa-dev xdg-utils tzdata`
- Once dependencies are setup, run:
  - `./build.sh blinux`
- Run via `./transito`
- Install via: `./build.sh install`

## **Build for Android**
- On Android you'll need to have the Android SDK setup
  - See [Gio's Android Guide](https://gioui.org/doc/install/android)
- Note: Android 11 / R / API Version 30 & SQLite version >= 3.28.0 is
  required.
- Once dependencies setup, run:
  - `./build.sh bandroid`
- Once build is complete, you have a new `.apk`:
  - Run `adb install transito.apk` to copy to device
  - Or copy the apk to your device some other way

---

> [All Transito Docs](http://git.sr.ht/~mil/transito)
