#!/usr/bin/env sh
set -e

fmt() {
  ag -g '.go$' | xargs -IC go fmt C
}

vercodeandroid() {
  # Android specificies a 'versionCode' which is a numerical
  # increased by 1 for every release / only used for android releases
  # and generally anytime versemver is changed, vercodeandroid should
  # be incremented
  echo "7"
}

versemver() {
  # Semver used for both linux & android builds, should match git
  # tag on releases
  echo "0.8.4"
}

verhash() {
  # Git hash used in dev builds
  echo "$(versemver)_$(git rev-parse HEAD | head -c 5)"
}

verhelpui() {
  # Enable verhash master builds / enable versemver for tagged/release builds
  #verhash
  versemver
}

bandroid() {
  # E.g. copy sqlite headers to android root as these are required for
  # building custom SQLite shared module; they are automatically picked
  # up in ordinary builds for mobroute/mobsql etc.; however for android
  # gogio build the NDK headers so we just copy into needed NDK dir so
  # build succeeds
  if [ -n "$ANDROID_NDK_ROOT" ]; then
    cp /usr/include/sqlite3* $ANDROID_NDK_ROOT/toolchains/llvm/prebuilt/*/sysroot/usr/include/
  elif [ -n "$ANDROID_SDK_ROOT" ]; then
    cp /usr/include/sqlite3* $ANDROID_SDK_ROOT/ndk-bundle/toolchains/llvm/prebuilt/*/sysroot/usr/include/
  else
    echo "Neither ANDROID_SDK_ROOT nor ANDROID_NDK_ROOT set; failed to copy sqlite-dev headers for build"
  fi

  GOFLAGS="-buildvcs=false -trimpath" gogio \
    -icon assets/transito.png \
    -tags=sqlite_math_functions,android \
    -target android \
    -appid ht.sr.git.mil.transito \
    -version "$(versemver)"."$(vercodeandroid)" \
    -minsdk 30 \
    -ldflags="-buildid= -X git.sr.ht/~mil/transito/src/uipages/pageconfig.Commit=$(verhelpui).$(vercodeandroid)" \
    "$@" .
}

blinux() {
  go build -v -tags=sqlite_math_functions -ldflags="-X git.sr.ht/~mil/transito/src/uipages/pageconfig.Commit=$(verhelpui)"
}

install() {
  mkdir -p /usr/bin /usr/share/applications /usr/share/pixmaps/
  mkdir -p /usr/share/icons/hicolor/16x16/apps
  mkdir -p /usr/share/icons/hicolor/32x32/apps
  mkdir -p /usr/share/icons/hicolor/48x48/apps
  mkdir -p /usr/share/icons/hicolor/128x128/apps
  mkdir -p /usr/share/icons/hicolor/512x512/apps

  cp transito /usr/bin/transito
  cp assets/transito.desktop /usr/share/applications/
  cp assets/transito.png /usr/share/pixmaps/transito.png
  cp assets/transito_16x16.png /usr/share/icons/hicolor/16x16/apps/transito.png
  cp assets/transito_32x32.png /usr/share/icons/hicolor/32x32/apps/transito.png
  cp assets/transito_48x48.png /usr/share/icons/hicolor/48x48/apps/transito.png
  cp assets/transito_128x128.png /usr/share/icons/hicolor/128x128/apps/transito.png
  cp assets/transito_512x512.png /usr/share/icons/hicolor/512x512/apps/transito.png
}

adbinstall() {
  adb uninstall ht.sr.git.transito || echo "uninstall fail"
  adb install transito.apk
}

adbflush() {
  adb kill-server
  adb start-server
}

updatemr() {
  GOPROXY=direct go get -v -u git.sr.ht/~mil/mobroute
}

um() {
  updatemr
}

run() {
  blinux
  ./transito
}

"$@"