import 'package:crypt/crypt.dart';

const value =
    r'{crypt}$5$zQUCjEzs9jnrRdCK$dbo1i9WjQjbUwOC4JCRAZHpfd31Dh676vI0L6w0dZw1';

bool matchesUserPassword(String userPassword, String plaintext) {
  const cryptPrefix = '{crypt}';
  if (userPassword.startsWith(cryptPrefix)) {
    return Crypt(userPassword.substring(cryptPrefix.length)).match(plaintext);
  } else {
    throw const FormatException(
        'unexpected hash in LDAP userPassword attribute');
  }
}

void main() {
  const guess = 'p@ssw0rd';

  if (matchesUserPassword(value, guess)) {
    print('ok');
  } else {
    print('bad');
  }
}
