/**
 *  Copyright (C) 2021 Anthony Chomienne
 *  This program is free software: you can redistribute it and/or modify it under the terms of the
 *  GNU Affero General Public License as published by the Free Software Foundation, version 3.
 *
 *  This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 *  without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *  See the GNU Affero General Public License for more details.
 *
 *  You should have received a copy of the GNU Affero General Public License along with this program.
 *  If not, see <https://www.gnu.org/licenses/>
 */

package fr.mobdev.peertubelive.utils

import fr.mobdev.peertubelive.R

class TranslationUtils {
    companion object {
        private val categoryMap: Map<String, Int> = mapOf(
            "Music" to R.string.music,
            "Films" to R.string.films,
            "Vehicles" to R.string.vehicles,
            "Art" to R.string.art,
            "Sports" to R.string.sports,
            "Travels" to R.string.travels,
            "Gaming" to R.string.gaming,
            "People" to R.string.people,
            "Comedy" to R.string.comedy,
            "Entertainment" to R.string.entertainment,
            "News & Politics" to R.string.news_politics,
            "How To" to R.string.how_to,
            "Education" to R.string.education,
            "Activism" to R.string.activism,
            "Science & Technology" to R.string.science_tech,
            "Animals" to R.string.animals,
            "Kids" to R.string.kids,
            "Food" to R.string.food
        )

        fun getCategoryTranslationFor(category: String):Int {
            return if (categoryMap.containsKey(category))
                categoryMap[category]!!
            else
                -1
        }

        private val licenceMap: Map<String, Int> = mapOf(
            "Attribution" to R.string.by,
            "Attribution - Share Alike" to R.string.bysa,
            "Attribution - No Derivatives" to R.string.bynd,
            "Attribution - Non Commercial" to R.string.bync,
            "Attribution - Non Commercial - Share Alike" to R.string.byncsa,
            "Attribution - Non Commercial - No Derivatives" to R.string.byncnd,
            "Public Domain Dedication" to R.string.public_domain
        )

        fun getLicenceTranslationFor(licence: String):Int {
            return if (licenceMap.containsKey(licence))
                licenceMap[licence]!!
            else
                -1
        }

        private val privacyMap: Map<String, Int> = mapOf(
            "Public" to R.string.privacy_public,
            "Private" to R.string.privacy_private,
            "Internal" to R.string.internal,
            "Unlisted" to R.string.unlisted
        )

        fun getPrivacyTranslationFor(privacy: String):Int {
            return if (privacyMap.containsKey(privacy))
                privacyMap[privacy]!!
            else
                -1
        }

        private val languageMap: Map<String, Int> = mapOf(
            "Afar" to R.string.afar,
            "Abkhazian" to R.string.abkhazian,
            "Afrikaans" to R.string.afrikaans,
            "Akan" to R.string.akan,
            "Amharic" to R.string.amharic,
            "Arabic" to R.string.arabic,
            "Aragonese" to R.string.aragonese,
            "American Sign Language" to R.string.american_sign_language,
            "Assamese" to R.string.assamese,
            "Avaric" to R.string.avaric,
            "Kotava" to R.string.kotava,
            "Aymara" to R.string.aymara,
            "Azerbaijani" to R.string.azerbaijani,
            "Bashkir" to R.string.bashkir,
            "Bambara" to R.string.bambara,
            "Belarusian" to R.string.belarusian,
            "Bengali" to R.string.bengali,
            "British Sign Language" to R.string.british_sign_language,
            "Bislama" to R.string.bislama,
            "Tibetan" to R.string.tibetan,
            "Bosnian" to R.string.bosnian,
            "Breton" to R.string.breton,
            "Bulgarian" to R.string.bulgarian,
            "Brazilian Sign Language" to R.string.brazilian_sign_language,
            "Catalan" to R.string.catalan,
            "Czech" to R.string.czech,
            "Chamorro" to R.string.chamorro,
            "Chechen" to R.string.chechen,
            "Chuvash" to R.string.chuvash,
            "Cornish" to R.string.cornish,
            "Corsican" to R.string.corsican,
            "Cree" to R.string.cree,
            "Czech Sign Language" to R.string.czech_sign_language,
            "Chinese Sign Language" to R.string.chinese_sign_language,
            "Welsh" to R.string.welsh,
            "Danish" to R.string.danish,
            "German" to R.string.german,
            "Dhivehi" to R.string.dhivehi,
            "Danish Sign Language" to R.string.danish_sign_language,
            "Dzongkha" to R.string.dzongkha,
            "Greek" to R.string.greek,
            "English" to R.string.english,
            "Esperanto" to R.string.esperanto,
            "Estonian" to R.string.estonian,
            "Basque" to R.string.basque,
            "Ewe" to R.string.ewe,
            "Faroese" to R.string.faroese,
            "Persian" to R.string.persian,
            "Fijian" to R.string.fijian,
            "Finnish" to R.string.finnish,
            "French" to R.string.french,
            "Western Frisian" to R.string.western_frisian,
            "French Sign Language" to R.string.french_sign_language,
            "Fulah" to R.string.fulah,
            "Scottish Gaelic" to R.string.scottish_gaelic,
            "Irish" to R.string.irish,
            "Galician" to R.string.galician,
            "Manx" to R.string.manx,
            "Guarani" to R.string.guarani,
            "German Sign Language" to R.string.german_sign_language,
            "Gujarati" to R.string.gujarati,
            "Haitian" to R.string.haitian,
            "Hausa" to R.string.hausa,
            "Serbo-Croatian" to R.string.serbo_croatian,
            "Hebrew" to R.string.hebrew,
            "Herero" to R.string.herero,
            "Hindi" to R.string.hindi,
            "Hiri Motu" to R.string.hiri_motu,
            "Croatian" to R.string.croatian,
            "Hungarian" to R.string.hungarian,
            "Armenian" to R.string.armenian,
            "Igbo" to R.string.igbo,
            "Sichuan Yi" to R.string.sichuan_yi,
            "Inuktitut" to R.string.inuktitut,
            "Indonesian" to R.string.indonesian,
            "Inupiaq" to R.string.inupiaq,
            "Icelandic" to R.string.icelandic,
            "Italian" to R.string.italian,
            "Javanese" to R.string.javanese,
            "Lojban" to R.string.lojban,
            "Japanese" to R.string.japanese,
            "Japanese Sign Language" to R.string.japanese_sign_language,
            "Kabyle" to R.string.kabyle,
            "Kalaallisut" to R.string.kalaallisut,
            "Kannada" to R.string.kannada,
            "Kashmiri" to R.string.kashmiri,
            "Georgian" to R.string.georgian,
            "Kanuri" to R.string.kanuri,
            "Kazakh" to R.string.kazakh,
            "Khmer" to R.string.khmer,
            "Kikuyu" to R.string.kikuyu,
            "Kinyarwanda" to R.string.kinyarwanda,
            "Kirghiz" to R.string.kirghiz,
            "Komi" to R.string.komi,
            "Kongo" to R.string.kongo,
            "Korean" to R.string.korean,
            "Kuanyama" to R.string.kuanyama,
            "Kurdish" to R.string.kurdish,
            "Lao" to R.string.lao,
            "Latvian" to R.string.latvian,
            "Limburgan" to R.string.limburgan,
            "Lingala" to R.string.lingala,
            "Lithuanian" to R.string.lithuanian,
            "Luxembourgish" to R.string.luxembourgish,
            "Luba-Katanga" to R.string.luba_katanga,
            "Ganda" to R.string.ganda,
            "Marshallese" to R.string.marshallese,
            "Malayalam" to R.string.malayalam,
            "Marathi" to R.string.marathi,
            "Macedonian" to R.string.macedonian,
            "Malagasy" to R.string.malagasy,
            "Maltese" to R.string.maltese,
            "Mongolian" to R.string.mongolian,
            "Maori" to R.string.maori,
            "Malay (macrolanguage)" to R.string.malay_macrolanguage,
            "Burmese" to R.string.burmese,
            "Nauru" to R.string.nauru,
            "Navajo" to R.string.navajo,
            "South Ndebele" to R.string.south_ndebele,
            "North Ndebele" to R.string.north_ndebele,
            "Ndonga" to R.string.ndonga,
            "Nepali (macrolanguage)" to R.string.nepali_macrolanguage,
            "Dutch" to R.string.dutch,
            "Norwegian Nynorsk" to R.string.norwegian_nynorsk,
            "Norwegian Bokmål" to R.string.norwegian_bokmål,
            "Norwegian" to R.string.norwegian,
            "Nyanja" to R.string.nyanja,
            "Occitan" to R.string.occitan,
            "Ojibwa" to R.string.ojibwa,
            "Oriya (macrolanguage)" to R.string.oriya_macrolanguage,
            "Oromo" to R.string.oromo,
            "Ossetian" to R.string.ossetian,
            "Panjabi" to R.string.panjabi,
            "Pakistan Sign Language" to R.string.pakistan_sign_language,
            "Polish" to R.string.polish,
            "Portuguese" to R.string.portuguese,
            "Pushto" to R.string.pushto,
            "Quechua" to R.string.quechua,
            "Romansh" to R.string.romansh,
            "Romanian" to R.string.romanian,
            "Russian Sign Language" to R.string.russian_sign_language,
            "Rundi" to R.string.rundi,
            "Russian" to R.string.russian,
            "Sango" to R.string.sango,
            "Saudi Arabian Sign Language" to R.string.saudi_arabian_sign_language,
            "South African Sign Language" to R.string.south_african_sign_language,
            "Sinhala" to R.string.sinhala,
            "Slovak" to R.string.slovak,
            "Slovenian" to R.string.slovenian,
            "Northern Sami" to R.string.northern_sami,
            "Samoan" to R.string.samoan,
            "Shona" to R.string.shona,
            "Sindhi" to R.string.sindhi,
            "Somali" to R.string.somali,
            "Southern Sotho" to R.string.southern_sotho,
            "Spanish" to R.string.spanish,
            "Albanian" to R.string.albanian,
            "Sardinian" to R.string.sardinian,
            "Serbian" to R.string.serbian,
            "Swati" to R.string.swati,
            "Sundanese" to R.string.sundanese,
            "Swahili (macrolanguage)" to R.string.swahili_macrolanguage,
            "Swedish" to R.string.swedish,
            "Swedish Sign Language" to R.string.swedish_sign_language,
            "Tahitian" to R.string.tahitian,
            "Tamil" to R.string.tamil,
            "Tatar" to R.string.tatar,
            "Telugu" to R.string.telugu,
            "Tajik" to R.string.tajik,
            "Tagalog" to R.string.tagalog,
            "Thai" to R.string.thai,
            "Tigrinya" to R.string.tigrinya,
            "Klingon" to R.string.klingon,
            "Tonga (Tonga Islands)" to R.string.tonga_tonga_islands,
            "Tswana" to R.string.tswana,
            "Tsonga" to R.string.tsonga,
            "Turkmen" to R.string.turkmen,
            "Turkish" to R.string.turkish,
            "Twi" to R.string.twi,
            "Uighur" to R.string.uighur,
            "Ukrainian" to R.string.ukrainian,
            "Urdu" to R.string.urdu,
            "Uzbek" to R.string.uzbek,
            "Venda" to R.string.venda,
            "Vietnamese" to R.string.vietnamese,
            "Walloon" to R.string.walloon,
            "Wolof" to R.string.wolof,
            "Xhosa" to R.string.xhosa,
            "Yiddish" to R.string.yiddish,
            "Yoruba" to R.string.yoruba,
            "Zhuang" to R.string.zhuang,
            "Chinese" to R.string.chinese,
            "Zulu" to R.string.zulu
        )

        fun getLanguageTranslationFor(language: String):Int {
            return if (languageMap.containsKey(language))
                languageMap[language]!!
            else
                -1
        }

    }

}