package f.cking.software.domain.interactor

import f.cking.software.extract16BitUuid

object GetCharacteristicNameFromUUID {

    fun execute(characteristicId: String): String? {
        return KNOWN_CHARACTERISTIC_ID_TO_NAME[extract16BitUuid(characteristicId)?.uppercase()]
    }

    private val KNOWN_CHARACTERISTIC_ID_TO_NAME = mapOf(
        "2A00" to "Device Name",
        "2A01" to "Appearance",
        "2A02" to "Peripheral Privacy Flag",
        "2A03" to "Reconnection Address",
        "2A04" to "Peripheral Preferred Connection Parameters",
        "2A05" to "Service Changed",
        "2A06" to "Alert Level",
        "2A07" to "Tx Power Level",
        "2A08" to "Date Time",
        "2A09" to "Day of Week",
        "2A0A" to "Day Date Time",
        "2A0C" to "Exact Time 256",
        "2A0D" to "DST Offset",
        "2A0E" to "Time Zone",
        "2A0F" to "Local Time Information",
        "2A11" to "Time with DST",
        "2A12" to "Time Accuracy",
        "2A13" to "Time Source",
        "2A14" to "Reference Time Information",
        "2A16" to "Time Update Control Point",
        "2A17" to "Time Update State",
        "2A18" to "Glucose Measurement",
        "2A19" to "Battery Level",
        "2A1C" to "Temperature Measurement",
        "2A1D" to "Temperature Type",
        "2A1E" to "Intermediate Temperature",
        "2A21" to "Measurement Interval",
        "2A22" to "Boot Keyboard Input Report",
        "2A23" to "System ID",
        "2A24" to "Model Number String",
        "2A25" to "Serial Number String",
        "2A26" to "Firmware Revision String",
        "2A27" to "Hardware Revision String",
        "2A28" to "Software Revision String",
        "2A29" to "Manufacturer Name String",
        "2A2A" to "IEEE 11073-20601 Regulatory Certification Data List",
        "2A2B" to "Current Time",
        "2A2C" to "Magnetic Declination",
        "2A31" to "Scan Refresh",
        "2A32" to "Boot Keyboard Output Report",
        "2A33" to "Boot Mouse Input Report",
        "2A34" to "Glucose Measurement Context",
        "2A35" to "Blood Pressure Measurement",
        "2A36" to "Intermediate Cuff Pressure",
        "2A37" to "Heart Rate Measurement",
        "2A38" to "Body Sensor Location",
        "2A39" to "Heart Rate Control Point",
        "2A3F" to "Alert Status",
        "2A40" to "Ringer Control Point",
        "2A41" to "Ringer Setting",
        "2A42" to "Alert Category ID Bit Mask",
        "2A43" to "Alert Category ID",
        "2A44" to "Alert Notification Control Point",
        "2A45" to "Unread Alert Status",
        "2A46" to "New Alert",
        "2A47" to "Supported New Alert Category",
        "2A48" to "Supported Unread Alert Category",
        "2A49" to "Blood Pressure Feature",
        "2A4A" to "HID Information",
        "2A4B" to "Report Map",
        "2A4C" to "HID Control Point",
        "2A4D" to "Report",
        "2A4E" to "Protocol Mode",
        "2A4F" to "Scan Interval Window",
        "2A50" to "PnP ID",
        "2A51" to "Glucose Feature",
        "2A52" to "Record Access Control Point",
        "2A53" to "RSC Measurement",
        "2A54" to "RSC Feature",
        "2A55" to "SC Control Point",
        "2A5A" to "Aggregate",
        "2A5B" to "CSC Measurement",
        "2A5C" to "CSC Feature",
        "2A5D" to "Sensor Location",
        "2A5E" to "PLX Spot-Check Measurement",
        "2A5F" to "PLX Continuous Measurement",
        "2A60" to "PLX Features",
        "2A63" to "Cycling Power Measurement",
        "2A64" to "Cycling Power Vector",
        "2A65" to "Cycling Power Feature",
        "2A66" to "Cycling Power Control Point",
        "2A67" to "Location and Speed",
        "2A68" to "Navigation",
        "2A69" to "Position Quality",
        "2A6A" to "LN Feature",
        "2A6B" to "LN Control Point",
        "2A6C" to "Elevation",
        "2A6D" to "Pressure",
        "2A6E" to "Temperature",
        "2A6F" to "Humidity",
        "2A70" to "True Wind Speed",
        "2A71" to "True Wind Direction",
        "2A72" to "Apparent Wind Speed",
        "2A73" to "Apparent Wind Direction",
        "2A74" to "Gust Factor",
        "2A75" to "Pollen Concentration",
        "2A76" to "UV Index",
        "2A77" to "Irradiance",
        "2A78" to "Rainfall",
        "2A79" to "Wind Chill",
        "2A7A" to "Heat Index",
        "2A7B" to "Dew Point",
        "2A7D" to "Descriptor Value Changed",
        "2A7E" to "Aerobic Heart Rate Lower Limit",
        "2A7F" to "Aerobic Threshold",
        "2A80" to "Age",
        "2A81" to "Anaerobic Heart Rate Lower Limit",
        "2A82" to "Anaerobic Heart Rate Upper Limit",
        "2A83" to "Anaerobic Threshold",
        "2A84" to "Aerobic Heart Rate Upper Limit",
        "2A85" to "Date of Birth",
        "2A86" to "Date of Threshold Assessment",
        "2A87" to "Email Address",
        "2A88" to "Fat Burn Heart Rate Lower Limit",
        "2A89" to "Fat Burn Heart Rate Upper Limit",
        "2A8A" to "First Name",
        "2A8B" to "Five Zone Heart Rate Limits",
        "2A8C" to "Gender",
        "2A8D" to "Heart Rate Max",
        "2A8E" to "Height",
        "2A8F" to "Hip Circumference",
        "2A90" to "Last Name",
        "2A91" to "Maximum Recommended Heart Rate",
        "2A92" to "Resting Heart Rate",
        "2A93" to "Sport Type for Aerobic and Anaerobic Thresholds",
        "2A94" to "Three Zone Heart Rate Limits",
        "2A95" to "Two Zone Heart Rate Limits",
        "2A96" to "VO2 Max",
        "2A97" to "Waist Circumference",
        "2A98" to "Weight",
        "2A99" to "Database Change Increment",
        "2A9A" to "User Index",
        "2A9B" to "Body Composition Feature",
        "2A9C" to "Body Composition Measurement",
        "2A9D" to "Weight Measurement",
        "2A9E" to "Weight Scale Feature",
        "2A9F" to "User Control Point",
        "2AA0" to "Magnetic Flux Density - 2D",
        "2AA1" to "Magnetic Flux Density - 3D",
        "2AA2" to "Language",
        "2AA3" to "Barometric Pressure Trend",
        "2AA4" to "Bond Management Control Point",
        "2AA5" to "Bond Management Feature",
        "2AA6" to "Central Address Resolution",
        "2AA7" to "CGM Measurement",
        "2AA8" to "CGM Feature",
        "2AA9" to "CGM Status",
        "2AAA" to "CGM Session Start Time",
        "2AAB" to "CGM Session Run Time",
        "2AAC" to "CGM Specific Ops Control Point",
        "2AAD" to "Indoor Positioning Configuration",
        "2AAE" to "Latitude",
        "2AAF" to "Longitude",
        "2AB0" to "Local North Coordinate",
        "2AB1" to "Local East Coordinate",
        "2AB2" to "Floor Number",
        "2AB3" to "Altitude",
        "2AB4" to "Uncertainty",
        "2AB5" to "Location Name",
        "2AB6" to "URI",
        "2AB7" to "HTTP Headers",
        "2AB8" to "HTTP Status Code",
        "2AB9" to "HTTP Entity Body",
        "2ABA" to "HTTP Control Point",
        "2ABB" to "HTTPS Security",
        "2ABC" to "TDS Control Point",
        "2ABD" to "OTS Feature",
        "2ABE" to "Object Name",
        "2ABF" to "Object Type",
        "2AC0" to "Object Size",
        "2AC1" to "Object First-Created",
        "2AC2" to "Object Last-Modified",
        "2AC3" to "Object ID",
        "2AC4" to "Object Properties",
        "2AC5" to "Object Action Control Point",
        "2AC6" to "Object List Control Point",
        "2AC7" to "Object List Filter",
        "2AC8" to "Object Changed",
        "2AC9" to "Resolvable Private Address Only",
        "2ACC" to "Fitness Machine Feature",
        "2ACD" to "Treadmill Data",
        "2ACE" to "Cross Trainer Data",
        "2ACF" to "Step Climber Data",
        "2AD0" to "Stair Climber Data",
        "2AD1" to "Rower Data",
        "2AD2" to "Indoor Bike Data",
        "2AD3" to "Training Status",
        "2AD4" to "Supported Speed Range",
        "2AD5" to "Supported Inclination Range",
        "2AD6" to "Supported Resistance Level Range",
        "2AD7" to "Supported Heart Rate Range",
        "2AD8" to "Supported Power Range",
        "2AD9" to "Fitness Machine Control Point",
        "2ADA" to "Fitness Machine Status",
        "2ADB" to "Mesh Provisioning Data In",
        "2ADC" to "Mesh Provisioning Data Out",
        "2ADD" to "Mesh Proxy Data In",
        "2ADE" to "Mesh Proxy Data Out",
        "2AE0" to "Average Current",
        "2AE1" to "Average Voltage",
        "2AE2" to "Boolean",
        "2AE3" to "Chromatic Distance from Planckian",
        "2AE4" to "Chromaticity Coordinates",
        "2AE5" to "Chromaticity in CCT and Duv Values",
        "2AE6" to "Chromaticity Tolerance",
        "2AE7" to "CIE 13.3-1995 Color Rendering Index",
        "2AE8" to "Coefficient",
        "2AE9" to "Correlated Color Temperature",
        "2AEA" to "Count 16",
        "2AEB" to "Count 24",
        "2AEC" to "Country Code",
        "2AED" to "Date UTC",
        "2AEE" to "Electric Current",
        "2AEF" to "Electric Current Range",
        "2AF0" to "Electric Current Specification",
        "2AF1" to "Electric Current Statistics",
        "2AF2" to "Energy",
        "2AF3" to "Energy in a Period of Day",
        "2AF4" to "Event Statistics",
        "2AF5" to "Fixed String 16",
        "2AF6" to "Fixed String 24",
        "2AF7" to "Fixed String 36",
        "2AF8" to "Fixed String 8",
        "2AF9" to "Generic Level",
        "2AFA" to "Global Trade Item Number",
        "2AFB" to "Illuminance",
        "2AFC" to "Luminous Efficacy",
        "2AFD" to "Luminous Energy",
        "2AFE" to "Luminous Exposure",
        "2AFF" to "Luminous Flux",
        "2B00" to "Luminous Flux Range",
        "2B01" to "Luminous Intensity",
        "2B02" to "Mass Flow",
        "2B03" to "Perceived Lightness",
        "2B04" to "Percentage 8",
        "2B05" to "Power",
        "2B06" to "Power Specification",
        "2B07" to "Relative Runtime in a Current Range",
        "2B08" to "Relative Runtime in a Generic Level Range",
        "2B09" to "Relative Value in a Voltage Range",
        "2B0A" to "Relative Value in an Illuminance Range",
        "2B0B" to "Relative Value in a Period of Day",
        "2B0C" to "Relative Value in a Temperature Range",
        "2B0D" to "Temperature 8",
        "2B0E" to "Temperature 8 in a Period of Day",
        "2B0F" to "Temperature 8 Statistics",
        "2B10" to "Temperature Range",
        "2B11" to "Temperature Statistics",
        "2B12" to "Time Decihour 8",
        "2B13" to "Time Exponential 8",
        "2B14" to "Time Hour 24",
        "2B15" to "Time Millisecond 24",
        "2B16" to "Time Second 16",
        "2B17" to "Time Second 8",
        "2B18" to "Voltage",
        "2B19" to "Voltage Specification",
        "2B1A" to "Voltage Statistics",
        "2B1B" to "Volume Flow",
        "2B1C" to "Chromaticity Coordinate",
        "2B1D" to "RC Feature",
        "2B1E" to "RC Settings",
        "2B1F" to "Reconnection Configuration Control Point",
        "2B20" to "IDD Status Changed",
        "2B21" to "IDD Status",
        "2B22" to "IDD Annunciation Status",
        "2B23" to "IDD Features",
        "2B24" to "IDD Status Reader Control Point",
        "2B25" to "IDD Command Control Point",
        "2B26" to "IDD Command Data",
        "2B27" to "IDD Record Access Control Point",
        "2B28" to "IDD History Data",
        "2B29" to "Client Supported Features",
        "2B2A" to "Database Hash",
        "2B2B" to "BSS Control Point",
        "2B2C" to "BSS Response",
        "2B2D" to "Emergency ID",
        "2B2E" to "Emergency Text",
        "2B2F" to "ACS Status",
        "2B30" to "ACS Data In",
        "2B31" to "ACS Data Out Notify",
        "2B32" to "ACS Data Out Indicate",
        "2B33" to "ACS Control Point",
        "2B34" to "Enhanced Blood Pressure Measurement",
        "2B35" to "Enhanced Intermediate Cuff Pressure",
        "2B36" to "Blood Pressure Record",
        "2B37" to "Registered User",
        "2B38" to "BR-EDR Handover Data",
        "2B39" to "Bluetooth SIG Data",
        "2B3A" to "Server Supported Features",
        "2B3B" to "Physical Activity Monitor Features",
        "2B3C" to "General Activity Instantaneous Data",
        "2B3D" to "General Activity Summary Data",
        "2B3E" to "CardioRespiratory Activity Instantaneous Data",
        "2B3F" to "CardioRespiratory Activity Summary Data",
        "2B40" to "Step Counter Activity Summary Data",
        "2B41" to "Sleep Activity Instantaneous Data",
        "2B42" to "Sleep Activity Summary Data",
        "2B43" to "Physical Activity Monitor Control Point",
        "2B44" to "Physical Activity Current Session",
        "2B45" to "Physical Activity Session Descriptor",
        "2B46" to "Preferred Units",
        "2B47" to "High Resolution Height",
        "2B48" to "Middle Name",
        "2B49" to "Stride Length",
        "2B4A" to "Handedness",
        "2B4B" to "Device Wearing Position",
        "2B4C" to "Four Zone Heart Rate Limits",
        "2B4D" to "High Intensity Exercise Threshold",
        "2B4E" to "Activity Goal",
        "2B4F" to "Sedentary Interval Notification",
        "2B50" to "Caloric Intake",
        "2B51" to "TMAP Role",
        "2B77" to "Audio Input State",
        "2B78" to "Gain Settings Attribute",
        "2B79" to "Audio Input Type",
        "2B7A" to "Audio Input Status",
        "2B7B" to "Audio Input Control Point",
        "2B7C" to "Audio Input Description",
        "2B7D" to "Volume State",
        "2B7E" to "Volume Control Point",
        "2B7F" to "Volume Flags",
        "2B80" to "Volume Offset State",
        "2B81" to "Audio Location",
        "2B82" to "Volume Offset Control Point",
        "2B83" to "Audio Output Description",
        "2B84" to "Set Identity Resolving Key",
        "2B85" to "Coordinated Set Size",
        "2B86" to "Set Member Lock",
        "2B87" to "Set Member Rank",
        "2B88" to "Encrypted Data Key Material",
        "2B89" to "Apparent Energy 32",
        "2B8A" to "Apparent Power",
        "2B8B" to "Live Health Observations",
        "2B8D" to "Cosine of the Angle",
        "2B8E" to "Device Time Feature",
        "2B8F" to "Device Time Parameters",
        "2B90" to "Device Time",
        "2B91" to "Device Time Control Point",
        "2B92" to "Time Change Log Data",
        "2B93" to "Media Player Name",
        "2B94" to "Media Player Icon Object ID",
        "2B95" to "Media Player Icon URL",
        "2B96" to "Track Changed",
        "2B97" to "Track Title",
        "2B98" to "Track Duration",
        "2B99" to "Track Position",
        "2B9A" to "Playback Speed",
        "2B9B" to "Seeking Speed",
        "2B9C" to "Current Track Segments Object ID",
        "2B9D" to "Current Track Object ID",
        "2B9E" to "Next Track Object ID",
        "2B9F" to "Parent Group Object ID",
        "2BA0" to "Current Group Object ID",
        "2BA1" to "Playing Order",
        "2BA2" to "Playing Orders Supported",
        "2BA3" to "Media State",
        "2BA4" to "Media Control Point",
        "2BA5" to "Media Control Point Opcodes Supported",
        "2BA6" to "Search Results Object ID",
        "2BA7" to "Search Control Point",
        "2BA8" to "Energy 32",
        "2BAD" to "Constant Tone Extension Enable",
        "2BAE" to "Advertising Constant Tone Extension Minimum Length",
        "2BAF" to "Advertising Constant Tone Extension Minimum Transmit Count",
        "2BB0" to "Advertising Constant Tone Extension Transmit Duration",
        "2BB1" to "Advertising Constant Tone Extension Interval",
        "2BB2" to "Advertising Constant Tone Extension PHY",
        "2BB3" to "Bearer Provider Name",
        "2BB4" to "Bearer UCI",
        "2BB5" to "Bearer Technology",
        "2BB6" to "Bearer URI Schemes Supported List",
        "2BB7" to "Bearer Signal Strength",
        "2BB8" to "Bearer Signal Strength Reporting Interval",
        "2BB9" to "Bearer List Current Calls",
        "2BBA" to "Content Control ID",
        "2BBB" to "Status Flags",
        "2BBC" to "Incoming Call Target Bearer URI",
        "2BBD" to "Call State",
        "2BBE" to "Call Control Point",
        "2BBF" to "Call Control Point Optional Opcodes",
        "2BC0" to "Termination Reason",
        "2BC1" to "Incoming Call",
        "2BC2" to "Call Friendly Name",
        "2BC3" to "Mute",
        "2BC4" to "Sink ASE",
        "2BC5" to "Source ASE",
        "2BC6" to "ASE Control Point",
        "2BC7" to "Broadcast Audio Scan Control Point",
        "2BC8" to "Broadcast Receive State",
        "2BC9" to "Sink PAC",
        "2BCA" to "Sink Audio Locations",
        "2BCB" to "Source PAC",
        "2BCC" to "Source Audio Locations",
        "2BCD" to "Available Audio Contexts",
        "2BCE" to "Supported Audio Contexts",
        "2BCF" to "Ammonia Concentration",
        "2BD0" to "Carbon Monoxide Concentration",
        "2BD1" to "Methane Concentration",
        "2BD2" to "Nitrogen Dioxide Concentration",
        "2BD3" to "Non-Methane Volatile Organic Compounds Concentration",
        "2BD4" to "Ozone Concentration",
        "2BD5" to "Particulate Matter - PM1 Concentration",
        "2BD6" to "Particulate Matter - PM2.5 Concentration",
        "2BD7" to "Particulate Matter - PM10 Concentration",
        "2BD8" to "Sulfur Dioxide Concentration",
        "2BD9" to "Sulfur Hexafluoride Concentration",
        "2BDA" to "Hearing Aid Features",
        "2BDB" to "Hearing Aid Preset Control Point",
        "2BDC" to "Active Preset Index",
        "2BDD" to "Stored Health Observations",
        "2BDE" to "Fixed String 64",
        "2BDF" to "High Temperature",
        "2BE0" to "High Voltage",
        "2BE1" to "Light Distribution",
        "2BE2" to "Light Output",
        "2BE3" to "Light Source Type",
        "2BE4" to "Noise",
        "2BE5" to "Relative Runtime in a Correlated Color Temperature Range",
        "2BE6" to "Time Second 32",
        "2BE7" to "VOC Concentration",
        "2BE8" to "Voltage Frequency",
        "2BE9" to "Battery Critical Status",
        "2BEA" to "Battery Health Status",
        "2BEB" to "Battery Health Information",
        "2BEC" to "Battery Information",
        "2BED" to "Battery Level Status",
        "2BEE" to "Battery Time Status",
        "2BEF" to "Estimated Service Date",
        "2BF0" to "Battery Energy Status",
        "2BF1" to "Observation Schedule Changed",
        "2BF2" to "Current Elapsed Time",
        "2BF3" to "Health Sensor Features",
        "2BF4" to "GHS Control Point",
        "2BF5" to "LE GATT Security Levels",
        "2BF6" to "ESL Address",
        "2BF7" to "AP Sync Key Material",
        "2BF8" to "ESL Response Key Material",
        "2BF9" to "ESL Current Absolute Time",
        "2BFA" to "ESL Display Information",
        "2BFB" to "ESL Image Information",
        "2BFC" to "ESL Sensor Information",
        "2BFD" to "ESL LED Information",
        "2BFE" to "ESL Control Point",
        "2BFF" to "UDI for Medical Devices",
        "2C00" to "GMAP Role",
        "2C01" to "UGG Features",
        "2C02" to "UGT Features",
        "2C03" to "BGS Features",
        "2C04" to "BGR Features",
        "2C05" to "Percentage 8 Steps",
        "2C06" to "Acceleration",
        "2C07" to "Force",
        "2C08" to "Linear Position",
        "2C09" to "Rotational Speed",
        "2C0A" to "Length",
        "2C0B" to "Torque",
        "2C0C" to "IMD Status",
        "2C0D" to "IMDS Descriptor Value Changed",
        "2C0E" to "First Use Date",
        "2C0F" to "Life Cycle Data",
        "2C10" to "Work Cycle Data",
        "2C11" to "Service Cycle Data",
        "2C12" to "IMD Control",
        "2C13" to "IMD Historical Data",
        "2C14" to "RAS Features",
        "2C15" to "Real-time Ranging Data",
        "2C16" to "On-demand Ranging Data",
        "2C17" to "RAS Control Point",
        "2C18" to "Ranging Data Ready",
        "2C19" to "Ranging Data Overwritten",
    )
}
