package f.cking.software.data.helpers

object BluetoothSIG {
    val bluetoothSIG: Map<Int, String> = hashMapOf(
        0x0000 to "Ericsson Technology Licensing",
        0x0001 to "Nokia Mobile Phones",
        0x0002 to "Intel Corp.",
        0x0003 to "IBM Corp.",
        0x0004 to "Toshiba Corp.",
        0x0005 to "3Com",
        0x0006 to "Microsoft",
        0x0007 to "Lucent",
        0x0008 to "Motorola",
        0x0009 to "Infineon Technologies AG",
        0x000A to "Cambridge Silicon Radio",
        0x000B to "Silicon Wave",
        0x000C to "Digianswer A/S",
        0x000D to "Texas Instruments Inc.",
        0x000E to "Parthus Technologies Inc.",
        0x000F to "Broadcom Corporation",
        0x0010 to "Mitel Semiconductor",
        0x0011 to "Widcomm, Inc.",
        0x0012 to "Zeevo, Inc.",
        0x0013 to "Atmel Corporation",
        0x0014 to "Mitsubishi Electric Corporation",
        0x0015 to "RTX Telecom A/S",
        0x0016 to "KC Technology Inc.",
        0x0017 to "Newlogic",
        0x0018 to "Transilica, Inc.",
        0x0019 to "Rohde & Schwarz GmbH & Co. KG",
        0x001A to "TTPCom Limited",
        0x001B to "Signia Technologies, Inc.",
        0x001C to "Conexant Systems Inc.",
        0x001D to "Qualcomm",
        0x001E to "Inventel",
        0x001F to "AVM Berlin",
        0x0020 to "BandSpeed, Inc.",
        0x0021 to "Mansella Ltd",
        0x0022 to "NEC Corporation",
        0x0023 to "WavePlus Technology Co., Ltd.",
        0x0024 to "Alcatel",
        0x0025 to "NXP Semiconductors (formerly Philips Semiconductors)",
        0x0026 to "C Technologies",
        0x0027 to "Open Interface",
        0x0028 to "R F Micro Devices",
        0x0029 to "Hitachi Ltd",
        0x002A to "Symbol Technologies, Inc.",
        0x002B to "Tenovis",
        0x002C to "Macronix International Co. Ltd.",
        0x002D to "GCT Semiconductor",
        0x002E to "Norwood Systems",
        0x002F to "MewTel Technology Inc.",
        0x0030 to "ST Microelectronics",
        0x0031 to "Synopsys, Inc.",
        0x0032 to "Red-M (Communications) Ltd",
        0x0033 to "Commil Ltd",
        0x0034 to "Computer Access Technology Corporation (CATC)",
        0x0035 to "Eclipse (HQ Espana) S.L.",
        0x0036 to "Renesas Electronics Corporation",
        0x0037 to "Mobilian Corporation",
        0x0038 to "Terax",
        0x0039 to "Integrated System Solution Corp.",
        0x003A to "Matsushita Electric Industrial Co., Ltd.",
        0x003B to "Gennum Corporation",
        0x003C to "BlackBerry Limited (formerly Research In Motion)",
        0x003D to "IPextreme, Inc.",
        0x003E to "Systems and Chips, Inc",
        0x003F to "Bluetooth SIG, Inc",
        0x0040 to "Seiko Epson Corporation",
        0x0041 to "Integrated Silicon Solution Taiwan, Inc.",
        0x0042 to "CONWISE Technology Corporation Ltd",
        0x0043 to "PARROT SA",
        0x0044 to "Socket Mobile",
        0x0045 to "Atheros Communications, Inc.",
        0x0046 to "MediaTek, Inc.",
        0x0047 to "Bluegiga",
        0x0048 to "Marvell Technology Group Ltd.",
        0x0049 to "3DSP Corporation",
        0x004A to "Accel Semiconductor Ltd.",
        0x004B to "Continental Automotive Systems",
        0x004C to "Apple, Inc.",
        0x004D to "Staccato Communications, Inc.",
        0x004E to "Avago Technologies",
        0x004F to "APT Ltd.",
        0x0050 to "SiRF Technology, Inc.",
        0x0051 to "Tzero Technologies, Inc.",
        0x0052 to "J&M Corporation",
        0x0053 to "Free2move AB",
        0x0054 to "3DiJoy Corporation",
        0x0055 to "Plantronics, Inc.",
        0x0056 to "Sony Ericsson Mobile Communications",
        0x0057 to "Harman International Industries, Inc.",
        0x0058 to "Vizio, Inc.",
        0x0059 to "Nordic Semiconductor ASA",
        0x005A to "EM Microelectronic-Marin SA",
        0x005B to "Ralink Technology Corporation",
        0x005C to "Belkin International, Inc.",
        0x005D to "Realtek Semiconductor Corporation",
        0x005E to "Stonestreet One, LLC",
        0x005F to "Wicentric, Inc.",
        0x0060 to "RivieraWaves S.A.S",
        0x0061 to "RDA Microelectronics",
        0x0062 to "Gibson Guitars",
        0x0063 to "MiCommand Inc.",
        0x0064 to "Band XI International, LLC",
        0x0065 to "Hewlett-Packard Company",
        0x0066 to "9Solutions Oy",
        0x0067 to "GN Netcom A/S",
        0x0068 to "General Motors",
        0x0069 to "A&D Engineering, Inc.",
        0x006A to "MindTree Ltd.",
        0x006B to "Polar Electro OY",
        0x006C to "Beautiful Enterprise Co., Ltd.",
        0x006D to "BriarTek, Inc",
        0x006E to "Summit Data Communications, Inc.",
        0x006F to "Sound ID",
        0x0070 to "Monster, LLC",
        0x0071 to "connectBlue AB",
        0x0072 to "ShangHai Super Smart Electronics Co. Ltd.",
        0x0073 to "Group Sense Ltd.",
        0x0074 to "Zomm, LLC",
        0x0075 to "Samsung Electronics Co. Ltd.",
        0x0076 to "Creative Technology Ltd.",
        0x0077 to "Laird Technologies",
        0x0078 to "Nike, Inc.",
        0x0079 to "lesswire AG",
        0x007A to "MStar Semiconductor, Inc.",
        0x007B to "Hanlynn Technologies",
        0x007C to "A & R Cambridge",
        0x007D to "Seers Technology Co., Ltd.",
        0x007E to "Sports Tracking Technologies Ltd.",
        0x007F to "Autonet Mobile",
        0x0080 to "DeLorme Publishing Company, Inc.",
        0x0081 to "WuXi Vimicro",
        0x0082 to "Sennheiser Communications A/S",
        0x0083 to "TimeKeeping Systems, Inc.",
        0x0084 to "Ludus Helsinki Ltd.",
        0x0085 to "BlueRadios, Inc.",
        0x0086 to "Equinux AG",
        0x0087 to "Garmin International, Inc.",
        0x0088 to "Ecotest",
        0x0089 to "GN ReSound A/S",
        0x008A to "Jawbone",
        0x008B to "Topcon Positioning Systems, LLC",
        0x008C to "Gimbal Inc. (formerly Qualcomm Labs, Inc. and Qualcomm Retail Solutions, Inc.)",
        0x008D to "Zscan Software",
        0x008E to "Quintic Corp",
        0x008F to "Telit Wireless Solutions GmbH (formerly Stollmann E+V GmbH)",
        0x0090 to "Funai Electric Co., Ltd.",
        0x0091 to "Advanced PANMOBIL systems GmbH & Co. KG",
        0x0092 to "ThinkOptics, Inc.",
        0x0093 to "Universal Electronics, Inc.",
        0x0094 to "Airoha Technology Corp.",
        0x0095 to "NEC Lighting, Ltd.",
        0x0096 to "ODM Technology, Inc.",
        0x0097 to "ConnecteDevice Ltd.",
        0x0098 to "zero1.tv GmbH",
        0x0099 to "i.Tech Dynamic Global Distribution Ltd.",
        0x009A to "Alpwise",
        0x009B to "Jiangsu Toppower Automotive Electronics Co., Ltd.",
        0x009C to "Colorfy, Inc.",
        0x009D to "Geoforce Inc.",
        0x009E to "Bose Corporation",
        0x009F to "Suunto Oy",
        0x00A0 to "Kensington Computer Products Group",
        0x00A1 to "SR-Medizinelektronik",
        0x00A2 to "Vertu Corporation Limited",
        0x00A3 to "Meta Watch Ltd.",
        0x00A4 to "LINAK A/S",
        0x00A5 to "OTL Dynamics LLC",
        0x00A6 to "Panda Ocean Inc.",
        0x00A7 to "Visteon Corporation",
        0x00A8 to "ARP Devices Limited",
        0x00A9 to "Magneti Marelli S.p.A",
        0x00AA to "CAEN RFID srl",
        0x00AB to "Ingenieur-Systemgruppe Zahn GmbH",
        0x00AC to "Green Throttle Games",
        0x00AD to "Peter Systemtechnik GmbH",
        0x00AE to "Omegawave Oy",
        0x00AF to "Cinetix",
        0x00B0 to "Passif Semiconductor Corp",
        0x00B1 to "Saris Cycling Group, Inc",
        0x00B2 to "Bekey A/S",
        0x00B3 to "Clarinox Technologies Pty. Ltd.",
        0x00B4 to "BDE Technology Co., Ltd.",
        0x00B5 to "Swirl Networks",
        0x00B6 to "Meso international",
        0x00B7 to "TreLab Ltd",
        0x00B8 to "Qualcomm Innovation Center, Inc. (QuIC)",
        0x00B9 to "Johnson Controls, Inc.",
        0x00BA to "Starkey Laboratories Inc.",
        0x00BB to "S-Power Electronics Limited",
        0x00BC to "Ace Sensor Inc",
        0x00BD to "Aplix Corporation",
        0x00BE to "AAMP of America",
        0x00BF to "Stalmart Technology Limited",
        0x00C0 to "AMICCOM Electronics Corporation",
        0x00C1 to "Shenzhen Excelsecu Data Technology Co.,Ltd",
        0x00C2 to "Geneq Inc.",
        0x00C3 to "adidas AG",
        0x00C4 to "LG Electronics",
        0x00C5 to "Onset Computer Corporation",
        0x00C6 to "Selfly BV",
        0x00C7 to "Quuppa Oy.",
        0x00C8 to "GeLo Inc",
        0x00C9 to "Evluma",
        0x00CA to "MC10",
        0x00CB to "Binauric SE",
        0x00CC to "Beats Electronics",
        0x00CD to "Microchip Technology Inc.",
        0x00CE to "Elgato Systems GmbH",
        0x00CF to "ARCHOS SA",
        0x00D0 to "Dexcom, Inc.",
        0x00D1 to "Polar Electro Europe B.V.",
        0x00D2 to "Dialog Semiconductor B.V.",
        0x00D3 to "Taixingbang Technology (HK) Co,. LTD.",
        0x00D4 to "Kawantech",
        0x00D5 to "Austco Communication Systems",
        0x00D6 to "Timex Group USA, Inc.",
        0x00D7 to "Qualcomm Technologies, Inc.",
        0x00D8 to "Qualcomm Connected Experiences, Inc.",
        0x00D9 to "Voyetra Turtle Beach",
        0x00DA to "txtr GmbH",
        0x00DB to "Biosentronics",
        0x00DC to "Procter & Gamble",
        0x00DD to "Hosiden Corporation",
        0x00DE to "Muzik LLC",
        0x00DF to "Misfit Wearables Corp",
        0x00E0 to "Google",
        0x00E1 to "Danlers Ltd",
        0x00E2 to "Semilink Inc",
        0x00E3 to "inMusic Brands, Inc",
        0x00E4 to "L.S. Research Inc.",
        0x00E5 to "Eden Software Consultants Ltd.",
        0x00E6 to "Freshtemp",
        0x00E7 to "KS Technologies",
        0x00E8 to "ACTS Technologies",
        0x00E9 to "Vtrack Systems",
        0x00EA to "Nielsen-Kellerman Company",
        0x00EB to "Server Technology Inc.",
        0x00EC to "BioResarch Associates",
        0x00ED to "Jolly Logic, LLC",
        0x00EE to "Above Average Outcomes, Inc.",
        0x00EF to "Bitsplitters GmbH",
        0x00F0 to "PayPal, Inc.",
        0x00F1 to "Witron Technology Limited",
        0x00F2 to "Morse Project Inc.",
        0x00F3 to "Kent Displays Inc.",
        0x00F4 to "Nautilus Inc.",
        0x00F5 to "Smartifier Oy",
        0x00F6 to "Elcometer Limited",
        0x00F7 to "VSN Technologies, Inc.",
        0x00F8 to "AceUni Corp., Ltd.",
        0x00F9 to "StickNFind",
        0x00FA to "Crystal Code AB",
        0x00FB to "KOUKAAM a.s.",
        0x00FC to "Delphi Corporation",
        0x00FD to "ValenceTech Limited",
        0x00FE to "Stanley Black and Decker",
        0x00FF to "Typo Products, LLC",
        0x0100 to "TomTom International BV",
        0x0101 to "Fugoo, Inc.",
        0x0102 to "Keiser Corporation",
        0x0103 to "Bang & Olufsen S/A",
        0x0104 to "PLUS Location Systems Pty Ltd",
        0x0105 to "Ubiquitous Computing Technology Corporation",
        0x0106 to "Innovative Yachtter Solutions",
        0x0107 to "William Demant Holding A/S",
        0x0108 to "Chicony Electronics Co., Ltd.",
        0x0109 to "Atus BV",
        0x010A to "Codegate Ltd",
        0x010B to "ERi, Inc",
        0x010C to "Transducers Direct, LLC",
        0x010D to "Fujitsu Ten LImited",
        0x010E to "Audi AG",
        0x010F to "HiSilicon Technologies Col, Ltd.",
        0x0110 to "Nippon Seiki Co., Ltd.",
        0x0111 to "Steelseries ApS",
        0x0112 to "Visybl Inc.",
        0x0113 to "Openbrain Technologies, Co., Ltd.",
        0x0114 to "Xensr",
        0x0115 to "e.solutions",
        0x0116 to "10AK Technologies",
        0x0117 to "Wimoto Technologies Inc",
        0x0118 to "Radius Networks, Inc.",
        0x0119 to "Wize Technology Co., Ltd.",
        0x011A to "Qualcomm Labs, Inc.",
        0x011B to "Aruba Networks",
        0x011C to "Baidu",
        0x011D to "Arendi AG",
        0x011E to "Skoda Auto a.s.",
        0x011F to "Volkwagon AG",
        0x0120 to "Porsche AG",
        0x0121 to "Sino Wealth Electronic Ltd.",
        0x0122 to "AirTurn, Inc.",
        0x0123 to "Kinsa, Inc",
        0x0124 to "HID Global",
        0x0125 to "SEAT es",
        0x0126 to "Promethean Ltd.",
        0x0127 to "Salutica Allied Solutions",
        0x0128 to "GPSI Group Pty Ltd",
        0x0129 to "Nimble Devices Oy",
        0x012A to "Changzhou Yongse Infotech Co., Ltd.",
        0x012B to "SportIQ",
        0x012C to "TEMEC Instruments B.V.",
        0x012D to "Sony Corporation",
        0x012E to "ASSA ABLOY",
        0x012F to "Clarion Co. Inc.",
        0x0130 to "Warehouse Innovations",
        0x0131 to "Cypress Semiconductor",
        0x0132 to "MADS Inc",
        0x0133 to "Blue Maestro Limited",
        0x0134 to "Resolution Products, Ltd.",
        0x0135 to "Aireware LLC",
        0x0136 to "Seed Labs, Inc. (formerly ETC sp. z.o.o.)",
        0x0137 to "Prestigio Plaza Ltd.",
        0x0138 to "NTEO Inc.",
        0x0139 to "Focus Systems Corporation",
        0x013A to "Tencent Holdings Ltd.",
        0x013B to "Allegion",
        0x013C to "Murata Manufacturing Co., Ltd.",
        0x013D to "WirelessWERX",
        0x013E to "Nod, Inc.",
        0x013F to "B&B Manufacturing Company",
        0x0140 to "Alpine Electronics (China) Co., Ltd",
        0x0141 to "FedEx Services",
        0x0142 to "Grape Systems Inc.",
        0x0143 to "Bkon Connect",
        0x0144 to "Lintech GmbH",
        0x0145 to "Novatel Wireless",
        0x0146 to "Ciright",
        0x0147 to "Mighty Cast, Inc.",
        0x0148 to "Ambimat Electronics",
        0x0149 to "Perytons Ltd.",
        0x014A to "Tivoli Audio, LLC",
        0x014B to "Master Lock",
        0x014C to "Mesh-Net Ltd",
        0x014D to "HUIZHOU DESAY SV AUTOMOTIVE CO., LTD.",
        0x014E to "Tangerine, Inc.",
        0x014F to "B&W Group Ltd.",
        0x0150 to "Pioneer Corporation",
        0x0151 to "OnBeep",
        0x0152 to "Vernier Software & Technology",
        0x0153 to "ROL Ergo",
        0x0154 to "Pebble Technology",
        0x0155 to "NETATMO",
        0x0156 to "Accumulate AB",
        0x0157 to "Anhui Huami Information Technology Co., Ltd.",
        0x0158 to "Inmite s.r.o.",
        0x0159 to "ChefSteps, Inc.",
        0x015A to "micas AG",
        0x015B to "Biomedical Research Ltd.",
        0x015C to "Pitius Tec S.L.",
        0x015D to "Estimote, Inc.",
        0x015E to "Unikey Technologies, Inc.",
        0x015F to "Timer Cap Co.",
        0x0160 to "AwoX",
        0x0161 to "yikes",
        0x0162 to "MADSGlobalNZ Ltd.",
        0x0163 to "PCH International",
        0x0164 to "Qingdao Yeelink Information Technology Co., Ltd.",
        0x0165 to "Milwaukee Tool (Formally Milwaukee Electric Tools)",
        0x0166 to "MISHIK Pte Ltd",
        0x0167 to "Bayer HealthCare",
        0x0168 to "Spicebox LLC",
        0x0169 to "emberlight",
        0x016A to "Cooper-Atkins Corporation",
        0x016B to "Qblinks",
        0x016C to "MYSPHERA",
        0x016D to "LifeScan Inc",
        0x016E to "Volantic AB",
        0x016F to "Podo Labs, Inc",
        0x0170 to "Roche Diabetes Care AG",
        0x0171 to "Amazon Fulfillment Service",
        0x0172 to "Connovate Technology Private Limited",
        0x0173 to "Kocomojo, LLC",
        0x0174 to "EveryKey LLC",
        0x0175 to "Dynamic Controls",
        0x0176 to "SentriLock",
        0x0177 to "I-SYST inc.",
        0x0178 to "CASIO COMPUTER CO., LTD.",
        0x0179 to "LAPIS Semiconductor Co., Ltd.",
        0x017A to "Telemonitor, Inc.",
        0x017B to "taskit GmbH",
        0x017C to "Daimler AG",
        0x017D to "BatAndCat",
        0x017E to "BluDotz Ltd",
        0x017F to "XTel ApS",
        0x0180 to "Gigaset Communications GmbH",
        0x0181 to "Gecko Health Innovations, Inc.",
        0x0182 to "HOP Ubiquitous",
        0x0183 to "Walt Disney",
        0x0184 to "Nectar",
        0x0185 to "bel'apps LLC",
        0x0186 to "CORE Lighting Ltd",
        0x0187 to "Seraphim Sense Ltd",
        0x0188 to "Unico RBC",
        0x0189 to "Physical Enterprises Inc.",
        0x018A to "Able Trend Technology Limited",
        0x018B to "Konica Minolta, Inc.",
        0x018C to "Wilo SE",
        0x018D to "Extron Design Services",
        0x018E to "Fitbit, Inc.",
        0x018F to "Fireflies Systems",
        0x0190 to "Intelletto Technologies Inc.",
        0x0191 to "FDK CORPORATION",
        0x0192 to "Cloudleaf, Inc",
        0x0193 to "Maveric Automation LLC",
        0x0194 to "Acoustic Stream Corporation",
        0x0195 to "Zuli",
        0x0196 to "Paxton Access Ltd",
        0x0197 to "WiSilica Inc.",
        0x0198 to "VENGIT Korltolt Felelssg Trsasg",
        0x0199 to "SALTO SYSTEMS S.L.",
        0x019A to "TRON Forum (formerly T-Engine Forum)",
        0x019B to "CUBETECH s.r.o.",
        0x019C to "Cokiya Incorporated",
        0x019D to "CVS Health",
        0x019E to "Ceruus",
        0x019F to "Strainstall Ltd",
        0x01A0 to "Channel Enterprises (HK) Ltd.",
        0x01A1 to "FIAMM",
        0x01A2 to "GIGALANE.CO.,LTD",
        0x01A3 to "EROAD",
        0x01A4 to "Mine Safety Appliances",
        0x01A5 to "Icon Health and Fitness",
        0x01A6 to "Asandoo GmbH",
        0x01A7 to "ENERGOUS CORPORATION",
        0x01A8 to "Taobao",
        0x01A9 to "Canon Inc.",
        0x01AA to "Geophysical Technology Inc.",
        0x01AB to "Facebook, Inc.",
        0x01AC to "Nipro Diagnostics, Inc.",
        0x01AD to "FlightSafety International",
        0x01AE to "Earlens Corporation",
        0x01AF to "Sunrise Micro Devices, Inc.",
        0x01B0 to "Star Micronics Co., Ltd.",
        0x01B1 to "Netizens Sp. z o.o.",
        0x01B2 to "Nymi Inc.",
        0x01B3 to "Nytec, Inc.",
        0x01B4 to "Trineo Sp. z o.o.",
        0x01B5 to "Nest Labs Inc.",
        0x01B6 to "LM Technologies Ltd",
        0x01B7 to "General Electric Company",
        0x01B8 to "i+D3 S.L.",
        0x01B9 to "HANA Micron",
        0x01BA to "Stages Cycling LLC",
        0x01BB to "Cochlear Bone Anchored Solutions AB",
        0x01BC to "SenionLab AB",
        0x01BD to "Syszone Co., Ltd",
        0x01BE to "Pulsate Mobile Ltd.",
        0x01BF to "Hong Kong HunterSun Electronic Limited",
        0x01C0 to "pironex GmbH",
        0x01C1 to "BRADATECH Corp.",
        0x01C2 to "Transenergooil AG",
        0x01C3 to "Bunch",
        0x01C4 to "DME Microelectronics",
        0x01C5 to "Bitcraze AB",
        0x01C6 to "HASWARE Inc.",
        0x01C7 to "Abiogenix Inc.",
        0x01C8 to "Poly-Control ApS",
        0x01C9 to "Avi-on",
        0x01CA to "Laerdal Medical AS",
        0x01CB to "Fetch My Pet",
        0x01CC to "Sam Labs Ltd.",
        0x01CD to "Chengdu Synwing Technology Ltd",
        0x01CE to "HOUWA SYSTEM DESIGN, k.k.",
        0x01CF to "BSH",
        0x01D0 to "Primus Inter Pares Ltd",
        0x01D1 to "August Home, Inc",
        0x01D2 to "Gill Electronics",
        0x01D3 to "Sky Wave Design",
        0x01D4 to "Newlab S.r.l.",
        0x01D5 to "ELAD srl",
        0x01D6 to "G-wearables inc.",
        0x01D7 to "Squadrone Systems Inc.",
        0x01D8 to "Code Corporation",
        0x01D9 to "Savant Systems LLC",
        0x01DA to "Logitech International SA",
        0x01DB to "Innblue Consulting",
        0x01DC to "iParking Ltd.",
        0x01DD to "Koninklijke Philips Electronics N.V.",
        0x01DE to "Minelab Electronics Pty Limited",
        0x01DF to "Bison Group Ltd.",
        0x01E0 to "Widex A/S",
        0x01E1 to "Jolla Ltd",
        0x01E2 to "Lectronix, Inc.",
        0x01E3 to "Caterpillar Inc",
        0x01E4 to "Freedom Innovations",
        0x01E5 to "Dynamic Devices Ltd",
        0x01E6 to "Technology Solutions (UK) Ltd",
        0x01E7 to "IPS Group Inc.",
        0x01E8 to "STIR",
        0x01E9 to "Sano, Inc.",
        0x01EA to "Advanced Application Design, Inc.",
        0x01EB to "AutoMap LLC",
        0x01EC to "Spreadtrum Communications Shanghai Ltd",
        0x01ED to "CuteCircuit LTD",
        0x01EE to "Valeo Service",
        0x01EF to "Fullpower Technologies, Inc.",
        0x01F0 to "KloudNation",
        0x01F1 to "Zebra Technologies Corporation",
        0x01F2 to "Itron, Inc.",
        0x01F3 to "The University of Tokyo",
        0x01F4 to "UTC Fire and Security",
        0x01F5 to "Cool Webthings Limited",
        0x01F6 to "DJO Global",
        0x01F7 to "Gelliner Limited",
        0x01F8 to "Anyka (Guangzhou) Microelectronics Technology Co, LTD",
        0x01F9 to "Medtronic Inc.",
        0x01FA to "Gozio Inc.",
        0x01FB to "Form Lifting, LLC",
        0x01FC to "Wahoo Fitness, LLC",
        0x01FD to "Kontakt Micro-Location Sp. z o.o.",
        0x01FE to "Radio Systems Corporation",
        0x01FF to "Freescale Semiconductor, Inc.",
        0x0200 to "Verifone Systems Pte Ltd. Taiwan Branch",
        0x0201 to "AR Timing",
        0x0202 to "Rigado LLC",
        0x0203 to "Kemppi Oy",
        0x0204 to "Tapcentive Inc.",
        0x0205 to "Smartbotics Inc.",
        0x0206 to "Otter Products, LLC",
        0x0207 to "STEMP Inc.",
        0x0208 to "LumiGeek LLC",
        0x0209 to "InvisionHeart Inc.",
        0x020A to "Macnica Inc.",
        0x020B to "Jaguar Land Rover Limited",
        0x020C to "CoroWare Technologies, Inc",
        0x020D to "Simplo Technology Co., LTD",
        0x020E to "Omron Healthcare Co., LTD",
        0x020F to "Comodule GMBH",
        0x0210 to "ikeGPS",
        0x0211 to "Telink Semiconductor Co. Ltd",
        0x0212 to "Interplan Co., Ltd",
        0x0213 to "Wyler AG",
        0x0214 to "IK Multimedia Production srl",
        0x0215 to "Lukoton Experience Oy",
        0x0216 to "MTI Ltd",
        0x0217 to "Tech4home, Lda",
        0x0218 to "Hiotech AB",
        0x0219 to "DOTT Limited",
        0x021A to "Blue Speck Labs, LLC",
        0x021B to "Cisco Systems, Inc",
        0x021C to "Mobicomm Inc",
        0x021D to "Edamic",
        0x021E to "Goodnet, Ltd",
        0x021F to "Luster Leaf Products Inc",
        0x0220 to "Manus Machina BV",
        0x0221 to "Mobiquity Networks Inc",
        0x0222 to "Praxis Dynamics",
        0x0223 to "Philip Morris Products S.A.",
        0x0224 to "Comarch SA",
        0x0225 to "Nestl Nespresso S.A.",
        0x0226 to "Merlinia A/S",
        0x0227 to "LifeBEAM Technologies",
        0x0228 to "Twocanoes Labs, LLC",
        0x0229 to "Muoverti Limited",
        0x022A to "Stamer Musikanlagen GMBH",
        0x022B to "Tesla Motors",
        0x022C to "Pharynks Corporation",
        0x022D to "Lupine",
        0x022E to "Siemens AG",
        0x022F to "Huami (Shanghai) Culture Communication CO., LTD",
        0x0230 to "Foster Electric Company, Ltd",
        0x0231 to "ETA SA",
        0x0232 to "x-Senso Solutions Kft",
        0x0233 to "Shenzhen SuLong Communication Ltd",
        0x0234 to "FengFan (BeiJing) Technology Co, Ltd",
        0x0235 to "Qrio Inc",
        0x0236 to "Pitpatpet Ltd",
        0x0237 to "MSHeli s.r.l.",
        0x0238 to "Trakm8 Ltd",
        0x0239 to "JIN CO, Ltd",
        0x023A to "Alatech Tehnology",
        0x023B to "Beijing CarePulse Electronic Technology Co, Ltd",
        0x023C to "Awarepoint",
        0x023D to "ViCentra B.V.",
        0x023E to "Raven Industries",
        0x023F to "WaveWare Technologies Inc.",
        0x0240 to "Argenox Technologies",
        0x0241 to "Bragi GmbH",
        0x0242 to "16Lab Inc",
        0x0243 to "Masimo Corp",
        0x0244 to "Iotera Inc",
        0x0245 to "Endress+Hauser",
        0x0246 to "ACKme Networks, Inc.",
        0x0247 to "FiftyThree Inc.",
        0x0248 to "Parker Hannifin Corp",
        0x0249 to "Transcranial Ltd",
        0x024A to "Uwatec AG",
        0x024B to "Orlan LLC",
        0x024C to "Blue Clover Devices",
        0x024D to "M-Way Solutions GmbH",
        0x024E to "Microtronics Engineering GmbH",
        0x024F to "Schneider Schreibgerte GmbH",
        0x0250 to "Sapphire Circuits LLC",
        0x0251 to "Lumo Bodytech Inc.",
        0x0252 to "UKC Technosolution",
        0x0253 to "Xicato Inc.",
        0x0254 to "Playbrush",
        0x0255 to "Dai Nippon Printing Co., Ltd.",
        0x0256 to "G24 Power Limited",
        0x0257 to "AdBabble Local Commerce Inc.",
        0x0258 to "Devialet SA",
        0x0259 to "ALTYOR",
        0x025A to "University of Applied Sciences Valais/Haute Ecole Valaisanne",
        0x025B to "Five Interactive, LLC dba Zendo",
        0x025C to "NetEaseHangzhouNetwork co.Ltd.",
        0x025D to "Lexmark International Inc.",
        0x025E to "Fluke Corporation",
        0x025F to "Yardarm Technologies",
        0x0260 to "SensaRx",
        0x0261 to "SECVRE GmbH",
        0x0262 to "Glacial Ridge Technologies",
        0x0263 to "Identiv, Inc.",
        0x0264 to "DDS, Inc.",
        0x0265 to "SMK Corporation",
        0x0266 to "Schawbel Technologies LLC",
        0x0267 to "XMI Systems SA",
        0x0268 to "Cerevo",
        0x0269 to "Torrox GmbH & Co KG",
        0x026A to "Gemalto",
        0x026B to "DEKA Research & Development Corp.",
        0x026C to "Domster Tadeusz Szydlowski",
        0x026D to "Technogym SPA",
        0x026E to "FLEURBAEY BVBA",
        0x026F to "Aptcode Solutions",
        0x0270 to "LSI ADL Technology",
        0x0271 to "Animas Corp",
        0x0272 to "Alps Electric Co., Ltd.",
        0x0273 to "OCEASOFT",
        0x0274 to "Motsai Research",
        0x0275 to "Geotab",
        0x0276 to "E.G.O. Elektro-Gertebau GmbH",
        0x0277 to "bewhere inc",
        0x0278 to "Johnson Outdoors Inc",
        0x0279 to "steute Schaltgerate GmbH & Co. KG",
        0x027A to "Ekomini inc.",
        0x027B to "DEFA AS",
        0x027C to "Aseptika Ltd",
        0x027D to "HUAWEI Technologies Co., Ltd. ( )",
        0x027E to "HabitAware, LLC",
        0x027F to "ruwido austria gmbh",
        0x0280 to "ITEC corporation",
        0x0281 to "StoneL",
        0x0282 to "Sonova AG",
        0x0283 to "Maven Machines, Inc.",
        0x0284 to "Synapse Electronics",
        0x0285 to "Standard Innovation Inc.",
        0x0286 to "RF Code, Inc.",
        0x0287 to "Wally Ventures S.L.",
        0x0288 to "Willowbank Electronics Ltd",
        0x0289 to "SK Telecom",
        0x028A to "Jetro AS",
        0x028B to "Code Gears LTD",
        0x028C to "NANOLINK APS",
        0x028D to "IF, LLC",
        0x028E to "RF Digital Corp",
        0x028F to "Church & Dwight Co., Inc",
        0x0290 to "Multibit Oy",
        0x0291 to "CliniCloud Inc",
        0x0292 to "SwiftSensors",
        0x0293 to "Blue Bite",
        0x0294 to "ELIAS GmbH",
        0x0295 to "Sivantos GmbH",
        0x0296 to "Petzl",
        0x0297 to "storm power ltd",
        0x0298 to "EISST Ltd",
        0x0299 to "Inexess Technology Simma KG",
        0x029A to "Currant, Inc.",
        0x029B to "C2 Development, Inc.",
        0x029C to "Blue Sky Scientific, LLC",
        0x029D to "ALOTTAZS LABS, LLC",
        0x029E to "Kupson spol. s r.o.",
        0x029F to "Areus Engineering GmbH",
        0x02A0 to "Impossible Camera GmbH",
        0x02A1 to "InventureTrack Systems",
        0x02A2 to "LockedUp",
        0x02A3 to "Itude",
        0x02A4 to "Pacific Lock Company",
        0x02A5 to "Tendyron Corporation ( )",
        0x02A6 to "Robert Bosch GmbH",
        0x02A7 to "Illuxtron international B.V.",
        0x02A8 to "miSport Ltd.",
        0x02A9 to "Chargelib",
        0x02AA to "Doppler Lab",
        0x02AB to "BBPOS Limited",
        0x02AC to "RTB Elektronik GmbH & Co. KG",
        0x02AD to "Rx Networks, Inc.",
        0x02AE to "WeatherFlow, Inc.",
        0x02AF to "Technicolor USA Inc.",
        0x02B0 to "Bestechnic(Shanghai),Ltd",
        0x02B1 to "Raden Inc",
        0x02B2 to "JouZen Oy",
        0x02B3 to "CLABER S.P.A.",
        0x02B4 to "Hyginex, Inc.",
        0x02B5 to "HANSHIN ELECTRIC RAILWAY CO.,LTD.",
        0x02B6 to "Schneider Electric",
        0x02B7 to "Oort Technologies LLC",
        0x02B8 to "Chrono Therapeutics",
        0x02B9 to "Rinnai Corporation",
        0x02BA to "Swissprime Technologies AG",
        0x02BB to "Koha.,Co.Ltd",
        0x02BC to "Genevac Ltd",
        0x02BD to "Chemtronics",
        0x02BE to "Seguro Technology Sp. z o.o.",
        0x02BF to "Redbird Flight Simulations",
        0x02C0 to "Dash Robotics",
        0x02C1 to "LINE Corporation",
        0x02C2 to "Guillemot Corporation",
        0x02C3 to "Techtronic Power Tools Technology Limited",
        0x02C4 to "Wilson Sporting Goods",
        0x02C5 to "Lenovo (Singapore) Pte Ltd. ( )",
        0x02C6 to "Ayatan Sensors",
        0x02C7 to "Electronics Tomorrow Limited",
        0x02C8 to "VASCO Data Security International, Inc.",
        0x02C9 to "PayRange Inc.",
        0x02CA to "ABOV Semiconductor",
        0x02CB to "AINA-Wireless Inc.",
        0x02CC to "Eijkelkamp Soil & Water",
        0x02CD to "BMA ergonomics b.v.",
        0x02CE to "Teva Branded Pharmaceutical Products R&D, Inc.",
        0x02CF to "Anima",
        0x02D0 to "3M",
        0x02D1 to "Empatica Srl",
        0x02D2 to "Afero, Inc.",
        0x02D3 to "Powercast Corporation",
        0x02D4 to "Secuyou ApS",
        0x02D5 to "OMRON Corporation",
        0x02D6 to "Send Solutions",
        0x02D7 to "NIPPON SYSTEMWARE CO.,LTD.",
        0x02D8 to "Neosfar",
        0x02D9 to "Fliegl Agrartechnik GmbH",
        0x02DA to "Gilvader",
        0x02DB to "Digi International Inc (R)",
        0x02DC to "DeWalch Technologies, Inc.",
        0x02DD to "Flint Rehabilitation Devices, LLC",
        0x02DE to "Samsung SDS Co., Ltd.",
        0x02DF to "Blur Product Development",
        0x02E0 to "University of Michigan",
        0x02E1 to "Victron Energy BV",
        0x02E2 to "NTT docomo",
        0x02E3 to "Carmanah Technologies Corp.",
        0x02E4 to "Bytestorm Ltd.",
        0x02E5 to "Espressif Incorporated ( () )",
        0x02E6 to "Unwire",
        0x02E7 to "Connected Yard, Inc.",
        0x02E8 to "American Music Environments",
        0x02E9 to "Sensogram Technologies, Inc.",
        0x02EA to "Fujitsu Limited",
        0x02EB to "Ardic Technology",
        0x02EC to "Delta Systems, Inc",
        0x02ED to "HTC Corporation",
        0x02EE to "Citizen Holdings Co., Ltd.",
        0x02EF to "SMART-INNOVATION.inc",
        0x02F0 to "Blackrat Software",
        0x02F1 to "The Idea Cave, LLC",
        0x02F2 to "GoPro, Inc.",
        0x02F3 to "AuthAir, Inc",
        0x02F4 to "Vensi, Inc.",
        0x02F5 to "Indagem Tech LLC",
        0x02F6 to "Intemo Technologies",
        0x02F7 to "DreamVisions co., Ltd.",
        0x02F8 to "Runteq Oy Ltd",
        0x02F9 to "IMAGINATION TECHNOLOGIES LTD",
        0x02FA to "CoSTAR TEchnologies",
        0x02FB to "Clarius Mobile Health Corp.",
        0x02FC to "Shanghai Frequen Microelectronics Co., Ltd.",
        0x02FD to "Uwanna, Inc.",
        0x02FE to "Lierda Science & Technology Group Co., Ltd.",
        0x02FF to "Silicon Laboratories",
        0x0300 to "World Moto Inc.",
        0x0301 to "Giatec Scientific Inc.",
        0x0302 to "Loop Devices, Inc",
        0x0303 to "IACA electronique",
        0x0304 to "Martians Inc",
        0x0305 to "Swipp ApS",
        0x0306 to "Life Laboratory Inc.",
        0x0307 to "FUJI INDUSTRIAL CO.,LTD.",
        0x0308 to "Surefire, LLC",
        0x0309 to "Dolby Labs",
        0x030A to "Ellisys",
        0x030B to "Magnitude Lighting Converters",
        0x030C to "Hilti AG",
        0x030D to "Devdata S.r.l.",
        0x030E to "Deviceworx",
        0x030F to "Shortcut Labs",
        0x0310 to "SGL Italia S.r.l.",
        0x0311 to "PEEQ DATA",
        0x0312 to "Ducere Technologies Pvt Ltd",
        0x0313 to "DiveNav, Inc.",
        0x0314 to "RIIG AI Sp. z o.o.",
        0x0315 to "Thermo Fisher Scientific",
        0x0316 to "AG Measurematics Pvt. Ltd.",
        0x0317 to "CHUO Electronics CO., LTD.",
        0x0318 to "Aspenta International",
        0x0319 to "Eugster Frismag AG",
        0x031A to "Amber wireless GmbH",
        0x031B to "HQ Inc",
        0x031C to "Lab Sensor Solutions",
        0x031D to "Enterlab ApS",
        0x031E to "Eyefi, Inc.",
        0x031F to "MetaSystem S.p.A.",
        0x0320 to "SONO ELECTRONICS. CO., LTD",
        0x0321 to "Jewelbots",
        0x0322 to "Compumedics Limited",
        0x0323 to "Rotor Bike Components",
        0x0324 to "Astro, Inc.",
        0x0325 to "Amotus Solutions",
        0x0326 to "Healthwear Technologies (Changzhou)Ltd",
        0x0327 to "Essex Electronics",
        0x0328 to "Grundfos A/S",
        0x0329 to "Eargo, Inc.",
        0x032A to "Electronic Design Lab",
        0x032B to "ESYLUX",
        0x032C to "NIPPON SMT.CO.,Ltd",
        0x032D to "BM innovations GmbH",
        0x032E to "indoormap",
        0x032F to "OttoQ Inc",
        0x0330 to "North Pole Engineering",
        0x0331 to "3flares Technologies Inc.",
        0x0332 to "Electrocompaniet A.S.",
        0x0333 to "Mul-T-Lock",
        0x0334 to "Corentium AS",
        0x0335 to "Enlighted Inc",
        0x0336 to "GISTIC",
        0x0337 to "AJP2 Holdings, LLC",
        0x0338 to "COBI GmbH",
        0x0339 to "Blue Sky Scientific, LLC",
        0x033A to "Appception, Inc.",
        0x033B to "Courtney Thorne Limited",
        0x033C to "Virtuosys",
        0x033D to "TPV Technology Limited",
        0x033E to "Monitra SA",
        0x033F to "Automation Components, Inc.",
        0x0340 to "Letsense s.r.l.",
        0x0341 to "Etesian Technologies LLC",
        0x0342 to "GERTEC BRASIL LTDA.",
        0x0343 to "Drekker Development Pty. Ltd.",
        0x0344 to "Whirl Inc",
        0x0345 to "Locus Positioning",
        0x0346 to "Acuity Brands Lighting, Inc",
        0x0347 to "Prevent Biometrics",
        0x0348 to "Arioneo",
        0x0349 to "VersaMe",
        0x034A to "Vaddio",
        0x034B to "Libratone A/S",
        0x034C to "HM Electronics, Inc.",
        0x034D to "TASER International, Inc.",
        0x034E to "SafeTrust Inc.",
        0x034F to "Heartland Payment Systems",
        0x0350 to "Bitstrata Systems Inc.",
        0x0351 to "Pieps GmbH",
        0x0352 to "iRiding(Xiamen)Technology Co.,Ltd.",
        0x0353 to "Alpha Audiotronics, Inc.",
        0x0354 to "TOPPAN FORMS CO.,LTD.",
        0x0355 to "Sigma Designs, Inc.",
        0x0356 to "Spectrum Brands, Inc.",
        0x0357 to "Polymap Wireless",
        0x0358 to "MagniWare Ltd.",
        0x0359 to "Novotec Medical GmbH",
        0x035A to "Medicom Innovation Partner a/s",
        0x035B to "Matrix Inc.",
        0x035C to "Eaton Corporation",
        0x035D to "KYS",
        0x035E to "Naya Health, Inc.",
        0x035F to "Acromag",
        0x0360 to "Insulet Corporation",
        0x0361 to "Wellinks Inc.",
        0x0362 to "ON Semiconductor",
        0x0363 to "FREELAP SA",
        0x0364 to "Favero Electronics Srl",
        0x0365 to "BioMech Sensor LLC",
        0x0366 to "BOLTT Sports technologies Private limited",
        0x0367 to "Saphe International",
        0x0368 to "Metormote AB",
        0x0369 to "littleBits",
        0x036A to "SetPoint Medical",
        0x036B to "BRControls Products BV",
        0x036C to "Zipcar",
        0x036D to "AirBolt Pty Ltd",
        0x036E to "KeepTruckin Inc",
        0x036F to "Motiv, Inc.",
        0x0370 to "Wazombi Labs O",
        0x0371 to "ORBCOMM",
        0x0372 to "Nixie Labs, Inc.",
        0x0373 to "AppNearMe Ltd",
        0x0374 to "Holman Industries",
        0x0375 to "Expain AS",
        0x0376 to "Electronic Temperature Instruments Ltd",
        0x0377 to "Plejd AB",
        0x0378 to "Propeller Health",
        0x0379 to "Shenzhen iMCO Electronic Technology Co.,Ltd",
        0x037A to "Algoria",
        0x037B to "Apption Labs Inc.",
        0x037C to "Cronologics Corporation",
        0x037D to "MICRODIA Ltd.",
        0x037E to "lulabytes S.L.",
        0x037F to "Nestec S.A.",
        0x0380 to "LLC MEGA - F service",
        0x0381 to "Sharp Corporation",
        0x0382 to "Precision Outcomes Ltd",
        0x0383 to "Kronos Incorporated",
        0x0384 to "OCOSMOS Co., Ltd.",
        0x0385 to "Embedded Electronic Solutions Ltd. dba e2Solutions",
        0x0386 to "Aterica Inc.",
        0x0387 to "BluStor PMC, Inc.",
        0x0388 to "Kapsch TrafficCom AB",
        0x0389 to "ActiveBlu Corporation",
        0x038A to "Kohler Mira Limited",
        0x038B to "Noke",
        0x038C to "Appion Inc.",
        0x038D to "Resmed Ltd",
        0x038E to "Crownstone B.V.",
        0x038F to "Xiaomi Inc.",
        0x0390 to "INFOTECH s.r.o.",
        0x0391 to "Thingsquare AB",
        0x0392 to "T&D",
        0x0393 to "LAVAZZA S.p.A.",
        0x0394 to "Netclearance Systems, Inc.",
        0x0395 to "SDATAWAY",
        0x0396 to "BLOKS GmbH",
        0x0397 to "LEGO System A/S",
        0x0398 to "Thetatronics Ltd",
        0x0399 to "Nikon Corporation",
        0x039A to "NeST",
        0x039B to "South Silicon Valley Microelectronics",
        0x039C to "ALE International",
        0x039D to "CareView Communications, Inc.",
        0x039E to "SchoolBoard Limited",
        0x039F to "Molex Corporation",
        0x03A0 to "IVT Wireless Limited",
        0x03A1 to "Alpine Labs LLC",
        0x03A2 to "Candura Instruments",
        0x03A3 to "SmartMovt Technology Co., Ltd",
        0x03A4 to "Token Zero Ltd",
        0x03A5 to "ACE CAD Enterprise Co., Ltd. (ACECAD)",
        0x03A6 to "Medela, Inc",
        0x03A7 to "AeroScout",
        0x03A8 to "Esrille Inc.",
        0x03A9 to "THINKERLY SRL",
        0x03AA to "Exon Sp. z o.o.",
        0x03AB to "Meizu Technology Co., Ltd.",
        0x03AC to "Smablo LTD",
        0x03AD to "XiQ",
        0x03AE to "Allswell Inc.",
        0x03AF to "Comm-N-Sense Corp DBA Verigo",
        0x03B0 to "VIBRADORM GmbH",
        0x03B1 to "Otodata Wireless Network Inc.",
        0x03B2 to "Propagation Systems Limited",
        0x03B3 to "Midwest Instruments & Controls",
        0x03B4 to "Alpha Nodus, inc.",
        0x03B5 to "petPOMM, Inc",
        0x03B6 to "Mattel",
        0x03B7 to "Airbly Inc.",
        0x03B8 to "A-Safe Limited",
        0x03B9 to "FREDERIQUE CONSTANT SA",
        0x03BA to "Maxscend Microelectronics Company Limited",
        0x03BB to "Abbott Diabetes Care",
        0x03BC to "ASB Bank Ltd",
        0x03BD to "amadas",
        0x03BE to "Applied Science, Inc.",
        0x03BF to "iLumi Solutions Inc.",
        0x03C0 to "Arch Systems Inc.",
        0x03C1 to "Ember Technologies, Inc.",
        0x03C2 to "Snapchat Inc",
        0x03C3 to "Casambi Technologies Oy",
        0x03C4 to "Pico Technology Inc.",
        0x03C5 to "St. Jude Medical, Inc.",
        0x03C6 to "Intricon",
        0x03C7 to "Structural Health Systems, Inc.",
        0x03C8 to "Avvel International",
        0x03C9 to "Gallagher Group",
        0x03CA to "In2things Automation Pvt. Ltd.",
        0x03CB to "SYSDEV Srl",
        0x03CC to "Vonkil Technologies Ltd",
        0x03CD to "Wynd Technologies, Inc.",
        0x03CE to "CONTRINEX S.A.",
        0x03CF to "MIRA, Inc.",
        0x03D0 to "Watteam Ltd",
        0x03D1 to "Density Inc.",
        0x03D2 to "IOT Pot India Private Limited",
        0x03D3 to "Sigma Connectivity AB",
        0x03D4 to "PEG PEREGO SPA",
        0x03D5 to "Wyzelink Systems Inc.",
        0x03D6 to "Yota Devices LTD",
        0x03D7 to "FINSECUR",
        0x03D8 to "Zen-Me Labs Ltd",
        0x03D9 to "3IWare Co., Ltd.",
        0x03DA to "EnOcean GmbH",
        0x03DB to "Instabeat, Inc",
        0x03DC to "Nima Labs",
        0x03DD to "Andreas Stihl AG & Co. KG",
        0x03DE to "Nathan Rhoades LLC",
        0x03DF to "Grob Technologies, LLC",
        0x03E0 to "Actions (Zhuhai) Technology Co., Limited",
        0x03E1 to "SPD Development Company Ltd",
        0x03E2 to "Sensoan Oy",
        0x03E3 to "Qualcomm Life Inc",
        0x03E4 to "Chip-ing AG",
        0x03E5 to "ffly4u",
        0x03E6 to "IoT Instruments Oy",
        0x03E7 to "TRUE Fitness Technology",
        0x03E8 to "Reiner Kartengeraete GmbH & Co. KG.",
        0x03E9 to "SHENZHEN LEMONJOY TECHNOLOGY CO., LTD.",
        0x03EA to "Hello Inc.",
        0x03EB to "Evollve Inc.",
        0x03EC to "Jigowatts Inc.",
        0x03ED to "BASIC MICRO.COM,INC.",
        0x03EE to "CUBE TECHNOLOGIES",
        0x03EF to "foolography GmbH",
        0x03F0 to "CLINK",
        0x03F1 to "Hestan Smart Cooking Inc.",
        0x03F2 to "WindowMaster A/S",
        0x03F3 to "Flowscape AB",
        0x03F4 to "PAL Technologies Ltd",
        0x03F5 to "WHERE, Inc.",
        0x03F6 to "Iton Technology Corp.",
        0x03F7 to "Owl Labs Inc.",
        0x03F8 to "Rockford Corp.",
        0x03F9 to "Becon Technologies Co.,Ltd.",
        0x03FA to "Vyassoft Technologies Inc",
        0x03FB to "Nox Medical",
        0x03FC to "Kimberly-Clark",
        0x03FD to "Trimble Navigation Ltd.",
        0x03FE to "Littelfuse",
        0x03FF to "Withings",
        0x0400 to "i-developer IT Beratung UG",
        0x0401 to "",
        0x0402 to "Sears Holdings Corporation",
        0x0403 to "Gantner Electronic GmbH",
        0x0404 to "Authomate Inc",
        0x0405 to "Vertex International, Inc.",
        0x0406 to "Airtago",
        0x0407 to "Swiss Audio SA",
        0x0408 to "ToGetHome Inc.",
        0x0409 to "AXIS",
        0x040A to "Openmatics",
        0x040B to "Jana Care Inc.",
        0x040C to "Senix Corporation",
        0x040D to "NorthStar Battery Company, LLC",
        0x040E to "SKF (U.K.) Limited",
        0x040F to "CO-AX Technology, Inc.",
        0x0410 to "Fender Musical Instruments",
        0x0411 to "Luidia Inc",
        0x0412 to "SEFAM",
        0x0413 to "Wireless Cables Inc",
        0x0414 to "Lightning Protection International Pty Ltd",
        0x0415 to "Uber Technologies Inc",
        0x0416 to "SODA GmbH",
        0x0417 to "Fatigue Science",
        0x0418 to "Alpine Electronics Inc.",
        0x0419 to "Novalogy LTD",
        0x041A to "Friday Labs Limited",
        0x041B to "OrthoAccel Technologies",
        0x041C to "WaterGuru, Inc.",
        0x041D to "Benning Elektrotechnik und Elektronik GmbH & Co. KG",
        0x041E to "Dell Computer Corporation",
        0x041F to "Kopin Corporation",
        0x0420 to "TecBakery GmbH",
        0x0421 to "Backbone Labs, Inc.",
        0x0422 to "DELSEY SA",
        0x0423 to "Chargifi Limited",
        0x0424 to "Trainesense Ltd.",
        0x0425 to "Unify Software and Solutions GmbH & Co. KG",
        0x0426 to "Husqvarna AB",
        0x0427 to "Focus fleet and fuel management inc",
        0x0428 to "SmallLoop, LLC",
        0x0429 to "Prolon Inc.",
        0x042A to "BD Medical",
        0x042B to "iMicroMed Incorporated",
        0x042C to "Ticto N.V.",
        0x042D to "Meshtech AS",
        0x042E to "MemCachier Inc.",
        0x042F to "Danfoss A/S",
        0x0430 to "SnapStyk Inc.",
        0x0431 to "Amyway Corporation",
        0x0432 to "Silk Labs, Inc.",
        0x0433 to "Pillsy Inc.",
        0x0434 to "Hatch Baby, Inc.",
        0x0435 to "Blocks Wearables Ltd.",
        0x0436 to "Drayson Technologies (Europe) Limited",
        0x0437 to "eBest IOT Inc.",
        0x0438 to "Helvar Ltd",
        0x0439 to "Radiance Technologies",
        0x043A to "Nuheara Limited",
        0x043B to "Appside co., ltd.",
        0x043C to "DeLaval",
        0x043D to "Coiler Corporation",
        0x043E to "Thermomedics, Inc.",
        0x043F to "Tentacle Sync GmbH",
        0x0440 to "Valencell, Inc.",
        0x0441 to "iProtoXi Oy",
        0x0442 to "SECOM CO., LTD.",
        0x0443 to "Tucker International LLC",
        0x0444 to "Metanate Limited",
        0x0445 to "Kobian Canada Inc.",
        0x0446 to "NETGEAR, Inc.",
        0x0447 to "Fabtronics Australia Pty Ltd",
        0x0448 to "Grand Centrix GmbH",
        0x0449 to "1UP USA.com llc",
        0x044A to "SHIMANO INC.",
        0x044B to "Nain Inc.",
        0x044C to "LifeStyle Lock, LLC",
        0x044D to "VEGA Grieshaber KG",
        0x044E to "Xtrava Inc.",
        0x044F to "TTS Tooltechnic Systems AG & Co. KG",
        0x0450 to "Teenage Engineering AB",
        0x0451 to "Tunstall Nordic AB",
        0x0452 to "Svep Design Center AB",
        0x0453 to "GreenPeak Technologies BV",
        0x0454 to "Sphinx Electronics GmbH & Co KG",
        0x0455 to "Atomation",
        0x0456 to "Nemik Consulting Inc",
        0x0457 to "RF INNOVATION",
        0x0458 to "Mini Solution Co., Ltd.",
        0x0459 to "Lumenetix, Inc",
        0x045A to "2048450 Ontario Inc",
        0x045B to "SPACEEK LTD",
        0x045C to "Delta T Corporation",
        0x045D to "Boston Scientific Corporation",
        0x045E to "Nuviz, Inc.",
        0x045F to "Real Time Automation, Inc.",
        0x0460 to "Kolibree",
        0x0461 to "vhf elektronik GmbH",
        0x0462 to "Bonsai Systems GmbH",
        0x0463 to "Fathom Systems Inc.",
        0x0464 to "Bellman & Symfon",
        0x0465 to "International Forte Group LLC",
        0x0466 to "CycleLabs Solutions inc.",
        0x0467 to "Codenex Oy",
        0x0468 to "Kynesim Ltd",
        0x0469 to "Palago AB",
        0x046A to "INSIGMA INC.",
        0x046B to "PMD Solutions",
        0x046C to "Qingdao Realtime Technology Co., Ltd.",
        0x046D to "BEGA Gantenbrink-Leuchten KG",
        0x046E to "Pambor Ltd.",
        0xFFFF to "SPECIAL USE/DEFAULT",
    )
}