/**
 * openCloud Android client application
 *
 * @author Abel García de Prada
 * @author Juan Carlos Garrote Gascón
 * @author Jorge Aguado Recio
 *
 * Copyright (C) 2024 ownCloud GmbH.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2,
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package eu.opencloud.android.domain.user

import eu.opencloud.android.domain.user.model.UserAvatar
import eu.opencloud.android.domain.user.model.UserInfo
import eu.opencloud.android.domain.user.model.UserQuota
import kotlinx.coroutines.flow.Flow

interface UserRepository {
    fun getUserInfo(accountName: String): UserInfo
    fun getUserQuota(accountName: String): UserQuota
    fun getStoredUserQuota(accountName: String): UserQuota?
    fun getStoredUserQuotaAsFlow(accountName: String): Flow<UserQuota?>
    fun getAllUserQuotas(): List<UserQuota>
    fun getAllUserQuotasAsFlow(): Flow<List<UserQuota>>
    fun getUserAvatar(accountName: String): UserAvatar
}
