/**
 * openCloud Android client application
 *
 * @author David González Verdugo
 * Copyright (C) 2020 ownCloud GmbH.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2,
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package eu.opencloud.android.data.sharing.sharees.datasources.implementation

import eu.opencloud.android.data.ClientManager
import eu.opencloud.android.data.executeRemoteOperation
import eu.opencloud.android.data.sharing.sharees.datasources.RemoteShareeDataSource
import eu.opencloud.android.data.sharing.sharees.datasources.mapper.RemoteShareeMapper
import eu.opencloud.android.domain.sharing.sharees.model.OCSharee

class OCRemoteShareeDataSource(
    private val clientManager: ClientManager,
    private val shareeMapper: RemoteShareeMapper
) : RemoteShareeDataSource {

    override fun getSharees(
        searchString: String,
        page: Int,
        perPage: Int,
        accountName: String,
    ): List<OCSharee> =
        executeRemoteOperation {
            clientManager.getShareeService(accountName)
                .getSharees(
                    searchString = searchString,
                    page = page,
                    perPage = perPage
                )
        }.let {
            shareeMapper.toModel(it)
        }
}
