/**
 * openCloud Android client application
 *
 * @author Juan Carlos Garrote Gascón
 *
 * Copyright (C) 2022 ownCloud GmbH.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2,
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package eu.opencloud.android.usecases.transfers.uploads

import androidx.work.WorkManager
import eu.opencloud.android.data.providers.LocalStorageProvider
import eu.opencloud.android.domain.BaseUseCase
import eu.opencloud.android.domain.transfers.TransferRepository

class ClearFailedTransfersUseCase(
    private val workManager: WorkManager,
    private val transferRepository: TransferRepository,
    private val localStorageProvider: LocalStorageProvider,
) : BaseUseCase<Unit, Unit>() {
    override fun run(params: Unit) {
        val failedTransfers = transferRepository.getFailedTransfers()
        failedTransfers.forEach { failedTransfer ->
            workManager.cancelAllWorkByTag(failedTransfer.id.toString())
            localStorageProvider.deleteCacheIfNeeded(failedTransfer)
        }
        transferRepository.clearFailedTransfers()
    }
}
