/********************************************************************************************

These sources are distributed in the hope that they will be useful, but WITHOUT ANY WARRANTY;
without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. All
the information given here, within the interface descriptions and within the specification
are subject to change without notice. Errors and omissions excepted.

These sources can be used freely according to the OpenAPC Dual License: As long as the
sources and the resulting applications/libraries/Plug-Ins are used together with the OpenAPC
software, they are licensed as freeware. When you use them outside the OpenAPC software they
are licensed under the terms of the GNU General Public License.

For more information please refer to https://openapc.com/oapc_license.php

*********************************************************************************************/


#include <wx/wx.h>
#include <wx/dcbuffer.h>

#include "oapcGreyMapPanel.h"
#include "oapc_libio.h"

extern wxColour selectedColour;
extern wxSize mainPanelSize;

BEGIN_EVENT_TABLE(oapcGreyMapPanel,wxPanel)
   EVT_PAINT(oapcGreyMapPanel::OnPaint)
END_EVENT_TABLE()


oapcGreyMapPanel::oapcGreyMapPanel(wxWindow *parent,const wxSize size)
        :wxPanel(parent,wxID_ANY,wxDefaultPosition,size,wxBORDER_SIMPLE)
{
   int i;

   for (i=0; i<7; i++) m_greyValue[i]=0;

#if wxCHECK_VERSION(3,0,0)
   SetBackgroundStyle(wxBG_STYLE_PAINT);
#endif
}


oapcGreyMapPanel::~oapcGreyMapPanel()
{

}

void oapcGreyMapPanel::SetGreyValue(const int idx, const double value)
{
   if (idx>7)
   {
      assert(0);
      return;
   }
   m_greyValue[idx]=value;
   Refresh();
}



void oapcGreyMapPanel::OnPaint(wxPaintEvent &WXUNUSED(event))
{
   int    w,h,i,j;
   double segWidth;
   int    greyValue,prevGreyValue=-1,lineWidth;

   wxAutoBufferedPaintDC dc(this);

   GetSize(&w,&h);
   lineWidth=((int)OAPC_ROUND(w/255.0,0)+1);
   segWidth=w/6.0;

   for (i=0; i<6; i++)
   {
      for (j=0; j<segWidth; j++)
      {
         double fac1=(segWidth-j)/segWidth;
         double fac2=1.0-fac1;

         greyValue=(int)OAPC_ROUND((m_greyValue[i]*fac1)+(m_greyValue[i+1]*fac2),0);
         if (greyValue!=prevGreyValue)
         {
            dc.SetPen(wxPen(wxColour(greyValue,greyValue,greyValue)));
            prevGreyValue=greyValue;
         }
         dc.DrawRectangle(i*segWidth+j,0,lineWidth,h);
      }
   }
}
