/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.audio.analysis;

import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.SharedLibraryLoader;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.ShortBuffer;

public class AudioTools {
    public static native void convertToFloat(ShortBuffer var0, FloatBuffer var1, int var2);

    public static native void convertToShort(FloatBuffer var0, ShortBuffer var1, int var2);

    public static native void convertToMonoShort(ShortBuffer var0, ShortBuffer var1, int var2);

    public static native void convertToMonoFloat(FloatBuffer var0, FloatBuffer var1, int var2);

    public static native float spectralFlux(FloatBuffer var0, FloatBuffer var1, int var2);

    public static FloatBuffer allocateFloatBuffer(int numSamples, int numChannels) {
        ByteBuffer b = ByteBuffer.allocateDirect(numSamples * numChannels * 4);
        b.order(ByteOrder.nativeOrder());
        return b.asFloatBuffer();
    }

    public static ShortBuffer allocateShortBuffer(int numSamples, int numChannels) {
        ByteBuffer b = ByteBuffer.allocateDirect(numSamples * numChannels * 2);
        b.order(ByteOrder.nativeOrder());
        return b.asShortBuffer();
    }

    public static void toShort(byte[] src, int offsetSrc, short[] dst, int offsetDst, int numBytes) {
        if (numBytes % 2 != 0) {
            throw new GdxRuntimeException("bytes must be even (2 bytes 16-bit PCM expected)");
        }
        int i = offsetSrc;
        int ii = offsetDst;
        while (i < numBytes) {
            int b1 = src[i++] & 0xFF;
            int b2 = src[i++] & 0xFF;
            dst[ii++] = (short)(b1 | b2 << 8);
        }
    }

    public static void toFloat(byte[] src, int offsetSrc, float[] dst, int offsetDst, int numBytes) {
        if (numBytes % 2 != 0) {
            throw new GdxRuntimeException("bytes must be even (2 bytes 16-bit PCM expected)");
        }
        float scale = 3.051851E-5f;
        int i = offsetSrc;
        int ii = offsetDst;
        while (i < numBytes) {
            int b1 = src[i++] & 0xFF;
            int b2 = src[i++] & 0xFF;
            dst[ii++] = (float)((short)(b1 | b2 << 8)) * scale;
        }
    }

    public static void toFloat(short[] src, int offsetSrc, float[] dst, int offsetDst, int numBytes) {
        float scale = 3.051851E-5f;
        int i = offsetSrc;
        int ii = offsetDst;
        while (i < numBytes) {
            dst[i] = (float)src[ii] * scale;
            ++i;
            ++ii;
        }
    }

    public static short[] generate(int samplingRate, int frequency, int numSamples) {
        short[] samples = new short[numSamples];
        float increment = (float)Math.PI * 2 * (float)frequency / (float)samplingRate;
        float angle = 0.0f;
        for (int i = 0; i < numSamples; ++i) {
            samples[i] = (short)(Math.sin(angle) * 32767.0);
            angle += increment;
        }
        return samples;
    }

    public static short[] generate(int samplingRate, int frequency, float length) {
        int numSamples = (int)((float)samplingRate * length);
        return AudioTools.generate(samplingRate, frequency, numSamples);
    }

    public static float[] generateFloat(int samplingRate, int frequency, int numSamples) {
        float[] samples = new float[numSamples];
        float increment = (float)Math.PI * 2 * (float)frequency / (float)samplingRate;
        float angle = 0.0f;
        for (int i = 0; i < numSamples; ++i) {
            samples[i] = (float)Math.sin(angle);
            angle += increment;
        }
        return samples;
    }

    public static float[] generateFloat(int samplingRate, int frequency, float length) {
        int numSamples = (int)((float)samplingRate * length);
        return AudioTools.generateFloat(samplingRate, frequency, numSamples);
    }

    static {
        new SharedLibraryLoader().load("gdx-audio");
    }
}

