/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.audio;

import com.badlogic.gdx.math.MathUtils;

public class CircularBuffer {
    private final short[] buffer;
    private int writePosition;
    private int readPosition;
    private int available;

    public CircularBuffer(int size) {
        this.buffer = new short[size];
    }

    public void write(short[] data, int offset, int count) {
        int copy = 0;
        if (this.writePosition > this.readPosition || this.available == 0) {
            copy = Math.min(this.buffer.length - this.writePosition, count);
            System.arraycopy(data, offset, this.buffer, this.writePosition, copy);
            this.writePosition = (this.writePosition + copy) % this.buffer.length;
            this.available += copy;
            if ((count -= copy) == 0) {
                return;
            }
        }
        copy = Math.min(this.readPosition - this.writePosition, count);
        System.arraycopy(data, offset, this.buffer, this.writePosition, copy);
        this.writePosition += copy;
        this.available += copy;
    }

    public void combine(short[] data, int offset, int count) {
        int copy = 0;
        if (this.writePosition > this.readPosition || this.available == 0) {
            copy = Math.min(this.buffer.length - this.writePosition, count);
            CircularBuffer.combine(data, offset, this.buffer, this.writePosition, copy);
            this.writePosition = (this.writePosition + copy) % this.buffer.length;
            this.available += copy;
            if ((count -= copy) == 0) {
                return;
            }
        }
        copy = Math.min(this.readPosition - this.writePosition, count);
        CircularBuffer.combine(data, offset, this.buffer, this.writePosition, copy);
        this.writePosition += copy;
        this.available += copy;
    }

    public int read(short[] data, int offset, int count) {
        if (this.available == 0) {
            return 0;
        }
        int total = count = Math.min(this.available, count);
        int copy = Math.min(this.buffer.length - this.readPosition, total);
        System.arraycopy(this.buffer, this.readPosition, data, offset, copy);
        this.readPosition = (this.readPosition + copy) % this.buffer.length;
        this.available -= copy;
        if ((count -= copy) > 0 && this.available > 0) {
            copy = Math.min(this.buffer.length - this.available, count);
            System.arraycopy(this.buffer, this.readPosition, data, offset, copy);
            this.readPosition = (this.readPosition + copy) % this.buffer.length;
            this.available -= copy;
        }
        return total;
    }

    public void clear() {
        int n = this.buffer.length;
        for (int i = 0; i < n; ++i) {
            this.buffer[i] = 0;
        }
        this.readPosition = 0;
        this.writePosition = 0;
        this.available = 0;
    }

    public void setWritePosition(int writePosition) {
        this.writePosition = Math.abs(writePosition) % this.buffer.length;
    }

    public int getWritePosition() {
        return this.writePosition;
    }

    public void setReadPosition(int readPosition) {
        this.readPosition = Math.abs(readPosition) % this.buffer.length;
    }

    public int getReadPosition() {
        return this.readPosition;
    }

    private void dump() {
        int n = this.buffer.length;
        for (int i = 0; i < n; ++i) {
            System.out.println(this.buffer[i] + (i == this.writePosition ? " <- write" : "") + (i == this.readPosition ? " <- read" : ""));
        }
        System.out.println();
    }

    private static void combine(short[] src, int srcPos, short[] dest, int destPos, int length) {
        for (int i = 0; i < length; ++i) {
            int destIndex = destPos + i;
            short a = src[srcPos + i];
            short b = dest[destIndex];
            dest[destIndex] = MathUtils.clamp((short)((short)(a + b - a * b / Short.MAX_VALUE)), (short)0, (short)Short.MAX_VALUE);
        }
    }

    public static void main(String[] args) throws Exception {
        CircularBuffer buffer = new CircularBuffer(5);
        short[] write = new short[]{1, 2, 3, 4, 5, 6, 7};
        short[] read = new short[3];
        buffer.write(write, 0, write.length);
        buffer.dump();
        System.out.println(buffer.read(read, 0, read.length) + " read\n");
        buffer.dump();
    }
}

