/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.tablelayout;

import com.esotericsoftware.tablelayout.Cell;
import com.esotericsoftware.tablelayout.TableLayoutParser;
import com.esotericsoftware.tablelayout.Toolkit;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class BaseTableLayout<C, T extends C, L extends BaseTableLayout, K extends Toolkit<C, T, L>> {
    public static final int CENTER = 1;
    public static final int TOP = 2;
    public static final int BOTTOM = 4;
    public static final int LEFT = 8;
    public static final int RIGHT = 16;
    public static final int SCALE_FIT = 2;
    public static final int SCALE_FILL = 4;
    public static final int SCALE_STRETCH = 8;
    public static final String MIN = "min";
    public static final String PREF = "pref";
    public static final String MAX = "max";
    public static final int DEBUG_NONE = 0;
    public static final int DEBUG_ALL = 1;
    public static final int DEBUG_TABLE = 2;
    public static final int DEBUG_CELL = 4;
    public static final int DEBUG_WIDGET = 8;
    K toolkit;
    T table;
    HashMap<String, C> nameToWidget = new HashMap(8);
    HashMap<C, Cell> widgetToCell = new HashMap(8);
    private int columns;
    private int rows;
    private final ArrayList<Cell> cells = new ArrayList(4);
    private final Cell cellDefaults = Cell.defaults(this);
    private final ArrayList<Cell> columnDefaults = new ArrayList(2);
    private Cell rowDefaults;
    private int layoutX;
    private int layoutY;
    private int layoutWidth;
    private int layoutHeight;
    private boolean sizeInvalid = true;
    private int[] columnMinWidth;
    private int[] rowMinHeight;
    private int[] columnPrefWidth;
    private int[] rowPrefHeight;
    private int tableMinWidth;
    private int tableMinHeight;
    private int tablePrefWidth;
    private int tablePrefHeight;
    private int[] columnWidth;
    private int[] rowHeight;
    private float[] expandWidth;
    private float[] expandHeight;
    private int[] columnWeightedWidth;
    private int[] rowWeightedHeight;
    String width;
    String height;
    String padTop;
    String padLeft;
    String padBottom;
    String padRight;
    int align = 1;
    int debug = 0;

    public BaseTableLayout(K toolkit) {
        this.toolkit = toolkit;
    }

    public void invalidate() {
        this.sizeInvalid = true;
    }

    public abstract void invalidateHierarchy();

    public void setLayoutSize(int tableLayoutX, int tableLayoutY, int tableLayoutWidth, int tableLayoutHeight) {
        this.layoutX = tableLayoutX;
        this.layoutY = tableLayoutY;
        this.layoutWidth = tableLayoutWidth;
        this.layoutHeight = tableLayoutHeight;
    }

    public C register(String name, C widget) {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null.");
        }
        if (this.nameToWidget.containsKey(name = name.toLowerCase().trim())) {
            throw new IllegalArgumentException("Name is already used: " + name);
        }
        this.nameToWidget.put(name, widget);
        return widget;
    }

    public void parse(String tableDescription) {
        TableLayoutParser.parse(this, tableDescription);
    }

    public Cell<C> add(C widget) {
        widget = ((Toolkit)this.toolkit).wrap((BaseTableLayout)this, widget);
        Cell cell = new Cell(this);
        cell.widget = widget;
        this.widgetToCell.put(widget, cell);
        for (Map.Entry<String, C> entry : this.nameToWidget.entrySet()) {
            if (widget != entry.getValue()) continue;
            cell.name = entry.getKey();
            break;
        }
        if (this.cells.size() > 0) {
            Cell lastCell = this.cells.get(this.cells.size() - 1);
            if (!lastCell.endRow) {
                cell.column = lastCell.column + lastCell.colspan;
                cell.row = lastCell.row;
            } else {
                cell.row = lastCell.row + 1;
            }
            if (cell.row > 0) {
                block1: for (int i = this.cells.size() - 1; i >= 0; --i) {
                    int column;
                    Cell other = this.cells.get(i);
                    int nn = column + other.colspan;
                    for (column = other.column; column < nn; ++column) {
                        if (other.column != cell.column) continue;
                        cell.cellAboveIndex = i;
                        break block1;
                    }
                }
            }
        }
        this.cells.add(cell);
        if (cell.column < this.columnDefaults.size()) {
            Cell columnDefaults = this.columnDefaults.get(cell.column);
            cell.set(columnDefaults != null ? columnDefaults : this.cellDefaults);
        } else {
            cell.set(this.cellDefaults);
        }
        cell.merge(this.rowDefaults);
        ((Toolkit)this.toolkit).addChild(this.table, widget, null);
        return cell;
    }

    public Cell<C> stack(C ... widgets) {
        Object stack = ((Toolkit)this.toolkit).newStack();
        int n = widgets.length;
        for (int i = 0; i < n; ++i) {
            ((Toolkit)this.toolkit).addChild(stack, widgets[i], null);
        }
        return this.add(stack);
    }

    public Cell row() {
        if (this.cells.size() > 0) {
            this.endRow();
        }
        this.rowDefaults = new Cell(this);
        return this.rowDefaults;
    }

    private void endRow() {
        int rowColumns = 0;
        for (int i = this.cells.size() - 1; i >= 0; --i) {
            Cell cell = this.cells.get(i);
            if (cell.endRow) break;
            rowColumns += cell.colspan.intValue();
        }
        this.columns = Math.max(this.columns, rowColumns);
        ++this.rows;
        this.cells.get((int)(this.cells.size() - 1)).endRow = true;
        this.invalidate();
    }

    public Cell columnDefaults(int column) {
        Cell cell;
        Cell cell2 = cell = this.columnDefaults.size() > column ? this.columnDefaults.get(column) : null;
        if (cell == null) {
            cell = new Cell(this);
            cell.set(this.cellDefaults);
            if (column >= this.columnDefaults.size()) {
                for (int i = this.columnDefaults.size(); i < column; ++i) {
                    this.columnDefaults.add(null);
                }
                this.columnDefaults.add(cell);
            } else {
                this.columnDefaults.set(column, cell);
            }
        }
        return cell;
    }

    public void reset() {
        this.clear();
        this.padTop = null;
        this.padLeft = null;
        this.padBottom = null;
        this.padRight = null;
        this.align = 1;
        if (this.debug != 0) {
            ((Toolkit)this.toolkit).clearDebugRectangles((BaseTableLayout)this);
        }
        this.debug = 0;
        this.cellDefaults.set(Cell.defaults(this));
        this.columnDefaults.clear();
        this.rowDefaults = null;
    }

    public void clear() {
        for (int i = this.cells.size() - 1; i >= 0; --i) {
            ((Toolkit)this.toolkit).removeChild(this.table, this.cells.get((int)i).widget);
        }
        this.cells.clear();
        this.nameToWidget.clear();
        this.widgetToCell.clear();
        this.rows = 0;
        this.columns = 0;
        this.invalidate();
    }

    public C getWidget(String name) {
        return this.nameToWidget.get(name.toLowerCase());
    }

    public List<C> getWidgets() {
        return new ArrayList<C>(this.nameToWidget.values());
    }

    public List<C> getWidgets(String namePrefix) {
        ArrayList<C> widgets = new ArrayList<C>();
        for (Map.Entry<String, C> entry : this.nameToWidget.entrySet()) {
            if (!entry.getKey().startsWith(namePrefix)) continue;
            widgets.add(entry.getValue());
        }
        return widgets;
    }

    public Cell getCell(C widget) {
        return this.widgetToCell.get(widget);
    }

    public Cell getCell(String name) {
        return this.getCell(this.getWidget(name));
    }

    public List<Cell> getAllCells() {
        return new ArrayList<Cell>(this.widgetToCell.values());
    }

    public List<Cell> getAllCells(String namePrefix) {
        ArrayList<Cell> cells = new ArrayList<Cell>();
        for (Cell cell : this.widgetToCell.values()) {
            if (!cell.name.startsWith(namePrefix)) continue;
            cells.add(cell);
        }
        return cells;
    }

    public List<Cell> getCells() {
        return this.cells;
    }

    public void setWidget(String name, C widget) {
        this.getCell(name).setWidget(widget);
    }

    public void setParent(BaseTableLayout parent) {
        this.nameToWidget = parent.nameToWidget;
        this.widgetToCell = parent.widgetToCell;
    }

    public void setToolkit(K toolkit) {
        this.toolkit = toolkit;
    }

    public T getTable() {
        return this.table;
    }

    public void setTable(T table) {
        this.table = table;
    }

    public int getLayoutX() {
        return this.layoutX;
    }

    public int getLayoutY() {
        return this.layoutY;
    }

    public int getLayoutWidth() {
        return this.layoutWidth;
    }

    public int getLayoutHeight() {
        return this.layoutHeight;
    }

    public int getMinWidth() {
        if (this.sizeInvalid) {
            this.computeSize();
        }
        return this.tableMinWidth;
    }

    public int getMinHeight() {
        if (this.sizeInvalid) {
            this.computeSize();
        }
        return this.tableMinHeight;
    }

    public int getPrefWidth() {
        if (this.sizeInvalid) {
            this.computeSize();
        }
        return this.tablePrefWidth;
    }

    public int getPrefHeight() {
        if (this.sizeInvalid) {
            this.computeSize();
        }
        return this.tablePrefHeight;
    }

    public Cell defaults() {
        return this.cellDefaults;
    }

    public K getToolkit() {
        return this.toolkit;
    }

    public L size(String width, String height) {
        this.width = width;
        this.height = height;
        this.sizeInvalid = true;
        return (L)this;
    }

    public L width(String width) {
        this.width = width;
        this.sizeInvalid = true;
        return (L)this;
    }

    public L height(String height) {
        this.height = height;
        this.sizeInvalid = true;
        return (L)this;
    }

    public L size(int width, int height) {
        this.width = String.valueOf(width);
        this.height = String.valueOf(height);
        this.sizeInvalid = true;
        return (L)this;
    }

    public L width(int width) {
        this.width = String.valueOf(width);
        this.sizeInvalid = true;
        return (L)this;
    }

    public L height(int height) {
        this.height = String.valueOf(height);
        this.sizeInvalid = true;
        return (L)this;
    }

    public L pad(String pad) {
        this.padTop = pad;
        this.padLeft = pad;
        this.padBottom = pad;
        this.padRight = pad;
        this.sizeInvalid = true;
        return (L)this;
    }

    public L pad(String top, String left, String bottom, String right) {
        this.padTop = top;
        this.padLeft = left;
        this.padBottom = bottom;
        this.padRight = right;
        this.sizeInvalid = true;
        return (L)this;
    }

    public L padTop(String padTop) {
        this.padTop = padTop;
        this.sizeInvalid = true;
        return (L)this;
    }

    public L padLeft(String padLeft) {
        this.padLeft = padLeft;
        this.sizeInvalid = true;
        return (L)this;
    }

    public L padBottom(String padBottom) {
        this.padBottom = padBottom;
        this.sizeInvalid = true;
        return (L)this;
    }

    public L padRight(String padRight) {
        this.padRight = padRight;
        this.sizeInvalid = true;
        return (L)this;
    }

    public L pad(int pad) {
        this.padTop = String.valueOf(pad);
        this.padLeft = String.valueOf(pad);
        this.padBottom = String.valueOf(pad);
        this.padRight = String.valueOf(pad);
        this.sizeInvalid = true;
        return (L)this;
    }

    public L pad(int top, int left, int bottom, int right) {
        this.padTop = String.valueOf(top);
        this.padLeft = String.valueOf(left);
        this.padBottom = String.valueOf(bottom);
        this.padRight = String.valueOf(right);
        this.sizeInvalid = true;
        return (L)this;
    }

    public L padTop(int padTop) {
        this.padTop = String.valueOf(padTop);
        this.sizeInvalid = true;
        return (L)this;
    }

    public L padLeft(int padLeft) {
        this.padLeft = String.valueOf(padLeft);
        this.sizeInvalid = true;
        return (L)this;
    }

    public L padBottom(int padBottom) {
        this.padBottom = String.valueOf(padBottom);
        this.sizeInvalid = true;
        return (L)this;
    }

    public L padRight(int padRight) {
        this.padRight = String.valueOf(padRight);
        this.sizeInvalid = true;
        return (L)this;
    }

    public L align(int align) {
        this.align = align;
        return (L)this;
    }

    public L align(String value) {
        this.align = 0;
        if (value.contains("center")) {
            this.align |= 1;
        }
        if (value.contains("left")) {
            this.align |= 8;
        }
        if (value.contains("right")) {
            this.align |= 0x10;
        }
        if (value.contains("top")) {
            this.align |= 2;
        }
        if (value.contains("bottom")) {
            this.align |= 4;
        }
        return (L)this;
    }

    public L center() {
        this.align |= 1;
        return (L)this;
    }

    public L top() {
        this.align |= 2;
        this.align &= 0xFFFFFFFB;
        return (L)this;
    }

    public L left() {
        this.align |= 8;
        this.align &= 0xFFFFFFEF;
        return (L)this;
    }

    public L bottom() {
        this.align |= 4;
        this.align &= 0xFFFFFFFD;
        return (L)this;
    }

    public L right() {
        this.align |= 0x10;
        this.align &= 0xFFFFFFF7;
        return (L)this;
    }

    public L debug() {
        this.debug = 1;
        this.invalidate();
        return (L)this;
    }

    public L debug(int debug) {
        this.debug = debug;
        if (debug == 0) {
            ((Toolkit)this.toolkit).clearDebugRectangles((BaseTableLayout)this);
        } else {
            this.invalidate();
        }
        return (L)this;
    }

    public L debug(String value) {
        this.debug = 0;
        if (value == null) {
            return (L)this;
        }
        if (value.equalsIgnoreCase("true")) {
            this.debug |= 1;
        }
        if (value.contains("all")) {
            this.debug |= 1;
        }
        if (value.contains("cell")) {
            this.debug |= 4;
        }
        if (value.contains("table")) {
            this.debug |= 2;
        }
        if (value.contains("widget")) {
            this.debug |= 8;
        }
        if (this.debug == 0) {
            ((Toolkit)this.toolkit).clearDebugRectangles((BaseTableLayout)this);
        } else {
            this.invalidate();
        }
        return (L)this;
    }

    public int getDebug() {
        return this.debug;
    }

    public String getWidth() {
        return this.width;
    }

    public String getHeight() {
        return this.height;
    }

    public String getPadTop() {
        return this.padTop;
    }

    public String getPadLeft() {
        return this.padLeft;
    }

    public String getPadBottom() {
        return this.padBottom;
    }

    public String getPadRight() {
        return this.padRight;
    }

    public int getAlign() {
        return this.align;
    }

    public int getRow(float y) {
        int i;
        int row = 0;
        y += (float)((Toolkit)this.toolkit).height((BaseTableLayout)this, this.padTop);
        int n = this.cells.size();
        if (n == 0) {
            return -1;
        }
        for (i = 0; i < n && !this.cells.get(i).isEndRow(); ++i) {
        }
        while (i < n) {
            Cell c;
            if ((c = this.cells.get(i++)).getIgnore()) continue;
            if ((float)(c.widgetY + c.computedPadTop) > y) break;
            if (!c.endRow) continue;
            ++row;
        }
        return this.rows - row;
    }

    private int[] ensureSize(int[] array, int size) {
        if (array == null || array.length < size) {
            return new int[size];
        }
        int n = array.length;
        for (int i = 0; i < n; ++i) {
            array[i] = 0;
        }
        return array;
    }

    private float[] ensureSize(float[] array, int size) {
        if (array == null || array.length < size) {
            return new float[size];
        }
        int n = array.length;
        for (int i = 0; i < n; ++i) {
            array[i] = 0.0f;
        }
        return array;
    }

    private void computeSize() {
        int prefWidth;
        Cell c;
        int i;
        this.sizeInvalid = false;
        K toolkit = this.toolkit;
        ArrayList<Cell> cells = this.cells;
        if (cells.size() > 0 && !cells.get((int)(cells.size() - 1)).endRow) {
            this.endRow();
        }
        this.columnMinWidth = this.ensureSize(this.columnMinWidth, this.columns);
        this.rowMinHeight = this.ensureSize(this.rowMinHeight, this.rows);
        this.columnPrefWidth = this.ensureSize(this.columnPrefWidth, this.columns);
        this.rowPrefHeight = this.ensureSize(this.rowPrefHeight, this.rows);
        this.columnWidth = this.ensureSize(this.columnWidth, this.columns);
        this.rowHeight = this.ensureSize(this.rowHeight, this.rows);
        this.expandWidth = this.ensureSize(this.expandWidth, this.columns);
        this.expandHeight = this.ensureSize(this.expandHeight, this.rows);
        int spaceRightLast = 0;
        int n = cells.size();
        for (i = 0; i < n; ++i) {
            c = cells.get(i);
            if (c.ignore.booleanValue()) continue;
            if (c.expandY != 0 && this.expandHeight[c.row] == 0.0f) {
                this.expandHeight[c.row] = c.expandY.intValue();
            }
            if (c.colspan == 1 && c.expandX != 0 && this.expandWidth[c.column] == 0.0f) {
                this.expandWidth[c.column] = c.expandX.intValue();
            }
            c.computedPadLeft = c.column == 0 ? ((Toolkit)toolkit).width((BaseTableLayout)this, c.padLeft) : ((Toolkit)toolkit).width((BaseTableLayout)this, c.padLeft) + Math.max(0, ((Toolkit)toolkit).width((BaseTableLayout)this, c.spaceLeft) - spaceRightLast);
            c.computedPadTop = c.cellAboveIndex == -1 ? ((Toolkit)toolkit).height((BaseTableLayout)this, c.padTop) : ((Toolkit)toolkit).height((BaseTableLayout)this, c.padTop) + Math.max(0, ((Toolkit)toolkit).height((BaseTableLayout)this, c.spaceTop) - ((Toolkit)toolkit).height((BaseTableLayout)this, cells.get((int)c.cellAboveIndex).spaceBottom));
            int spaceRight = ((Toolkit)toolkit).width((BaseTableLayout)this, c.spaceRight);
            c.computedPadRight = c.column + c.colspan == this.columns ? ((Toolkit)toolkit).width((BaseTableLayout)this, c.padRight) : ((Toolkit)toolkit).width((BaseTableLayout)this, c.padRight) + spaceRight;
            c.computedPadBottom = c.row == this.rows - 1 ? ((Toolkit)toolkit).height((BaseTableLayout)this, c.padBottom) : ((Toolkit)toolkit).height((BaseTableLayout)this, c.padBottom) + ((Toolkit)toolkit).height((BaseTableLayout)this, c.spaceBottom);
            spaceRightLast = spaceRight;
            prefWidth = ((Toolkit)toolkit).getWidgetWidth((BaseTableLayout)this, c.widget, c.prefWidth);
            int prefHeight = ((Toolkit)toolkit).getWidgetHeight((BaseTableLayout)this, c.widget, c.prefHeight);
            int minWidth = ((Toolkit)toolkit).getWidgetWidth((BaseTableLayout)this, c.widget, c.minWidth);
            int minHeight = ((Toolkit)toolkit).getWidgetHeight((BaseTableLayout)this, c.widget, c.minHeight);
            int maxWidth = ((Toolkit)toolkit).getWidgetWidth((BaseTableLayout)this, c.widget, c.maxWidth);
            int maxHeight = ((Toolkit)toolkit).getWidgetHeight((BaseTableLayout)this, c.widget, c.maxHeight);
            if (prefWidth < minWidth) {
                prefWidth = minWidth;
            }
            if (prefHeight < minHeight) {
                prefHeight = minHeight;
            }
            if (maxWidth > 0 && prefWidth > maxWidth) {
                prefWidth = maxWidth;
            }
            if (maxHeight > 0 && prefHeight > maxHeight) {
                prefHeight = maxHeight;
            }
            if (c.colspan == 1) {
                int hpadding = c.computedPadLeft + c.computedPadRight;
                this.columnPrefWidth[c.column] = Math.max(this.columnPrefWidth[c.column], prefWidth + hpadding);
                this.columnMinWidth[c.column] = Math.max(this.columnMinWidth[c.column], minWidth + hpadding);
            }
            int vpadding = c.computedPadTop + c.computedPadBottom;
            this.rowPrefHeight[c.row] = Math.max(this.rowPrefHeight[c.row], prefHeight + vpadding);
            this.rowMinHeight[c.row] = Math.max(this.rowMinHeight[c.row], minHeight + vpadding);
        }
        n = cells.size();
        block1: for (i = 0; i < n; ++i) {
            int column;
            c = cells.get(i);
            if (c.ignore.booleanValue() || c.expandX == 0) continue;
            int nn = column + c.colspan;
            for (column = c.column; column < nn; ++column) {
                if (this.expandWidth[column] != 0.0f) continue block1;
            }
            nn = column + c.colspan;
            for (column = c.column; column < nn; ++column) {
                this.expandWidth[column] = c.expandX.intValue();
            }
        }
        n = cells.size();
        for (i = 0; i < n; ++i) {
            int column;
            int column2;
            c = cells.get(i);
            if (c.ignore.booleanValue() || c.colspan == 1) continue;
            int minWidth = ((Toolkit)toolkit).getWidgetWidth((BaseTableLayout)this, c.widget, c.minWidth);
            prefWidth = ((Toolkit)toolkit).getWidgetWidth((BaseTableLayout)this, c.widget, c.prefWidth);
            int maxWidth = ((Toolkit)toolkit).getWidgetWidth((BaseTableLayout)this, c.widget, c.maxWidth);
            if (prefWidth < minWidth) {
                prefWidth = minWidth;
            }
            if (maxWidth > 0 && prefWidth > maxWidth) {
                prefWidth = maxWidth;
            }
            int spannedMinWidth = 0;
            int spannedPrefWidth = 0;
            int nn = column2 + c.colspan;
            for (column2 = c.column; column2 < nn; ++column2) {
                spannedMinWidth += this.columnMinWidth[column2];
                spannedPrefWidth += this.columnPrefWidth[column2];
            }
            float totalExpandWidth = 0.0f;
            int nn2 = column + c.colspan;
            for (column = c.column; column < nn2; ++column) {
                totalExpandWidth += this.expandWidth[column];
            }
            int extraMinWidth = Math.max(0, minWidth - spannedMinWidth);
            int extraPrefWidth = Math.max(0, prefWidth - spannedPrefWidth);
            int column3 = c.column;
            int nn3 = column3 + c.colspan;
            while (column3 < nn3) {
                float ratio = totalExpandWidth == 0.0f ? 1.0f / (float)c.colspan.intValue() : this.expandWidth[column3] / totalExpandWidth;
                int n2 = column3;
                this.columnMinWidth[n2] = (int)((float)this.columnMinWidth[n2] + (float)extraMinWidth * ratio);
                int n3 = column3++;
                this.columnPrefWidth[n3] = (int)((float)this.columnPrefWidth[n3] + (float)extraPrefWidth * ratio);
            }
        }
        this.tableMinWidth = 0;
        this.tableMinHeight = 0;
        this.tablePrefWidth = 0;
        this.tablePrefHeight = 0;
        for (i = 0; i < this.columns; ++i) {
            this.tableMinWidth += this.columnMinWidth[i];
            this.tablePrefWidth += this.columnPrefWidth[i];
        }
        for (i = 0; i < this.rows; ++i) {
            this.tableMinHeight += this.rowMinHeight[i];
            this.tablePrefHeight += Math.max(this.rowMinHeight[i], this.rowPrefHeight[i]);
        }
        int hpadding = ((Toolkit)toolkit).width((BaseTableLayout)this, this.padLeft) + ((Toolkit)toolkit).width((BaseTableLayout)this, this.padRight);
        int vpadding = ((Toolkit)toolkit).height((BaseTableLayout)this, this.padTop) + ((Toolkit)toolkit).height((BaseTableLayout)this, this.padBottom);
        int width = ((Toolkit)toolkit).width((BaseTableLayout)this, this.width);
        int height = ((Toolkit)toolkit).height((BaseTableLayout)this, this.height);
        this.tableMinWidth = Math.max(this.tableMinWidth + hpadding, width);
        this.tableMinHeight = Math.max(this.tableMinHeight + vpadding, height);
        this.tablePrefWidth = Math.max(this.tablePrefWidth + hpadding, this.tableMinWidth);
        this.tablePrefHeight = Math.max(this.tablePrefHeight + vpadding, this.tableMinHeight);
    }

    public void layout() {
        int nn;
        int spannedCellWidth;
        Cell c;
        int i;
        int amount;
        int i2;
        int used;
        int i3;
        int extra;
        int i4;
        int[] rowWeightedHeight;
        int[] columnWeightedWidth;
        int i5;
        K toolkit = this.toolkit;
        ArrayList<Cell> cells = this.cells;
        if (this.sizeInvalid) {
            this.computeSize();
        }
        int hpadding = ((Toolkit)toolkit).width((BaseTableLayout)this, this.padLeft) + ((Toolkit)toolkit).width((BaseTableLayout)this, this.padRight);
        int vpadding = ((Toolkit)toolkit).height((BaseTableLayout)this, this.padTop) + ((Toolkit)toolkit).height((BaseTableLayout)this, this.padBottom);
        int totalMinWidth = 0;
        int totalMinHeight = 0;
        float totalExpandWidth = 0.0f;
        float totalExpandHeight = 0.0f;
        for (i5 = 0; i5 < this.columns; ++i5) {
            totalMinWidth += this.columnMinWidth[i5];
            totalExpandWidth += this.expandWidth[i5];
        }
        for (i5 = 0; i5 < this.rows; ++i5) {
            totalMinHeight += this.rowMinHeight[i5];
            totalExpandHeight += this.expandHeight[i5];
        }
        int totalGrowWidth = this.tablePrefWidth - totalMinWidth;
        if (totalGrowWidth == 0) {
            columnWeightedWidth = this.columnMinWidth;
        } else {
            int extraWidth = Math.min(totalGrowWidth, Math.max(0, this.layoutWidth - totalMinWidth));
            this.columnWeightedWidth = this.ensureSize(this.columnWeightedWidth, this.columns);
            columnWeightedWidth = this.columnWeightedWidth;
            for (int i6 = 0; i6 < this.columns; ++i6) {
                int growWidth = this.columnPrefWidth[i6] - this.columnMinWidth[i6];
                float growRatio = (float)growWidth / (float)totalGrowWidth;
                columnWeightedWidth[i6] = this.columnMinWidth[i6] + (int)((float)extraWidth * growRatio);
            }
        }
        int totalGrowHeight = this.tablePrefHeight - totalMinHeight;
        if (totalGrowHeight == 0) {
            rowWeightedHeight = this.rowMinHeight;
        } else {
            this.rowWeightedHeight = this.ensureSize(this.rowWeightedHeight, this.rows);
            rowWeightedHeight = this.rowWeightedHeight;
            int extraHeight = Math.min(totalGrowHeight, Math.max(0, this.layoutHeight - totalMinHeight));
            for (int i7 = 0; i7 < this.rows; ++i7) {
                int growHeight = this.rowPrefHeight[i7] - this.rowMinHeight[i7];
                float growRatio = (float)growHeight / (float)totalGrowHeight;
                rowWeightedHeight[i7] = this.rowMinHeight[i7] + (int)((float)extraHeight * growRatio);
            }
        }
        int n = cells.size();
        for (int i8 = 0; i8 < n; ++i8) {
            int column;
            Cell c2 = cells.get(i8);
            if (c2.ignore.booleanValue()) continue;
            int spannedWeightedWidth = 0;
            int nn2 = column + c2.colspan;
            for (column = c2.column; column < nn2; ++column) {
                spannedWeightedWidth += columnWeightedWidth[column];
            }
            int weightedHeight = rowWeightedHeight[c2.row];
            int prefWidth = ((Toolkit)toolkit).getWidgetWidth((BaseTableLayout)this, c2.widget, c2.prefWidth);
            int prefHeight = ((Toolkit)toolkit).getWidgetHeight((BaseTableLayout)this, c2.widget, c2.prefHeight);
            int minWidth = ((Toolkit)toolkit).getWidgetWidth((BaseTableLayout)this, c2.widget, c2.minWidth);
            int minHeight = ((Toolkit)toolkit).getWidgetHeight((BaseTableLayout)this, c2.widget, c2.minHeight);
            int maxWidth = ((Toolkit)toolkit).getWidgetWidth((BaseTableLayout)this, c2.widget, c2.maxWidth);
            int maxHeight = ((Toolkit)toolkit).getWidgetHeight((BaseTableLayout)this, c2.widget, c2.maxHeight);
            if (prefWidth < minWidth) {
                prefWidth = minWidth;
            }
            if (prefHeight < minHeight) {
                prefHeight = minHeight;
            }
            if (maxWidth > 0 && prefWidth > maxWidth) {
                prefWidth = maxWidth;
            }
            if (maxHeight > 0 && prefHeight > maxHeight) {
                prefHeight = maxHeight;
            }
            c2.widgetWidth = Math.min(spannedWeightedWidth - c2.computedPadLeft - c2.computedPadRight, prefWidth);
            c2.widgetHeight = Math.min(weightedHeight - c2.computedPadTop - c2.computedPadBottom, prefHeight);
            if (c2.colspan == 1) {
                this.columnWidth[c2.column] = Math.max(this.columnWidth[c2.column], spannedWeightedWidth);
            }
            this.rowHeight[c2.row] = Math.max(this.rowHeight[c2.row], weightedHeight);
        }
        int uniformMaxWidth = 0;
        int uniformMaxHeight = 0;
        int n2 = cells.size();
        for (i4 = 0; i4 < n2; ++i4) {
            Cell c3 = cells.get(i4);
            if (c3.ignore.booleanValue()) continue;
            if (c3.uniformX != null) {
                uniformMaxWidth = Math.max(uniformMaxWidth, this.columnWidth[c3.column] - c3.computedPadLeft - c3.computedPadRight);
            }
            if (c3.uniformY == null) continue;
            uniformMaxHeight = Math.max(uniformMaxHeight, this.rowHeight[c3.row] - c3.computedPadTop - c3.computedPadBottom);
        }
        if (uniformMaxWidth > 0 || uniformMaxHeight > 0) {
            n2 = cells.size();
            for (i4 = 0; i4 < n2; ++i4) {
                int tempPadding;
                int diff;
                Cell c4 = cells.get(i4);
                if (c4.ignore.booleanValue()) continue;
                if (uniformMaxWidth > 0 && c4.uniformX != null && (diff = uniformMaxWidth - (this.columnWidth[c4.column] - (tempPadding = c4.computedPadLeft + c4.computedPadRight))) > 0) {
                    this.columnWidth[c4.column] = uniformMaxWidth + tempPadding;
                    this.tableMinWidth += diff;
                    this.tablePrefWidth += diff;
                }
                if (uniformMaxHeight <= 0 || c4.uniformY == null || (diff = uniformMaxHeight - (this.rowHeight[c4.row] - (tempPadding = c4.computedPadTop + c4.computedPadBottom))) <= 0) continue;
                this.rowHeight[c4.row] = uniformMaxHeight + tempPadding;
                this.tableMinHeight += diff;
                this.tablePrefHeight += diff;
            }
        }
        if (totalExpandWidth > 0.0f) {
            extra = this.layoutWidth - hpadding;
            for (i3 = 0; i3 < this.columns; ++i3) {
                extra -= this.columnWidth[i3];
            }
            used = 0;
            int lastIndex = 0;
            for (i2 = 0; i2 < this.columns; ++i2) {
                if (this.expandWidth[i2] == 0.0f) continue;
                amount = (int)((float)extra * this.expandWidth[i2] / totalExpandWidth);
                int n3 = i2;
                this.columnWidth[n3] = this.columnWidth[n3] + amount;
                used += amount;
                lastIndex = i2;
            }
            int n4 = lastIndex;
            this.columnWidth[n4] = this.columnWidth[n4] + (extra - used);
        }
        if (totalExpandHeight > 0.0f) {
            extra = this.layoutHeight - vpadding;
            for (i3 = 0; i3 < this.rows; ++i3) {
                extra -= this.rowHeight[i3];
            }
            used = 0;
            int lastIndex = 0;
            for (i2 = 0; i2 < this.rows; ++i2) {
                if (this.expandHeight[i2] == 0.0f) continue;
                amount = (int)((float)extra * this.expandHeight[i2] / totalExpandHeight);
                int n5 = i2;
                this.rowHeight[n5] = this.rowHeight[n5] + amount;
                used += amount;
                lastIndex = i2;
            }
            int n6 = lastIndex;
            this.rowHeight[n6] = this.rowHeight[n6] + (extra - used);
        }
        n2 = cells.size();
        for (i4 = 0; i4 < n2; ++i4) {
            int column;
            Cell c5 = cells.get(i4);
            if (c5.ignore.booleanValue() || c5.colspan == 1) continue;
            int extraWidth = 0;
            int nn3 = column + c5.colspan;
            for (column = c5.column; column < nn3; ++column) {
                extraWidth += columnWeightedWidth[column] - this.columnWidth[column];
            }
            extraWidth -= c5.computedPadLeft + c5.computedPadRight;
            if ((extraWidth /= c5.colspan.intValue()) <= 0) continue;
            column = c5.column;
            nn3 = column + c5.colspan;
            while (column < nn3) {
                int n7 = column++;
                this.columnWidth[n7] = this.columnWidth[n7] + extraWidth;
            }
        }
        int tableWidth = 0;
        int tableHeight = 0;
        for (int i9 = 0; i9 < this.columns; ++i9) {
            tableWidth += this.columnWidth[i9];
        }
        int width = ((Toolkit)toolkit).width((BaseTableLayout)this, this.width);
        tableWidth = Math.max(tableWidth + hpadding, width);
        for (i2 = 0; i2 < this.rows; ++i2) {
            tableHeight += this.rowHeight[i2];
        }
        int height = ((Toolkit)toolkit).height((BaseTableLayout)this, this.height);
        tableHeight = Math.max(tableHeight + vpadding, height);
        int x = this.layoutX + ((Toolkit)toolkit).width((BaseTableLayout)this, this.padLeft);
        if ((this.align & 0x10) != 0) {
            x += this.layoutWidth - tableWidth;
        } else if ((this.align & 8) == 0) {
            x += (this.layoutWidth - tableWidth) / 2;
        }
        int y = this.layoutY + ((Toolkit)toolkit).height((BaseTableLayout)this, this.padTop);
        if ((this.align & 4) != 0) {
            y += this.layoutHeight - tableHeight;
        } else if ((this.align & 2) == 0) {
            y += (this.layoutHeight - tableHeight) / 2;
        }
        int currentX = x;
        int currentY = y;
        int n8 = cells.size();
        for (i = 0; i < n8; ++i) {
            int column;
            c = cells.get(i);
            if (c.ignore.booleanValue()) continue;
            spannedCellWidth = 0;
            nn = column + c.colspan;
            for (column = c.column; column < nn; ++column) {
                spannedCellWidth += this.columnWidth[column];
            }
            spannedCellWidth -= c.computedPadLeft + c.computedPadRight;
            currentX += c.computedPadLeft;
            if (c.fillX.floatValue() > 0.0f) {
                c.widgetWidth = (int)((float)spannedCellWidth * c.fillX.floatValue());
                int maxWidth = ((Toolkit)toolkit).getWidgetWidth((BaseTableLayout)this, c.widget, c.maxWidth);
                if (maxWidth > 0) {
                    c.widgetWidth = Math.min(c.widgetWidth, maxWidth);
                }
            }
            if (c.fillY.floatValue() > 0.0f) {
                c.widgetHeight = (int)((float)this.rowHeight[c.row] * c.fillY.floatValue()) - c.computedPadTop - c.computedPadBottom;
                int maxHeight = ((Toolkit)toolkit).getWidgetHeight((BaseTableLayout)this, c.widget, c.maxHeight);
                if (maxHeight > 0) {
                    c.widgetHeight = Math.min(c.widgetHeight, maxHeight);
                }
            }
            if (c.scaling != 8) {
                float sourceWidth = ((Toolkit)toolkit).getWidgetWidth((BaseTableLayout)this, c.widget, PREF);
                float sourceHeight = ((Toolkit)toolkit).getWidgetHeight((BaseTableLayout)this, c.widget, PREF);
                switch (c.scaling) {
                    case 2: {
                        float scale = (float)c.widgetHeight / (float)c.widgetWidth > sourceHeight / sourceWidth ? (float)c.widgetWidth / sourceWidth : (float)c.widgetHeight / sourceHeight;
                        c.widgetWidth = (int)(sourceWidth * scale);
                        c.widgetHeight = (int)(sourceHeight * scale);
                        break;
                    }
                    case 4: {
                        float scale = (float)c.widgetHeight / (float)c.widgetWidth < sourceHeight / sourceWidth ? (float)c.widgetWidth / sourceWidth : (float)c.widgetHeight / sourceHeight;
                        c.widgetWidth = (int)(sourceWidth * scale);
                        c.widgetHeight = (int)(sourceHeight * scale);
                        break;
                    }
                }
            }
            c.widgetX = (c.align & 8) != 0 ? currentX : ((c.align & 0x10) != 0 ? currentX + spannedCellWidth - c.widgetWidth : currentX + (spannedCellWidth - c.widgetWidth) / 2);
            c.widgetY = (c.align & 2) != 0 ? currentY + c.computedPadTop : ((c.align & 4) != 0 ? currentY + this.rowHeight[c.row] - c.widgetHeight - c.computedPadBottom : currentY + (this.rowHeight[c.row] - c.widgetHeight + c.computedPadTop - c.computedPadBottom) / 2);
            if (c.endRow) {
                currentX = x;
                currentY += this.rowHeight[c.row];
                continue;
            }
            currentX += spannedCellWidth + c.computedPadRight;
        }
        if (this.debug == 0) {
            return;
        }
        ((Toolkit)toolkit).clearDebugRectangles((BaseTableLayout)this);
        currentX = x;
        currentY = y;
        if ((this.debug & 2) != 0 || (this.debug & 1) != 0) {
            ((Toolkit)toolkit).addDebugRectangle((BaseTableLayout)this, 2, this.layoutX, this.layoutY, this.layoutWidth, this.layoutHeight);
            ((Toolkit)toolkit).addDebugRectangle((BaseTableLayout)this, 2, x, y, tableWidth - hpadding, tableHeight - vpadding);
        }
        n8 = cells.size();
        for (i = 0; i < n8; ++i) {
            int column;
            c = cells.get(i);
            if (c.ignore.booleanValue()) continue;
            if ((this.debug & 8) != 0 || (this.debug & 1) != 0) {
                ((Toolkit)toolkit).addDebugRectangle((BaseTableLayout)this, 8, c.widgetX, c.widgetY, c.widgetWidth, c.widgetHeight);
            }
            spannedCellWidth = 0;
            nn = column + c.colspan;
            for (column = c.column; column < nn; ++column) {
                spannedCellWidth += this.columnWidth[column];
            }
            spannedCellWidth -= c.computedPadLeft + c.computedPadRight;
            currentX += c.computedPadLeft;
            if ((this.debug & 4) != 0 || (this.debug & 1) != 0) {
                ((Toolkit)toolkit).addDebugRectangle((BaseTableLayout)this, 4, currentX, currentY + c.computedPadTop, spannedCellWidth, this.rowHeight[c.row] - c.computedPadTop - c.computedPadBottom);
            }
            if (c.endRow) {
                currentX = x;
                currentY += this.rowHeight[c.row];
                continue;
            }
            currentX += spannedCellWidth + c.computedPadRight;
        }
    }
}

