/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.scenes.scene2d.ui;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.BitmapFontCache;
import com.badlogic.gdx.graphics.g2d.NinePatch;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.tablelayout.LibgdxToolkit;
import com.badlogic.gdx.scenes.scene2d.ui.tablelayout.Table;

public class Window
extends Table {
    private WindowStyle style;
    private String title;
    private BitmapFontCache titleCache;
    private boolean isMovable = true;
    private boolean isModal;
    private final Vector2 dragOffset = new Vector2();
    private boolean dragging;

    public Window(Skin skin) {
        this("", skin.getStyle(WindowStyle.class), null);
        this.setSkin(skin);
    }

    public Window(String title, Skin skin) {
        this(title, skin.getStyle(WindowStyle.class), null);
        this.setSkin(skin);
    }

    public Window(String title, WindowStyle style) {
        this(title, style, null);
    }

    public Window(String title, WindowStyle style, String name) {
        super(null, null, name);
        if (title == null) {
            throw new IllegalArgumentException("title cannot be null.");
        }
        this.setClip(true);
        this.title = title;
        this.setStyle(style);
        this.width = 150.0f;
        this.height = 150.0f;
    }

    public void setStyle(WindowStyle style) {
        if (style == null) {
            throw new IllegalArgumentException("style cannot be null.");
        }
        this.style = style;
        this.setBackground(style.background);
        this.titleCache = new BitmapFontCache(style.titleFont);
        this.titleCache.setColor(style.titleFontColor);
        this.invalidateHierarchy();
    }

    public WindowStyle getStyle() {
        return this.style;
    }

    private int getTitleBarHeight() {
        return ((LibgdxToolkit)this.getTableLayout().getToolkit()).height(this.getTableLayout(), this.getPadTop());
    }

    @Override
    public void layout() {
        super.layout();
        BitmapFont.TextBounds bounds = this.style.titleFont.getMultiLineBounds(this.title);
        this.titleCache.setMultiLineText(this.title, this.width / 2.0f - bounds.width / 2.0f, this.height - (float)(this.getTitleBarHeight() / 2) + bounds.height / 2.0f);
    }

    @Override
    protected void drawBackground(SpriteBatch batch, float parentAlpha) {
        super.drawBackground(batch, parentAlpha);
        this.titleCache.setPosition(this.x, this.y);
        this.titleCache.draw(batch, parentAlpha);
    }

    @Override
    public boolean touchDown(float x, float y, int pointer) {
        if (pointer != 0) {
            return false;
        }
        if (this.parent.getActors().size() > 1) {
            this.parent.swapActor(this, this.parent.getActors().get(this.parent.getActors().size() - 1));
        }
        if (super.touchDown(x, y, pointer)) {
            return true;
        }
        this.dragging = this.isMovable && this.height - y <= (float)this.getTitleBarHeight() && y < this.height && x > 0.0f && x < this.width;
        this.dragOffset.set(x, y);
        return true;
    }

    @Override
    public void touchDragged(float x, float y, int pointer) {
        if (!this.dragging) {
            return;
        }
        this.x += x - this.dragOffset.x;
        this.y += y - this.dragOffset.y;
    }

    @Override
    public Actor hit(float x, float y) {
        return this.isModal || x > 0.0f && x < this.width && y > 0.0f && y < this.height ? this : null;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTitle() {
        return this.title;
    }

    public void setMovable(boolean isMovable) {
        this.isMovable = isMovable;
    }

    public void setModal(boolean isModal) {
        this.isModal = isModal;
    }

    public static class WindowStyle {
        public NinePatch background;
        public BitmapFont titleFont;
        public Color titleFontColor = new Color(1.0f, 1.0f, 1.0f, 1.0f);

        public WindowStyle() {
        }

        public WindowStyle(BitmapFont titleFont, Color titleFontColor, NinePatch backgroundPatch) {
            this.background = backgroundPatch;
            this.titleFont = titleFont;
            this.titleFontColor.set(titleFontColor);
        }
    }
}

