/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.scenes.scene2d.ui;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.NinePatch;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.Widget;
import com.badlogic.gdx.scenes.scene2d.ui.utils.Clipboard;
import com.badlogic.gdx.utils.FloatArray;
import com.badlogic.gdx.utils.TimeUtils;
import java.util.List;

public class TextField
extends Widget {
    private static final char BACKSPACE = '\b';
    private static final char ENTER_DESKTOP = '\r';
    private static final char ENTER_ANDROID = '\n';
    private static final char TAB = '\t';
    private static final char DELETE = '\u007f';
    private static final char BULLET = '\u0095';
    private TextFieldStyle style;
    private String text;
    private String messageText;
    private CharSequence displayText;
    private int cursor;
    private Clipboard clipboard;
    private TextFieldListener listener;
    private TextFieldFilter filter;
    private OnscreenKeyboard keyboard = new DefaultOnscreenKeyboard();
    private boolean passwordMode;
    private StringBuilder passwordBuffer;
    private final Rectangle fieldBounds = new Rectangle();
    private final BitmapFont.TextBounds textBounds = new BitmapFont.TextBounds();
    private final Rectangle scissor = new Rectangle();
    private float renderOffset;
    private float textOffset;
    private int visibleTextStart;
    private int visibleTextEnd;
    private final FloatArray glyphAdvances = new FloatArray();
    private final FloatArray glyphPositions = new FloatArray();
    private boolean cursorOn = true;
    private float blinkTime = 0.42f;
    private long lastBlink;
    private boolean hasSelection;
    private int selectionStart;
    private float selectionX;
    private float selectionWidth;
    private char passwordCharacter = (char)149;

    public TextField(Skin skin) {
        this("", null, skin.getStyle(TextFieldStyle.class), null);
    }

    public TextField(String text, Skin skin) {
        this(text, null, skin.getStyle(TextFieldStyle.class), null);
    }

    public TextField(String text, String messageText, Skin skin) {
        this(text, messageText, skin.getStyle(TextFieldStyle.class), null);
    }

    public TextField(TextFieldStyle style) {
        this("", null, style, null);
    }

    public TextField(String text, TextFieldStyle style) {
        this(text, null, style, null);
    }

    public TextField(String text, String messageText, TextFieldStyle style) {
        this(text, messageText, style, null);
    }

    public TextField(String text, String messageText, TextFieldStyle style, String name) {
        super(name);
        this.setStyle(style);
        this.clipboard = Clipboard.getDefaultClipboard();
        this.setText(text);
        this.messageText = messageText;
        this.width = this.getPrefWidth();
        this.height = this.getPrefHeight();
    }

    public void setStyle(TextFieldStyle style) {
        if (style == null) {
            throw new IllegalArgumentException("style cannot be null.");
        }
        this.style = style;
        this.invalidateHierarchy();
    }

    public void setPasswordCharacter(char passwordCharacter) {
        this.passwordCharacter = passwordCharacter;
    }

    public TextFieldStyle getStyle() {
        return this.style;
    }

    @Override
    public void layout() {
    }

    private void calculateOffsets() {
        float position = this.glyphPositions.get(this.cursor);
        float distance = position - Math.abs(this.renderOffset);
        float visibleWidth = this.width;
        if (this.style.background != null) {
            visibleWidth -= this.style.background.getLeftWidth() + this.style.background.getRightWidth();
        }
        if (distance <= 0.0f) {
            this.renderOffset = this.cursor > 0 ? -this.glyphPositions.get(this.cursor - 1) : 0.0f;
        } else if (distance > visibleWidth) {
            this.renderOffset -= distance - visibleWidth;
        }
        this.visibleTextStart = 0;
        this.textOffset = 0.0f;
        float start = Math.abs(this.renderOffset);
        int len = this.glyphPositions.size;
        float startPos = 0.0f;
        for (int i = 0; i < len; ++i) {
            if (!(this.glyphPositions.items[i] >= start)) continue;
            this.visibleTextStart = i;
            startPos = this.glyphPositions.items[i];
            this.textOffset = this.glyphPositions.items[this.visibleTextStart] - start;
            break;
        }
        this.visibleTextEnd = Math.min(this.displayText.length(), this.cursor + 1);
        while (this.visibleTextEnd <= this.displayText.length() && !(this.glyphPositions.items[this.visibleTextEnd] - startPos > visibleWidth)) {
            ++this.visibleTextEnd;
        }
        this.visibleTextEnd = Math.max(0, this.visibleTextEnd - 1);
        if (this.hasSelection) {
            int minIndex = Math.min(this.cursor, this.selectionStart);
            int maxIndex = Math.max(this.cursor, this.selectionStart);
            float minX = Math.max(this.glyphPositions.get(minIndex), this.glyphPositions.get(this.visibleTextStart));
            float maxX = Math.min(this.glyphPositions.get(maxIndex), this.glyphPositions.get(this.visibleTextEnd));
            this.selectionX = minX;
            this.selectionWidth = maxX - minX;
        }
    }

    @Override
    public void draw(SpriteBatch batch, float parentAlpha) {
        boolean focused;
        BitmapFont font = this.style.font;
        Color fontColor = this.style.fontColor;
        TextureRegion selection = this.style.selection;
        NinePatch cursorPatch = this.style.cursor;
        batch.setColor(this.color.r, this.color.g, this.color.b, this.color.a * parentAlpha);
        float bgLeftWidth = 0.0f;
        if (this.style.background != null) {
            this.style.background.draw(batch, this.x, this.y, this.width, this.height);
            bgLeftWidth = this.style.background.getLeftWidth();
        }
        float textY = (int)(this.height / 2.0f + this.textBounds.height / 2.0f + font.getDescent());
        this.calculateOffsets();
        boolean bl = focused = this.stage != null && this.stage.getKeyboardFocus() == this;
        if (focused && this.hasSelection && selection != null) {
            batch.draw(selection, this.x + this.selectionX + bgLeftWidth + this.renderOffset, this.y + textY - this.textBounds.height - font.getDescent() / 2.0f, this.selectionWidth, this.textBounds.height);
        }
        if (this.displayText.length() == 0) {
            if (!focused && this.messageText != null) {
                if (this.style.messageFontColor != null) {
                    font.setColor(this.style.messageFontColor.r, this.style.messageFontColor.g, this.style.messageFontColor.b, this.style.messageFontColor.a * parentAlpha);
                } else {
                    font.setColor(0.7f, 0.7f, 0.7f, parentAlpha);
                }
                BitmapFont messageFont = this.style.messageFont != null ? this.style.messageFont : font;
                font.draw(batch, this.messageText, this.x + bgLeftWidth, this.y + textY);
            }
        } else {
            font.setColor(fontColor.r, fontColor.g, fontColor.b, fontColor.a * parentAlpha);
            font.draw(batch, this.displayText, this.x + bgLeftWidth + this.textOffset, this.y + textY, this.visibleTextStart, this.visibleTextEnd);
        }
        if (focused) {
            this.blink();
            if (this.cursorOn && cursorPatch != null) {
                cursorPatch.draw(batch, this.x + bgLeftWidth + this.glyphPositions.get(this.cursor) + this.renderOffset - 1.0f, this.y + textY - this.textBounds.height - font.getDescent(), cursorPatch.getTotalWidth(), this.textBounds.height + font.getDescent() / 2.0f);
            }
        }
    }

    private void updateDisplayText() {
        if (this.passwordMode && this.style.font.containsCharacter(this.passwordCharacter)) {
            if (this.passwordBuffer == null) {
                this.passwordBuffer = new StringBuilder(this.text.length());
            }
            if (this.passwordBuffer.length() > this.text.length()) {
                this.passwordBuffer.setLength(this.text.length());
            } else {
                int n = this.text.length();
                for (int i = this.passwordBuffer.length(); i < n; ++i) {
                    this.passwordBuffer.append(this.passwordCharacter);
                }
            }
            this.displayText = this.passwordBuffer;
        } else {
            this.displayText = this.text;
        }
        this.style.font.computeGlyphAdvancesAndPositions(this.displayText, this.glyphAdvances, this.glyphPositions);
    }

    private void blink() {
        long time = TimeUtils.nanoTime();
        if ((float)(time - this.lastBlink) / 1.0E9f > this.blinkTime) {
            this.cursorOn = !this.cursorOn;
            this.lastBlink = time;
        }
    }

    @Override
    public boolean touchDown(float x, float y, int pointer) {
        if (pointer != 0) {
            return false;
        }
        if (this.stage != null) {
            this.stage.setKeyboardFocus(this);
        }
        this.keyboard.show(true);
        this.clearSelection();
        this.lastBlink = 0L;
        this.cursorOn = false;
        x -= this.renderOffset;
        for (int i = 0; i < this.glyphPositions.size; ++i) {
            float pos = this.glyphPositions.items[i];
            if (!(pos > x)) continue;
            this.cursor = Math.max(0, i - 1);
            return true;
        }
        this.cursor = Math.max(0, this.glyphPositions.size - 1);
        return true;
    }

    @Override
    public boolean keyDown(int keycode) {
        BitmapFont font = this.style.font;
        if (this.stage != null && this.stage.getKeyboardFocus() == this) {
            if (Gdx.input.isKeyPressed(129) || Gdx.input.isKeyPressed(130)) {
                if (keycode == 50) {
                    this.paste();
                }
                if (keycode == 31 || keycode == 133) {
                    this.copy();
                }
            } else if (Gdx.input.isKeyPressed(59) || Gdx.input.isKeyPressed(60)) {
                if (keycode == 133) {
                    this.paste();
                }
                if (keycode == 112 && this.hasSelection) {
                    this.copy();
                    this.delete();
                }
                if (keycode == 21) {
                    if (!this.hasSelection) {
                        this.selectionStart = this.cursor;
                        this.hasSelection = true;
                    }
                    --this.cursor;
                }
                if (keycode == 22) {
                    if (!this.hasSelection) {
                        this.selectionStart = this.cursor;
                        this.hasSelection = true;
                    }
                    ++this.cursor;
                }
                if (keycode == 3) {
                    if (!this.hasSelection) {
                        this.selectionStart = this.cursor;
                        this.hasSelection = true;
                    }
                    this.cursor = 0;
                }
                if (keycode == 132) {
                    if (!this.hasSelection) {
                        this.selectionStart = this.cursor;
                        this.hasSelection = true;
                    }
                    this.cursor = this.text.length();
                }
                this.cursor = Math.max(0, this.cursor);
                this.cursor = Math.min(this.text.length(), this.cursor);
            } else {
                if (keycode == 21) {
                    --this.cursor;
                    this.clearSelection();
                }
                if (keycode == 22) {
                    ++this.cursor;
                    this.clearSelection();
                }
                if (keycode == 3) {
                    this.cursor = 0;
                    this.clearSelection();
                }
                if (keycode == 132) {
                    this.cursor = this.text.length();
                    this.clearSelection();
                }
                this.cursor = Math.max(0, this.cursor);
                this.cursor = Math.min(this.text.length(), this.cursor);
            }
            return true;
        }
        return false;
    }

    private void copy() {
        if (this.hasSelection) {
            int minIndex = Math.min(this.cursor, this.selectionStart);
            int maxIndex = Math.max(this.cursor, this.selectionStart);
            this.clipboard.setContents(this.text.substring(minIndex, maxIndex));
        }
    }

    private void paste() {
        String content = this.clipboard.getContents();
        if (content != null) {
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < content.length(); ++i) {
                char c = content.charAt(i);
                if (!this.style.font.containsCharacter(c)) continue;
                builder.append(c);
            }
            content = builder.toString();
            this.text = this.text.substring(0, this.cursor) + content + this.text.substring(this.cursor, this.text.length());
            this.updateDisplayText();
            this.cursor += content.length();
        }
    }

    private void delete() {
        int minIndex = Math.min(this.cursor, this.selectionStart);
        int maxIndex = Math.max(this.cursor, this.selectionStart);
        this.text = (minIndex > 0 ? this.text.substring(0, minIndex) : "") + (maxIndex < this.text.length() ? this.text.substring(maxIndex, this.text.length()) : "");
        this.updateDisplayText();
        this.cursor = minIndex;
        this.clearSelection();
    }

    @Override
    public boolean keyTyped(char character) {
        BitmapFont font = this.style.font;
        if (this.stage != null && this.stage.getKeyboardFocus() == this) {
            if (character == '\b' && (this.cursor > 0 || this.hasSelection)) {
                if (!this.hasSelection) {
                    this.text = this.text.substring(0, this.cursor - 1) + this.text.substring(this.cursor);
                    this.updateDisplayText();
                    --this.cursor;
                } else {
                    this.delete();
                }
            }
            if (character == '\u007f') {
                if (this.cursor < this.text.length() || this.hasSelection) {
                    if (!this.hasSelection) {
                        this.text = this.text.substring(0, this.cursor) + this.text.substring(this.cursor + 1);
                        this.updateDisplayText();
                    } else {
                        this.delete();
                    }
                }
                return true;
            }
            if (character != '\r' && character != '\n' && this.filter != null && !this.filter.acceptChar(this, character)) {
                return true;
            }
            if (character == '\t' || character == '\n') {
                this.next(Gdx.input.isKeyPressed(59) || Gdx.input.isKeyPressed(60));
            }
            if (font.containsCharacter(character)) {
                if (!this.hasSelection) {
                    this.text = this.text.substring(0, this.cursor) + character + this.text.substring(this.cursor, this.text.length());
                    this.updateDisplayText();
                    ++this.cursor;
                } else {
                    int minIndex = Math.min(this.cursor, this.selectionStart);
                    int maxIndex = Math.max(this.cursor, this.selectionStart);
                    this.text = (minIndex > 0 ? this.text.substring(0, minIndex) : "") + (maxIndex < this.text.length() ? this.text.substring(maxIndex, this.text.length()) : "");
                    this.cursor = minIndex;
                    this.text = this.text.substring(0, this.cursor) + character + this.text.substring(this.cursor, this.text.length());
                    this.updateDisplayText();
                    ++this.cursor;
                    this.clearSelection();
                }
            }
            if (this.listener != null) {
                this.listener.keyTyped(this, character);
            }
            return true;
        }
        return false;
    }

    public void next(boolean up) {
        if (this.stage == null) {
            return;
        }
        TextField textField = this.findNextTextField(this.stage.getActors(), null, up);
        if (textField != null) {
            this.stage.setKeyboardFocus(textField);
        } else {
            Gdx.input.setOnscreenKeyboardVisible(false);
        }
    }

    private TextField findNextTextField(List<Actor> actors, TextField best, boolean up) {
        int n = actors.size();
        for (int i = 0; i < n; ++i) {
            Actor actor = actors.get(i);
            if (actor instanceof TextField) {
                if (actor == this) continue;
                if (actor.y == this.y) {
                    if (best == null && actor.x >= this.x ^ up) {
                        best = (TextField)actor;
                    }
                } else if (actor.y < this.y ^ up && (best == null || actor.y - this.y > best.y - this.y ^ up)) {
                    best = (TextField)actor;
                }
            }
            if (!(actor instanceof Group)) continue;
            best = this.findNextTextField(((Group)actor).getActors(), best, up);
        }
        return best;
    }

    public void setTextFieldListener(TextFieldListener listener) {
        this.listener = listener;
    }

    public void setTextFieldFilter(TextFieldFilter filter) {
        this.filter = filter;
    }

    public String getMessageText() {
        return this.messageText;
    }

    public void setMessageText(String messageText) {
        this.messageText = messageText;
    }

    public void setText(String text) {
        if (text == null) {
            throw new IllegalArgumentException("text cannot be null.");
        }
        BitmapFont font = this.style.font;
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (!font.containsCharacter(c)) continue;
            buffer.append(c);
        }
        this.text = buffer.toString();
        this.updateDisplayText();
        this.cursor = 0;
        this.clearSelection();
        this.textBounds.set(font.getBounds(this.displayText));
        this.textBounds.height -= font.getDescent() * 2.0f;
        font.computeGlyphAdvancesAndPositions(this.displayText, this.glyphAdvances, this.glyphPositions);
    }

    public String getText() {
        return this.text;
    }

    public void setSelection(int selectionStart, int selectionEnd) {
        if (selectionStart < 0) {
            throw new IllegalArgumentException("selectionStart must be >= 0");
        }
        if (selectionEnd < 0) {
            throw new IllegalArgumentException("selectionEnd must be >= 0");
        }
        selectionStart = Math.min(this.text.length(), selectionStart);
        selectionEnd = Math.min(this.text.length(), selectionEnd);
        if (selectionEnd == selectionStart) {
            this.clearSelection();
            return;
        }
        if (selectionEnd < selectionStart) {
            int temp = selectionEnd;
            selectionEnd = selectionStart;
            selectionStart = temp;
        }
        this.hasSelection = true;
        this.selectionStart = selectionStart;
        this.cursor = selectionEnd;
    }

    public void clearSelection() {
        this.hasSelection = false;
    }

    public void setCursorPosition(int cursorPosition) {
        if (cursorPosition < 0) {
            throw new IllegalArgumentException("cursorPosition must be >= 0");
        }
        this.clearSelection();
        this.cursor = Math.min(cursorPosition, this.text.length());
    }

    public int getCursorPosition() {
        return this.cursor;
    }

    public OnscreenKeyboard getOnscreenKeyboard() {
        return this.keyboard;
    }

    public void setOnscreenKeyboard(OnscreenKeyboard keyboard) {
        this.keyboard = keyboard;
    }

    public void setClipboard(Clipboard clipboard) {
        this.clipboard = clipboard;
    }

    @Override
    public float getPrefWidth() {
        return 150.0f;
    }

    @Override
    public float getPrefHeight() {
        float prefHeight = this.textBounds.height;
        if (this.style.background != null) {
            prefHeight += this.style.background.getBottomHeight() + this.style.background.getTopHeight();
        }
        return prefHeight;
    }

    public void setPasswordMode(boolean passwordMode) {
        this.passwordMode = passwordMode;
    }

    public static class TextFieldStyle {
        public NinePatch background;
        public NinePatch cursor;
        public BitmapFont font;
        public Color fontColor;
        public TextureRegion selection;
        public BitmapFont messageFont;
        public Color messageFontColor;

        public TextFieldStyle() {
        }

        public TextFieldStyle(BitmapFont font, Color fontColor, BitmapFont messageFont, Color messageFontColor, NinePatch cursor, TextureRegion selection, NinePatch background) {
            this.messageFont = messageFont;
            this.messageFontColor = messageFontColor;
            this.background = background;
            this.cursor = cursor;
            this.font = font;
            this.fontColor = fontColor;
            this.selection = selection;
        }
    }

    public static class DefaultOnscreenKeyboard
    implements OnscreenKeyboard {
        @Override
        public void show(boolean visible) {
            Gdx.input.setOnscreenKeyboardVisible(visible);
        }
    }

    public static interface OnscreenKeyboard {
        public void show(boolean var1);
    }

    public static interface TextFieldFilter {
        public boolean acceptChar(TextField var1, char var2);

        public static class DigitsOnlyFilter
        implements TextFieldFilter {
            @Override
            public boolean acceptChar(TextField textField, char key) {
                return Character.isDigit(key);
            }
        }
    }

    public static interface TextFieldListener {
        public void keyTyped(TextField var1, char var2);
    }
}

