/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.scenes.scene2d.ui;

import com.badlogic.gdx.graphics.g2d.NinePatch;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Cullable;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.Layout;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.WidgetGroup;
import com.badlogic.gdx.scenes.scene2d.ui.utils.ScissorStack;

public class ScrollPane
extends WidgetGroup {
    private ScrollPaneStyle style;
    private Actor widget;
    private final Rectangle hScrollBounds = new Rectangle();
    private final Rectangle vScrollBounds = new Rectangle();
    private final Rectangle hKnobBounds = new Rectangle();
    private final Rectangle vKnobBounds = new Rectangle();
    private final Rectangle widgetAreaBounds = new Rectangle();
    private final Rectangle widgetCullingArea = new Rectangle();
    private final Rectangle scissorBounds = new Rectangle();
    private boolean scrollX;
    private boolean scrollY;
    private float amountX;
    private float amountY;
    private boolean touchScrollH;
    private boolean touchScrollV;
    private final Vector2 lastPoint = new Vector2();
    private float handlePosition;
    private boolean disableX;
    private boolean disableY;
    private float areaWidth;
    private float areaHeight;

    public ScrollPane(Skin skin) {
        this(null, skin);
    }

    public ScrollPane(Actor widget, Skin skin) {
        this(widget, skin.getStyle(ScrollPaneStyle.class), null);
    }

    public ScrollPane(Actor widget, ScrollPaneStyle style) {
        this(widget, style, null);
    }

    public ScrollPane(Actor widget, ScrollPaneStyle style, String name) {
        super(name);
        if (style == null) {
            throw new IllegalArgumentException("style cannot be null.");
        }
        this.widget = widget;
        this.style = style;
        if (widget != null) {
            this.setWidget(widget);
        }
        this.width = 150.0f;
        this.height = 150.0f;
    }

    public void setStyle(ScrollPaneStyle style) {
        if (style == null) {
            throw new IllegalArgumentException("style cannot be null.");
        }
        this.style = style;
        this.invalidateHierarchy();
    }

    public ScrollPaneStyle getStyle() {
        return this.style;
    }

    @Override
    public void layout() {
        float widgetHeight;
        float widgetWidth;
        Layout layout;
        NinePatch bg = this.style.background;
        NinePatch hScrollKnob = this.style.hScrollKnob;
        NinePatch vScrollKnob = this.style.vScrollKnob;
        float bgLeftWidth = bg == null ? 0.0f : bg.getLeftWidth();
        float bgRightWidth = bg == null ? 0.0f : bg.getRightWidth();
        float bgTopHeight = bg == null ? 0.0f : bg.getTopHeight();
        float bgBottomHeight = bg == null ? 0.0f : bg.getTopHeight();
        this.areaWidth = this.width - bgLeftWidth - bgRightWidth;
        this.areaHeight = this.height - bgTopHeight - bgBottomHeight;
        if (this.widget == null) {
            return;
        }
        if (this.widget instanceof Layout) {
            layout = (Layout)((Object)this.widget);
            widgetWidth = layout.getPrefWidth();
            widgetHeight = layout.getPrefHeight();
        } else {
            widgetWidth = this.widget.width;
            widgetHeight = this.widget.height;
        }
        this.scrollX = false;
        this.scrollY = false;
        if (!this.disableX && widgetWidth > this.areaWidth) {
            this.scrollX = true;
        }
        if (!this.disableY && widgetHeight > this.areaHeight) {
            this.scrollY = true;
        }
        if (!this.disableX && this.scrollY && widgetWidth > this.areaWidth - vScrollKnob.getTotalWidth()) {
            this.scrollX = true;
            this.areaWidth -= vScrollKnob.getTotalWidth();
        }
        if (!this.disableY && this.scrollX && widgetHeight > this.areaHeight - hScrollKnob.getTotalHeight()) {
            this.scrollY = true;
            this.areaHeight -= hScrollKnob.getTotalHeight();
        }
        this.widgetAreaBounds.set(bgLeftWidth, bgBottomHeight + (this.scrollX ? hScrollKnob.getTotalHeight() : 0.0f), this.areaWidth, this.areaHeight);
        this.amountX = MathUtils.clamp(this.amountX, 0.0f, this.widgetAreaBounds.x);
        this.amountY = MathUtils.clamp(this.amountY, 0.0f, this.widgetAreaBounds.y);
        widgetWidth = this.disableX ? this.width : Math.max(this.areaWidth, widgetWidth);
        float f = widgetHeight = this.disableY ? this.height : Math.max(this.areaHeight, widgetHeight);
        if (this.widget.width != widgetWidth || this.widget.height != widgetHeight) {
            this.widget.width = widgetWidth;
            this.widget.height = widgetHeight;
        }
        if (this.scrollX) {
            this.hScrollBounds.set(bgLeftWidth, bgBottomHeight, this.areaWidth, hScrollKnob.getTotalHeight());
            this.hKnobBounds.width = Math.max(hScrollKnob.getTotalWidth(), (float)((int)(this.hScrollBounds.width * this.areaWidth / this.widget.width)));
            this.hKnobBounds.height = hScrollKnob.getTotalHeight();
            this.hKnobBounds.x = this.hScrollBounds.x + (float)((int)((this.hScrollBounds.width - this.hKnobBounds.width) * this.getScrollPercentX()));
            this.hKnobBounds.y = this.hScrollBounds.y;
        }
        if (this.scrollY) {
            this.vScrollBounds.set(this.width - bgRightWidth - vScrollKnob.getTotalWidth(), this.height - bgTopHeight - this.areaHeight, vScrollKnob.getTotalWidth(), this.areaHeight);
            this.vKnobBounds.width = vScrollKnob.getTotalWidth();
            this.vKnobBounds.height = Math.max(vScrollKnob.getTotalHeight(), (float)((int)(this.vScrollBounds.height * this.areaHeight / this.widget.height)));
            this.vKnobBounds.x = this.vScrollBounds.x;
            this.vKnobBounds.y = this.vScrollBounds.y + (float)((int)((this.vScrollBounds.height - this.vKnobBounds.height) * (1.0f - this.getScrollPercentY())));
        }
        if (this.widget instanceof Layout) {
            layout = (Layout)((Object)this.widget);
            layout.invalidate();
            layout.validate();
        }
    }

    @Override
    public void draw(SpriteBatch batch, float parentAlpha) {
        if (this.widget == null) {
            return;
        }
        this.validate();
        this.applyTransform(batch);
        if (this.scrollX) {
            this.hKnobBounds.x = this.hScrollBounds.x + (float)((int)((this.hScrollBounds.width - this.hKnobBounds.width) * this.getScrollPercentX()));
        }
        if (this.scrollY) {
            this.vKnobBounds.y = this.vScrollBounds.y + (float)((int)((this.vScrollBounds.height - this.vKnobBounds.height) * (1.0f - this.getScrollPercentY())));
        }
        this.widget.y = this.widgetAreaBounds.y - (float)(!this.scrollY ? (int)(this.widget.height - this.areaHeight) : 0) - (float)(this.scrollY ? (int)((this.widget.height - this.areaHeight) * (1.0f - this.getScrollPercentY())) : 0);
        this.widget.x = this.widgetAreaBounds.x - (float)(this.scrollX ? (int)((this.widget.width - this.areaWidth) * this.getScrollPercentX()) : 0);
        if (this.widget instanceof Cullable) {
            this.widgetCullingArea.x = -this.widget.x + this.widgetAreaBounds.x;
            this.widgetCullingArea.y = -this.widget.y + this.widgetAreaBounds.y;
            this.widgetCullingArea.width = this.areaWidth;
            this.widgetCullingArea.height = this.areaHeight;
            ((Cullable)((Object)this.widget)).setCullingArea(this.widgetCullingArea);
        }
        ScissorStack.calculateScissors(this.stage.getCamera(), this.batchTransform, this.widgetAreaBounds, this.scissorBounds);
        batch.setColor(this.color.r, this.color.g, this.color.b, this.color.a * parentAlpha);
        if (this.style.background != null) {
            this.style.background.draw(batch, 0.0f, 0.0f, this.width, this.height);
        }
        batch.flush();
        if (ScissorStack.pushScissors(this.scissorBounds)) {
            this.drawChildren(batch, parentAlpha);
            ScissorStack.popScissors();
        }
        batch.setColor(this.color.r, this.color.g, this.color.b, this.color.a * parentAlpha);
        if (this.scrollX) {
            this.style.hScroll.draw(batch, this.hScrollBounds.x, this.hScrollBounds.y, this.hScrollBounds.width, this.hScrollBounds.height);
            this.style.hScrollKnob.draw(batch, this.hKnobBounds.x, this.hKnobBounds.y, this.hKnobBounds.width, this.hKnobBounds.height);
        }
        if (this.scrollY) {
            this.style.vScroll.draw(batch, this.vScrollBounds.x, this.vScrollBounds.y, this.vScrollBounds.width, this.vScrollBounds.height);
            this.style.vScrollKnob.draw(batch, this.vKnobBounds.x, this.vKnobBounds.y, this.vKnobBounds.width, this.vKnobBounds.height);
        }
        this.resetTransform(batch);
    }

    @Override
    public float getPrefWidth() {
        if (this.widget instanceof Layout) {
            return ((Layout)((Object)this.widget)).getPrefWidth();
        }
        return 150.0f;
    }

    @Override
    public float getPrefHeight() {
        if (this.widget instanceof Layout) {
            return ((Layout)((Object)this.widget)).getPrefHeight();
        }
        return 150.0f;
    }

    @Override
    public float getMinWidth() {
        return 0.0f;
    }

    @Override
    public float getMinHeight() {
        return 0.0f;
    }

    @Override
    public boolean touchDown(float x, float y, int pointer) {
        if (pointer != 0) {
            return false;
        }
        if (this.scrollX && this.hScrollBounds.contains(x, y)) {
            if (this.hKnobBounds.contains(x, y)) {
                this.lastPoint.set(x, y);
                this.handlePosition = this.hKnobBounds.x;
                this.touchScrollH = true;
                return true;
            }
            if (x < this.hKnobBounds.x) {
                this.setScrollPercentX(Math.max(0.0f, this.getScrollPercentX() - 0.1f));
            } else {
                this.setScrollPercentX(Math.min(1.0f, this.getScrollPercentX() + 0.1f));
            }
            return false;
        }
        if (this.scrollY && this.vScrollBounds.contains(x, y)) {
            if (this.vKnobBounds.contains(x, y)) {
                this.lastPoint.set(x, y);
                this.handlePosition = this.vKnobBounds.y;
                this.touchScrollV = true;
                return true;
            }
            if (y < this.vKnobBounds.y) {
                this.setScrollPercentY(Math.max(0.0f, this.getScrollPercentY() + 0.1f));
            } else {
                this.setScrollPercentY(Math.min(1.0f, this.getScrollPercentY() - 0.1f));
            }
            return false;
        }
        if (this.widgetAreaBounds.contains(x, y)) {
            return super.touchDown(x, y, pointer);
        }
        return false;
    }

    @Override
    public void touchUp(float x, float y, int pointer) {
        this.touchScrollH = false;
        this.touchScrollV = false;
    }

    @Override
    public void touchDragged(float x, float y, int pointer) {
        if (this.touchScrollH) {
            float scrollH;
            float delta = x - this.lastPoint.x;
            this.handlePosition = scrollH = this.handlePosition + delta;
            scrollH = Math.max(this.hScrollBounds.x, scrollH);
            scrollH = Math.min(this.hScrollBounds.x + this.hScrollBounds.width - this.hKnobBounds.width, scrollH);
            this.setScrollPercentX((scrollH - this.hScrollBounds.x) / (this.hScrollBounds.width - this.hKnobBounds.width));
            this.lastPoint.set(x, y);
        } else if (this.touchScrollV) {
            float scrollV;
            float delta = y - this.lastPoint.y;
            this.handlePosition = scrollV = this.handlePosition + delta;
            scrollV = Math.max(this.vScrollBounds.y, scrollV);
            scrollV = Math.min(this.vScrollBounds.y + this.vScrollBounds.height - this.vKnobBounds.height, scrollV);
            this.setScrollPercentY(1.0f - (scrollV - this.vScrollBounds.y) / (this.vScrollBounds.height - this.vKnobBounds.height));
            this.lastPoint.set(x, y);
        } else {
            super.touchDragged(x, y, pointer);
        }
    }

    public void setWidget(Actor widget) {
        if (widget == null) {
            throw new IllegalArgumentException("widget cannot be null.");
        }
        if (this.widget != null) {
            super.removeActor(this.widget);
        }
        this.widget = widget;
        if (widget != null) {
            super.addActor(widget);
        }
    }

    @Override
    public void addActor(Actor actor) {
        throw new UnsupportedOperationException("Use ScrollPane#setWidget.");
    }

    @Override
    public void addActorAt(int index, Actor actor) {
        throw new UnsupportedOperationException("Use ScrollPane#setWidget.");
    }

    @Override
    public void addActorBefore(Actor actorBefore, Actor actor) {
        throw new UnsupportedOperationException("Use ScrollPane#setWidget.");
    }

    @Override
    public void removeActor(Actor actor) {
        throw new UnsupportedOperationException("Use ScrollPane#setWidget(null).");
    }

    @Override
    public void removeActorRecursive(Actor actor) {
        if (actor == this.widget) {
            this.setWidget(null);
        } else if (this.widget instanceof Group) {
            ((Group)this.widget).removeActorRecursive(actor);
        }
    }

    @Override
    public Actor hit(float x, float y) {
        if (x > 0.0f && x < this.width && y > 0.0f && y < this.height) {
            return super.hit(x, y);
        }
        return null;
    }

    public void setScrollX(float pixels) {
        this.amountX = pixels;
    }

    public float getScrollX() {
        return this.amountX;
    }

    public void setScrollY(float pixels) {
        this.amountY = pixels;
    }

    public float getScrollY() {
        return this.amountY;
    }

    public float getScrollPercentX() {
        return this.amountX / this.widgetAreaBounds.x;
    }

    public void setScrollPercentX(float percentX) {
        this.amountX = this.widgetAreaBounds.x * percentX;
    }

    public float getScrollPercentY() {
        return this.amountY / this.widgetAreaBounds.y;
    }

    public void setScrollPercentY(float percentY) {
        this.amountY = this.widgetAreaBounds.y * percentY;
    }

    public float getMaxX() {
        return this.widgetAreaBounds.x;
    }

    public float getMaxY() {
        return this.widgetAreaBounds.y;
    }

    public void setScrollingDisabled(boolean x, boolean y) {
        this.disableX = x;
        this.disableY = y;
    }

    public static class ScrollPaneStyle {
        public NinePatch background;
        public NinePatch hScroll;
        public NinePatch hScrollKnob;
        public NinePatch vScroll;
        public NinePatch vScrollKnob;

        public ScrollPaneStyle() {
        }

        public ScrollPaneStyle(NinePatch backgroundPatch, NinePatch hScroll, NinePatch hScrollKnob, NinePatch vScroll, NinePatch vScrollKnob) {
            this.background = backgroundPatch;
            this.hScroll = hScroll;
            this.hScrollKnob = hScrollKnob;
            this.vScroll = vScroll;
            this.vScrollKnob = vScrollKnob;
        }
    }
}

