/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.scenes.scene2d.actions;

import com.badlogic.gdx.scenes.scene2d.Action;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.CompositeAction;
import com.badlogic.gdx.scenes.scene2d.actions.ActionResetingPool;

public class Sequence
extends CompositeAction {
    static final ActionResetingPool<Sequence> pool = new ActionResetingPool<Sequence>(4, 100){

        @Override
        protected Sequence newObject() {
            return new Sequence();
        }
    };
    protected Actor target;
    protected int currAction = 0;

    public static Sequence $(Action ... actions) {
        Sequence sequence = (Sequence)pool.obtain();
        sequence.actions.clear();
        int len = actions.length;
        for (int i = 0; i < len; ++i) {
            sequence.actions.add(actions[i]);
        }
        return sequence;
    }

    @Override
    public void setTarget(Actor actor) {
        this.target = actor;
        if (this.actions.size() > 0) {
            ((Action)this.actions.get(0)).setTarget(this.target);
        }
        this.currAction = 0;
    }

    @Override
    public void act(float delta) {
        if (this.actions.size() == 0) {
            this.currAction = 1;
            return;
        }
        if (this.currAction >= this.actions.size()) {
            this.callActionCompletedListener();
            return;
        }
        ((Action)this.actions.get(this.currAction)).act(delta);
        if (((Action)this.actions.get(this.currAction)).isDone()) {
            ((Action)this.actions.get(this.currAction)).callActionCompletedListener();
            ++this.currAction;
            if (this.currAction < this.actions.size()) {
                ((Action)this.actions.get(this.currAction)).setTarget(this.target);
            }
        }
    }

    @Override
    public boolean isDone() {
        return this.currAction >= this.actions.size();
    }

    @Override
    public void finish() {
        pool.free(this);
        super.finish();
    }

    @Override
    public Action copy() {
        Sequence action = (Sequence)pool.obtain();
        action.actions.clear();
        int len = this.actions.size();
        for (int i = 0; i < len; ++i) {
            action.actions.add(((Action)this.actions.get(i)).copy());
        }
        return action;
    }

    @Override
    public Actor getTarget() {
        return this.target;
    }
}

