/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.scenes.scene2d.actions;

import com.badlogic.gdx.scenes.scene2d.Action;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.AnimationAction;
import com.badlogic.gdx.scenes.scene2d.actions.ActionResetingPool;

public class ScaleTo
extends AnimationAction {
    private static final ActionResetingPool<ScaleTo> pool = new ActionResetingPool<ScaleTo>(4, 100){

        @Override
        protected ScaleTo newObject() {
            return new ScaleTo();
        }
    };
    protected float scaleX;
    protected float scaleY;
    protected float startScaleX;
    protected float startScaleY;
    protected float deltaScaleX;
    protected float deltaScaleY;

    public static ScaleTo $(float scaleX, float scaleY, float duration) {
        ScaleTo action = (ScaleTo)pool.obtain();
        action.scaleX = scaleX;
        action.scaleY = scaleY;
        action.duration = duration;
        action.invDuration = 1.0f / duration;
        return action;
    }

    @Override
    public void setTarget(Actor actor) {
        this.target = actor;
        this.startScaleX = this.target.scaleX;
        this.deltaScaleX = this.scaleX - this.target.scaleX;
        this.startScaleY = this.target.scaleY;
        this.deltaScaleY = this.scaleY - this.target.scaleY;
        this.taken = 0.0f;
        this.done = false;
    }

    @Override
    public void act(float delta) {
        float alpha = this.createInterpolatedAlpha(delta);
        if (this.done) {
            this.target.scaleX = this.scaleX;
            this.target.scaleY = this.scaleY;
        } else {
            this.target.scaleX = this.startScaleX + this.deltaScaleX * alpha;
            this.target.scaleY = this.startScaleY + this.deltaScaleY * alpha;
        }
    }

    @Override
    public void finish() {
        super.finish();
        pool.free(this);
    }

    @Override
    public Action copy() {
        ScaleTo scaleTo = ScaleTo.$(this.scaleX, this.scaleY, this.duration);
        if (this.interpolator != null) {
            scaleTo.setInterpolator(this.interpolator.copy());
        }
        return scaleTo;
    }
}

