/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.scenes.scene2d.actions;

import com.badlogic.gdx.scenes.scene2d.Action;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.AnimationAction;
import com.badlogic.gdx.scenes.scene2d.actions.ActionResetingPool;

public class FadeIn
extends AnimationAction {
    private static final ActionResetingPool<FadeIn> pool = new ActionResetingPool<FadeIn>(4, 100){

        @Override
        protected FadeIn newObject() {
            return new FadeIn();
        }
    };
    protected float startAlpha = 0.0f;
    protected float deltaAlpha = 0.0f;

    public static FadeIn $(float duration) {
        FadeIn action = (FadeIn)pool.obtain();
        action.duration = duration;
        action.invDuration = 1.0f / duration;
        return action;
    }

    @Override
    public void setTarget(Actor actor) {
        this.target = actor;
        this.startAlpha = this.target.color.a;
        this.deltaAlpha = 1.0f - this.target.color.a;
        this.taken = 0.0f;
        this.done = false;
    }

    @Override
    public void act(float delta) {
        float alpha = this.createInterpolatedAlpha(delta);
        this.target.color.a = this.done ? 1.0f : this.startAlpha + this.deltaAlpha * alpha;
    }

    @Override
    public void finish() {
        pool.free(this);
        if (this.listener != null) {
            this.listener.completed(this);
        }
    }

    @Override
    public Action copy() {
        FadeIn fadeIn = FadeIn.$(this.duration);
        if (this.interpolator != null) {
            fadeIn.setInterpolator(this.interpolator.copy());
        }
        return fadeIn;
    }
}

