/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.scenes.scene2d;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Action;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.utils.PooledLinkedList;

public abstract class Actor {
    public Group parent;
    public final String name;
    public boolean touchable = true;
    public boolean visible = true;
    public float x;
    public float y;
    public float width;
    public float height;
    public float originX;
    public float originY;
    public float scaleX = 1.0f;
    public float scaleY = 1.0f;
    public float rotation;
    public final Color color = new Color(1.0f, 1.0f, 1.0f, 1.0f);
    protected PooledLinkedList<Action> actions = new PooledLinkedList(10);
    private boolean toRemove;
    protected Stage stage;

    public Actor() {
        this.name = null;
    }

    public Actor(String name) {
        this.name = name;
    }

    public abstract void draw(SpriteBatch var1, float var2);

    public boolean touchDown(float x, float y, int pointer) {
        return false;
    }

    public void touchUp(float x, float y, int pointer) {
    }

    public void touchDragged(float x, float y, int pointer) {
    }

    public boolean touchMoved(float x, float y) {
        return false;
    }

    public boolean scrolled(int amount) {
        return false;
    }

    public boolean keyDown(int keycode) {
        return false;
    }

    public boolean keyUp(int keycode) {
        return false;
    }

    public boolean keyTyped(char character) {
        return false;
    }

    public abstract Actor hit(float var1, float var2);

    public void toLocalCoordinates(Vector2 point) {
        if (this.parent == null) {
            return;
        }
        this.parent.toLocalCoordinates(point);
        Group.toChildCoordinates(this, point.x, point.y, point);
    }

    public void remove() {
        if (this.parent != null) {
            this.parent.removeActor(this);
        }
    }

    public void act(float delta) {
        Action action;
        this.actions.iter();
        while ((action = this.actions.next()) != null) {
            action.act(delta);
            if (!action.isDone()) continue;
            action.finish();
            this.actions.remove();
        }
    }

    public void action(Action action) {
        action.setTarget(this);
        this.actions.add(action);
    }

    public void clearActions() {
        this.actions.clear();
    }

    public String toString() {
        String name;
        String string = name = this.name != null ? this.name : this.getClass().getName();
        if (name.equals("")) {
            name = this.getClass().getName();
        }
        return name + " pos=" + this.x + "," + this.y + " origin=" + this.originX + "," + this.originY + " size=" + this.width + "," + this.height;
    }

    public void markToRemove(boolean remove) {
        this.toRemove = remove;
    }

    public boolean isMarkedToRemove() {
        return this.toRemove;
    }

    public Stage getStage() {
        return this.stage;
    }
}

