/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.math;

import com.badlogic.gdx.utils.NumberUtils;
import java.util.Random;

public class MathUtils {
    public static final float PI = (float)Math.PI;
    private static final int SIN_BITS = 13;
    private static final int SIN_MASK = 8191;
    private static final int SIN_COUNT = 8192;
    private static final float radFull = (float)Math.PI * 2;
    private static final float degFull = 360.0f;
    private static final float radToIndex = 1303.7972f;
    private static final float degToIndex = 22.755556f;
    public static final float radiansToDegrees = 57.295776f;
    public static final float degreesToRadians = (float)Math.PI / 180;
    public static final float[] sin;
    public static final float[] cos;
    private static final int ATAN2_BITS = 7;
    private static final int ATAN2_BITS2 = 14;
    private static final int ATAN2_MASK = 16383;
    private static final int ATAN2_COUNT = 16384;
    private static final int ATAN2_DIM;
    private static final float INV_ATAN2_DIM_MINUS_1;
    private static final float[] atan2;
    public static Random random;
    private static final int BIG_ENOUGH_INT = 16384;
    private static final double BIG_ENOUGH_FLOOR = 16384.0;
    private static final double CEIL = 0.9999999;
    private static final double BIG_ENOUGH_CEIL;
    private static final double BIG_ENOUGH_ROUND = 16384.5;

    public static final float sin(float rad) {
        return sin[(int)(rad * 1303.7972f) & 0x1FFF];
    }

    public static final float cos(float rad) {
        return cos[(int)(rad * 1303.7972f) & 0x1FFF];
    }

    public static final float sinDeg(float deg) {
        return sin[(int)(deg * 22.755556f) & 0x1FFF];
    }

    public static final float cosDeg(float deg) {
        return cos[(int)(deg * 22.755556f) & 0x1FFF];
    }

    public static final float atan2(float y, float x) {
        float add;
        float mul;
        if (x < 0.0f) {
            if (y < 0.0f) {
                y = -y;
                mul = 1.0f;
            } else {
                mul = -1.0f;
            }
            x = -x;
            add = (float)(-Math.PI);
        } else {
            if (y < 0.0f) {
                y = -y;
                mul = -1.0f;
            } else {
                mul = 1.0f;
            }
            add = 0.0f;
        }
        float invDiv = 1.0f / ((x < y ? y : x) * INV_ATAN2_DIM_MINUS_1);
        int xi = (int)(x * invDiv);
        int yi = (int)(y * invDiv);
        return (atan2[yi * ATAN2_DIM + xi] + add) * mul;
    }

    public static final int random(int range) {
        return random.nextInt(range + 1);
    }

    public static final int random(int start, int end) {
        return start + random.nextInt(end - start + 1);
    }

    public static final boolean randomBoolean() {
        return random.nextBoolean();
    }

    public static final float random() {
        return random.nextFloat();
    }

    public static final float random(float range) {
        return random.nextFloat() * range;
    }

    public static final float random(float start, float end) {
        return start + random.nextFloat() * (end - start);
    }

    public static int nextPowerOfTwo(int value) {
        if (value == 0) {
            return 1;
        }
        --value;
        value |= value >> 1;
        value |= value >> 2;
        value |= value >> 4;
        value |= value >> 8;
        value |= value >> 16;
        return value + 1;
    }

    public static boolean isPowerOfTwo(int value) {
        return value != 0 && (value & value - 1) == 0;
    }

    public static int clamp(int value, int min, int max) {
        if (value < min) {
            return min;
        }
        if (value > max) {
            return max;
        }
        return value;
    }

    public static short clamp(short value, short min, short max) {
        if (value < min) {
            return min;
        }
        if (value > max) {
            return max;
        }
        return value;
    }

    public static float clamp(float value, float min, float max) {
        if (value < min) {
            return min;
        }
        if (value > max) {
            return max;
        }
        return value;
    }

    public static int floor(float x) {
        return (int)((double)x + 16384.0) - 16384;
    }

    public static int floorPositive(float x) {
        return (int)x;
    }

    public static int ceil(float x) {
        return (int)((double)x + BIG_ENOUGH_CEIL) - 16384;
    }

    public static int ceilPositive(float x) {
        return (int)((double)x + 0.9999999);
    }

    public static int round(float x) {
        return (int)((double)x + 16384.5) - 16384;
    }

    public static int roundPositive(float x) {
        return (int)(x + 0.5f);
    }

    static {
        int i;
        sin = new float[8192];
        cos = new float[8192];
        for (i = 0; i < 8192; ++i) {
            float a = ((float)i + 0.5f) / 8192.0f * ((float)Math.PI * 2);
            MathUtils.sin[i] = (float)Math.sin(a);
            MathUtils.cos[i] = (float)Math.cos(a);
        }
        for (i = 0; i < 360; i += 90) {
            MathUtils.sin[(int)((float)i * 22.755556f) & 0x1FFF] = (float)Math.sin((float)i * ((float)Math.PI / 180));
            MathUtils.cos[(int)((float)i * 22.755556f) & 0x1FFF] = (float)Math.cos((float)i * ((float)Math.PI / 180));
        }
        ATAN2_DIM = (int)Math.sqrt(16384.0);
        INV_ATAN2_DIM_MINUS_1 = 1.0f / (float)(ATAN2_DIM - 1);
        atan2 = new float[16384];
        for (i = 0; i < ATAN2_DIM; ++i) {
            for (int j = 0; j < ATAN2_DIM; ++j) {
                float x0 = (float)i / (float)ATAN2_DIM;
                float y0 = (float)j / (float)ATAN2_DIM;
                MathUtils.atan2[j * MathUtils.ATAN2_DIM + i] = (float)Math.atan2(y0, x0);
            }
        }
        random = new Random();
        BIG_ENOUGH_CEIL = NumberUtils.longBitsToDouble(NumberUtils.doubleToLongBits(16385.0) - 1L);
    }
}

