/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.input;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.InputAdapter;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.utils.TimeUtils;

public class GestureDetector
extends InputAdapter {
    private final int tapSquareSize;
    private final long tapCountInterval;
    private final long longPressDuration;
    private long maxFlingDelay;
    private boolean inTapSquare;
    private int tapCount;
    private long lastTapTime;
    private boolean longPressFired;
    private boolean pinching;
    private boolean panning;
    private final VelocityTracker tracker = new VelocityTracker();
    private int tapSquareCenterX;
    private int tapSquareCenterY;
    private long gestureStartTime;
    private Vector2 firstPointer = new Vector2();
    private Vector2 secondPointer = new Vector2();
    private Vector2 initialFirstPointer = new Vector2();
    private Vector2 initialSecondPointer = new Vector2();
    private final GestureListener listener;

    public GestureDetector(GestureListener listener) {
        this(20, 0.4f, 1.5f, 0.15f, listener);
    }

    public GestureDetector(int halfTapSquareSize, float tapCountInterval, float longPressDuration, float maxFlingDelay, GestureListener listener) {
        this.tapSquareSize = halfTapSquareSize;
        this.tapCountInterval = (long)(tapCountInterval * 1.0E9f);
        this.longPressDuration = (long)(longPressDuration * 1.0E9f);
        this.maxFlingDelay = (long)(maxFlingDelay * 1.0E9f);
        this.listener = listener;
    }

    @Override
    public boolean touchDown(int x, int y, int pointer, int button) {
        if (pointer > 1) {
            return false;
        }
        if (pointer == 0) {
            this.firstPointer.set(x, y);
            this.gestureStartTime = Gdx.input.getCurrentEventTime();
            this.tracker.start(x, y, this.gestureStartTime);
            if (Gdx.input.isTouched(1)) {
                this.inTapSquare = false;
                this.pinching = true;
                this.initialFirstPointer.set(this.firstPointer);
                this.initialSecondPointer.set(this.secondPointer);
            } else {
                this.inTapSquare = true;
                this.pinching = false;
                this.longPressFired = false;
                this.tapSquareCenterX = x;
                this.tapSquareCenterY = y;
            }
        } else {
            this.secondPointer.set(x, y);
            this.inTapSquare = false;
            this.pinching = true;
            this.initialFirstPointer.set(this.firstPointer);
            this.initialSecondPointer.set(this.secondPointer);
        }
        return this.listener.touchDown(x, y, pointer);
    }

    @Override
    public boolean touchDragged(int x, int y, int pointer) {
        if (pointer > 1) {
            return false;
        }
        if (this.pinching) {
            if (pointer == 0) {
                this.firstPointer.set(x, y);
            } else {
                this.secondPointer.set(x, y);
            }
            if (this.listener != null) {
                boolean result = this.listener.pinch(this.initialFirstPointer, this.initialSecondPointer, this.firstPointer, this.secondPointer);
                return this.listener.zoom(this.initialFirstPointer.dst(this.initialSecondPointer), this.firstPointer.dst(this.secondPointer)) || result;
            }
            return false;
        }
        this.tracker.update(x, y, Gdx.input.getCurrentEventTime());
        if (!this.inTapSquare || Math.abs(x - this.tapSquareCenterX) >= this.tapSquareSize || Math.abs(y - this.tapSquareCenterY) >= this.tapSquareSize) {
            this.inTapSquare = false;
        }
        if (!this.inTapSquare) {
            this.inTapSquare = false;
            this.panning = true;
            return this.listener.pan(this.tracker.lastX, this.tracker.lastY, this.tracker.deltaX, this.tracker.deltaY);
        }
        if (!this.longPressFired && Gdx.input.getCurrentEventTime() - this.gestureStartTime > this.longPressDuration) {
            this.longPressFired = true;
            return this.listener.longPress(x, y);
        }
        return false;
    }

    @Override
    public boolean touchUp(int x, int y, int pointer, int button) {
        if (pointer > 1) {
            return false;
        }
        this.panning = false;
        if (this.inTapSquare & !this.longPressFired) {
            if (TimeUtils.nanoTime() - this.lastTapTime > this.tapCountInterval) {
                this.tapCount = 0;
            }
            ++this.tapCount;
            this.lastTapTime = TimeUtils.nanoTime();
            this.gestureStartTime = 0L;
            return this.listener.tap(this.tapSquareCenterX, this.tapSquareCenterY, this.tapCount);
        }
        if (this.pinching) {
            this.pinching = false;
            this.panning = true;
            if (pointer == 0) {
                this.tracker.start((int)this.secondPointer.x, (int)this.secondPointer.y, Gdx.input.getCurrentEventTime());
            } else {
                this.tracker.start((int)this.firstPointer.x, (int)this.firstPointer.y, Gdx.input.getCurrentEventTime());
            }
        } else {
            this.gestureStartTime = 0L;
            long time = Gdx.input.getCurrentEventTime();
            if (time - this.tracker.lastTime < this.maxFlingDelay) {
                this.tracker.update(x, y, time);
                return this.listener.fling(this.tracker.getVelocityX(), this.tracker.getVelocityY());
            }
        }
        return false;
    }

    public boolean isLongPressed() {
        return this.isLongPressed(this.longPressDuration);
    }

    public boolean isLongPressed(float duration) {
        if (this.gestureStartTime == 0L) {
            return false;
        }
        return TimeUtils.nanoTime() - this.gestureStartTime > (long)(duration * 1.0E9f);
    }

    public boolean isPanning() {
        return this.panning;
    }

    public void reset() {
        this.gestureStartTime = 0L;
        this.panning = false;
        this.inTapSquare = false;
    }

    static class VelocityTracker {
        int sampleSize = 10;
        int lastX;
        int lastY;
        int deltaX;
        int deltaY;
        long lastTime;
        int numSamples;
        float[] meanX = new float[this.sampleSize];
        float[] meanY = new float[this.sampleSize];
        long[] meanTime = new long[this.sampleSize];

        VelocityTracker() {
        }

        public void start(int x, int y, long timeStamp) {
            this.lastX = x;
            this.lastY = y;
            this.deltaX = 0;
            this.deltaY = 0;
            this.numSamples = 0;
            for (int i = 0; i < this.sampleSize; ++i) {
                this.meanX[i] = 0.0f;
                this.meanY[i] = 0.0f;
                this.meanTime[i] = 0L;
            }
            this.lastTime = timeStamp;
        }

        public void update(int x, int y, long timeStamp) {
            long currTime = timeStamp;
            this.deltaX = x - this.lastX;
            this.deltaY = y - this.lastY;
            this.lastX = x;
            this.lastY = y;
            long deltaTime = currTime - this.lastTime;
            this.lastTime = currTime;
            int index = this.numSamples % this.sampleSize;
            this.meanX[index] = this.deltaX;
            this.meanY[index] = this.deltaY;
            this.meanTime[index] = deltaTime;
            ++this.numSamples;
        }

        public float getVelocityX() {
            float meanX = this.getAverage(this.meanX, this.numSamples);
            float meanTime = (float)this.getAverage(this.meanTime, this.numSamples) / 1.0E9f;
            if (meanTime == 0.0f) {
                return 0.0f;
            }
            return meanX / meanTime;
        }

        public float getVelocityY() {
            float meanY = this.getAverage(this.meanY, this.numSamples);
            float meanTime = (float)this.getAverage(this.meanTime, this.numSamples) / 1.0E9f;
            if (meanTime == 0.0f) {
                return 0.0f;
            }
            return meanY / meanTime;
        }

        private float getAverage(float[] values, int numSamples) {
            numSamples = Math.min(this.sampleSize, numSamples);
            float sum = 0.0f;
            for (int i = 0; i < numSamples; ++i) {
                sum += values[i];
            }
            return sum / (float)numSamples;
        }

        private long getAverage(long[] values, int numSamples) {
            numSamples = Math.min(this.sampleSize, numSamples);
            long sum = 0L;
            for (int i = 0; i < numSamples; ++i) {
                sum += values[i];
            }
            if (numSamples == 0) {
                return 0L;
            }
            return sum / (long)numSamples;
        }

        private float getSum(float[] values, int numSamples) {
            numSamples = Math.min(this.sampleSize, numSamples);
            float sum = 0.0f;
            for (int i = 0; i < numSamples; ++i) {
                sum += values[i];
            }
            if (numSamples == 0) {
                return 0.0f;
            }
            return sum;
        }
    }

    public static class GestureAdapter
    implements GestureListener {
        @Override
        public boolean touchDown(int x, int y, int pointer) {
            return false;
        }

        @Override
        public boolean tap(int x, int y, int count) {
            return false;
        }

        @Override
        public boolean longPress(int x, int y) {
            return false;
        }

        @Override
        public boolean fling(float velocityX, float velocityY) {
            return false;
        }

        @Override
        public boolean pan(int x, int y, int deltaX, int deltaY) {
            return false;
        }

        @Override
        public boolean zoom(float originalDistance, float currentDistance) {
            return false;
        }

        @Override
        public boolean pinch(Vector2 initialFirstPointer, Vector2 initialSecondPointer, Vector2 firstPointer, Vector2 secondPointer) {
            return false;
        }
    }

    public static interface GestureListener {
        public boolean touchDown(int var1, int var2, int var3);

        public boolean tap(int var1, int var2, int var3);

        public boolean longPress(int var1, int var2);

        public boolean fling(float var1, float var2);

        public boolean pan(int var1, int var2, int var3, int var4);

        public boolean zoom(float var1, float var2);

        public boolean pinch(Vector2 var1, Vector2 var2, Vector2 var3, Vector2 var4);
    }
}

