/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.assets.loaders;

import com.badlogic.gdx.assets.AssetDescriptor;
import com.badlogic.gdx.assets.AssetLoaderParameters;
import com.badlogic.gdx.assets.AssetManager;
import com.badlogic.gdx.assets.loaders.AsynchronousAssetLoader;
import com.badlogic.gdx.assets.loaders.FileHandleResolver;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.utils.Array;

public class BitmapFontLoader
extends AsynchronousAssetLoader<BitmapFont, BitmapFontParameter> {
    BitmapFont.BitmapFontData data;

    public BitmapFontLoader(FileHandleResolver resolver) {
        super(resolver);
    }

    @Override
    public Array<AssetDescriptor> getDependencies(String fileName, BitmapFontParameter parameter) {
        Array<AssetDescriptor> deps = new Array<AssetDescriptor>();
        if (parameter != null && parameter.bitmapFontData != null) {
            this.data = parameter.bitmapFontData;
            return deps;
        }
        FileHandle handle = this.resolve(fileName);
        this.data = new BitmapFont.BitmapFontData(handle, parameter != null ? parameter.flip : false);
        deps.add(new AssetDescriptor<Texture>(this.data.getImagePath(), Texture.class));
        return deps;
    }

    @Override
    public void loadAsync(AssetManager manager, String fileName, BitmapFontParameter parameter) {
    }

    @Override
    public BitmapFont loadSync(AssetManager manager, String fileName, BitmapFontParameter parameter) {
        FileHandle handle = this.resolve(fileName);
        TextureRegion region = new TextureRegion(manager.get(this.data.getImagePath(), Texture.class));
        if (parameter != null) {
            region.getTexture().setFilter(parameter.minFitler, parameter.maxFilter);
        }
        return new BitmapFont(this.data, region, true);
    }

    public static class BitmapFontParameter
    extends AssetLoaderParameters<BitmapFont> {
        public boolean flip = false;
        public Texture.TextureFilter minFitler = Texture.TextureFilter.Nearest;
        public Texture.TextureFilter maxFilter = Texture.TextureFilter.Nearest;
        public BitmapFont.BitmapFontData bitmapFontData = null;
    }
}

