/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.backends.android;

import android.media.MediaPlayer;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.audio.Music;
import com.badlogic.gdx.backends.android.AndroidAudio;
import java.io.IOException;
import java.util.List;

public class AndroidMusic
implements Music {
    private final AndroidAudio audio;
    private MediaPlayer player;
    private boolean isPrepared = true;

    AndroidMusic(AndroidAudio audio, MediaPlayer player) {
        this.audio = audio;
        this.player = player;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        if (this.player == null) {
            return;
        }
        try {
            if (this.player.isPlaying()) {
                this.player.stop();
            }
            this.player.release();
        }
        catch (Throwable t) {
            Gdx.app.log("AndroidMusic", "error while disposing AndroidMusic instance, non-fatal");
        }
        finally {
            this.player = null;
            List<AndroidMusic> list = this.audio.musics;
            synchronized (list) {
                this.audio.musics.remove(this);
            }
        }
    }

    public boolean isLooping() {
        return this.player.isLooping();
    }

    public boolean isPlaying() {
        return this.player.isPlaying();
    }

    public void pause() {
        if (this.player.isPlaying()) {
            this.player.pause();
        }
    }

    public void play() {
        if (this.player.isPlaying()) {
            return;
        }
        try {
            if (!this.isPrepared) {
                this.player.prepare();
                this.isPrepared = true;
            }
            this.player.start();
        }
        catch (IllegalStateException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void setLooping(boolean isLooping) {
        this.player.setLooping(isLooping);
    }

    public void setVolume(float volume) {
        this.player.setVolume(volume, volume);
    }

    public void stop() {
        if (this.isPrepared) {
            this.player.seekTo(0);
        }
        this.player.stop();
        this.isPrepared = false;
    }

    public float getPosition() {
        return (float)this.player.getCurrentPosition() / 1000.0f;
    }
}

