/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.backends.android;

import android.app.Activity;
import android.content.Context;
import android.opengl.GLSurfaceView;
import android.os.Build;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.View;
import com.badlogic.gdx.Application;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Graphics;
import com.badlogic.gdx.backends.android.AndroidApplication;
import com.badlogic.gdx.backends.android.AndroidApplicationConfiguration;
import com.badlogic.gdx.backends.android.AndroidGL10;
import com.badlogic.gdx.backends.android.AndroidGL11;
import com.badlogic.gdx.backends.android.AndroidGL20;
import com.badlogic.gdx.backends.android.AndroidGLU;
import com.badlogic.gdx.backends.android.surfaceview.GLSurfaceView20;
import com.badlogic.gdx.backends.android.surfaceview.GLSurfaceViewCupcake;
import com.badlogic.gdx.backends.android.surfaceview.GdxEglConfigChooser;
import com.badlogic.gdx.backends.android.surfaceview.ResolutionStrategy;
import com.badlogic.gdx.graphics.GL10;
import com.badlogic.gdx.graphics.GL11;
import com.badlogic.gdx.graphics.GL20;
import com.badlogic.gdx.graphics.GLCommon;
import com.badlogic.gdx.graphics.GLU;
import com.badlogic.gdx.graphics.Mesh;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.glutils.FrameBuffer;
import com.badlogic.gdx.graphics.glutils.ShaderProgram;
import com.badlogic.gdx.math.WindowedMean;
import com.badlogic.gdx.utils.Array;
import java.lang.reflect.Method;
import javax.microedition.khronos.egl.EGL10;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.egl.EGLContext;
import javax.microedition.khronos.egl.EGLDisplay;

public final class AndroidGraphics
implements Graphics,
GLSurfaceView.Renderer {
    final View view;
    int width;
    int height;
    AndroidApplication app;
    GLCommon gl;
    GL10 gl10;
    GL11 gl11;
    GL20 gl20;
    GLU glu;
    EGLContext eglContext;
    String extensions;
    private long lastFrameTime = System.nanoTime();
    private float deltaTime = 0.0f;
    private long frameStart = System.nanoTime();
    private int frames = 0;
    private int fps;
    private WindowedMean mean = new WindowedMean(5);
    volatile boolean created = false;
    volatile boolean running = false;
    volatile boolean pause = false;
    volatile boolean resume = false;
    volatile boolean destroy = false;
    private float ppiX = 0.0f;
    private float ppiY = 0.0f;
    private float ppcX = 0.0f;
    private float ppcY = 0.0f;
    private float density = 1.0f;
    private final AndroidApplicationConfiguration config;
    private Graphics.BufferFormat bufferFormat = new Graphics.BufferFormat(5, 6, 5, 0, 16, 0, 0, false);
    private boolean isContinuous = true;
    int[] value = new int[1];
    Object synch = new Object();

    public AndroidGraphics(AndroidApplication activity, AndroidApplicationConfiguration config, ResolutionStrategy resolutionStrategy) {
        this.config = config;
        this.view = this.createGLSurfaceView(activity, config.useGL20, resolutionStrategy);
        this.setPreserveContext(this.view);
        this.view.setFocusable(true);
        this.view.setFocusableInTouchMode(true);
        this.app = activity;
    }

    private void setPreserveContext(View view) {
        int sdkVersion = Integer.parseInt(Build.VERSION.SDK);
        if (sdkVersion >= 11 && view instanceof GLSurfaceView20) {
            try {
                Method method = null;
                for (Method m : view.getClass().getMethods()) {
                    if (!m.getName().equals("setPreserveEGLContextOnPause")) continue;
                    method = m;
                    break;
                }
                if (method != null) {
                    method.invoke((Object)((GLSurfaceView20)view), true);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private View createGLSurfaceView(Activity activity, boolean useGL2, final ResolutionStrategy resolutionStrategy) {
        GLSurfaceView.EGLConfigChooser configChooser = this.getEglConfigChooser();
        if (useGL2 && this.checkGL20()) {
            GLSurfaceView20 view = new GLSurfaceView20((Context)activity, resolutionStrategy);
            if (configChooser != null) {
                view.setEGLConfigChooser(configChooser);
            } else {
                view.setEGLConfigChooser(this.config.r, this.config.g, this.config.b, this.config.a, this.config.depth, this.config.stencil);
            }
            view.setRenderer(this);
            return view;
        }
        this.config.useGL20 = false;
        configChooser = this.getEglConfigChooser();
        int sdkVersion = Integer.parseInt(Build.VERSION.SDK);
        if (sdkVersion >= 11) {
            GLSurfaceView view = new GLSurfaceView((Context)activity){

                protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
                    ResolutionStrategy.MeasuredDimension measures = resolutionStrategy.calcMeasures(widthMeasureSpec, heightMeasureSpec);
                    this.setMeasuredDimension(measures.width, measures.height);
                }
            };
            if (configChooser != null) {
                view.setEGLConfigChooser(configChooser);
            } else {
                view.setEGLConfigChooser(this.config.r, this.config.g, this.config.b, this.config.a, this.config.depth, this.config.stencil);
            }
            view.setRenderer((GLSurfaceView.Renderer)this);
            return view;
        }
        GLSurfaceViewCupcake view = new GLSurfaceViewCupcake((Context)activity, resolutionStrategy);
        if (configChooser != null) {
            view.setEGLConfigChooser(configChooser);
        } else {
            view.setEGLConfigChooser(this.config.r, this.config.g, this.config.b, this.config.a, this.config.depth, this.config.stencil);
        }
        view.setRenderer(this);
        return view;
    }

    private GLSurfaceView.EGLConfigChooser getEglConfigChooser() {
        return new GdxEglConfigChooser(this.config.r, this.config.g, this.config.b, this.config.a, this.config.depth, this.config.stencil, this.config.numSamples, this.config.useGL20);
    }

    private void updatePpi() {
        DisplayMetrics metrics = new DisplayMetrics();
        this.app.getWindowManager().getDefaultDisplay().getMetrics(metrics);
        this.ppiX = metrics.xdpi;
        this.ppiY = metrics.ydpi;
        this.ppcX = metrics.xdpi / 2.54f;
        this.ppcY = metrics.ydpi / 2.54f;
        this.density = metrics.density;
    }

    private boolean checkGL20() {
        EGL10 egl = (EGL10)EGLContext.getEGL();
        EGLDisplay display = egl.eglGetDisplay(EGL10.EGL_DEFAULT_DISPLAY);
        int[] version = new int[2];
        egl.eglInitialize(display, version);
        int EGL_OPENGL_ES2_BIT = 4;
        int[] configAttribs = new int[]{12324, 4, 12323, 4, 12322, 4, 12352, EGL_OPENGL_ES2_BIT, 12344};
        EGLConfig[] configs = new EGLConfig[10];
        int[] num_config = new int[1];
        egl.eglChooseConfig(display, configAttribs, configs, 10, num_config);
        egl.eglTerminate(display);
        return num_config[0] > 0;
    }

    public GL10 getGL10() {
        return this.gl10;
    }

    public GL11 getGL11() {
        return this.gl11;
    }

    public GL20 getGL20() {
        return this.gl20;
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    public boolean isGL11Available() {
        return this.gl11 != null;
    }

    public boolean isGL20Available() {
        return this.gl20 != null;
    }

    private static boolean isPowerOfTwo(int value) {
        return value != 0 && (value & value - 1) == 0;
    }

    private void setupGL(javax.microedition.khronos.opengles.GL10 gl) {
        if (this.gl10 != null || this.gl20 != null) {
            return;
        }
        if (this.view instanceof GLSurfaceView20) {
            this.gl20 = new AndroidGL20();
            this.gl = this.gl20;
        } else {
            String renderer;
            this.gl10 = new AndroidGL10(gl);
            this.gl = this.gl10;
            if (!(!(gl instanceof javax.microedition.khronos.opengles.GL11) || (renderer = gl.glGetString(7937)) == null || renderer.toLowerCase().contains("pixelflinger") || Build.MODEL.equals("MB200") || Build.MODEL.equals("MB220") || Build.MODEL.contains("Behold"))) {
                this.gl11 = new AndroidGL11((javax.microedition.khronos.opengles.GL10)((javax.microedition.khronos.opengles.GL11)gl));
                this.gl10 = this.gl11;
            }
        }
        this.glu = new AndroidGLU();
        Gdx.gl = this.gl;
        Gdx.gl10 = this.gl10;
        Gdx.gl11 = this.gl11;
        Gdx.gl20 = this.gl20;
        Gdx.glu = this.glu;
        Gdx.app.log("AndroidGraphics", "OGL renderer: " + gl.glGetString(7937));
        Gdx.app.log("AndroidGraphics", "OGL vendor: " + gl.glGetString(7936));
        Gdx.app.log("AndroidGraphics", "OGL version: " + gl.glGetString(7938));
        Gdx.app.log("AndroidGraphics", "OGL extensions: " + gl.glGetString(7939));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onSurfaceChanged(javax.microedition.khronos.opengles.GL10 gl, int width, int height) {
        this.width = width;
        this.height = height;
        this.updatePpi();
        gl.glViewport(0, 0, this.width, this.height);
        if (!this.created) {
            this.app.listener.create();
            this.created = true;
            AndroidGraphics androidGraphics = this;
            synchronized (androidGraphics) {
                this.running = true;
            }
        }
        this.app.listener.resize(width, height);
    }

    public void onSurfaceCreated(javax.microedition.khronos.opengles.GL10 gl, EGLConfig config) {
        this.eglContext = ((EGL10)EGLContext.getEGL()).eglGetCurrentContext();
        this.setupGL(gl);
        this.logConfig(config);
        this.updatePpi();
        Mesh.invalidateAllMeshes((Application)this.app);
        Texture.invalidateAllTextures((Application)this.app);
        ShaderProgram.invalidateAllShaderPrograms((Application)this.app);
        FrameBuffer.invalidateAllFrameBuffers((Application)this.app);
        Gdx.app.log("AndroidGraphics", Mesh.getManagedStatus());
        Gdx.app.log("AndroidGraphics", Texture.getManagedStatus());
        Gdx.app.log("AndroidGraphics", ShaderProgram.getManagedStatus());
        Gdx.app.log("AndroidGraphics", FrameBuffer.getManagedStatus());
        Display display = this.app.getWindowManager().getDefaultDisplay();
        this.width = display.getWidth();
        this.height = display.getHeight();
        this.mean = new WindowedMean(5);
        this.lastFrameTime = System.nanoTime();
        gl.glViewport(0, 0, this.width, this.height);
    }

    private void logConfig(EGLConfig config) {
        EGL10 egl = (EGL10)EGLContext.getEGL();
        EGLDisplay display = egl.eglGetDisplay(EGL10.EGL_DEFAULT_DISPLAY);
        int r = this.getAttrib(egl, display, config, 12324, 0);
        int g = this.getAttrib(egl, display, config, 12323, 0);
        int b = this.getAttrib(egl, display, config, 12322, 0);
        int a = this.getAttrib(egl, display, config, 12321, 0);
        int d = this.getAttrib(egl, display, config, 12325, 0);
        int s = this.getAttrib(egl, display, config, 12326, 0);
        int samples = Math.max(this.getAttrib(egl, display, config, 12337, 0), this.getAttrib(egl, display, config, 12513, 0));
        boolean coverageSample = this.getAttrib(egl, display, config, 12513, 0) != 0;
        Gdx.app.log("AndroidGraphics", "framebuffer: (" + r + ", " + g + ", " + b + ", " + a + ")");
        Gdx.app.log("AndroidGraphics", "depthbuffer: (" + d + ")");
        Gdx.app.log("AndroidGraphics", "stencilbuffer: (" + s + ")");
        Gdx.app.log("AndroidGraphics", "samples: (" + samples + ")");
        Gdx.app.log("AndroidGraphics", "coverage sampling: (" + coverageSample + ")");
        this.bufferFormat = new Graphics.BufferFormat(r, g, b, a, d, s, samples, coverageSample);
    }

    private int getAttrib(EGL10 egl, EGLDisplay display, EGLConfig config, int attrib, int defValue) {
        if (egl.eglGetConfigAttrib(display, config, attrib, this.value)) {
            return this.value[0];
        }
        return defValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resume() {
        Object object = this.synch;
        synchronized (object) {
            this.running = true;
            this.resume = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void pause() {
        Object object = this.synch;
        synchronized (object) {
            if (!this.running) {
                return;
            }
            this.running = false;
            this.pause = true;
            while (this.pause) {
                try {
                    this.synch.wait();
                }
                catch (InterruptedException ignored) {
                    Gdx.app.log("AndroidGraphics", "waiting for pause synchronization failed!");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void destroy() {
        Object object = this.synch;
        synchronized (object) {
            this.running = false;
            this.destroy = true;
            while (this.destroy) {
                try {
                    this.synch.wait();
                }
                catch (InterruptedException ex) {
                    Gdx.app.log("AndroidGraphics", "waiting for destroy synchronization failed!");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onDrawFrame(javax.microedition.khronos.opengles.GL10 gl) {
        long time = System.nanoTime();
        this.deltaTime = (float)(time - this.lastFrameTime) / 1.0E9f;
        this.lastFrameTime = time;
        this.mean.addValue(this.deltaTime);
        boolean lrunning = false;
        boolean lpause = false;
        boolean ldestroy = false;
        boolean lresume = false;
        Array<Runnable> array = this.synch;
        synchronized (array) {
            lrunning = this.running;
            lpause = this.pause;
            ldestroy = this.destroy;
            lresume = this.resume;
            if (this.resume) {
                this.resume = false;
            }
            if (this.pause) {
                this.pause = false;
                this.synch.notifyAll();
            }
            if (this.destroy) {
                this.destroy = false;
                this.synch.notifyAll();
            }
        }
        if (lresume) {
            this.app.audio.resume();
            this.app.listener.resume();
            Gdx.app.log("AndroidGraphics", "resumed");
        }
        if (lrunning) {
            array = this.app.runnables;
            synchronized (array) {
                this.app.executedRunnables.clear();
                this.app.executedRunnables.addAll(this.app.runnables);
                this.app.runnables.clear();
                for (int i = 0; i < this.app.executedRunnables.size; ++i) {
                    try {
                        ((Runnable)this.app.executedRunnables.get(i)).run();
                        continue;
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                }
            }
            this.app.input.processEvents();
            this.app.listener.render();
        }
        if (lpause) {
            this.app.listener.pause();
            this.app.audio.pause();
            Gdx.app.log("AndroidGraphics", "paused");
        }
        if (ldestroy) {
            this.app.listener.dispose();
            this.app.audio.dispose();
            this.app.audio = null;
            Gdx.app.log("AndroidGraphics", "destroyed");
        }
        if (time - this.frameStart > 1000000000L) {
            this.fps = this.frames;
            this.frames = 0;
            this.frameStart = time;
        }
        ++this.frames;
    }

    public float getDeltaTime() {
        return this.mean.getMean() == 0.0f ? this.deltaTime : this.mean.getMean();
    }

    public float getRawDeltaTime() {
        return this.deltaTime;
    }

    public Graphics.GraphicsType getType() {
        return Graphics.GraphicsType.AndroidGL;
    }

    public int getFramesPerSecond() {
        return this.fps;
    }

    public void clearManagedCaches() {
        Mesh.clearAllMeshes((Application)this.app);
        Texture.clearAllTextures((Application)this.app);
        ShaderProgram.clearAllShaderPrograms((Application)this.app);
        FrameBuffer.clearAllFrameBuffers((Application)this.app);
        Gdx.app.log("AndroidGraphics", Mesh.getManagedStatus());
        Gdx.app.log("AndroidGraphics", Texture.getManagedStatus());
        Gdx.app.log("AndroidGraphics", ShaderProgram.getManagedStatus());
        Gdx.app.log("AndroidGraphics", FrameBuffer.getManagedStatus());
    }

    public View getView() {
        return this.view;
    }

    public GLCommon getGLCommon() {
        return this.gl;
    }

    public float getPpiX() {
        return this.ppiX;
    }

    public float getPpiY() {
        return this.ppiY;
    }

    public float getPpcX() {
        return this.ppcX;
    }

    public float getPpcY() {
        return this.ppcY;
    }

    public float getDensity() {
        return this.density;
    }

    public GLU getGLU() {
        return this.glu;
    }

    public boolean supportsDisplayModeChange() {
        return false;
    }

    public boolean setDisplayMode(Graphics.DisplayMode displayMode) {
        return false;
    }

    public Graphics.DisplayMode[] getDisplayModes() {
        return new Graphics.DisplayMode[]{this.getDesktopDisplayMode()};
    }

    public boolean setDisplayMode(int width, int height, boolean fullscreen) {
        return false;
    }

    public void setTitle(String title) {
    }

    public void setIcon(Pixmap[] pixmap) {
    }

    public Graphics.DisplayMode getDesktopDisplayMode() {
        DisplayMetrics metrics = new DisplayMetrics();
        this.app.getWindowManager().getDefaultDisplay().getMetrics(metrics);
        return new AndroidDisplayMode(metrics.widthPixels, metrics.heightPixels, 0, 0);
    }

    public Graphics.BufferFormat getBufferFormat() {
        return this.bufferFormat;
    }

    public void setVSync(boolean vsync) {
    }

    public boolean supportsExtension(String extension) {
        if (this.extensions == null) {
            this.extensions = Gdx.gl.glGetString(7939);
        }
        return this.extensions.contains(extension);
    }

    public void setContinuousRendering(boolean isContinuous) {
        if (this.view != null) {
            int renderMode;
            this.isContinuous = isContinuous;
            int n = renderMode = isContinuous ? 1 : 0;
            if (this.view instanceof GLSurfaceViewCupcake) {
                ((GLSurfaceViewCupcake)this.view).setRenderMode(renderMode);
            }
            if (this.view instanceof GLSurfaceView) {
                ((GLSurfaceView)this.view).setRenderMode(renderMode);
            }
        }
    }

    public boolean isContinuousRendering() {
        return this.isContinuous;
    }

    public void requestRendering() {
        if (this.view != null) {
            if (this.view instanceof GLSurfaceViewCupcake) {
                ((GLSurfaceViewCupcake)this.view).requestRender();
            }
            if (this.view instanceof GLSurfaceView) {
                ((GLSurfaceView)this.view).requestRender();
            }
        }
    }

    public boolean isFullscreen() {
        return true;
    }

    private class AndroidDisplayMode
    extends Graphics.DisplayMode {
        protected AndroidDisplayMode(int width, int height, int refreshRate, int bitsPerPixel) {
            super(width, height, refreshRate, bitsPerPixel);
        }
    }
}

