## Changelog

&#x1F30E; [Google Translate](https://translate.google.com/translate?sl=en&u=https%3A%2F%2Fgithub.com%2FM66B%2FFairEmail%2Fblob%2Fmaster%2FCHANGELOG.md)

### Latest version

* Added option for line spacing
* Performance optimizations
* Accessibility improvements
* Small improvements and minor bug fixes
* Updated [translations](https://crowdin.com/project/open-source-email)

### Notices

People keep asking me to add new, often exotic, features to the app, to whom I often say "no", and other people complain about too many features.
Both groups of people leave bad reviews for this, which is frustrating, also because there are already enough bad reviews for the wrong reasons
(email server problems, which unfortunately happen too often, etc.).
The main problem is that more features now make more people unhappy than happy.
Therefore, [the rules for new features](https://m66b.github.io/FairEmail/#get-support) will be strictly followed from today.

No worries, the app will [continue to be maintained](https://github.com/M66B/FairEmail/commits/) and supported as usual.

<br>

Google requires FairEmail to undergo an annual [CASA](https://appdefensealliance.dev/casa) security audit,
which must be conducted by an authorized assessor (this year [TAC Security](https://casa.tacsecurity.com/site/home)).
Besides being time-consuming, this is no longer free as of this year.
This is one of the reasons why the app cannot be completely free, meaning some features must be paid for in order to pay for an annual security audit.
To be clear, nothing will be changed for now.

The security audit revealed no problems, so Google accounts [can continue to be used](https://support.google.com/cloud/answer/13464325) as usual for a year.

<br>

For support you can use [the contact form](https://contact.faircode.eu/?product=fairemailsupport).

### [Diuqin](https://en.wikipedia.org/wiki/Diuqin)

### Next version (Work in progress)

### 1.2310 2026-01-20

* Fixed crash on older Android versions

### 1.2309 2026-01-20

* Added option for line spacing
* Performance optimizations
* Accessibility improvements
* Small improvements and minor bug fixes
* Updated [translations](https://crowdin.com/project/open-source-email)

### 1.2308 2025-12-24

* Added undo to swipe to hide
* Added Roboto monospace font for devices without monospace font
* Small improvements and minor bug fixes
* Updated build tools
* Updated [translations](https://crowdin.com/project/open-source-email)
* Updated [Public Suffix List](https://github.com/publicsuffix/list)

### 1.2307 2025-12-15

* Fixed message list widget flickering on some devices
* Added option to select space between messages (display settings tab page)
* Small improvements and minor bug fixes
* Updated [translations](https://crowdin.com/project/open-source-email)
* Updated [AndroidX](https://developer.android.com/jetpack/androidx/versions/all-channel)
* Updated [Public Suffix List](https://github.com/publicsuffix/list)

### 1.2306 2025-12-02 *

* Fixed scroll issues with the original message view

### 1.2305 2025-12-01

* Fixed deleting Gmail labels

### 1.2304 2025-11-28

* Fixed all reported bugs
* Small improvements and minor bug fixes
* Updated [Public Suffix List](https://github.com/publicsuffix/list)

### 1.2303 2025-11-25

* Fixed all reported bugs
* Small improvements and minor bug fixes
* Added resizing of HEIC/HEIF encoded images (Android 9 or later only)
* Updated [translations](https://crowdin.com/project/open-source-email)
* Updated [Public Suffix List](https://github.com/publicsuffix/list)
* Updated [Brave's debounce list](https://github.com/brave/brave-browser/wiki/Debouncing)

### 1.2302 2025-10-30

* Fixed all reported bugs
* Updated [translations](https://crowdin.com/project/open-source-email)
* Updated [Public Suffix List](https://github.com/publicsuffix/list)

### 1.2301 2025-10-23

* Fixed all reported bugs
* Updated [translations](https://crowdin.com/project/open-source-email)
* Updated [Public Suffix List](https://github.com/publicsuffix/list)

### [Ceratonykus](https://en.wikipedia.org/wiki/Ceratonykus)

### 1.2300 2025-10-06

* Fixed all reported bugs
* Added collapsible attachments for the message editor
* Updated [S/MIME root certificates](https://wiki.mozilla.org/CA/Included_Certificates)
* Updated [translations](https://crowdin.com/project/open-source-email)

### 1.2299 2025-09-30 *

* Fixed all reported bugs
* Small improvements and minor bug fixes
* Updated [AndroidX](https://developer.android.com/jetpack/androidx/versions/all-channel)
* Updated [Public Suffix List](https://github.com/publicsuffix/list)

### 1.2298 2025-09-22

* Added support for Open Xchange flag colors
* Improved scroll behavior of original message view for most devices
* Small improvements and minor bug fixes
* Updated [Public Suffix List](https://github.com/publicsuffix/list)

### 1.2297 2025-09-18

* Fixed all reported bugs
* Small improvements and minor bug fixes
* Updated [BouncyCastle](https://www.bouncycastle.org/)
* Updated [Public Suffix List](https://github.com/publicsuffix/list)
* Updated [translations](https://crowdin.com/project/open-source-email)

### 1.2296 2025-09-12

* Fixed all reported bugs
* Small improvements and minor bug fixes
* Updated [AndroidX](https://developer.android.com/jetpack/androidx/versions/all-channel)
* Updated [Public Suffix List](https://github.com/publicsuffix/list)
* Updated [translations](https://crowdin.com/project/open-source-email)

### 1.2295 2025-09-01 *

* Fixed scroll issues with delayed marking read
* Fixed selecting messages when swiping a message

### 1.2294 2025-08-30

* One-click unsubscribe improvements
* Small improvements and minor bug fixes
* Updated [Public Suffix List](https://github.com/publicsuffix/list)
* Updated [translations](https://crowdin.com/project/open-source-email)

### 1.2293 2025-08-25

* One-click unsubscribe improvements
* Small improvements and minor bug fixes
* Updated [Public Suffix List](https://github.com/publicsuffix/list)
* Updated [translations](https://crowdin.com/project/open-source-email)

### 1.2292 2025-08-18 *

* Fixed unchanged external drafts being saved
* Added support for "one-click" unsubscribe
* Small improvements and minor bug fixes
* Updated [AndroidX](https://developer.android.com/jetpack/androidx/versions/all-channel)

### 1.2291 2025-08-13

* Small improvements and minor bug fixes
* Updated [Public Suffix List](https://github.com/publicsuffix/list)

### 1.2290 2025-08-11

* Fixed all reported bugs
* A conversation will be important if any message is marked important
* Small improvements and minor bug fixes
* Updated [Public Suffix List](https://github.com/publicsuffix/list)
* Updated [translations](https://crowdin.com/project/open-source-email)

### 1.2289 2025-08-02

* Fixed all reported bugs
* Small improvements and minor bug fixes
* Updated [Brave's debounce list](https://github.com/brave/brave-browser/wiki/Debouncing)
* Updated [AndroidX](https://developer.android.com/jetpack/androidx/versions/all-channel)
* Updated [Public Suffix List](https://github.com/publicsuffix/list)
* Updated [translations](https://crowdin.com/project/open-source-email)

### 1.2288 2025-07-21

* Fixed status bar color in some cases
* Updated [Public Suffix List](https://github.com/publicsuffix/list)
* Updated [translations](https://crowdin.com/project/open-source-email)

### 1.2287 2025-07-17

* Resolved all reported bugs
* Small improvements and minor bug fixes
* Updated [S/MIME root certificates](https://wiki.mozilla.org/CA/Included_Certificates)
* Updated [Public Suffix List](https://github.com/publicsuffix/list)
* Updated [translations](https://crowdin.com/project/open-source-email)

### 1.2286 2025-07-04 *

* Fixed workaround for multiple inboxes

### 1.2285 2025-07-04

* Fixed workaround for incorrectly shared files

### 1.2284 2025-07-02

* Added filtering out unread / starred messages
* Added workaround for incorrectly shared files (Xiaomi gallery)
* Small improvements and minor bug fixes
* Updated [Public Suffix List](https://github.com/publicsuffix/list)
* Updated [translations](https://crowdin.com/project/open-source-email)

### 1.2283 2025-06-21 *

* Disabled Certficate Transparency because Google broke it. 'Thanks' for all the 1-star ratings :-(
* Small improvements and minor bug fixes
* Updated [translations](https://crowdin.com/project/open-source-email)

### 1.2282 2025-06-20

* Small improvements and minor bug fixes
* Updated [AndroidX](https://developer.android.com/jetpack/androidx/versions/all-channel)
* Updated [Public Suffix List](https://github.com/publicsuffix/list)
* Updated [translations](https://crowdin.com/project/open-source-email)

### 1.2281 2025-06-18

* Added dropping files/images into the message editor
* Small improvements and minor bug fixes
* Updated [Public Suffix List](https://github.com/publicsuffix/list)
* Updated [translations](https://crowdin.com/project/open-source-email)

### 1.2280 2025-06-10

* Fixed mime type of shared files
* Small improvements and minor bug fixes
* Updated [Public Suffix List](https://github.com/publicsuffix/list)
* Updated [translations](https://crowdin.com/project/open-source-email)

### 1.2279 2025-06-09

* Added auto-reset of PGP keys
* Small improvements and minor bug fixes
* Updated [AndroidX](https://developer.android.com/jetpack/androidx/versions/all-channel)
* Updated [Public Suffix List](https://github.com/publicsuffix/list)
* Updated [translations](https://crowdin.com/project/open-source-email)

### 1.2278 2025-06-05

* Added option to limit the width only when resizing images
* Added support for separate S/MIME sign/encrypt certificates, see [the FAQ](https://m66b.github.io/FairEmail/#faq12) for details
* Small improvements and minor bug fixes
* Updated [AndroidX](https://developer.android.com/jetpack/androidx/versions/all-channel)
* Updated [Public Suffix List](https://github.com/publicsuffix/list)
* Updated [translations](https://crowdin.com/project/open-source-email)

### 1.2277 2025-05-28

* Small improvements and minor bug fixes
* Updated [AndroidX](https://developer.android.com/jetpack/androidx/versions/all-channel)
* Updated [Public Suffix List](https://github.com/publicsuffix/list)
* Updated [translations](https://crowdin.com/project/open-source-email)

### 1.2276 2025-05-07 *

* Removed TTS from the Play Store version (only) due to Play Store policies
* Removed external intents from the Play Store version (only) due to Play Store policies
* Small improvements and minor bug fixes
* Updated [translations](https://crowdin.com/project/open-source-email)

### 1.2275 2025-05-06

* Added Mozilla CA S/MIME certificates
* Fixed navigation bar color in some cases
* Small improvements and minor bug fixes
* Updated [Public Suffix List](https://github.com/publicsuffix/list)
* Updated [translations](https://crowdin.com/project/open-source-email)

### 1.2274 2025-04-24 *

* Small improvements and minor bug fixes
* Updated [AndroidX](https://developer.android.com/jetpack/androidx/versions/all-channel)
* Updated [Public Suffix List](https://github.com/publicsuffix/list)
* Updated [translations](https://crowdin.com/project/open-source-email)

### 1.2273 2025-04-23

* Removed Bugsnag
* Small improvements and minor bug fixes
* Updated [AndroidX](https://developer.android.com/jetpack/androidx/versions/all-channel)
* Updated [Public Suffix List](https://github.com/publicsuffix/list)
* Updated [translations](https://crowdin.com/project/open-source-email)

### 1.2272 2025-04-08 *

* Fixed back gestures for Hyper OS
* Small improvements and minor bug fixes
* Updated [translations](https://crowdin.com/project/open-source-email)

### 1.2271 2025-04-08

* Added option for narrow color stripes
* Small improvements and minor bug fixes
* Updated [Public Suffix List](https://github.com/publicsuffix/list)
* Updated [translations](https://crowdin.com/project/open-source-email)

### 1.2270 2025-03-31

* Fixed widgets for some Android variants
* Small improvements and minor bug fixes
* Updated [Public Suffix List](https://github.com/publicsuffix/list)
* Updated [translations](https://crowdin.com/project/open-source-email)

### 1.2269 2025-03-27

* Fixed all reported issues
* Targeting Android 16 Baklava
* Added optional TTS button / notification action
* Improved accessibility
* Small improvements and minor bug fixes
* Updated [AndroidX](https://developer.android.com/jetpack/androidx/versions/all-channel)
* Updated [Public Suffix List](https://github.com/publicsuffix/list)
* Updated [translations](https://crowdin.com/project/open-source-email)

### 1.2268 2025-03-14 *

* Fixed delayed marking read
* Small improvements and minor bug fixes
* Updated [translations](https://crowdin.com/project/open-source-email)

### 1.2267 2025-03-12

* Reverted to [ShortcutBadger](https://github.com/leolin310148/ShortcutBadger)
* Small improvements and minor bug fixes
* Updated [translations](https://crowdin.com/project/open-source-email)

### 1.2266 2025-03-11

* Fixed all reported issues
* Small improvements and minor bug fixes
* Updated [translations](https://crowdin.com/project/open-source-email)

### 1.2265 2025-03-07

* Fixed all reported issues
* Switched to [ShortcutBadgerX](https://github.com/kibotu/ShortcutBadgerX)
* Small improvements and minor bug fixes
* Updated build tools (Android Studio, gradle)
* Updated [Public Suffix List](https://github.com/publicsuffix/list)
* Updated [translations](https://crowdin.com/project/open-source-email)

### [Barsboldia](https://en.wikipedia.org/wiki/Barsboldia)

### 1.2264 2025-03-03

* Fixed saving drafts on the server in some circumstances
* Fixed VPN-only account option not being applied always
* Added mark-read option to hide rule action
* Small improvements and minor bug fixes
* Updated [translations](https://crowdin.com/project/open-source-email)

### 1.2263 2025-03-01

* Fixed all reported bugs
* Added S/MIME encrypt-only
* Small improvements and minor bug fixes
* Updated [AndroidX](https://developer.android.com/jetpack/androidx/versions/all-channel)
* Updated [Public Suffix List](https://github.com/publicsuffix/list)
* Updated [translations](https://crowdin.com/project/open-source-email)

### 1.2262 2025-01-30

* Fixed deleting sent messages in some cases

### 1.2261 2025-01-30

* Released [expression conditions](https://m66b.github.io/FairEmail/#expression_conditions) as non-experimental
* Small improvements and minor bug fixes
* Updated [AndroidX](https://developer.android.com/jetpack/androidx/versions/all-channel)
* Updated [Public Suffix List](https://github.com/publicsuffix/list)
* Updated [translations](https://crowdin.com/project/open-source-email)

### 1.2260 2025-01-23

* Disabled viewport height limitation
* Small improvements and minor bug fixes
* Updated libraries, including [EvalEx](https://github.com/ezylang/EvalEx)
* Updated [Public Suffix List](https://github.com/publicsuffix/list)
* Updated [translations](https://crowdin.com/project/open-source-email)

### 1.2259 2025-01-16

* Added resize to basic image editor
* Added dialog box for message editor AI actions
* Added loop sound option to play sound rule actions
* Updated build tools
* Small improvements and minor bug fixes
* Updated [AndroidX](https://developer.android.com/jetpack/androidx/versions/all-channel)
* Updated [Public Suffix List](https://github.com/publicsuffix/list)
* Updated [translations](https://crowdin.com/project/open-source-email)

### 1.2258 2025-01-08 *

* Fixed S/MIME decrypt in some cases
* Small improvements and minor bug fixes
* Updated [translations](https://crowdin.com/project/open-source-email)

### 1.2257 2025-01-07

* Added sort on sender name (Android 14+ only)
* Added basic image editor (slowly tap twice on an inserted image in the message editor)
* Small improvements and minor bug fixes
* Updated [translations](https://crowdin.com/project/open-source-email)

### 1.2256 2025-01-01 *

* Happy New Year
* Fixed force light of reformatted message view
* Small improvements and minor bug fixes
* Updated [translations](https://crowdin.com/project/open-source-email)

### 1.2254 2024-12-31

* Added experimental force light for reformatted message view
* Updated libraries, including [Jsoup](https://jsoup.org/news/) and [BouncyCastle](https://www.bouncycastle.org/news/)
* Small improvements and minor bug fixes
* Updated [translations](https://crowdin.com/project/open-source-email)

### 1.2253 2024-12-23 *

* Fixed showing S/MIME digest algorithm
* Added option to select default font size for sending
* Small improvements and minor bug fixes
* Updated [translations](https://crowdin.com/project/open-source-email)

### 1.2252 2024-12-18

* Fixed in-app changelog
* Small improvements and minor bug fixes
* Updated [Public Suffix List](https://github.com/publicsuffix/list)
* Updated [translations](https://crowdin.com/project/open-source-email)

### 1.2251 2024-12-14

* Added S/MIME UTF-8 support
* Updated Brave's debounce list
* Improved internationalized email address support
* Small improvements and minor bug fixes
* Updated [Public Suffix List](https://github.com/publicsuffix/list)
* Updated [translations](https://crowdin.com/project/open-source-email)

### 1.2250 2024-12-05

* Fixed all reported bugs
* Added long press folder - mark all read
* Small improvements and minor bug fixes
* Updated build tools
* Updated [AndroidX](https://developer.android.com/jetpack/androidx/versions/all-channel)
* Updated [Public Suffix List](https://github.com/publicsuffix/list)
* Updated [translations](https://crowdin.com/project/open-source-email)

### 1.2249 2024-11-20 *

* Small improvements and minor bug fixes
* Updated [Public Suffix List](https://github.com/publicsuffix/list)
* Updated [translations](https://crowdin.com/project/open-source-email)

### 1.2248 2024-11-17

* Fixed crash on removing privacy sensitive info from images (reverted to previous EXIF library)
* Small improvements and minor bug fixes
* Updated [translations](https://crowdin.com/project/open-source-email)

### 1.2247 2024-11-16

* Small improvements and minor bug fixes
* Updated [AndroidX](https://developer.android.com/jetpack/androidx/versions/all-channel)
* Updated [translations](https://crowdin.com/project/open-source-email)

### 1.2246 2024-11-13

* Added fast *forward to*, see [the FAQ](https://m66b.github.io/FairEmail/#faq125)
* Small improvements and minor bug fixes
* Updated [AndroidX](https://developer.android.com/jetpack/androidx/versions/all-channel)
* Updated [Public Suffix List](https://github.com/publicsuffix/list)
* Updated [translations](https://crowdin.com/project/open-source-email)

### 1.2245 2024-11-08

* Added manage keywords for multiple selected messages
* Small improvements and minor bug fixes
* Updated [Public Suffix List](https://github.com/publicsuffix/list)
* Updated [translations](https://crowdin.com/project/open-source-email)

### 1.2244 2024-11-01

* Fixed deleting old unread messages
* Small improvements and minor bug fixes
* Updated build tools
* Updated [translations](https://crowdin.com/project/open-source-email)

### 1.2243 2024-11-01

* Added AI interference to [expression conditions](https://m66b.github.io/FairEmail/#faq71)
* Small improvements and minor bug fixes
* Updated [AndroidX](https://developer.android.com/jetpack/androidx/versions/all-channel)
* Updated [translations](https://crowdin.com/project/open-source-email)

### 1.2242 2024-10-29

* Updated MiniDNS to version 1.1.1
* Small improvements and minor bug fixes
* Updated [Public Suffix List](https://github.com/publicsuffix/list)
* Updated [translations](https://crowdin.com/project/open-source-email)

### 1.2241 2024-10-24

* Fixed interaction sharing email / biometric authentication
* Added trash/archive to swipe/ask popup menu
* Added confirmation for signature deletion
* Small improvements and minor bug fixes
* Updated [Public Suffix List](https://github.com/publicsuffix/list)
* Updated [translations](https://crowdin.com/project/open-source-email)

### 1.2240 2024-10-19

* Fixed newlines for messages sent with Outlook 2024

### 1.2239 2024-10-18

* Fixed workaround for invalid PGP messages
* Small improvements and minor bug fixes
* Updated [Public Suffix List](https://github.com/publicsuffix/list)
* Updated [translations](https://crowdin.com/project/open-source-email)

### 1.2238 2024-10-17

* Fixed zooming with always shown inline images
* Added copying of POP3 accounts
* Removed inline build of MiniDNS
* Small improvements and minor bug fixes
* Updated [AndroidX](https://developer.android.com/jetpack/androidx/versions/all-channel)
* Updated [Public Suffix List](https://github.com/publicsuffix/list)
* Updated [translations](https://crowdin.com/project/open-source-email)

### 1.2237 2024-10-14

* Small improvements and minor bug fixes
* Updated [Public Suffix List](https://github.com/publicsuffix/list)
* Updated [translations](https://crowdin.com/project/open-source-email)

### 1.2236 2024-10-08

* Disabled workaround for Gmail
* Fixed sort order folders
* Small improvements and minor bug fixes
* Updated [translations](https://crowdin.com/project/open-source-email)

### 1.2235 2024-10-05

* Added option to show stars in message list widgets (requires Android 12 or later)
* Small improvements and minor bug fixes
* Updated [AndroidX](https://developer.android.com/jetpack/androidx/versions/all-channel)
* Updated [Public Suffix List](https://github.com/publicsuffix/list)
* Updated [translations](https://crowdin.com/project/open-source-email)

### 1.2234 2024-09-28 *

* Added option for undo send bar/action
* Small improvements and minor bug fixes
* Updated libraries
* Updated [Public Suffix List](https://github.com/publicsuffix/list)
* Updated [translations](https://crowdin.com/project/open-source-email)

### 1.2233 2024-09-26

* Improved foldable devices support
* Small improvements and minor bug fixes
* Updated [AndroidX](https://developer.android.com/jetpack/androidx/versions/all-channel)
* Updated [Public Suffix List](https://github.com/publicsuffix/list)
* Updated [translations](https://crowdin.com/project/open-source-email)

### [Acantholipan](https://en.wikipedia.org/wiki/Acantholipan)

### 1.2232 2024-09-16

* Fixed resuming sending after restarting the device

### 1.2231 2024-09-16

* Fixed downloading raw message files (EML files) in some situations
* Added detection of screen recording (Android 15+)
* Small improvements and minor bug fixes
* Updated [Public Suffix List](https://github.com/publicsuffix/list)
* Updated [translations](https://crowdin.com/project/open-source-email)

### 1.2230 2024-09-11

* Fixed text-to-speak stops working on some devices
* Fixed duplicate sent-messages in some cases for Yahoo
* Added option to prefer IPv6 over IPv4
* Small improvements and minor bug fixes
* Updated [Public Suffix List](https://github.com/publicsuffix/list)
* Updated [translations](https://crowdin.com/project/open-source-email)

### 1.2229 - 2024-09-07

* Fixed foreground service permission
* Updated [translations](https://crowdin.com/project/open-source-email)

### 1.2228 - 2024-09-07

* Accessibility improvements (thanks @pvagner)
* Small improvements and minor bug fixes
* Updated [AndroidX](https://developer.android.com/jetpack/androidx/versions/all-channel)
* Updated [Public Suffix List](https://github.com/publicsuffix/list)
* Updated [translations](https://crowdin.com/project/open-source-email)

### 1.2227 - 2024-08-31 *

* Small improvements and minor bug fixes
* Updated build tools
* Updated [translations](https://crowdin.com/project/open-source-email)

### 1.2226 - 2024-08-27

* Added Fastmail OAuth
* Added text-to-speech swipe action
* Small improvements and minor bug fixes
* Updated [translations](https://crowdin.com/project/open-source-email)

### 1.2225 - 2024-08-24

* Small improvements and minor bug fixes
* Updated [translations](https://crowdin.com/project/open-source-email)

### 1.2224 - 2024-08-20

* Small improvements and minor bug fixes
* Updated [translations](https://crowdin.com/project/open-source-email)

### 1.2223 - 2024-08-17

* Small improvements and minor bug fixes
* Updated [translations](https://crowdin.com/project/open-source-email)

### 1.2222 - 2024-08-16

* Fixed bug in JavaMail causing iCloud move issues
* Added reply/forward header template option
* Small improvements and minor bug fixes
* Updated [Public Suffix List](https://github.com/publicsuffix/list)
* Updated [translations](https://crowdin.com/project/open-source-email)

### 1.2221 - 2024-08-13

* Fixed bug in JavaMail causing iCloud sync issues
* Fixed back navigation for older Android versions
* Small improvements and minor bug fixes
* Updated [AndroidX](https://developer.android.com/jetpack/androidx/versions/all-channel)
* Updated [Public Suffix List](https://github.com/publicsuffix/list)
* Updated [translations](https://crowdin.com/project/open-source-email)

### 1.2220 - 2024-08-07 *

* Fixed verifying PGP signature in some cases
* Updated [Public Suffix List](https://github.com/publicsuffix/list)
* Updated [translations](https://crowdin.com/project/open-source-email)

### 1.2219 - 2024-08-04

* Fixed right-to-left script support
* Small improvements and minor bug fixes
* Updated libraries, including [EvalEx](https://github.com/ezylang/EvalEx/releases) (rule expressions)
* Updated [Public Suffix List](https://github.com/publicsuffix/list)
* Updated [translations](https://crowdin.com/project/open-source-email)

### 1.2218 - 2024-08-03

* Fixed rule expression conditions
* Added option for color dot instead of color stripe
* Small improvements and minor bug fixes
* Updated [translations](https://crowdin.com/project/open-source-email)

### 1.2217 - 2024-08-02

* Added inbox per account category to navigation menu (optional)
* Small improvements and minor bug fixes
* Updated [Public Suffix List](https://github.com/publicsuffix/list)
* Updated [translations](https://crowdin.com/project/open-source-email)

### 1.2216 - 2024-07-27

* Added support for SVG data URI images
* Added option to automatically unstar on unsnooze
* Added option to auto-encrypt on replying to an encrypted message
* Small improvements and minor bug fixes
* Updated [AndroidX](https://developer.android.com/jetpack/androidx/versions/all-channel)
* Updated [Public Suffix List](https://github.com/publicsuffix/list)
* Updated [translations](https://crowdin.com/project/open-source-email)

### 1.2215 - 2024-07-20 *

* Small improvements and minor bug fixes

### 1.2214 - 2024-07-18

* Fixed all reported bugs
* Performance improvements
* Small improvements and minor bug fixes
* Updated [translations](https://crowdin.com/project/open-source-email)

### 1.2213 - 2024-07-13

* Added white theme
* Small improvements and minor bug fixes
* Updated build tools (Android Studio, gradle)
* Updated [Public Suffix List](https://github.com/publicsuffix/list)
* Updated [translations](https://crowdin.com/project/open-source-email)

### 1.2212 - 2024-07-11

* Added resizing of contact photos to avoid using a lot of memory
* Small improvements and minor bug fixes
* Updated [translations](https://crowdin.com/project/open-source-email)

### 1.2211 - 2024-07-10

* Added workaround for drop-down menu focus
* Small improvements and minor bug fixes
* Updated [translations](https://crowdin.com/project/open-source-email)

### 1.2210 - 2024-07-09

* Added optional DuckDuckGo favicons (GitHub version only)
* Fixed two memory leaks
* Small improvements and minor bug fixes
* Updated [translations](https://crowdin.com/project/open-source-email)

### 1.2209 - 2024-07-03

* Added account images (avatars)
* Added APK file attestation, see [the FAQ](https://m66b.github.io/FairEmail/#faq205)
* Small improvements and minor bug fixes
* Updated [AndroidX](https://developer.android.com/jetpack/androidx/versions/all-channel)
* Updated [Public Suffix List](https://github.com/publicsuffix/list)
* Updated [translations](https://crowdin.com/project/open-source-email)

### 1.2208 - 2024-06-22 *

* Changed copy signature button into edit signature button
* Small improvements and minor bug fixes
* Updated [Public Suffix List](https://github.com/publicsuffix/list)
* Updated [translations](https://crowdin.com/project/open-source-email)

### 1.2207 - 2024-06-20

* Fixed DANE with SHA-384 and CNAME TLSA
* Small improvements and minor bug fixes
* Updated [translations](https://crowdin.com/project/open-source-email)

### 1.2206 - 2024-06-19

* Reverted AndroidX Lifecycle to fix a crash
* Small improvements and minor bug fixes
* Updated [Public Suffix List](https://github.com/publicsuffix/list)
* Updated [translations](https://crowdin.com/project/open-source-email)

### 1.2205 - 2024-06-15

* Added attachments to templates
* Small improvements and minor bug fixes
* Updated [AndroidX](https://developer.android.com/jetpack/androidx/versions/all-channel)
* Updated [Public Suffix List](https://github.com/publicsuffix/list)
* Updated [translations](https://crowdin.com/project/open-source-email)

### 1.2204 - 2024-06-14 *

* Fixed downloading message for POP3 accounts
* Updated [translations](https://crowdin.com/project/open-source-email)

### 1.2203 - 2024-06-14 *

* Fixed downloading message/button
* Updated build tools
* Updated [translations](https://crowdin.com/project/open-source-email)

### 1.2202 - 2024-06-13 *

* Small improvements and minor bug fixes
* Updated [translations](https://crowdin.com/project/open-source-email)

### 1.2201 - 2024-06-13 *

* Small improvements and minor bug fixes
* Updated [translations](https://crowdin.com/project/open-source-email)

### 1.2200 - 2024-06-12

* Fixed keyboard inset for some devices
* Updated build tools
* Small improvements and minor bug fixes
* Updated [Public Suffix List](https://github.com/publicsuffix/list)
* Updated [translations](https://crowdin.com/project/open-source-email)

### 1.2199 - 2024-06-10

* Fixed original message view for Android 8 and before
* Added a button to retry downloading the message text
* Small improvements and minor bug fixes
* Updated [AndroidX](https://developer.android.com/jetpack/androidx/versions/all-channel)
* Updated [translations](https://crowdin.com/project/open-source-email)

### 1.2198 - 2024-06-06 *

* Fixed crash
* Added printing of file type icons
* Small improvements and minor bug fixes
* Updated [translations](https://crowdin.com/project/open-source-email)

### 1.2197 - 2024-06-06

* Fixed toolbar height on some Samsung devices
* Small improvements and minor bug fixes
* Updated [translations](https://crowdin.com/project/open-source-email)

### 1.2196 - 2024-06-04

* Fixed cancel of download attachments dialog
* Small improvements and minor bug fixes
* Updated [translations](https://crowdin.com/project/open-source-email)

### 1.2195 - 2024-06-04

* Fixed browsing old messages
* Added download attachments dialog (when replying/forwarding)
* Small improvements and minor bug fixes
* Updated [translations](https://crowdin.com/project/open-source-email)

### 1.2194 - 2024-06-03

* Fixed all reported bugs
* Added Android backup agent (optional)
* Small improvements and minor bug fixes
* Updated [translations](https://crowdin.com/project/open-source-email)

### 1.2193 - 2024-05-30 *

* Fixed deleting of old unread messages (regression)

### 1.2192 - 2024-05-30 *

* Fixed repeated new message notifications for old unread messages in some situations
* Small improvements and minor bug fixes
* Updated [translations](https://crowdin.com/project/open-source-email)

### 1.2191 - 2024-05-29 *

* Added "AI" templates
* Fixed darker navigation bar color
* Fixed top action bar when using [DeX](https://www.samsung.com/us/apps/dex/) on some Samsung devices
* Small improvements and minor bug fixes
* Updated [translations](https://crowdin.com/project/open-source-email)

### 1.2190 - 2024-05-28 *

* Fixed navigation bar color
* Fixed background color of tabular layout
* Small improvements and minor bug fixes
* Updated [translations](https://crowdin.com/project/open-source-email)

### 1.2189 - 2024-05-28 *

* Fixed all reported problems
* Small improvements and minor bug fixes
* Updated [Public Suffix List](https://github.com/publicsuffix/list)
* Updated [translations](https://crowdin.com/project/open-source-email)

### 1.2188 - 2024-05-27 *

* Fixed keyboard inset in some cases
* Small improvements and minor bug fixes
* Updated [translations](https://crowdin.com/project/open-source-email)

### 1.2187 - 2024-05-26

* Small improvements and minor bug fixes
* Updated [translations](https://crowdin.com/project/open-source-email)

### 1.2186 - 2024-05-24

* Fixed jitter when hiding the top toolbar
* Fixed Android navigation bar color for some Android versions (regression)
* Reverted AndroidX fragment to version 1.6.2 again due to instability
* Small improvements and minor bug fixes
* Updated [translations](https://crowdin.com/project/open-source-email)

### 1.2185 - 2024-05-22

* Fixed constraint violation when inserting identity
* Small improvements and minor bug fixes
* Updated [translations](https://crowdin.com/project/open-source-email)

### 1.2184 - 2024-05-22

* Fixed keyboard inset (regression)
* Fixed black background of black and white theme (regression)
* Using account color as default for inbox folder color
* Small improvements and minor bug fixes
* Updated [AndroidX](https://developer.android.com/jetpack/androidx/versions/all-channel)
* Updated [translations](https://crowdin.com/project/open-source-email)

### 1.2183 - 2024-05-21

* Prepared for Android 15
* Added "AI" summarize rule action
* Listing NOT rule conditions
* Reverted AndroidX fragment to version 1.6.2
* Small improvements and minor bug fixes
* Updated build tools
* Updated [translations](https://crowdin.com/project/open-source-email)

### 1.2182 - 2024-05-15

* Added optional "AI" summarize quick action
* Added optional "AI" summarize swipe action
* Changed default OpenAI model to [gpt-4o](https://openai.com/index/hello-gpt-4o/)
* Improved OpenAI integration (added multimodal support)
* Improved Gemini integration
* Made "AI" integrations available in the Play Store version
* Small improvements and minor bug fixes
* Updated [translations](https://crowdin.com/project/open-source-email)

### 1.2181 - 2024-05-13

* Reverted [AndroidX ROOM](https://developer.android.com/jetpack/androidx/releases/room#2.6.1) to version 2.4.3 to solve locking issues (*)
* Small improvements and minor bug fixes
* Updated [Public Suffix List](https://github.com/publicsuffix/list)
* Updated [translations](https://crowdin.com/project/open-source-email)

### 1.2180 - 2024-05-13

* Improved [Gemini](https://m66b.github.io/FairEmail/#faq204) integration
* Performance improvements
* Small improvements and minor bug fixes
* Updated [NDK](https://developer.android.com/ndk/)
* Updated [Public Suffix List](https://github.com/publicsuffix/list)
* Updated [translations](https://crowdin.com/project/open-source-email)

### 1.2179 - 2024-05-08

* Added option to change "AI" summarize prompt
* Added expression condition functions, see [the FAQ](https://m66b.github.io/FairEmail/#faq71)
* Small improvements and minor bug fixes
* Updated build tools
* Updated [AndroidX](https://developer.android.com/jetpack/androidx/versions/all-channel)
* Updated libraries (including [Bouncy Castle](https://www.bouncycastle.org/))
* Updated [Public Suffix List](https://github.com/publicsuffix/list)
* Updated [translations](https://crowdin.com/project/open-source-email)

### 1.2178 - 2024-04-29

* Added "AI" summarization of received messages (*)
* Small improvements and minor bug fixes
* Updated [translations](https://crowdin.com/project/open-source-email)

<sup>(*) Via the horizontal three-dots button just above the message text. ChatGPT or Gemini needs to be configured in the integrations-settings tab page for this.</sub>

### 1.2177 - 2024-04-27

* Added [Have I Been Pwned?](https://haveibeenpwned.com/) **<ins>password</ins>** check (*)
* Added identity option to configure envelope-from (*MAIL FROM*)
* Small improvements and minor bug fixes
* Updated [translations](https://crowdin.com/project/open-source-email)

<sub>(*) Via the three-dots overflow menu of the account list under "*Manual setup and account options*" in the main settings screen (GitHub version only)</sub>

### [Zby](https://en.wikipedia.org/wiki/Zby)

### 1.2176 - 2024-04-22 *

* Fixed British English translation
* Small improvements and minor bug fixes

### 1.2175 - 2024-04-20

* Fixed primary inbox navigation
* Updated [Public Suffix List](https://github.com/publicsuffix/list)
* Updated [translations](https://crowdin.com/project/open-source-email)

### 1.2174 - 2024-04-19

* Added expression conditions to rules, see [the FAQ](https://m66b.github.io/FairEmail/#faq71)
* Small improvements and minor bug fixes
* Updated [AndroidX](https://developer.android.com/jetpack/androidx/versions/all-channel)
* Updated [translations](https://crowdin.com/project/open-source-email)

### 1.2173 - 2024-04-16

* Added *primary inbox* start screen option
* Added *NOT* option to rule conditions
* Small improvements and minor bug fixes
* Updated [Public Suffix List](https://github.com/publicsuffix/list)
* Updated [translations](https://crowdin.com/project/open-source-email)

### 1.2172 - 2024-04-08

* Improved handling of messages via email forwarders (*)
* Small improvements and minor bug fixes
* Updated [AndroidX](https://developer.android.com/jetpack/androidx/versions/all-channel)
* Updated [translations](https://crowdin.com/project/open-source-email)

<sub>(*) Currently supported email forwarders:</sub>

* [addy.io](https://addy.io/)
* [DuckDuckGo Email Protection](https://duckduckgo.com/email/)
* [Firefox Relay](https://relay.firefox.com/)
* [SimpleLogin](https://simplelogin.io/)

### 1.2171 - 2024-03-30

* Added [Gemini](https://m66b.github.io/FairEmail/#faq204) integration
* Added answer button to buttons configuration
* Small improvements and minor bug fixes
* Updated [Public Suffix List](https://github.com/publicsuffix/list)
* Updated [translations](https://crowdin.com/project/open-source-email)

### 1.2170 - 2024-03-23

* Added Arabic to [DeepL translation](https://github.com/M66B/FairEmail/blob/master/FAQ.md#faq167) targets
* Small improvements and minor bug fixes
* Updated build tools
* Updated [Public Suffix List](https://github.com/publicsuffix/list)
* Updated [translations](https://crowdin.com/project/open-source-email)

### 1.2169 - 2024-03-16

* Small improvements and minor bug fixes
* Updated [translations](https://crowdin.com/project/open-source-email)

### 1.2168 - 2024-03-14 *

* Added option to ignore invalid addresses when sending
* Small improvements and minor bug fixes
* Updated [translations](https://crowdin.com/project/open-source-email)

### 1.2167 - 2024-03-09

* Fixed showing images in external drafts in some cases
* Small improvements and minor bug fixes
* Updated [translations](https://crowdin.com/project/open-source-email)

### 1.2166 - 2024-03-08

* Added sorting on unread/starred and starred/unread messages
* Added option to configure number of send attempts
* Small improvements and minor bug fixes
* Updated [AndroidX](https://developer.android.com/jetpack/androidx/versions/all-channel)
* Updated [Public Suffix List](https://github.com/publicsuffix/list)
* Updated [translations](https://crowdin.com/project/open-source-email)

### 1.2165 - 2024-03-05

* Fixed widget incompatibility (< Android 11)

### 1.2164 - 2024-03-05

* Fixed widget incompatibility

### 1.2163 - 2024-03-05

* Added option to show a star for accounts/folders with newly received unread messages (since last viewed)
* Added [UceProtect](https://www.uceprotect.net/en/) blocklists (receive-settings tab page)
* Small improvements and minor bug fixes
* Updated build tools
* Updated [Public Suffix List](https://github.com/publicsuffix/list)
* Updated [translations](https://crowdin.com/project/open-source-email)

### 1.2162 - 2024-02-22 *

* Added option for a gray background color for unread messages when using table style
* Small improvements and minor bug fixes
* Updated [translations](https://crowdin.com/project/open-source-email)

### 1.2161 - 2024-02-20

* Added [experimental](https://github.com/M66B/FairEmail/blob/master/FAQ.md#faq125) support for composing messages with [Markdown](https://en.wikipedia.org/wiki/Markdown)
* Added option to enable showing folders on the accounts start screen (three-dots overflow menu)
* Small improvements and minor bug fixes

### 1.2160 - 2024-02-19

* Added showing folders on the accounts start screen
* Added automatic deletion of old local contacts
* Added importing of mbox files into POP3 folders
* Added long press links to open confirmation dialog box
* Added long press archive / bottom action bar to move conversations
* Small improvements and minor bug fixes
* Updated [translations](https://crowdin.com/project/open-source-email)

### [Ypupiara](https://en.wikipedia.org/wiki/Ypupiara)

### 1.2159 - 2024-02-15

* Added optional reply/answer quick action
* Small improvements and minor bug fixes
* Updated [Public Suffix List](https://github.com/publicsuffix/list)
* Updated [translations](https://crowdin.com/project/open-source-email)

### 1.2158 - 2024-02-10

* Added image barcode decoding (requires Android 7+)
* Small improvements and minor bug fixes
* Updated [Public Suffix List](https://github.com/publicsuffix/list)
* Updated [translations](https://crowdin.com/project/open-source-email)

### 1.2157 - 2024-02-08

* Added widget option to show messages/folders standalone
* Small improvements and minor bug fixes
* Updated [Public Suffix List](https://github.com/publicsuffix/list)
* Updated [translations](https://crowdin.com/project/open-source-email)

### 1.2156 - 2024-02-03 *

* Small improvements and minor bug fixes
* Updated [translations](https://crowdin.com/project/open-source-email)

### 1.2155 - 2024-02-03

* Added title input fields for widgets
* Using high priority notifications for high importance messages
* Small improvements and minor bug fixes
* Updated [Public Suffix List](https://github.com/publicsuffix/list)
* Updated [translations](https://crowdin.com/project/open-source-email)

### 1.2154 - 2024-02-01

* Small improvements and minor bug fixes
* Updated [Public Suffix List](https://github.com/publicsuffix/list)
* Updated [translations](https://crowdin.com/project/open-source-email)

### 1.2153 - 2024-01-27 *

* Added mini audio player position
* Added showing duration of audio/video files
* Small improvements and minor bug fixes
* Updated [Public Suffix List](https://github.com/publicsuffix/list)
* Updated [translations](https://crowdin.com/project/open-source-email)

### 1.2152 - 2024-01-26

* Added mini audio player
* Added video preview image
* Small improvements and minor bug fixes
* Updated libraries (JsonPath)
* Updated [AndroidX](https://developer.android.com/jetpack/androidx/versions/all-channel)
* Updated [Public Suffix List](https://github.com/publicsuffix/list)
* Updated [translations](https://crowdin.com/project/open-source-email)

### 1.2151 - 2024-01-22

* Fixed crash on some devices

### 1.2150 - 2024-01-22

* Added rule action to silence notifications, see [the FAQ](https://github.com/M66B/FairEmail/blob/master/FAQ.md#faq71)
* Added option to disable Gmail labels button
* Performance optimizations
* Small improvements and minor bug fixes
* Updated [AndroidX](https://developer.android.com/jetpack/androidx/versions/all-channel)
* Updated [translations](https://crowdin.com/project/open-source-email)

### 1.2149 - 2024-01-08

* Added option to delay automatically marking messages as read
* Replaced [javadns](https://github.com/dnsjava/dnsjava) by [MiniDNS](https://github.com/MiniDNS/minidns)
* Added account/identity options to enforce DNSSEC and/or DANE, see [the FAQ](https://github.com/M66B/FairEmail/blob/master/FAQ.md#faq202)
* Small improvements and minor bug fixes
* Updated [biweekly](https://github.com/mangstadt/biweekly)
* Updated [translations](https://crowdin.com/project/open-source-email)

### [Wintonotitan](https://en.wikipedia.org/wiki/Wintonotitan)

### 1.2148 - 2024-01-08 *

* Fixed accepting EULA in some cases
* Fixed unified/primary folders navigation

### 1.2147 - 2024-01-04 *

* Small improvements and minor bug fixes
* Updated build tools
* Updated Material design library
* Updated [translations](https://crowdin.com/project/open-source-email)

### 1.2146 - 2024-01-02

* Happy New Year!
* Added *Certificate transparency*, see [the FAQ](https://github.com/M66B/FairEmail/blob/master/FAQ.md#faq201)
* Small improvements and minor bug fixes
* Updated libraries (Apache Compress, Bugsnag, Bouncy Castle, Jsoup)
* Updated [translations](https://crowdin.com/project/open-source-email)

<!-- truncate here -->

### 1.2145 - 2023-12-30

* Added Adguard filter list to remove tracking parameters from links, see [the FAQ](https://github.com/M66B/FairEmail/blob/master/FAQ.md#faq200)
* Small improvements and minor bug fixes
* Updated [translations](https://crowdin.com/project/open-source-email)

### 1.2144 - 2023-12-27

* Using [Brave browser lists](https://github.com/brave/adblock-lists/tree/master/brave-lists) to filter URLs
* Small improvements and minor bug fixes
* Updated [translations](https://crowdin.com/project/open-source-email)

### 1.2143 - 2023-12-22

* Fixed searching in single folder
* Added button to unblock all
* Added importance to swipe-ask popup menu
* Small improvements and minor bug fixes
* Updated [translations](https://crowdin.com/project/open-source-email)

### 1.2142 - 2023-12-20

* Fixed performance issues
* Restored storing attachments on external storage
* Small improvements and minor bug fixes
* Updated [translations](https://crowdin.com/project/open-source-email)

### 1.2141 - 2023-12-19

* Small improvements and minor bug fixes
* Updated [translations](https://crowdin.com/project/open-source-email)

### 1.2140 - 2023-12-17

* Fixed sometimes failing biometric authentication
* Switched to [tinylog](https://tinylog.org/v2/)
* Small improvements and minor bug fixes
* Updated [AndroidX](https://developer.android.com/jetpack/androidx/versions/all-channel)
* Updated [translations](https://crowdin.com/project/open-source-email)

### 1.2139 - 2023-12-13

* Enabled TLSv1.3 by default
* Added option to limit download size also for unmetered connections
* Small improvements and minor bug fixes
* Updated [Public Suffix List](https://github.com/publicsuffix/list)
* Updated [translations](https://crowdin.com/project/open-source-email)

### 1.2138 - 2023-12-12

* Fixed *No protocols enabled* error
* Small improvements and minor bug fixes
* Updated [translations](https://crowdin.com/project/open-source-email)

### 1.2137 - 2023-12-12

* Optimized database for storing many messages
* Automatically update [SSL provider](https://developer.android.com/privacy-and-security/security-gms-provider)
* Removed custom trust manager to comply with Play Store policies (Play Store version only)
* Removed external storage option of attachments to comply with Play Store policies (all versions)
* Small improvements and minor bug fixes
* Updated [Public Suffix List](https://github.com/publicsuffix/list)
* Updated [translations](https://crowdin.com/project/open-source-email)

### 1.2136 - 2023-12-07

* Preventing [XML external entity injection](https://cheatsheetseries.owasp.org/cheatsheets/XML_External_Entity_Prevention_Cheat_Sheet.html)
* Small improvements and minor bug fixes
* Updated [translations](https://crowdin.com/project/open-source-email)

### 1.2135 - 2023-12-04

* Added swipe action to change importance
* Added group headings for important and unimportant messages
* Small improvements and minor bug fixes
* Updated [translations](https://crowdin.com/project/open-source-email)

### 1.2134 - 2023-12-02

* Fixed clearing settings values
* Small improvements and minor bug fixes
* Updated [translations](https://crowdin.com/project/open-source-email)

### 1.2133 - 2023-12-01

* Fixed memory leak
* Improved [Linked Data](https://json-ld.org/) support (GitHub version only)
* Small improvements and minor bug fixes
* Updated [translations](https://crowdin.com/project/open-source-email)

### 1.2132 - 2023-12-01

* Added basic support for [Linked Data](https://json-ld.org/) (GitHub version only)
* Added date/time placeholders for keyword rules (see [the FAQ](https://github.com/M66B/FairEmail/blob/master/FAQ.md#faq71))
* Added option to disable saving revisions for undo/redo
* Small improvements and minor bug fixes
* Updated build tools
* Updated [AndroidX](https://developer.android.com/jetpack/androidx/versions/all-channel)
* Updated [translations](https://crowdin.com/project/open-source-email)

### [Vallibonavenatrix](https://en.wikipedia.org/wiki/Vallibonavenatrix)

### 1.2131 - 2023-11-27 *

* Small improvements and minor bug fixes
* Updated [translations](https://crowdin.com/project/open-source-email)

### 1.2130 - 2023-11-25

* Fixed styling of reformatted message view
* Updated [translations](https://crowdin.com/project/open-source-email)

### 1.2129 - 2023-11-25

* Added optional print margin
* Small improvements and minor bug fixes
* Updated [Public Suffix List](https://github.com/publicsuffix/list)
* Updated [translations](https://crowdin.com/project/open-source-email)

### 1.2128 - 2023-11-19

* Restored old behavior of move-to quick action
* Small improvements and minor bug fixes
* Updated [Public Suffix List](https://github.com/publicsuffix/list)
* Updated [translations](https://crowdin.com/project/open-source-email)

### 1.2127 - 2023-11-16

* Fixed move / quick action bar
* Small improvements and minor bug fixes
* Updated [AndroidX](https://developer.android.com/jetpack/androidx/versions/all-channel)
* Updated [translations](https://crowdin.com/project/open-source-email)

### 1.2126 - 2023-11-15

* Fixed compatibility with Android 5 Lollipop
* Small improvements and minor bug fixes

### 1.2125 - 2023-11-15

* Small improvements and minor bug fixes
* Updated [translations](https://crowdin.com/project/open-source-email)

### 1.2124 - 2023-11-14

* Fixed swipe / ask what to do
* Added moving POP3 messages to IMAP accounts
* Small improvements and minor bug fixes
* Updated [translations](https://crowdin.com/project/open-source-email)

### 1.2123 - 2023-11-13

* Added integrations-settings tab page
* Small improvements and minor bug fixes
* Updated [translations](https://crowdin.com/project/open-source-email)

### 1.2122 - 2023-11-11

* Fixed swipe to mark read/unread
* Small improvements and minor bug fixes
* Updated [translations](https://crowdin.com/project/open-source-email)

### 1.2121 - 2023-11-11

* Added option to disable haptic feedback
* Fixed swipe to mark read/unread
* Small improvements and minor bug fixes
* Updated [translations](https://crowdin.com/project/open-source-email)

### 1.2120 - 2023-11-09

* Added removing Gmail and Outlook style signatures (send settings)
* Reduced database traffic
* Small improvements and minor bug fixes
* Updated build tools and libraries
* Updated [translations](https://crowdin.com/project/open-source-email)

### 1.2119 - 2023-11-06

* Added folder selection for new message count widget
* Added dark mode, showing colors, check HTML and searching to message source view
* Added option for ASCII-only notifications (for some smartwatches)
* Small improvements and minor bug fixes
* Updated [translations](https://crowdin.com/project/open-source-email)

### 1.2118 - 2023-11-04

* Added native *View source* (HTML) with syntax highlighting, etc.
* Added configurable button for *View source*
* Added resizing of [WebP](https://en.wikipedia.org/wiki/WebP)
* Small improvements and minor bug fixes
* Updated [Public Suffix List](https://github.com/publicsuffix/list)
* Updated [translations](https://crowdin.com/project/open-source-email)

### 1.2117 - 2023-11-02

* Improved identity selector
* Small improvements and minor bug fixes
* Updated [AndroidX](https://developer.android.com/jetpack/androidx/versions/all-channel)
* Updated [translations](https://crowdin.com/project/open-source-email)

### 1.2116 - 2023-10-30

* Fixed a crash in the JSoup library on Android 7.0 and earlier
* Updated [translations](https://crowdin.com/project/open-source-email)

### 1.2115 - 2023-10-30

* Added option to disable storing invitations tentatively, see [the FAQ](https://github.com/M66B/FairEmail/blob/master/FAQ.md#faq186)
* Fixed time zone of some calendar events
* Small improvements and minor bug fixes
* Updated libraries, including [JSoup](https://jsoup.org/news/) and [Material Components](https://github.com/material-components/material-components-android)
* Updated [Public Suffix List](https://github.com/publicsuffix/list)
* Updated [translations](https://crowdin.com/project/open-source-email)

### 1.2114 - 2023-10-25

* Added tap on title/subtitle to open/switch to inbox
* Addded option to disable showing recipient for sent messages
* Small improvements and minor bug fixes
* Updated [translations](https://crowdin.com/project/open-source-email)

### 1.2113 - 2023-10-21

* Added '*More options*' to send dialog box
* Added option to disable PDF preview (display settings)
* Added option to suggest local contacts for the current account only (send settings)
* Android 14: using Material You background color
* Fixed back navigation in some circumstances
* Small improvements and minor bug fixes
* Updated [AndroidX](https://developer.android.com/jetpack/androidx/versions/all-channel)
* Updated [Public Suffix List](https://github.com/publicsuffix/list)
* Updated [translations](https://crowdin.com/project/open-source-email)

### 1.2112 - 2023-10-16 *

* Small improvements and minor bug fixes

### 1.2111 - 2023-10-16

* Added swipe to delete local contacts
* Small improvements and minor bug fixes
* Updated [translations](https://crowdin.com/project/open-source-email)

### 1.2110 - 2023-10-14

* Added PDF thumbnail preview (mini gallery)
* Small improvements and minor bug fixes
* Updated [translations](https://crowdin.com/project/open-source-email)

### 1.2109 - 2023-10-14

* Small improvements and minor bug fixes

### 1.2108 - 2023-10-12

* Added [Liberation Sans Narrow](https://github.com/liberationfonts/liberation-sans-narrow) font (advanced display options)
* Added *$weekday$* placeholder for templates
* Added option to disabling printing of block quotes lines
* Added accessibility actions to mark a message read/unread and to trash a conversation
* Small improvements and minor bug fixes
* Updated [AndroidX](https://developer.android.com/jetpack/androidx/versions/all-channel)
* Updated [translations](https://crowdin.com/project/open-source-email)

### 1.2107 - 2023-10-04

* Added rule action to execute webhooks
* Small improvements and minor bug fixes
* Updated [Public Suffix List](https://github.com/publicsuffix/list)
* Updated [translations](https://crowdin.com/project/open-source-email)

### 1.2106 - 2023-09-27

* Added option to use up/down arrows for next/previous conversation
* Small improvements and minor bug fixes
* Updated [Public Suffix List](https://github.com/publicsuffix/list)
* Updated [translations](https://crowdin.com/project/open-source-email)

### 1.2105 - 2023-09-23

* Added advanced identity option for default [sensitivity](https://datatracker.ietf.org/doc/html/rfc4021#section-2.1.55)
* Ignoring maximum width [media queries](https://developer.mozilla.org/en-US/docs/Web/CSS/CSS_media_queries/Using_media_queries)
* Small improvements and minor bug fixes
* Updated [translations](https://crowdin.com/project/open-source-email)

### 1.2104 - 2023-09-21

* Improved SVG support
* Small improvements and minor bug fixes
* Updated libraries
* Updated [AndroidX](https://developer.android.com/jetpack/androidx/versions/all-channel)
* Updated [Public Suffix List](https://github.com/publicsuffix/list)
* Updated [translations](https://crowdin.com/project/open-source-email)

### 1.2103 - 2023-09-18 *

* Small improvements and minor bug fixes
* Updated [translations](https://crowdin.com/project/open-source-email)

### 1.2102 - 2023-09-16

* Fixed back navigation search
* Small improvements and minor bug fixes
* Updated [translations](https://crowdin.com/project/open-source-email)

### 1.2101 - 2023-09-15

* Small improvements and minor bug fixes
* Updated [translations](https://crowdin.com/project/open-source-email)

### 1.2100 - 2023-09-14

* Fixed VPN only option
* Added option for LanguageTool problem description popup
* Small improvements and minor bug fixes
* Updated [translations](https://crowdin.com/project/open-source-email)

### 1.2099 - 2023-09-13

* Fixed POP3 sync issue
* Small improvements and minor bug fixes
* Updated [translations](https://crowdin.com/project/open-source-email)

### 1.2098 - 2023-09-12

* Added support for *text/markdown* message parts
* Added support for *text/x-diff* and *text/x-patch* message parts
* Small improvements and minor bug fixes
* Updated libraries
* Updated [translations](https://crowdin.com/project/open-source-email)

### 1.2097 - 2023-09-02

* Added LanguageTool option to check every sentence
* Added read/delivery receipt type selection to advanced identity settings
* Small improvements and minor bug fixes
* Updated [translations](https://crowdin.com/project/open-source-email)

### 1.2096 - 2023-08-31

* Small improvements and minor bug fixes
* Updated [Public Suffix List](https://github.com/publicsuffix/list)
* Updated [translations](https://crowdin.com/project/open-source-email)

### 1.2095 - 2023-08-26

* Added workaround for opening *audio/x-wav* attachments (not supported by all sound players)
* Added batch enable/disable downloading of headers only for all child folders
* Added notification to disable alarm sound initiated by filter rules
* Improved CSS processing for reformatted message view
* Restoring conversation thread on rotation changes from/to one/two rows/columns
* Disabled Android app chooser by default because of a bug in MIUI
* Fixed decoding of POP3 messages when *Content-Type* is missing due to truncated TOP headers
* Fixed multi term search with non-alphanumeric characters
* Fixed deleting of *message/rfc822* attachments (GitHub version only)
* Fixed option to disable Android photo picker with a workaround
* Small improvements and minor bug fixes
* Updated [AndroidX](https://developer.android.com/jetpack/androidx/versions/all-channel)
* Updated [Public Suffix List](https://github.com/publicsuffix/list)
* Updated [translations](https://crowdin.com/project/open-source-email)

### 1.2094 - 2023-08-14

* Added rule action to add local notes
* Removed a workaround for an Android issue that caused side effects
* Updated [translations](https://crowdin.com/project/open-source-email)

### 1.2093 - 2023-08-14

* Small improvements and minor bug fixes
* Updated [Public Suffix List](https://github.com/publicsuffix/list)
* Updated [AndroidX](https://developer.android.com/jetpack/androidx/versions/all-channel)
* Updated [translations](https://crowdin.com/project/open-source-email)

### 1.2092 - 2023-08-12

* Replace [address element](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/address) by [geo](https://en.wikipedia.org/wiki/Geo_URI_scheme) link
* Small improvements and minor bug fixes
* Updated [AndroidX](https://developer.android.com/jetpack/androidx/versions/all-channel)
* Updated [translations](https://crowdin.com/project/open-source-email)

### 1.2091 - 2023-08-05

* Fixed crash
* Small improvements and minor bug fixes
* Updated [translations](https://crowdin.com/project/open-source-email)

### 1.2090 - 2023-08-04

* Small improvements and minor bug fixes
* Updated [Bouncy Castle](https://www.bouncycastle.org/)
* Updated [Public Suffix List](https://github.com/publicsuffix/list)
* Updated [translations](https://crowdin.com/project/open-source-email)

### 1.2089 - 2023-08-01

* Fixed S/MIME encrypt+sign
* Fixed selecting images on older Android versions
* Small improvements and minor bug fixes
* Updated [Public Suffix List](https://github.com/publicsuffix/list)
* Updated [translations](https://crowdin.com/project/open-source-email)

### 1.2088 - 2023-07-28

* Improved Android 14 compatibility
* Small improvements and minor bug fixes
* Updated [AndroidX](https://developer.android.com/jetpack/androidx/versions/all-channel)
* Updated [translations](https://crowdin.com/project/open-source-email)

### 1.2087 - 2023-07-19

* Fixed duplicate sent messages for Outlook in some cases
* Small improvements and minor bug fixes

### 1.2086 - 2023-07-19

* Added option to disable message list widget title
* Fixed duplicate sent messages for Outlook in some cases
* Small improvements and minor bug fixes
* Updated [AndroidX](https://developer.android.com/jetpack/androidx/versions/all-channel)
* Updated [translations](https://crowdin.com/project/open-source-email)

### 1.2085 - 2023-07-14

* Improved Android 14 compatibility
* Small improvements and minor bug fixes
* Updated [translations](https://crowdin.com/project/open-source-email)

### 1.2083 - 2023-07-10

* Added collapsible attachment section
* Added support for *multipart/digest* messages
* Small improvements and minor bug fixes
* Updated [translations](https://crowdin.com/project/open-source-email)

### 1.2082 - 2023-07-07

* Added a workaround for a server bug
* Fixed crash introduced in version 1.2081
* Small improvements and minor bug fixes
* Updated [translations](https://crowdin.com/project/open-source-email)

### 1.2081 - 2023-07-06

* Added an option to auto-verify signed messages
* Added an option to use the identity color for bottom action bar
* Small improvements and minor bug fixes
* Updated [translations](https://crowdin.com/project/open-source-email)

### 1.2080 - 2023-07-03

* Fixed PGP and S/MIME signed messages in some cases
* Updated [Public Suffix List](https://github.com/publicsuffix/list)
* Updated [translations](https://crowdin.com/project/open-source-email)

### 1.2079 - 2023-06-30

* Targeting Android 14
* Added option to sync all folders (pull down to refresh account/folder list)
* Small improvements and minor bug fixes
* Updated [translations](https://crowdin.com/project/open-source-email)

### 1.2078 - 2023-06-27

* Added notes to message list widget
* Added create alias dialog (long press identity)
* Added option for larger count for new message count widget
* Added deleting attachments (horizontal three-dots menu above the message text)
* Added translating subject in message editor when it is focussed
* Inheriting identity color from account color
* Using selected font for reply header and signature too
* Updated [Public Suffix List](https://github.com/publicsuffix/list)
* Small improvements and minor bug fixes
* Updated [translations](https://crowdin.com/project/open-source-email)

### 1.2077 - 2023-06-14

* Fixed all reported bugs
* Updated [Public Suffix List](https://github.com/publicsuffix/list)
* Small improvements and minor bug fixes
* Updated [translations](https://crowdin.com/project/open-source-email)

### 1.2076 - 2023-06-13

* Android 14 compatibility
* Added downloading Outlook contacts (main settings)
* Added categories for [Disconnect's tracker protection lists](https://github.com/disconnectme/disconnect-tracking-protection) (privacy settings)
* Updated build tools and libraries
* Updated [Public Suffix List](https://github.com/publicsuffix/list)
* Small improvements and minor bug fixes
* Updated [translations](https://crowdin.com/project/open-source-email)

### [Tratayenia](https://en.wikipedia.org/wiki/Tratayenia)

### 1.2075 - 2023-06-08

* Added option to add send-to-self to Android's share menu
* Added separate filter settings for archive, trash and spam folder
* Small improvements and minor bug fixes
* Updated [translations](https://crowdin.com/project/open-source-email)

### 1.2074 - 2023-06-03

* Fixed all reported bugs
* Small improvements and minor bug fixes
* Updated [translations](https://crowdin.com/project/open-source-email)

### 1.2073 - 2023-05-30

* Added file viewing confirmation
* Small improvements and minor bug fixes
* Updated [translations](https://crowdin.com/project/open-source-email)

### 1.2072 - 2023-05-29

* Fixed [badge count](https://github.com/M66B/FairEmail/blob/master/FAQ.md#faq106)
* Small improvements and minor bug fixes
* Updated [translations](https://crowdin.com/project/open-source-email)

### 1.2071 - 2023-05-27

* Fixed photo picker for some devices
* Small improvements and minor bug fixes
* Updated [AndroidX](https://developer.android.com/jetpack/androidx/versions/all-channel)
* Updated [translations](https://crowdin.com/project/open-source-email)

### 1.2070 - 2023-05-20

* Added option to start with two columns/rows
* Added option to show both date and time in message headers
* Added option to replace source text by translated text
* Added support for reminders in events
* Small improvements and minor bug fixes
* Updated [AndroidX](https://developer.android.com/jetpack/androidx/versions/all-channel)
* Updated [translations](https://crowdin.com/project/open-source-email)

### [Saltopus](https://en.wikipedia.org/wiki/Saltopus)

### 1.2069 - 2023-05-09

* Added support for Surface Duo 2
* Added auto scroll to message editor for Android 14
* Improved swipe left/right sensitivity
* Small improvements and minor bug fixes
* Updated build tools
* Updated [Public Suffix List](https://github.com/publicsuffix/list)
* Updated [translations](https://crowdin.com/project/open-source-email)

### 1.2068 - 2023-04-29

* Fixed all reported bugs
* Small improvements and minor bug fixes
* Updated [Public Suffix List](https://github.com/publicsuffix/list)
* Updated [translations](https://crowdin.com/project/open-source-email)

### 1.2067 - 2023-04-22

* Fixed attaching files with a long name
* Small improvements and minor bug fixes

### 1.2066 - 2023-04-21

* Fixed all reported bugs
* Added younger than rule condition
* Added option to show filter icon when rules were applied
* Added warning for long attachment file names
* Small improvements and minor bug fixes
* Updated [AndroidX](https://developer.android.com/jetpack/androidx/versions/all-channel)
* Updated [translations](https://crowdin.com/project/open-source-email)

### 1.2065 - 2023-04-16

* Fixed extra new lines
* Small improvements and minor bug fixes

### 1.2064 - 2023-04-15

* Fixed all reported bugs
* Small improvements and minor bug fixes

### 1.2063 - 2023-04-13

* Fixed sending via Outlook graph in some cases
* Small improvements and minor bug fixes
* Updated [translations](https://crowdin.com/project/open-source-email)

### 1.2062 - 2023-04-12

* Fixed importing settings
* Added advanced account option for summary only notifications
* Small improvements and minor bug fixes
* Updated [translations](https://crowdin.com/project/open-source-email)

### 1.2061 - 2023-04-10

* Added filter rule groups (stop processing per group)
* Added executing of filter rules by automation apps, see [the FAQ](https://github.com/M66B/FairEmail/blob/master/FAQ.md#faq71)
* Improved auto-discovery via DNS SRV records
* Small improvements and minor bug fixes
* Updated [AndroidX](https://developer.android.com/jetpack/androidx/versions/all-channel)
* Updated [Material Components](https://github.com/material-components/material-components-android)
* Updated [Public Suffix List](https://github.com/publicsuffix/list)
* Updated [translations](https://crowdin.com/project/open-source-email)

### 1.2060 - 2023-04-01

* Added draft message printing
* Added copy filter rule to another account/folder
* Added linking contacts to identities to attach vCards
* Small improvements and minor bug fixes
* Updated [AndroidX](https://developer.android.com/jetpack/androidx/versions/all-channel)
* Updated [translations](https://crowdin.com/project/open-source-email)

### [Rahonavis](https://en.wikipedia.org/wiki/Rahonavis)

### 1.2059 - 2023-03-24

* Fixed all reported bugs

### 1.2058 - 2023-03-22

* Small improvements and minor bug fixes
* Updated [translations](https://crowdin.com/project/open-source-email)

### 1.2057 - 2023-03-19

* Added an option to use the monospaced font when writing a plain text only messages
* Small improvements and minor bug fixes
* Updated [translations](https://crowdin.com/project/open-source-email)

### 1.2056 - 2023-03-17

* Fixed decoding of subject in some cases
* Small improvements and minor bug fixes
* Updated [translations](https://crowdin.com/project/open-source-email)

### 1.2055 - 2023-03-16

* Added option to configure the number of widget subject lines
* Added remembering last used folder for contacts
* Small improvements and minor bug fixes
* Updated [translations](https://crowdin.com/project/open-source-email)

### 1.2054 - 2023-03-14

* Added rule action option to delete keywords
* Small improvements and minor bug fixes
* Updated build tools (NDK)
* Updated [translations](https://crowdin.com/project/open-source-email)

### 1.2053 - 2023-03-13

* Added PGP encrypt-only
* Added weekend scheduling (receive-settings tab page)
* Added reply template sorting options
* Added display option to vertically align keywords, preview, and notes
* Improved [OpenAI (ChatGPT) integration](https://github.com/M66B/FairEmail/blob/master/FAQ.md#faq190)
* Small improvements and minor bug fixes
* Updated [AndroidX](https://developer.android.com/jetpack/androidx/versions/all-channel)
* Updated [Public Suffix List](https://github.com/publicsuffix/list)
* Updated [translations](https://crowdin.com/project/open-source-email)

### 1.2052 - 2023-03-08

* Added experimental [OpenAI (ChatGPT) integration](https://github.com/M66B/FairEmail/blob/master/FAQ.md#faq190)
* Small improvements and minor bug fixes

### [Quetecsaurus](https://en.wikipedia.org/wiki/Quetecsaurus)

### 1.2051 - 2023-03-05

* Fixed changing auth type
* Small improvements and minor bug fixes

### 1.2050 - 2023-03-05

* Fixed updating Microsoft Graph tokens
* Small improvements and minor bug fixes

### 1.2049 - 2023-03-04

* Fixed refreshing Microsoft Graph tokens

### 1.2048 - 2023-03-04

* Fixed 'Other provider' setup wizard

### 1.2047 - 2023-03-04

* Fixed authenticating Yahoo/AOL accounts
* Small improvements and minor bug fixes
* Updated translations

### 1.2046 - 2023-03-04

* Added sort options for filter rules
* Added option to disable auto hiding of answer button
* Added option to auto enable sync of new folders
* Added presets for snooze / delayed send
* Added account/folder colors to account/folder name in message header
* Added scrolling of original message when using up/down buttons
* Added Korean and Norwegian to DeepL
* Small improvements and minor bug fixes
* Updated AndroidX
* Updated translations

### 1.2045 - 2023-02-18

* Small improvements and minor bug fixes
* Updated AndroidX
* Updated translations

### 1.2043 - 2023-02-05

* Small improvements and minor bug fixes
* Updated material design library
* Updated translations

### 1.2042 - 2023-02-03

* Fixed confirming non-https links
* Small improvements and minor bug fixes
* Updated translations

### 1.2041 - 2023-02-02

* Added collapsing block quotes again
* Added biometric authentication to show passwords
* Added every day to rule relative time condition
* Small improvements and minor bug fixes
* Updated build tools
* Updated translations

### 1.2040 - 2023-01-31

* Reverted message text preview layout change
* Small improvements and minor bug fixes
* Updated translations

### 1.2039 - 2023-01-31

* Fixed upgrading from older versions
* Small improvements and minor bug fixes
* Updated translations

### 1.2038 - 2023-01-30

* Showing person icon for contacts without avatars
* Small improvements and minor bug fixes
* Updated translations

### 1.2037 - 2023-01-29

* Fixed archiving of sent messages
* Small improvements and minor bug fixes
* Updated translations

### 1.2036 - 2023-01-29

* Fixed folder item layout
* Small improvements and minor bug fixes
* Updated translations

### 1.2035 - 2023-01-28

* Added option to disable trashing sent messages when trashing a conversation
* Small improvements and minor bug fixes
* Updated translations

### 1.2034 - 2023-01-27

* Fixed sending attachments with POP3
* Added styling settings with an option to keep the selection
* Added option to select default folder (behavior settings)
* Small improvements and minor bug fixes
* Updated translations

### 1.2033 - 2023-01-26

* Fixed incorrect folder state icons
* Small improvements and minor bug fixes
* Updated translations

### 1.2032 - 2023-01-26

* Added local POP3 operations to reduce the number of account connections
* Small improvements and minor bug fixes
* Updated AndroidX
* Updated translations

### 1.2031 - 2023-01-24

* Added [cloud sync](https://github.com/M66B/FairEmail/blob/master/FAQ.md#faq189) to synchronize accounts across devices
* Added "*Don't ask again*" for mailto links
* Added inserting image links
* Added menu item to check HTML syntax of a signature
* Added option to disable last sync time in the navigation menu
* Added option to disable automatically blocking spam senders
* Added option to configure default answer button action
* Added option to automatically close conversations on sending messages
* Small improvements and minor bug fixes
* Updated translations

### 1.2030 - 2023-01-14

* Added backup settings tab page
* Added option to disable quick actions
* Improved performance
* Small improvements and minor bug fixes
* Updated AndroidX
* Updated translations

### 1.2029 - 2023-01-09

* Added auto hiding top toolbar when scrolling messages (can be turned off in the display settings)
* Added option to disable automatically plain text only when replying to a plain text only message
* Added option to show unread count badge at the top of the unread count widget
* Added option for normal importance quick action
* Small improvements and minor bug fixes
* Updated translations

### [Pelecanimimus](https://en.wikipedia.org/wiki/Pelecanimimus)

### 1.2028 - 2023-01-06

* Small improvements and minor bug fixes
* Updated translations

### 1.2027 - 2023-01-04

* Small improvements and minor bug fixes
* Updated translations

### 1.2026 - 2023-01-02

* Small improvements and minor bug fixes
* Updated translations

### 1.2025 - 2023-01-01

* Happy New Year / Frohes neues Jahr / Bonne Année
* Small improvements and minor bug fixes

### 1.2024 - 2022-12-31

* Small improvements and minor bug fixes

### 1.2023 - 2022-12-30

* Restored the bugfix and declared that the app is sending email addresses to third-parties in the Play Store data safety form when it is not :-(

### 1.2022 - 2022-12-30

* Reverted a bugfix to comply with Play Store policies
* Small improvements and minor bug fixes

### 1.2021 - 2022-12-30

* Disabled BIMI for the Play Store version
* Small improvements and minor bug fixes

### 1.2020 - 2022-12-30

* Fixed opening the app in some circumstances
* Small improvements and minor bug fixes

### 1.2019 - 2022-12-28

* Fixed push messages in some circumstances
* Small improvements and minor bug fixes

### 1.2018 - 2022-12-28

* Fixed occasional freezes
* Added option to run rules daily
* Added inserting lines to style toolbar
* Small improvements and minor bug fixes
* Updated translations

### 1.2017 - 2022-12-23

* Added option to disable unread shadow border
* Small improvements and minor bug fixes
* Updated translations

### 1.2016 - 2022-12-18

* Fixed crash introduced in previous version
* Small improvements and minor bug fixes

### 1.2015 - 2022-12-18

* Fixed default compose font / text color
* Updated translations

### 1.2014 - 2022-12-17

* Added saved search for specific account/folder
* Added option for default text color for message composer
* Added option to swap trash/archive button in bottom action bar
* Small improvements and minor bug fixes
* Updated translations

### 1.2013 - 2022-12-09

* Added scrolling/fixed style toolbar
* Added folder create button to folder selection dialog
* Small improvements and minor bug fixes
* Updated AndroidX
* Updated translations

### 1.2012 - 2022-12-01

* Small improvements and minor bug fixes

### Next version

* Added send option for default text color
* Added display option to swap trash/archive in bottom action bar
* Small improvements and minor bug fixes
* Updated translations

### 1.2011 - 2022-11-29

* Added optional button to show original message full screen
* Added optional colored star quick action button
* Small improvements and minor bug fixes
* Updated AndroidX
* Updated translations

### 1.2010 - 2022-11-25

* Fixed inserting links into signatures
* Small improvements and minor bug fixes

### 1.2009 - 2022-11-25

* Small improvements and minor bug fixes
* Updated translations

### 1.2008 - 2022-11-23

* Improved original message view scrolling
* Small improvements and minor bug fixes
* Updated translations

### [Ninjatitan](https://en.wikipedia.org/wiki/Ninjatitan)

### 1.2007 - 2022-11-17

* Small improvements and minor bug fixes
* Updated translations

### 1.2006 - 2022-11-16

* Added searching again on the server in another account/folder
* Small improvements and minor bug fixes
* Updated translations

### 1.2004 - 2022-11-15

* Added send reminder for no/suitable internet
* Added option to retain selection after quick action
* LanguageTool premium: check per paragraph
* Small improvements and minor bug fixes
* Updated libraries
* Updated translations

### 1.2003 - 2022-11-12

* Added option to remove tracking parameters by default (privacy settings tab page)
* Small improvements and minor bug fixes
* Updated translations

### 1.2002 - 2022-11-10

* Fixed Outlook / Office 365 authentication
* Updated translations

### 1.2001 - 2022-11-10

* Fixed Outlook / Office 365 OAuth in some cases
* Small improvements and minor bug fixes
* Updated translations

### 1.2000 - 2022-11-10

* Added OAuth for AOL (quick setup wizard)
* Added change password button (main settings/extras section)
* Added support for LanguageTool premium features, [see the FAQ](https://github.com/M66B/FairEmail/blob/master/FAQ.md#faq180)
* Added optional unified inbox navigation menu item (when the inboxes and unified folders diverge)
* Added zipping attachments in the message composer (long press attached file)
* Small improvements and minor bug fixes
* Updated AndroidX
* Updated translations

### 1.1999 - 2022-11-05

* Fixed refreshing OAuth tokens in some situations
* Small improvements and minor bug fixes
* Updated translations

### 1.1998 - 2022-11-05

* Fixed purging spam/trash in some situations

### 1.1997 - 2022-11-05

* Small improvements and minor bug fixes
* Updated translations

### 1.1996 - 2022-11-04

* Added auto storing iCalendar invitations, [see the FAQ](https://github.com/M66B/FairEmail/blob/master/FAQ.md#faq186)
* Added Jsoup selector conditions, [see the FAQ](https://github.com/M66B/FairEmail/blob/master/FAQ.md#faq71)
* Small improvements and minor bug fixes
* Updated translations

### [Mei long](https://en.wikipedia.org/wiki/Mei_long)

### 1.1995 - 2022-10-30

* Added selectable widget opacity for Android 12 and later
* Added option to auto encrypt when all public keys are available
* Small improvements and minor bug fixes
* Updated libraries
* Updated translations

### 1.1994 - 2022-10-29

* Fixed settings export for older devices
* Small improvements and minor bug fixes
* Updated translations

### 1.1993 - 2022-10-28

* Fixed rare crash
* Small improvements and minor bug fixes
* Updated translations

### 1.1992 - 2022-10-27

* Fixed creating folders

### 1.1991 - 2022-10-26

* Small improvements and minor bug fixes
* Updated AndroidX
* Updated translations

### 1.1990 - 2022-10-23

* Added decryption of protected content, see [the FAQ](https://github.com/M66B/FairEmail/blob/master/FAQ.md#faq184)
* Fixed British English translation again
* Small improvements and minor bug fixes
* Updated translations

### 1.1989 - 2022-10-22

* Fixed British English translation
* Small improvements and minor bug fixes
* Updated translations

### 1.1988 - 2022-10-22

* Small improvements and minor bug fixes
* Updated translations

### 1.1987 - 2022-10-21

* Improved settings file encryption, see [the FAQ](https://github.com/M66B/FairEmail/blob/master/FAQ.md#faq36)
* Small improvements and minor bug fixes
* Updated translations

### 1.1986 - 2022-10-19

* Improved password entry
* Improved protected content length check
* Fixed rebuilding full-text index
* Small improvements and minor bug fixes
* Updated translations

### 1.1985 - 2022-10-18

* Added password protected content, see [the FAQ](https://github.com/M66B/FairEmail/blob/master/FAQ.md#faq184)
* Small improvements and minor bug fixes
* Updated translations

### 1.[1984](https://en.wikipedia.org/wiki/Nineteen_Eighty-Four) - 2022-10-16

* Small improvements and minor bug fixes
* Updated translations

### 1.1983 - 2022-10-15

* Added subscript and superscript to message editor
* Small improvements and minor bug fixes
* Updated Public Suffix List
* Updated build tools
* Updated translations

### 1.1982 - 2022-10-14

* Small improvements and minor bug fixes
* Updated Public Suffix List
* Updated translations

### 1.1981 - 2022-10-13

* Added AND (+) and NOT (-) search terms to on-device searching, see [the FAQ](https://github.com/M66B/FairEmail/blob/master/FAQ.md#faq13)
* Added filter conditions to match signed/encrypted messages, see [the FAQ](https://github.com/M66B/FairEmail/blob/master/FAQ.md#faq71)
* Small improvements and minor bug fixes
* Updated Public Suffix List
* Updated translations

### 1.1980 - 2022-10-10

* Added *cc:*, *bcc:* search prefixes, see [the FAQ](https://github.com/M66B/FairEmail/blob/master/FAQ.md#faq13)
* Small improvements and minor bug fixes
* Updated translations

### 1.1979 - 2022-10-09

* Added *from:*, *to:* and *keyword:* search prefixes, see [the FAQ](https://github.com/M66B/FairEmail/blob/master/FAQ.md#faq13)
* Fixed orphan message files
* Small improvements and minor bug fixes
* Updated translations

### 1.1978 - 2022-10-08

* Fixed orphan message files
* Small improvements and minor bug fixes
* Updated translations

### 1.1977 - 2022-10-08

* Copy/delete instead of move message files
* Small improvements and minor bug fixes
* Updated translations

### 1.1976 - 2022-10-08

* © A means for the automated addition of intrinsically-paired punctuation marks to a text, through the use of text selection and interaction with a screen-based context menu
* Optimized storing of messages
* Small improvements and minor bug fixes
* Updated AndroidX
* Updated Public Suffix List
* Updated translations

### 1.1975 - 2022-10-06

* Added Thunderbird label colors
* Added decoding of Mandrill and Amazon tracking links
* Fixed decoding of embedded messages
* Reduced memory usage
* Small improvements and minor bug fixes
* Updated Public Suffix List
* Updated translations

### 1.1974 - 2022-10-03

* Added long press date header to select messages
* Added option to check paragraph with LanguageTool after a newline
* Small improvements and minor bug fixes
* Updated translations

### 1.1973 - 2022-10-01

* Added Ukrainian to DeepL languages
* Added showing inline images in EML files
* Improved word breaking for local searching
* Small improvements and minor bug fixes
* Updated Public Suffix List
* Updated translations

### 1.1972 - 2022-09-27

* Fixed crash

### 1.1971 - 2022-09-27

* Fixed sqlite compatibility
* Updated translations

### 1.1970 - 2022-09-27

* Switched to native sqlite
* Small improvements and minor bug fixes
* Updated translations

### 1.1969 - 2022-09-23

* Added Material You monochrome themes (Android 12+)
* Small improvements and minor bug fixes
* Updated AndroidX
* Updated translations

### 1.1968 - 2022-09-20

* Small improvements and minor bug fixes
* Updated translations

### 1.1967 - 2022-09-19

* Added warnings for unsafe attachment types
* Added experimental text block toolbar
* Added option for grouping messages by week
* Extended ipinfo with city, region and country
* Small improvements and minor bug fixes
* Updated translations

### 1.1966 - 2022-09-17

* Added create subfolder option to move filter rule
* Small improvements and minor bug fixes
* Updated translations

### 1.1965 - 2022-09-10

* Added an advanced account option to use a VPN connection only
* Reduced memory usage of message classifier
* Small improvements and minor bug fixes
* Updated AndroidX
* Updated translations

### [Ledumahadi](https://en.wikipedia.org/wiki/Ledumahadi)

### 1.1964 - 2022-09-05

* Added 'whois' to open link dialog options
* Small improvements and minor bug fixes
* Updated translations

### 1.1963 - 2022-09-03

* Small improvements and minor bug fixes
* Updated translations

### 1.1962 - 2022-09-02

* Added workaround for Outlook push messages (IMAP IDLE) bug
* Small improvements and minor bug fixes
* Updated translations

### 1.1961 - 2022-09-01

* Fixed OAuth
* Small improvements and minor bug fixes
* Updated translations

### 1.1960 - 2022-08-31

* Enabled sqlite sync extra

### 1.1959 - 2022-08-31

* Small improvements and minor bug fixes
* Updated translations

### 1.1958 - 2022-08-30

* Added extra small/large font size to message editor
* Small improvements and minor bug fixes
* Updated Public Suffix List
* Updated AndroidX
* Updated translations

### 1.1957 - 2022-08-22

* Added custom placeholder values for reply templates
* Small improvements and minor bug fixes
* Updated translations

### 1.1956 - 2022-08-20

* Added overflow menu item for larger message action buttons
* Added recognition of a series tracking parameters
* Small improvements and minor bug fixes
* Updated libraries
* Updated translations

### 1.1955 - 2022-08-18

* Small improvements and minor bug fixes
* Updated translations

### 1.1954 - 2022-08-17

* Small improvements and minor bug fixes
* Updated translations

### 1.1952 - 2022-08-16

* Small improvements and minor bug fixes
* Updated build tools (Android Studio, gradle)
* Updated translations

### 1.1951 - 2022-08-15

* Added option to download images, etc via secure connections only
* Small improvements and minor bug fixes
* Updated libraries (OAuth)
* Updated translations

### 1.1950 - 2022-08-13

* Fixed authenticating on-device Gmail accounts in some cases

### 1.1949 - 2022-08-13

* Fixed a crash caused by fixing an issue

### 1.1948 - 2022-08-13

* Extended unread shadow
* Small improvements and minor bug fixes
* Updated AndroidX
* Updated build tools (NDK)
* Updated translations

### 1.1947 - 2022-08-09

* Added POP3 batch delete
* Added FFSend (not available in the Play store version)
* Added option to disable Android photo picker (Android 13+)
* Small improvements and minor bug fixes
* Updated AndroidX, BouncyCastle and Public Suffix List
* Updated translations

### 1.1946 - 2022-07-27

* Small improvements and minor bug fixes
* Updated translations

### 1.1942 - 2022-07-25

* Improved VirusTotal integration
* Small improvements and minor bug fixes
* Updated translations

### 1.1941 - 2022-07-24

* Added VirusTotal integration
* Small improvements and minor bug fixes
* Updated translations

### [Kinnareemimus](https://en.wikipedia.org/wiki/Kinnareemimus)

### 1.1940 - 2022-07-21

* Added check for token expiration

### 1.1939 - 2022-07-21

* Fixed saving searches

### 1.1938 - 2022-07-21

* Enabled Gmail web OAuth flow again
* Small improvements and minor bug fixes
* Updated translations

### 1.1937 - 2022-07-20

* Small improvements and minor bug fixes
* Updated translations

### 1.1936 - 2022-07-20

* Disabled Gmail web OAuth flow
* Small improvements and minor bug fixes
* Updated translations

### 1.1935 - 2022-07-20

* Added editing saved search name, order (new) and color
* Small improvements and minor bug fixes
* Updated libraries
* Updated translations

### 1.1934 - 2022-07-17

* Added Gmail web OAuth flow
* Improved Wingdings support
* Small improvements and minor bug fixes
* Updated translations

### 1.1933 - 2022-07-16

* Added 10 minutes check frequency
* Added option to enable/disable LanguageTool
* Added option to require TLS 1.3
* Small improvements and minor bug fixes
* Updated translations

### 1.1932 - 2022-07-08

* Fixed threading when Message-ID empty
* Small improvements and minor bug fixes
* Updated translations

### 1.1931 - 2022-07-07

* Added option to delay notifications while connected to Android auto (*)
* Added option to show number of listed messages in the top action bar
* Added option to show HTML element titles
* Added configurable button to save raw message files
* Small improvements and minor bug fixes
* Updated translations

<sub>(*) Due to Play store policies this feature is not available in the Play store version; Android version 6 or later is required</sub>

### 1.1930 - 2022-07-04

* Small improvements and minor bug fixes
* Updated AndroidX
* Updated translations

### 1.1929 - 2022-07-02

* Fixed hiding more than 300 messages
* Small improvements and minor bug fixes
* Updated translations

### 1.1928 - 2022-06-30

* Added *Select app* to browser selection
* Small improvements and minor bug fixes
* Updated AndroidX
* Updated translations

### 1.1927 - 2022-06-25

* Added import file to signature editor
* Added option to restore app state on start
* Added edit account color to folder list menu
* Added create/delete notification channel to account popup menu
* Small improvements and minor bug fixes
* Updated libraries
* Updated translations

### [Juratyrant](https://en.wikipedia.org/wiki/Juratyrant)

### 1.1926 - 2022-06-23

* Added workaround for crash in Chrome taking down FairEmail
* Small improvements and minor bug fixes
* Updated translations

### 1.1925 - 2022-06-22

* Fixed crash in some situations
* Small improvements and minor bug fixes
* Updated translations

### 1.1924 - 2022-06-19

* Small improvements and minor bug fixes
* Updated translations

### 1.1923 - 2022-06-18

* Added option to delay notifications while on a call (Android 12 or later)
* Small improvements and minor bug fixes
* Updated translations

### 1.1922 - 2022-06-18

* Small improvements and minor bug fixes
* Updated translations

### 1.1921 - 2022-06-17

* Small improvements and minor bug fixes
* Updated translations

### 1.1920 - 2022-06-16

* Fixed double back to exit
* Improved browser selection
* Added forward as attachment to answer menu
* Small improvements and minor bug fixes

### 1.1919 - 2022-06-15

* Fixed fragment back
* Small improvements and minor bug fixes
* Updated AndroidX

### 1.1918 - 2022-06-15

* Added browser selection to open link dialog
* Small improvements and minor bug fixes
* Updated translations

### 1.1917 - 2022-06-14

* Fixed moving to selected folder
* Small improvements and minor bug fixes
* Updated translations

### 1.1916 - 2022-06-14

* Added option to suppress new message notifications when calling
* Small improvements and minor bug fixes
* Updated translations

### 1.1915 - 2022-06-13

* Fixed initializing option values

### 1.1914 - 2022-06-13

* Added option for automatic hyphenation
* Improved Android 13 compatibility
* Small improvements and minor bug fixes
* Updated translations

### 1.1913 - 2022-06-12

* Fixed asking for permissions on Android 12 and before
* Small improvements and minor bug fixes
* Updated translations

### 1.1912 - 2022-06-11

* Targetting SDK 33 (Android 13)
* Small improvements and minor bug fixes
* Updated AndroidX Webkit
* Updated translations

### 1.1911 - 2022-06-11

* Added encoding (character set) override option
* Added UTF-16 endianness detection
* Small improvements and minor bug fixes
* Updated AndroidX and material design library
* Updated translations

### 1.1910 - 2022-06-10

* Fixed dark theme / original message view on Android 12 and before
* Small improvements and minor bug fixes
* Updated translations

### 1.1909 - 2022-06-10

* Fixed dark theme / original message view on Android 13
* Updated translations

### 1.1908 - 2022-06-09

* Added searching for text in drafts
* Added OAuth for Gmail POP3 accounts
* Improved Android 13 compatibility (notification permissions)
* Small improvements and minor bug fixes
* Updated translations

### 1.1907 - 2022-06-07

* Fixed deleted POP3 messages reappearing
* Small improvements and minor bug fixes
* Updated translations

### 1.1906 - 2022-06-06

* Added POP3 swipe action to report spam / block sender
* Added POP3 report spam / block sender for multiple selected messages
* Added check to prevent blocking self
* Added suffix guessing on adding attachments
* Fixed startup issue for some devices / Android versions
* Small improvements and minor bug fixes
* Updated translations

### 1.1905 - 2022-06-03

* Added print selected text
* Added quick actions unread and permanent deletion
* Added Turkish and Indonesian to DeepL languages
* Added auto fixing filename suffix on adding image attachments
* Improved insert link dialog
* Small improvements and minor bug fixes
* Updated translations

### [Itemirus](https://en.wikipedia.org/wiki/Itemirus)

### 1.1904 - 2022-05-30

* Fixed duplicate archived Gmail drafts

### 1.1903 - 2022-05-30

* Fixed archiving/trashing Gmail drafts
* Auto block sender on moving (as opposed to reporting) messages to spam
* Small improvements and minor bug fixes
* Updated translations

### 1.1902 - 2022-05-29

* Fixed memory leak in some scenarios
* Fixed persistent loading spinner in some situations
* Small improvements and minor bug fixes
* Updated AndroidX
* Updated translations

### 1.1901 - 2022-05-27

* Small improvements and minor bug fixes
* Updated translations

### 1.1900 - 2022-05-25

* Fixed mini gallery not showing in some cases
* Fixed folder sync in some cases
* Fixed displaying/editing lists in some cases
* Updated privacy policy
* Small improvements and minor bug fixes
* Updated translations

### 1.1899 - 2022-05-18

* Small improvements and minor bug fixes
* Updated translations

### 1.1898 - 2022-05-15

* Small improvements and minor bug fixes
* Updated translations

### 1.1897 - 2022-05-14

* Added configurable quick actions
* Small improvements and minor bug fixes
* Updated translations

### 1.1896 - 2022-05-13

* Prevent blocking self (report spam)
* Preliminary Android 13 support (photo picker)
* Small improvements and minor bug fixes
* Updated translations

### 1.1895 - 2022-05-12

* Added quick mark as read button
* Added send option to disable forwarding as new conversation thread
* Small improvements and minor bug fixes
* Updated AndroidX / material design library
* Updated translations

### 1.1894 - 2022-05-11

* Fixed widgets for older Android versions
* Small improvements and minor bug fixes
* Updated build tools
* Updated translations

### 1.1893 - 2022-05-10

* Small improvements and minor bug fixes
* Updated translations

### 1.1892 - 2022-05-07

* Added optional day/night mode for widgets
* Small improvements and minor bug fixes
* Updated translations

### 1.1891b - 2022-05-05

* Added avatars option to message list widget
* Added option to use blocklists for POP3
* Small improvements and minor bug fixes
* Updated translations

### 1.1891a - 2022-05-03

* Fixed unified folders nav menu message count
* Small improvements and minor bug fixes
* Updated translations

### 1.1890 - 2022-05-03

* Small improvements and minor bug fixes
* Updated translations

### 1.1889 - 2022-05-02

* Added translate all button
* Small improvements and minor bug fixes
* Updated translations

### 1.1888 - 2022-05-01

* Added quick actions for selected messages
* Added widget option to disable separator lines
* Added widget highlight color selection
* Added search for sender for single selected message
* Small improvements and minor bug fixes
* Updated translations

### [Hulsanpes](https://en.wikipedia.org/wiki/Hulsanpes)

### 1.1887 - 2022-04-29

* Small improvements and minor bug fixes
* Updated translations

### 1.1886 - 2022-04-28

* Added option to auto save after entering a dot
* Added LanguageTool support (long press the 'Save' button)
* Small improvements and minor bug fixes
* Updated translations

### 1.1885 - 2022-04-26

* Fixed saving drafts
* Small improvements and minor bug fixes
* Updated translations

### 1.1884 - 2022-04-26

* Added option to highlight unread messages in the message list widget
* Small improvements and minor bug fixes
* Updated translations

### 1.1883 - 2022-04-25

* Added auto save draft for every new paragraph (can be turned off in the send settings)
* Small improvements and minor bug fixes
* Updated translations

### 1.1882 - 2022-04-25

* Fixed dark texts in dark themes
* Small improvements and minor bug fixes
* Updated translations

### 1.1881 - 2022-04-24

* Added advanced account option to sync outside schedule
* Small improvements and minor bug fixes
* Updated translations

### 1.1879 - 2022-04-23

* Added warning about airplane mode enabled
* Added advanced account option to connect via unmetered networks only
* Small improvements and minor bug fixes
* Updated translations

### 1.1878 - 2022-04-21

* Fixed printing
* Fixed signature verification in some cases
* Small improvements and minor bug fixes
* Updated translations

### 1.1877 - 2022-04-21

* Small improvements and minor bug fixes
* Updated AndroidX
* Updated translations

### 1.1876 - 2022-04-20

* Added auto select same identity for same recipient for new messages
* Added option to add signature to first reply only
* Added option to hide folders with all read messages (start screen only)
* Fixed memory leaks
* Small improvements and minor bug fixes
* Updated AndroidX
* Updated translations

### [Gobivenator](https://en.wikipedia.org/wiki/Gobivenator)

### 1.1875 - 2022-04-13

* Fixed crash on some Android versions
* Small improvements and minor bug fixes
* Updated translations

### 1.1874 - 2022-04-13

* Added padding option for tabular view in overflow menu
* Added selection of contact type (home, work, etc) when inserting contact group
* Fixed some memory leaks
* Small improvements and minor bug fixes
* Updated translations

### 1.1873 - 2022-04-09

* Fix scroll stuttering in some case
* Small improvements and minor bug fixes
* Updated translations

### 1.1872 - 2022-04-09

* Small improvements and minor bug fixes
* Updated translations

### 1.1871 - 2022-04-09

* Small improvements and minor bug fixes
* Updated translations

### 1.1870 - 2022-04-08

* Small improvements and minor bug fixes
* Updated build tools
* Updated translations

### 1.1869 - 2022-04-07

* Added DeepL HTML support
* Fixed inline image handling for external drafts
* Small improvements and minor bug fixes
* Updated translations

### 1.1868 - 2022-04-06

* Small improvements and minor bug fixes
* Updated Public Suffix List
* Updated build tools
* Updated translations

### 1.1867 - 2022-04-04

* Added highlighting (marking) of text
* Small improvements and minor bug fixes
* Updated translations

### 1.1866 - 2022-04-02

* Small improvements and minor bug fixes
* Updated translations

### 1.1865 - 2022-04-01

* Added searching in rule actions
* Small improvements and minor bug fixes
* Updated translations

### 1.1864 - 2022-03-30

* Fixed starting disabled accounts

### 1.1863 - 2022-03-30

* Converting background images into images (reformatted message view)
* Small improvements and minor bug fixes
* Updated translations

### 1.1862 - 2022-03-28

* Added local contact editor
* Added local contact groups
* Added block sender for POP3 accounts
* Small improvements and minor bug fixes
* Updated translations

### 1.1861 - 2022-03-25

* Added option to show account categories in the navigation menu
* Added managing filter rules to the navigation menu
* Small improvements and minor bug fixes
* Updated AndroidX
* Updated Public Suffix List
* Updated translations

### 1.1860 - 2022-03-23

* Added sent sound selection
* Small improvements and minor bug fixes
* Updated translations

### 1.1859 - 2022-03-22

* Showing common filter rule action values in rule lists
* Small improvements and minor bug fixes
* Updated translations

### 1.1858 - 2022-03-21

* Added remove all attachments button to message editor
* Showing filter rule condition values in rule lists
* Small improvements and minor bug fixes
* Updated translations

### 1.1857 - 2022-03-19

* Added inserting templates as text snippets
* Small improvements and minor bug fixes
* Updated translations

### 1.1856 - 2022-03-14

* Added click link feedback
* Added option for direct server search
* Improved favicon selection
* Improved DMARC report viewer
* Small improvements and minor bug fixes
* Updated translations

### 1.1855 - 2022-03-12

* Added option to show contents of zipped attachments (enabled by default)
* Added option to sort reply templates by frequency of use
* Added basic DMARC report viewer
* Enabled sqlite analyze
* Small improvements and minor bug fixes
* Updated translations

### 1.1854 - 2022-03-09

* Added some more BIP39 word lists
* Added CSS inherit support
* Targeting Android 12L (SDK 32)
* Small improvements and minor bug fixes
* Updated translations

### 1.1853 - 2022-03-07

* Added BIP39 word lists in various languages
* Small improvements and minor bug fixes
* Updated translations

### 1.1852 - 2022-03-07

* Added image dimensions to mini gallery
* Added PGP and S/MIME key indicators to address bubbles
* Added delete existing accounts option to import dialog
* Added clear all data settings tile
* Added remote clear all data via mnemonic
* Small improvements and minor bug fixes
* Updated translations

### [Fulgurotherium](https://en.wikipedia.org/wiki/Fulgurotherium)

### 1.1851 - 2022-03-02

* Small improvements and minor bug fixes
* Updated translations

### 1.1850 - 2022-02-28

* Small improvements and minor bug fixes
* Updated translations

### 1.1849 - 2022-02-26

* Fixed inserting photos after device rotation
* Showing if there are attachments in conversations
* Small improvements and minor bug fixes
* Updated translations

### 1.1848 - 2022-02-25

* Fixed POP3 delete
* Small improvements and minor bug fixes
* Updated translations

### 1.1847 - 2022-02-24

* Address bubbles: generated icons
* Address bubbles: RTL support
* Address bubbles: accessibility improvements
* Small improvements and minor bug fixes
* Updated translations

### 1.1846 - 2022-02-24

* Small improvements and minor bug fixes
* Updated translations

### 1.1845 - 2022-02-23

* Address bubble fixes and improvements
* Small improvements and minor bug fixes
* Updated translations

### 1.1844 - 2022-02-23

* Improved address bubble handling
* Added "extra small" image resize option
* Small improvements and minor bug fixes
* Updated translations

### 1.1843 - 2022-02-22

* Added address bubbles (enable via overflow menu / message editor)
* Small improvements and minor bug fixes
* Updated translations

### 1.1842 - 2022-02-20

* Added (black or) white theme
* Added option to always navigation from message list to folder list
* Small improvements and minor bug fixes
* Updated translations

### 1.1841 - 2022-02-19

* Improved plain text only check
* Updated Public Suffix List
* Preliminary Android 13 support
* Small improvements and minor bug fixes
* Updated translations

### 1.1840 - 2022-02-17

* Fixed auto linking of email addresses
* Small improvements and minor bug fixes
* Updated translations

### 1.1839 - 2022-02-16

* Added an option to select the long press answer button action
* Small improvements and minor bug fixes
* Updated translations

### 1.1838 - 2022-02-15

* Small improvements and minor bug fixes
* Updated translations

### 1.1837 - 2022-02-14

* Added menu item to show plain text part
* Added AMP email support
* Small improvements and minor bug fixes
* Updated translations

### 1.1836 - 2022-02-12

* Added option to disable using bundled fonts
* Small improvements and minor bug fixes
* Updated translations

### 1.1835 - 2022-02-11

* Added default display font setting
* Replaced Cambo by Caladea font
* Small improvements and minor bug fixes
* Updated translations

### 1.1834 - 2022-02-10

* Added Croscore and Crosextra fonts
* Small improvements and minor bug fixes
* Updated translations

### 1.1833 - 2022-02-07

* Added view original signature
* Added support for CSS text-transform
* Added option to disable divider lines for tabular layout
* Small improvements and minor bug fixes
* Updated translations

### 1.1832 - 2022-02-05

* Added saving S/MIME public keys
* Small improvements and minor bug fixes
* Updated translations

### 1.1831 - 2022-02-04

* Added slider to change message column width
* Added option for formal/informal DeepL translation
* Added insert line to long press menu
* Small improvements and minor bug fixes
* Updated libraries/AndroidX
* Updated translations

### [Epidexipteryx](https://en.wikipedia.org/wiki/Epidexipteryx)

### 1.1830 - 2022-02-02

* Fixed extra buttons option

### 1.1829 - 2022-02-02

* Reduced logging
* Small improvements and minor bug fixes
* Updated translations

### 1.1828 - 2022-02-01

* Small improvements and minor bug fixes
* Updated translations

### 1.1827 - 2022-02-01

* Fixed forward as attachment
* Small improvements and minor bug fixes
* Updated translations

### 1.1826 - 2022-01-31

* Added $$tls$ rule condition
* Small improvements and minor bug fixes
* Updated translations

### 1.1825 - 2022-01-30

* Show image thumbnails in message editor
* Small improvements and minor bug fixes
* Updated translations

### 1.1824 - 2022-01-29

* Show image thumbnails in message editor
* Small improvements and minor bug fixes
* Updated translations

### 1.1823 - 2022-01-29

* Small improvements and minor bug fixes
* Updated translations

### 1.1822 - 2022-01-28

* Small improvements and minor bug fixes
* Updated translations

### 1.1821 - 2022-01-25

* Fixed answer menu crash
* Small improvements and minor bug fixes
* Updated translations

### 1.1820 - 2022-01-24

* Small improvements and minor bug fixes
* Updated translations

### 1.1819 - 2022-01-23

* Fixed crash in error handling
* Small improvements and minor bug fixes
* Updated translations

### 1.1818 - 2022-01-22

* Added colors to reply templates
* Added displaying reply templates by group
* Added option to group messages by account category (default disabled)
* Small improvements and minor bug fixes
* Updated translations

### 1.1817 - 2022-01-21

* Fixed text context menu actions
* Small improvements and minor bug fixes
* Updated translations

### 1.1816 - 2022-01-20

* Small improvements and minor bug fixes
* Updated translations

### 1.1815 - 2022-01-19

* Small improvements and minor bug fixes
* Updated translations

### 1.1814 - 2022-01-18

* Added support for sensitivity indicator (personal, private, confidential)
* Added batch setting of message flags (protocol level)
* Small improvements and minor bug fixes
* Updated translations

### 1.1813 - 2022-01-17

* Fixed downloading attachments on demand
* Small improvements and minor bug fixes

### 1.1812 - 2022-01-17

* Small improvements and minor bug fixes
* Updated translations

### [Draconyx](https://en.wikipedia.org/wiki/Draconyx)

### 1.1811 - 2022-01-14

* Fixed scroll issue

### 1.1810 - 2022-01-14

* Fixed searching for options when swiping
* Small improvements and minor bug fixes
* Updated translations

### 1.1809 - 2022-01-14

* Reply with selected text in style
* Small improvements and minor bug fixes
* Updated translations

### 1.1808 - 2022-01-13

* Added share images button above mini gallery
* Small improvements and minor bug fixes
* Updated translations

### 1.1807 - 2022-01-11

* Fixed delay when going to a settings page
* Small improvements and minor bug fixes
* Updated translations

### 1.1806 - 2022-01-11

* Small improvements and minor bug fixes
* Updated translations

### 1.1805 - 2022-01-10

* Long screenshots (Android 12+)
* Small improvements and minor bug fixes
* Updated translations

### 1.1804 - 2022-01-08

* Added check for secure (TLS) transport (experimental)
* Removed double confirm for permanently deleting messages
* Allowing three tries for biometric authentication
* Fixed RTL for sent messages
* Small improvements and minor bug fixes
* Updated translations

### 1.1803 - 2022-01-06

* Added rule action to play (alarm) sound (experimental)
* Small improvements and minor bug fixes
* Updated build tools and libraries
* Updated translations

### 1.1802 - 2022-01-03

* Improved original message view scrolling
* Small improvements and minor bug fixes
* Updated translations

### 1.1801 - 2021-12-30

* Added rule action to permanently delete messages
* Using IMAP flags to store low/high importance
* Small improvements and minor bug fixes
* Updated translations

### 1.1800 - 2021-12-27

* Fixed crash when manually configuring an account
* Small improvements and minor bug fixes
* Updated translations

### 1.1799 - 2021-12-27

* Fixed removing inline images on replying/forwarding
* Small improvements and minor bug fixes
* Updated translations

### 1.1798 - 2021-12-27

* Play store only release
* Fixed removing inline images on replying/forwarding

### 1.1797 - 2021-12-27

* Added Outlook Tenant ID field
* Added option for numbered reply prefix
* Added conversion of OAuth to password authentication
* Improved handling of delivery/read receipts
* Small improvements and minor bug fixes
* Updated translations

### [Caudipteryx](https://en.wikipedia.org/wiki/Caudipteryx)

### 1.1796 - 2021-12-23

* Fixed incorrect background colors
* Small improvements and minor bug fixes

### 1.1795 - 2021-12-23

* Small improvements and minor bug fixes
* Updated translations

### 1.1794 - 2021-12-22

* Added logarithmic PIN failure delay of 3 seconds
* Small improvements and minor bug fixes
* Updated translations

### 1.1793 - 2021-12-20

* Fixed crash related to resending
* Added compact mode for accounts on start screen
* Small improvements and minor bug fixes
* Updated translations

### 1.1792 - 2021-12-18

* Fixed always resending (2)
* Small improvements and minor bug fixes
* Updated translations

### 1.1791 - 2021-12-18

* Fixed always resending
* Added receive option to group on sender/subject
* Small improvements and minor bug fixes
* Updated translations

### 1.1790 - 2021-12-16

* Small improvements and minor bug fixes
* Updated AndroidX
* Updated translations

### 1.1789 - 2021-12-14

* Added support for foldable devices
* Small improvements and minor bug fixes
* Updated build tools
* Updated translations

### 1.1788 - 2021-12-13

* Added experimental resend support (RFC2822 section 3.6.6)
* Small improvements and minor bug fixes
* Updated translations

### 1.1787 - 2021-12-11

* Fixed always downloading headers/bodies for rules requiring this
* Small improvements and minor bug fixes
* Updated translations

### 1.1786 - 2021-12-10

* Fixed marking messages read in some situations
* Small improvements and minor bug fixes
* Updated translations

### 1.1785 - 2021-12-09

* Added "text contains" filter rule condition
* Small improvements and minor bug fixes
* Updated translations

### 1.1784 - 2021-12-08

* Added display option to override widths in original message view
* Added sync twice within 30 seconds to sync all messages
* Small improvements and minor bug fixes
* Updated translations

### 1.1783 - 2021-12-02

* Added display option to use highlight color for unread shadow
* Added display option for wide color stripe
* Added notification/delete for POP3 when "leave deleted" is enabled
* Improved support for read-only folders
* Small improvements and minor bug fixes
* Updated translations

### 1.1782 - 2021-11-27

* Added optional set importance button
* Small improvements and minor bug fixes
* Updated translations

### 1.1781 - 2021-11-23

* Added behavior option to enable swipe right to reply
* Added separate sort order setting for unified folders
* Updated AndroidX
* Small improvements and minor bug fixes
* Updated translations

### [Banji](https://en.wikipedia.org/wiki/Banji)

### 1.1780 - 2021-11-15

* Fixed empty lines in message headers
* Improved handling of read-only folders
* Small improvements and minor bug fixes
* Updated translations

### 1.1779 - 2021-11-13

* Added using folder colors for Gmail labels
* Added highlighting of searched text in messages
* Added filter for trashed messages in conversations
* Small improvements and minor bug fixes
* Updated translations

### 1.1778 - 2021-11-11

* Fixed duplicate submenu icons
* Small improvements and minor bug fixes

### 1.1777 - 2021-11-11

* Small improvements and minor bug fixes
* Updated translations

### 1.1776 - 2021-11-10

* Added message menu icons
* Small improvements and minor bug fixes
* Updated translations

### 1.1775 - 2021-11-09

* Small improvements and minor bug fixes
* Updated AndroidX
* Updated translations

### 1.1774 - 2021-11-08

* Added option to configure card padding (3-dots overflow menu)
* Small improvements and minor bug fixes
* Updated translations

### 1.1773 - 2021-11-06

* Small improvements and minor bug fixes
* Updated translations

### 1.1772 - 2021-11-04

* Added check for sending to no-reply addresses
* Small improvements and minor bug fixes
* Updated translations

### 1.1771 - 2021-11-03

* Small improvements and minor bug fixes
* Updated translations

### 1.1770 - 2021-11-01

* Added option to lock app (biometric/PIN) on leaving app
* Small improvements and minor bug fixes
* Updated AndroidX
* Updated translations

### 1.1769 - 2021-10-28

* Fixed drafts not being removed
* Added Emoji font loading (privacy settings)
* Small improvements and minor bug fixes
* Updated AndroidX
* Updated translations

### 1.1768 - 2021-10-27

* Added Material You theme (Android 12)
* Small improvements and minor bug fixes
* Updated translations

### 1.1767 - 2021-10-26

* Small improvements and minor bug fixes
* Updated translations

### 1.1766

* Small improvements and minor bug fixes
* Updated translations

### 1.1765

* Added option to disable lock on screen off for biometric authentication
* Small improvements and minor bug fixes
* Updated translations

### 1.1764

* Added support for latin and roman numbered lists (view only)
* Report new messages when composing a message [1]
* Use account categories for identities
* Small improvements and minor bug fixes
* Updated translations

[1] This is an experiment which needs to be enabled in the miscellaneous settings.

### 1.1763

* Small improvements and minor bug fixes
* Updated libraries
* Updated translations

### 1.1762

* Small improvements and minor bug fixes
* Updated translations

### 1.1761

* Small improvements and minor bug fixes
* Updated translations

### 1.1760

* Added multiple select spam / block sender
* Added conditional searching via search index
* Small improvements and minor bug fixes
* Updated translations

### 1.1757

* Improved send progress calculation
* Small improvements and minor bug fixes
* Updated translations

### 1.1756

* Added settings import result dialog
* Added send progress bar in sending notification
* Small improvements and minor bug fixes
* Updated translations

### 1.1755

* Added no font option for outgoing messages (send settings)
* Reduced memory usage
* Small improvements and minor bug fixes
* Updated translations

### [Adratiklit](https://en.wikipedia.org/wiki/Adratiklit)

### 1.1754

* Small improvements and minor bug fixes
* Updated translations

### 1.1752

* Added account categories [1]
* Small improvements and minor bug fixes
* Updated translations

[1] accounts, unified folders and messages in the unified inbox will be grouped by category.

### 1.1751

* Fixed updating system folder properties

### 1.1750

* Auto reselect system folders

### 1.1749

* Fixed handling namespace errors

### 1.1748

* Small improvements and minor bug fixes
* Updated translations

### 1.1747

* Disabled Android Auto support for the Play store version [1]
* Small improvements and minor bug fixes
* Updated translations

[1] Google does not allow email apps with Android Auto support, see the FAQ.

### 1.1746

* Enabled Android auto support (see the FAQ for details)

### [Zanabazar](https://en.wikipedia.org/wiki/Zanabazar_junior)

### 1.1745

* Auto delete stale grouped operations

### 1.1744

* Small improvements and minor bug fixes
* Updated translations

### 1.1743

* Fixed listing personal root namespace
* Small improvements and minor bug fixes
* Updated translations

### 1.1742

* Small improvements and minor bug fixes
* Updated AndroidX
* Updated translations

### 1.1741

* Fixed empty account/identity list crash
* Updated AndroidX
* Updated translations

### 1.1740

* Added importing/exporting of vCards for local contact database
* Added option to show number of unread drafts in the navigation menu
* Added option to disable collapsing on manually marking read/unread
* Reduced memory usage
* Small improvements and minor bug fixes

### 1.1739

* Showing search index state
* Small improvements and minor bug fixes
* Updated translations

### 1.1738

* Added theme option for always light message editor
* Small improvements and minor bug fixes
* Updated translations

### 1.1737

* Fixed crash

### 1.1736

* Small improvements and minor bug fixes

### 1.1735

* Added guided workaround for Outlook authentication errors

### 1.1734

* Added color to saved searches

### 1.1733

* Added saved searches (experimental)

### 1.1732

* Added collapsing of navigation menu folders
* Added theme option for default light original message view
* Unified colors based on account folder colors
* Showing folders of all personal namespaces
* Improved Android 12 support
* Fixed all reported bugs

### [Yaverlandia](https://en.wikipedia.org/wiki/Yaverlandia)

### 1.1731

* Fixed invalid error reports

### 1.1730

* Small improvements and minor bug fixes

### 1.1729

* Added miscellaneous option to disable showing the changelog

### 1.1728

* Prevent suggesting spam contacts
* Confirm deleting block sender rules

### 1.1727

* Following dark/light theme for original message view
* Added message menu item / optional button to force light theme for original message view
* Moved block sender rules to local contact database to make it a free feature
* Fixed verifying some S/MIME signatures

### 1.1726

* Show in-app changelog after updating

### 1.1725

* Added in-app changelog

### 1.1724

* Added display option for fixed date header
* Moved navigation folders under accounts in the navigation menu

### 1.1723

* Fixed polling sometimes stopping

### 1.1722

* Added sort folders on unread messages option
* Added Outlook .msg file decoder

### 1.1721

* Added decoding of Sophos Email Appliance links
* Updated libraries

### 1.1720

* Moved outbox to unified folders in navigation menu
* Added connection option to connect via VPN only
* Added sqlite checkpoint after processing operations

### [Xiyunykus](https://en.wikipedia.org/wiki/Xiyunykus)

### 1.1719

* Added tap on folder name to go to folder (conversation/message view only)
