
<img width="72" height="72" src="https://raw.githubusercontent.com/M66B/FairEmail/master/app/src/main/res/mipmap-hdpi/ic_launcher.png">

<sup>Provided by [FairCode B.V.](https://www.faircode.eu/)</sup>

## Privacy policy

[&#x1F30E; Google Translate](https://translate.google.com/translate?hl=&sl=en&u=https%3A%2F%2Fraw.githubusercontent.com%2FM66B%2FFairEmail%2Fmaster%2FPRIVACY.md)

<br />

This privacy policy will be updated as needed, such as when there are changes in the app or when regulations or laws change.

Last update: **June 2, 2024**

<br />

First of all, FairEmail's main goal is to help you protect your privacy.
What follows is a complete overview of all the data that will be stored on the device and that **can be** sent to the internet.
The latter is in the end always your choice and therefore optional.

Except for error reports (disabled by default), the app does not send any data to the developer.
Error reports will automatically be deleted after one month, or earlier upon request.

Data collected on the device will **never** be sold or shared in any way.

Data collected on the device will **never** be used for profiling, (AI) training or advertisements.

There are **no ads** in the app.

You have the right to lodge a complaint with a supervisory data protection authority,
please [see here](https://en.wikipedia.org/wiki/National_data_protection_authority) for a list.

<br>

The <a href="https://play.google.com/store/apps/datasafety?id=eu.faircode.email">data safety</a> in the Play Store says:

"*The developer says this app doesn't share user data with other companies or organizations.*".

Unfortunately, there is no way to say that the app doesn't share data with the developer.
Except for error reporting (explicitly opt-in) **no data will be shared with the developer**.
It is important to note that collecting data on the device isn't synonymous with sending data off the device!

<br />

### Overview

FairEmail **does not** send account information and message data elsewhere than to your email provider.

FairEmail **does not** allow other apps access to message data without your approval.

FairEmail **does not** require unnecessary permissions.
For more information on permissions, see [this FAQ](https://m66b.github.io/FairEmail/#faq1).

FairEmail **does** use modern and secure transport protocols by default.

Android [encrypts all user data by default](https://source.android.com/docs/security/features/encryption), so all data, including account credentials, is stored encrypted by default.

FairEmail **does** follow the recommendations of [this EFF article](https://www.eff.org/deeplinks/2019/01/stop-tracking-my-emails).

FairEmail is 100 % **open source**, see [the license](https://github.com/M66B/FairEmail/blob/master/LICENSE).

Error reporting via Bugsnag **is opt-in**, see [here](https://m66b.github.io/FairEmail/#faq104) for more information.

FairEmail **adheres** to the [Google API Services User Data Policy](https://developers.google.com/terms/api-services-user-data-policy),
including the [Limited Use requirements](https://developers.google.com/terms/api-services-user-data-policy#additional_requirements_for_specific_api_scopes).
Google API Services are used only to authenticate Gmail accounts through OAuth.

The use of information received from Gmail APIs will adhere to the Google User Data Policy, including the Limited Use requirements."

All stored information (account details, messages, etc.) is **protected by encryption**.
All information is sent and received through **secure connections**.
Of course, you should also protect your device by using a PIN code, pattern and/or biometric authentication.

FairEmail **can use** these services if they are explicitly enabled (off by default) or are explicitly used by you:

* [ipinfo.io](https://ipinfo.io/) &#8211; [Privacy policy](https://ipinfo.io/privacy-policy)
* [Spamhaus](https://www.spamhaus.org/) &#8211; [Privacy policy](https://www.spamhaus.org/organization/privacy/)
* [Spamcop](https://www.spamcop.net/) &#8211; [Privacy policy](https://www.spamcop.net/fom-serve/cache/168.html)
* [Barracuda](https://www.barracudacentral.org/rbl/how-to-use) &#8211; [Privacy policy](https://www.barracuda.com/company/legal/trust-center/data-privacy/privacy-policy)
* [Thunderbird autoconfiguration](https://wiki.mozilla.org/Thunderbird:Autoconfiguration) &#8211; [Privacy policy](https://www.mozilla.org/privacy/)
* [DeepL](https://www.deepl.com/) &#8211; [Privacy policy](https://www.deepl.com/privacy/)
* [LanguageTool](https://languagetool.org/) &#8211; [Privacy policy](https://languagetool.org/legal/privacy)
* [VirusTotal](https://www.virustotal.com/) &#8211; [Privacy policy](https://support.virustotal.com/hc/en-us/articles/115002168385-Privacy-Policy)
* [OpenAI](https://openai.com/) &#8211; [Privacy policy](https://openai.com/policies/privacy-policy)
* [Google Gemini](https://gemini.google.com/) &#8211; [Privacy policy](https://support.google.com/gemini/answer/13594961)
* [Gravatar](https://gravatar.com/) (GitHub version only) &#8211; [Privacy policy](https://automattic.com/privacy/)
* [Libravatar](https://www.libravatar.org/) (GitHub version only)  &#8211; [Privacy policy](https://www.libravatar.org/privacy/)
* [GitHub](https://github.com/) (GitHub version only) &#8211; [Privacy policy](https://docs.github.com/en/site-policy/privacy-policies/github-privacy-statement)
* [Have I Been Pwned?](https://haveibeenpwned.com/) &#8211; [Privacy policy](https://haveibeenpwned.com/Privacy)
* [Bugsnag](https://www.bugsnag.com/) &#8211; [Privacy policy](https://smartbear.com/privacy/)
* [Google data backup](https://developer.android.com/identity/data/backup) &#8211; [Privacy policy](https://policies.google.com/privacy)
* [Google Play Billing](https://developer.android.com/distribute/play-billing) &#8211; [Privacy policy](https://wallet.google.com/files/privacy.html)

FairEmail **can access** the websites at the domain names of email addresses (username@domain.name)
if [Brand Indicators for Message Identification](https://en.wikipedia.org/wiki/Brand_Indicators_for_Message_Identification) (BIMI)
or [favicons](https://en.wikipedia.org/wiki/Favicon)
were explicitly enabled (off by default).

FairEmail **will access** the website at the link address if you tap the *Fetch title* button in the insert link dialog (from version 1.1905).

FairEmail obviously **will access** the configured email servers.

FairEmail **is** [GDPR compliant](https://gdpr.eu/).

<br />

### Summary of stored (collected) data

The following data is stored on the device or, in other words, collected, but not sent off the device:

<div class="table-wrapper">

| Data stored (collected)                                                       | Purpose                         | Related Android permissions |
| ----------------------------------------------------------------------------- | ------------------------------- | --------------------------- |
| Names and email addresses (account and contact data)                          | To configure accounts           | GET_ACCOUNTS                |
|                                                                               | To suggest email addresses      | READ_CONTACTS               |
| Email messages, including meta data (headers)                                 | To list and display messages    |                             |
|                                                                               | To search for messages          |                             |
| Attachment files (audio, sound, music, voice, photos, video, documents, etc.) | To play media (audio, video)    | READ_EXTERNAL_STORAGE       |
|                                                                               | To view images, documents, etc. | READ_EXTERNAL_STORAGE       |

</div>

By default, personal data as mentioned above will be stored on your device for 30 days.

Under the General Data Protection Regulation (GDPR),
the California Consumer Privacy Act (CCPA),
the Virginia Consumer Data Protection Act (VCDPA),
Lei Geral de Proteção de Dados (LGPD), and other regulations,
you have the right to know whether your personal data is stored, shared or sold to third parties, used for (targeted) advertising, profiling (for decision making), etc.,
and you have the right to access, rectify and delete personal data.
Data stored on the device, see above for details, will never be shared, sold, used for advertising, profiling, etc.
You can access and change this data through the app.
You can delete this data, and you can opt-out of storing this data by uninstalling the app.
To exercise your rights, or if you have questions about data retention, etc., you can contact the developer, see for contact information below.

<br />

### Summary of shared data

This table provides a complete overview of all shared data and the conditions under which data will be shared:

<div class="table-wrapper">

| Service/function    | Data sent                                                          | When the data will be sent                                                  |
| ------------------- | ------------------------------------------------------------------ | --------------------------------------------------------------------------- |
| Mozilla autoconfig  | Domain name of email address of email accounts                     | Upon configuring an email account with the quick setup wizard               |
| Email server        | Login credentials (email address/password), messages sent          | Upon configuring and using an account or identity and upon sending messages |
| ipinfo.io           | IP (network) address of domain names of links or email addresses   | Upon pressing a button in the link confirmation dialog                      |
| Spamhaus            | IP (network) address of domain names of links or email addresses   | If spam blocklists are enabled, upon receiving a message                    |
| Spamcop             | IP (network) address of domain names of links or email addresses   | If spam blocklists are enabled, upon receiving a message                    |
| Barracuda           | IP (network) address of domain names of links or email addresses   | If spam blocklists are enabled, upon receiving a message                    |
| DeepL               | Received or entered message text and target language code          | If translating is enabled, upon pressing a translate button                 |
| LanguageTool        | Entered message texts                                              | If LanguageTools is enabled, upon long pressing the save draft button       |
| VirusTotal          | [SHA-256 hash](https://en.wikipedia.org/wiki/SHA-2) of attachments | If VirusTotal is enabled, upon long pressing a scan button (*)              |
| VirusTotal          | Attached file contents                                             | If VirusTotal is enabled, upon long pressing an upload button (*)           |
| OpenAI/ChatGPT      | Received and entered message texts                                 | If configured and upon pressing a button or using a menu item               |
| Google Gemini       | Received and entered message texts                                 | If configured and upon pressing a button or using a menu item               |
| Gravatar            | [MD5 hash](https://en.wikipedia.org/wiki/MD5) of email addresses   | If Gravatars are enabled, upon receiving a message (*)                      |
| Libravatar          | [MD5 hash](https://en.wikipedia.org/wiki/MD5) of email addresses   | If Libravatars are enabled, upon receiving a message (*)                    |
| GitHub              | None, but see the remarks below                                    | Upon downloading AdGuard tracking parameter list                            |
|                     |                                                                    | Upon downloading Disconnect's Tracker Protection lists                      |
|                     |                                                                    | Upon checking for updates (*)                                               |
| Have I Been Pwned?  | The first 5 characters of the SHA1 hash of passwords               | Upon checking for being pwned                                               |
| BIMI                | Domain name of email addresses                                     | If BIMI is enabled, upon receiving a message (*)                            |
| Favicons            | Domain name of email addresses                                     | If favicons are enabled, upon receiving a message                           |
| Link title          | Link address                                                       | Upon pressing a download button in the insert link dialog                   |
| Bugsnag             | Information about warnings and errors                              | If error reporting is enabled, upon detecting an abnormal situation         |
| Android data backup | Account configuration, selected settings                           | If Android's data backup is enabled on the miscellaneous settings tab page  |
| Google Play Billing | "insight into API usage and service connection issues"             | Not disclosed by Google (**) (endpoint: firebaselogging.googleapis.com)     |

</div>

(*) Only available in the GitHub version of the app

(**) Only available in the Play Store version of the app

All data is sent to improve the user experience in some way,
like to simplify account setup, identify spam and malicious messages, display message and sender information, find bugs and errors, etc.

Note that any internet connection reveals your current [network address](https://en.wikipedia.org/wiki/Network_address).
Also, when downloading content, like images and files, the [browser's user agent string](https://en.wikipedia.org/wiki/User_agent) will be sent.
There is a privacy option to minimize the information being sent, but please be aware that this can result in problems in some cases.

Under the General Data Protection Regulation (GDPR),
the California Consumer Privacy Act (CCPA),
the Virginia Consumer Data Protection Act (VCDPA),
Lei Geral de Proteção de Dados (LGPD), and other regulations,
you have the right to know whether your personal data is stored, shared or sold to third parties, used for (targeted) advertising, profiling (for decision making), etc.,
and you have the right to access, rectify and delete personal data.
To exercise these rights, or if you have questions about data retention, etc., you can contact the service providers listed above.
You can opt-out of having your data stored, shared, sold, used for (targeted) advertising, profiling (for decision making), etc. by not using these optional services/functions.

<br />

### Definitions of terms

This section defines some terms and words.
Knowing those terms will help you understand the following sections.

* *Data subject* &#8211; the user of the app
* *Personal data* &#8211; any data the data subject could be identified with
* *Data controller* &#8211; the person / entity providing the app
* *Data processor* &#8211; the person / entity providing the app
* *Sub-processor* &#8211; a third party processing data
* *Data protection officer* &#8211; the person responsible for any privacy related enquiries

<br>

### Contact details

Please feel free to contact me if you have any concerns:

```
FairCode BV
Represented by the managing director Marcel Bokhorst
Van Doesburg-Erf 194
3315 RG Dordrecht
the Netherlands
marcel+privacy@faircode.eu
```

FairCode BV is the data controller.
Its data protection officer is Marcel Bokhorst, reachable via the aforementioned address.
For any legal issues, the place of jurisdiction is Dordrecht, the Netherlands.

<br>

### A. General information on data processing

#### I. Scope of personal data processing

This privacy policy / data protection declaration applies to the Android app FairEmail.

The data processor only processes personal data insofar as absolutely required for providing a functioning email client as well as the explicitly requested services.
Users' personal data is usually only processed if required for fulfilling contractual or legal obligations or with the user's consent.

#### II Purpose of data processing

The purpose of any data processed is to provide you with the service requested.
The app by default exclusively processes data that is necessary for the proper functioning of the app and its intended purpose of being an email client.

#### III. Data storage and data deletion

By default, all data (both personal and non-personal) remains on the data subject's Android device for as long as not explicitly sent or shared by the data subject.
The data stored on the data subject's device can be deleted by the data subject at any time.

#### IV. Sub-processors

The services of all sub-processors are disabled by default.
The data subject's data is sent to and processed by sub-processors if and only if explicitly enabled or requested by the data subject.

The sub-processors are:

* [Bugsnag](https://www.bugsnag.com/) &#8211; [Privacy policy](https://docs.bugsnag.com/legal/privacy-policy/)

#### V. Permissions

The app only requests permissions that are necessary for the expected behavior of an email app.
For more information on permissions, see [this FAQ](https://m66b.github.io/FairEmail/#faq1).

#### VI. Logging

The app does not send any log entries to the data processor by default.
The error reporting system utilizes Bugsnag and is disabled by default.
See [this FAQ](https://m66b.github.io/FairEmail/#faq104) for more information.

#### VII. Legal basis

FairEmail is fully [GDPR compliant](https://gdpr.eu/). The legal basis for any data processing is Art. 6 (1) a - c GDPR.

<br>

### B. Support requests

#### I. Description and scope of data processing

The data subject may contact the data processor to request support through channels offered by the data processor.
When the data subject contacts the data processor, any provided personal data is stored by the data controller.

#### II. Purpose of data processing

The personal data is exclusively processed for finding a specific solution to support queries whilst recording and/or processing them.
It is essential in this respect for the data controller to be able to contact the person requesting support.

#### III. Sub-processors

The data processor utilizes the services of the following sub-processors in order to process support requests:

* Google LLC, if support request sent via email &#8211; [Privacy policy](https://policies.google.com/privacy?hl=en)
* Amazon Web Services EMEA SARL, if support request sent via the contact form &#8211; [Privacy policy](https://aws.amazon.com/privacy/)

#### IV. Legal basis

Any support requests are sent voluntarily by the data subject, including any personal data that might be attached.
As such, the explicit consent as outlined in Art. 6 (1) a GDPR forms the legal basis for processing.

Copyright &copy; 2018-2025 Marcel Bokhorst.
