import 'package:equatable/equatable.dart';

import 'models/note.dart';

abstract class NotesState extends Equatable {
  final List<Note> notes;
  const NotesState(this.notes);
}

class NotesInitial extends NotesState {
  NotesInitial() : super([]);

  @override
  List<Object> get props => [notes];
}

class NotesLoading extends NotesState {
  const NotesLoading(List<Note> notes) : super(notes);

  @override
  List<Object> get props => [notes];
}

class NotesLoaded extends NotesState {
  const NotesLoaded(List<Note> notes) : super(notes);

  @override
  List<Object> get props => [notes];
}

class NotesError extends NotesState {
  final String message;
  const NotesError(List<Note> notes, this.message) : super(notes);

  @override
  List<Object> get props => [notes, message];
}
