/**
  @file texts.h

  This file contains texts to be used in the game.

  by Miloslav Ciz (drummyfish), 2019

  Released under CC0 1.0 (https://creativecommons.org/publicdomain/zero/1.0/)
  plus a waiver of all other intellectual property. The goal of this work is
  be and remain completely in the public domain forever, available for any use
  whatsoever.
*/

#ifndef SFG_TEXTS_H
#define SFG_TEXTS_H

#include "texts_cs.h"
#include "texts_en.h"
#include "texts_pl.h"

/* NOTE: We don't use SFG_PROGRAM_MEMORY because that causes issues with drawing
  text (the drawing function gets a pointer and doesn't know if it's progmem or
  RAM). On Arduino these texts will simply be stored in RAM. */

#define MENU_ENTRIES_COUNT 8

#define SFG_NAME_STRING "Anarch RE"
#define SFG_NAME_NOSPACE_STRING "AnarchRE"
#define SFG_ORG_NAME_STRING "dev.serwin"
#ifndef SFG_IDENTIFIER_STRING
#define SFG_IDENTIFIER_STRING SFG_ORG_NAME_STRING "." SFG_NAME_NOSPACE_STRING
#endif
#define SFG_COPYRIGHT_STRING "This game is released into public domain"
#define SFG_URL_STRING "https://git.sr.ht/~marcin-serwin/anarch-re"
#ifndef SFG_VERSION_STRING
#define SFG_VERSION_STRING "z0-dev"
#endif

#define LANG_EN 0
#define LANG_CS 1
#define LANG_PL 2
#define LANG_COUNT 3

#define FOR_EACH_LANG(x) {x##_EN, x##_CS, x##_PL}

#define LANG_AUTO "SYS"

static const char *SFG_langNames[] = FOR_EACH_LANG(SFG_LANG_NAME);
static const char *SFG_textKills[] = FOR_EACH_LANG(SFG_TEXT_KILLS);
static const char *SFG_textSavePrompt[] = FOR_EACH_LANG(SFG_TEXT_SAVE_PROMPT);
static const char *SFG_textSaved[] = FOR_EACH_LANG(SFG_TEXT_SAVED);
static const char *SFG_textLevelComplete[] =
    FOR_EACH_LANG(SFG_TEXT_LEVEL_COMPLETE);

static const char *SFG_menuItemTexts[][MENU_ENTRIES_COUNT] =
    FOR_EACH_LANG(SFG_MENU_ITEM_TEXTS);

static const char *SFG_introText[] = FOR_EACH_LANG(SFG_INTRO_TEXT);

static const char *SFG_outroText[] = FOR_EACH_LANG(SFG_OUTRO_TEXT);

#if SFG_OS_IS_MALWARE
static const char *SFG_malwareWarning[] = FOR_EACH_LANG(SFG_MALWARE_WARNING);
#endif

#endif // gaurd
